/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.CacheBehavior;
import software.amazon.awssdk.services.omics.model.RunCacheStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RunCacheListItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RunCacheListItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RunCacheListItem.getter(RunCacheListItem::arn)).setter(RunCacheListItem.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheBehavior").getter(RunCacheListItem.getter(RunCacheListItem::cacheBehaviorAsString)).setter(RunCacheListItem.setter(Builder::cacheBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()}).build();
    private static final SdkField<String> CACHE_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cacheS3Uri").getter(RunCacheListItem.getter(RunCacheListItem::cacheS3Uri)).setter(RunCacheListItem.setter(Builder::cacheS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Uri").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(RunCacheListItem.getter(RunCacheListItem::creationTime)).setter(RunCacheListItem.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(RunCacheListItem.getter(RunCacheListItem::id)).setter(RunCacheListItem.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(RunCacheListItem.getter(RunCacheListItem::name)).setter(RunCacheListItem.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RunCacheListItem.getter(RunCacheListItem::statusAsString)).setter(RunCacheListItem.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CACHE_BEHAVIOR_FIELD, CACHE_S3_URI_FIELD, CREATION_TIME_FIELD, ID_FIELD, NAME_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("arn", ARN_FIELD);
            this.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
            this.put("cacheS3Uri", CACHE_S3_URI_FIELD);
            this.put("creationTime", CREATION_TIME_FIELD);
            this.put("id", ID_FIELD);
            this.put("name", NAME_FIELD);
            this.put("status", STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String cacheBehavior;
    private final String cacheS3Uri;
    private final Instant creationTime;
    private final String id;
    private final String name;
    private final String status;

    private RunCacheListItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.cacheBehavior = builder.cacheBehavior;
        this.cacheS3Uri = builder.cacheS3Uri;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
    }

    public final String arn() {
        return this.arn;
    }

    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(this.cacheBehavior);
    }

    public final String cacheBehaviorAsString() {
        return this.cacheBehavior;
    }

    public final String cacheS3Uri() {
        return this.cacheS3Uri;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final RunCacheStatus status() {
        return RunCacheStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunCacheListItem)) {
            return false;
        }
        RunCacheListItem other = (RunCacheListItem)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.cacheBehaviorAsString(), other.cacheBehaviorAsString()) && Objects.equals(this.cacheS3Uri(), other.cacheS3Uri()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"RunCacheListItem").add("Arn", (Object)this.arn()).add("CacheBehavior", (Object)this.cacheBehaviorAsString()).add("CacheS3Uri", (Object)this.cacheS3Uri()).add("CreationTime", (Object)this.creationTime()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "cacheBehavior": {
                return Optional.ofNullable(clazz.cast(this.cacheBehaviorAsString()));
            }
            case "cacheS3Uri": {
                return Optional.ofNullable(clazz.cast(this.cacheS3Uri()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RunCacheListItem, T> g) {
        return obj -> g.apply((RunCacheListItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String cacheBehavior;
        private String cacheS3Uri;
        private Instant creationTime;
        private String id;
        private String name;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(RunCacheListItem model) {
            this.arn(model.arn);
            this.cacheBehavior(model.cacheBehavior);
            this.cacheS3Uri(model.cacheS3Uri);
            this.creationTime(model.creationTime);
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCacheBehavior() {
            return this.cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getCacheS3Uri() {
            return this.cacheS3Uri;
        }

        public final void setCacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
        }

        @Override
        public final Builder cacheS3Uri(String cacheS3Uri) {
            this.cacheS3Uri = cacheS3Uri;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunCacheStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public RunCacheListItem build() {
            return new RunCacheListItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RunCacheListItem> {
        public Builder arn(String var1);

        public Builder cacheBehavior(String var1);

        public Builder cacheBehavior(CacheBehavior var1);

        public Builder cacheS3Uri(String var1);

        public Builder creationTime(Instant var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(RunCacheStatus var1);
    }
}

