/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.VersionOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnnotationStoreVersionRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateAnnotationStoreVersionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAnnotationStoreVersionRequest.getter(CreateAnnotationStoreVersionRequest::name)).setter(CreateAnnotationStoreVersionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(CreateAnnotationStoreVersionRequest.getter(CreateAnnotationStoreVersionRequest::versionName)).setter(CreateAnnotationStoreVersionRequest.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAnnotationStoreVersionRequest.getter(CreateAnnotationStoreVersionRequest::description)).setter(CreateAnnotationStoreVersionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<VersionOptions> VERSION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("versionOptions").getter(CreateAnnotationStoreVersionRequest.getter(CreateAnnotationStoreVersionRequest::versionOptions)).setter(CreateAnnotationStoreVersionRequest.setter(Builder::versionOptions)).constructor(VersionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionOptions").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAnnotationStoreVersionRequest.getter(CreateAnnotationStoreVersionRequest::tags)).setter(CreateAnnotationStoreVersionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, VERSION_OPTIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("name", NAME_FIELD);
            this.put("versionName", VERSION_NAME_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("versionOptions", VERSION_OPTIONS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String name;
    private final String versionName;
    private final String description;
    private final VersionOptions versionOptions;
    private final Map<String, String> tags;

    private CreateAnnotationStoreVersionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.versionOptions = builder.versionOptions;
        this.tags = builder.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final String description() {
        return this.description;
    }

    public final VersionOptions versionOptions() {
        return this.versionOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreVersionRequest)) {
            return false;
        }
        CreateAnnotationStoreVersionRequest other = (CreateAnnotationStoreVersionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.versionOptions(), other.versionOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnnotationStoreVersionRequest").add("Name", (Object)this.name()).add("VersionName", (Object)this.versionName()).add("Description", (Object)this.description()).add("VersionOptions", (Object)this.versionOptions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "versionOptions": {
                return Optional.ofNullable(clazz.cast(this.versionOptions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnnotationStoreVersionRequest, T> g) {
        return obj -> g.apply((CreateAnnotationStoreVersionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String versionName;
        private String description;
        private VersionOptions versionOptions;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnnotationStoreVersionRequest model) {
            super(model);
            this.name(model.name);
            this.versionName(model.versionName);
            this.description(model.description);
            this.versionOptions(model.versionOptions);
            this.tags(model.tags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final VersionOptions.Builder getVersionOptions() {
            return this.versionOptions != null ? this.versionOptions.toBuilder() : null;
        }

        public final void setVersionOptions(VersionOptions.BuilderImpl versionOptions) {
            this.versionOptions = versionOptions != null ? versionOptions.build() : null;
        }

        @Override
        public final Builder versionOptions(VersionOptions versionOptions) {
            this.versionOptions = versionOptions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnnotationStoreVersionRequest build() {
            return new CreateAnnotationStoreVersionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnnotationStoreVersionRequest> {
        public Builder name(String var1);

        public Builder versionName(String var1);

        public Builder description(String var1);

        public Builder versionOptions(VersionOptions var1);

        default public Builder versionOptions(Consumer<VersionOptions.Builder> versionOptions) {
            return this.versionOptions((VersionOptions)((VersionOptions.Builder)VersionOptions.builder().applyMutation(versionOptions)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

