/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.CreationType;
import software.amazon.awssdk.services.omics.model.ETag;
import software.amazon.awssdk.services.omics.model.FileType;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetFiles;
import software.amazon.awssdk.services.omics.model.ReadSetStatus;
import software.amazon.awssdk.services.omics.model.SequenceInformation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadSetMetadataResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetReadSetMetadataResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::id)).setter(GetReadSetMetadataResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::arn)).setter(GetReadSetMetadataResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::sequenceStoreId)).setter(GetReadSetMetadataResponse.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<String> SUBJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subjectId").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::subjectId)).setter(GetReadSetMetadataResponse.setter(Builder::subjectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()}).build();
    private static final SdkField<String> SAMPLE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sampleId").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::sampleId)).setter(GetReadSetMetadataResponse.setter(Builder::sampleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sampleId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::statusAsString)).setter(GetReadSetMetadataResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::name)).setter(GetReadSetMetadataResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::description)).setter(GetReadSetMetadataResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FILE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileType").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::fileTypeAsString)).setter(GetReadSetMetadataResponse.setter(Builder::fileType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileType").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::creationTime)).setter(GetReadSetMetadataResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<SequenceInformation> SEQUENCE_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sequenceInformation").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::sequenceInformation)).setter(GetReadSetMetadataResponse.setter(Builder::sequenceInformation)).constructor(SequenceInformation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceInformation").build()}).build();
    private static final SdkField<String> REFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("referenceArn").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::referenceArn)).setter(GetReadSetMetadataResponse.setter(Builder::referenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referenceArn").build()}).build();
    private static final SdkField<ReadSetFiles> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("files").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::files)).setter(GetReadSetMetadataResponse.setter(Builder::files)).constructor(ReadSetFiles::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::statusMessage)).setter(GetReadSetMetadataResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> CREATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationType").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::creationTypeAsString)).setter(GetReadSetMetadataResponse.setter(Builder::creationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationType").build()}).build();
    private static final SdkField<ETag> ETAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("etag").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::etag)).setter(GetReadSetMetadataResponse.setter(Builder::etag)).constructor(ETag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etag").build()}).build();
    private static final SdkField<String> CREATION_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creationJobId").getter(GetReadSetMetadataResponse.getter(GetReadSetMetadataResponse::creationJobId)).setter(GetReadSetMetadataResponse.setter(Builder::creationJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationJobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, SEQUENCE_STORE_ID_FIELD, SUBJECT_ID_FIELD, SAMPLE_ID_FIELD, STATUS_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FILE_TYPE_FIELD, CREATION_TIME_FIELD, SEQUENCE_INFORMATION_FIELD, REFERENCE_ARN_FIELD, FILES_FIELD, STATUS_MESSAGE_FIELD, CREATION_TYPE_FIELD, ETAG_FIELD, CREATION_JOB_ID_FIELD));
    private final String id;
    private final String arn;
    private final String sequenceStoreId;
    private final String subjectId;
    private final String sampleId;
    private final String status;
    private final String name;
    private final String description;
    private final String fileType;
    private final Instant creationTime;
    private final SequenceInformation sequenceInformation;
    private final String referenceArn;
    private final ReadSetFiles files;
    private final String statusMessage;
    private final String creationType;
    private final ETag etag;
    private final String creationJobId;

    private GetReadSetMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.subjectId = builder.subjectId;
        this.sampleId = builder.sampleId;
        this.status = builder.status;
        this.name = builder.name;
        this.description = builder.description;
        this.fileType = builder.fileType;
        this.creationTime = builder.creationTime;
        this.sequenceInformation = builder.sequenceInformation;
        this.referenceArn = builder.referenceArn;
        this.files = builder.files;
        this.statusMessage = builder.statusMessage;
        this.creationType = builder.creationType;
        this.etag = builder.etag;
        this.creationJobId = builder.creationJobId;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final String subjectId() {
        return this.subjectId;
    }

    public final String sampleId() {
        return this.sampleId;
    }

    public final ReadSetStatus status() {
        return ReadSetStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final FileType fileType() {
        return FileType.fromValue(this.fileType);
    }

    public final String fileTypeAsString() {
        return this.fileType;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final SequenceInformation sequenceInformation() {
        return this.sequenceInformation;
    }

    public final String referenceArn() {
        return this.referenceArn;
    }

    public final ReadSetFiles files() {
        return this.files;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final CreationType creationType() {
        return CreationType.fromValue(this.creationType);
    }

    public final String creationTypeAsString() {
        return this.creationType;
    }

    public final ETag etag() {
        return this.etag;
    }

    public final String creationJobId() {
        return this.creationJobId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.referenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.files());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.etag());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationJobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadSetMetadataResponse)) {
            return false;
        }
        GetReadSetMetadataResponse other = (GetReadSetMetadataResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(this.subjectId(), other.subjectId()) && Objects.equals(this.sampleId(), other.sampleId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.fileTypeAsString(), other.fileTypeAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.sequenceInformation(), other.sequenceInformation()) && Objects.equals(this.referenceArn(), other.referenceArn()) && Objects.equals(this.files(), other.files()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationTypeAsString(), other.creationTypeAsString()) && Objects.equals(this.etag(), other.etag()) && Objects.equals(this.creationJobId(), other.creationJobId());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadSetMetadataResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("SequenceStoreId", (Object)this.sequenceStoreId()).add("SubjectId", (Object)this.subjectId()).add("SampleId", (Object)this.sampleId()).add("Status", (Object)this.statusAsString()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("FileType", (Object)this.fileTypeAsString()).add("CreationTime", (Object)this.creationTime()).add("SequenceInformation", (Object)this.sequenceInformation()).add("ReferenceArn", (Object)this.referenceArn()).add("Files", (Object)this.files()).add("StatusMessage", (Object)this.statusMessage()).add("CreationType", (Object)this.creationTypeAsString()).add("Etag", (Object)this.etag()).add("CreationJobId", (Object)this.creationJobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "subjectId": {
                return Optional.ofNullable(clazz.cast(this.subjectId()));
            }
            case "sampleId": {
                return Optional.ofNullable(clazz.cast(this.sampleId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "fileType": {
                return Optional.ofNullable(clazz.cast(this.fileTypeAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "sequenceInformation": {
                return Optional.ofNullable(clazz.cast(this.sequenceInformation()));
            }
            case "referenceArn": {
                return Optional.ofNullable(clazz.cast(this.referenceArn()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "creationType": {
                return Optional.ofNullable(clazz.cast(this.creationTypeAsString()));
            }
            case "etag": {
                return Optional.ofNullable(clazz.cast(this.etag()));
            }
            case "creationJobId": {
                return Optional.ofNullable(clazz.cast(this.creationJobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadSetMetadataResponse, T> g) {
        return obj -> g.apply((GetReadSetMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String sequenceStoreId;
        private String subjectId;
        private String sampleId;
        private String status;
        private String name;
        private String description;
        private String fileType;
        private Instant creationTime;
        private SequenceInformation sequenceInformation;
        private String referenceArn;
        private ReadSetFiles files;
        private String statusMessage;
        private String creationType;
        private ETag etag;
        private String creationJobId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadSetMetadataResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.sequenceStoreId(model.sequenceStoreId);
            this.subjectId(model.subjectId);
            this.sampleId(model.sampleId);
            this.status(model.status);
            this.name(model.name);
            this.description(model.description);
            this.fileType(model.fileType);
            this.creationTime(model.creationTime);
            this.sequenceInformation(model.sequenceInformation);
            this.referenceArn(model.referenceArn);
            this.files(model.files);
            this.statusMessage(model.statusMessage);
            this.creationType(model.creationType);
            this.etag(model.etag);
            this.creationJobId(model.creationJobId);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getSubjectId() {
            return this.subjectId;
        }

        public final void setSubjectId(String subjectId) {
            this.subjectId = subjectId;
        }

        @Override
        public final Builder subjectId(String subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final String getSampleId() {
            return this.sampleId;
        }

        public final void setSampleId(String sampleId) {
            this.sampleId = sampleId;
        }

        @Override
        public final Builder sampleId(String sampleId) {
            this.sampleId = sampleId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFileType() {
            return this.fileType;
        }

        public final void setFileType(String fileType) {
            this.fileType = fileType;
        }

        @Override
        public final Builder fileType(String fileType) {
            this.fileType = fileType;
            return this;
        }

        @Override
        public final Builder fileType(FileType fileType) {
            this.fileType(fileType == null ? null : fileType.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final SequenceInformation.Builder getSequenceInformation() {
            return this.sequenceInformation != null ? this.sequenceInformation.toBuilder() : null;
        }

        public final void setSequenceInformation(SequenceInformation.BuilderImpl sequenceInformation) {
            this.sequenceInformation = sequenceInformation != null ? sequenceInformation.build() : null;
        }

        @Override
        public final Builder sequenceInformation(SequenceInformation sequenceInformation) {
            this.sequenceInformation = sequenceInformation;
            return this;
        }

        public final String getReferenceArn() {
            return this.referenceArn;
        }

        public final void setReferenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
        }

        @Override
        public final Builder referenceArn(String referenceArn) {
            this.referenceArn = referenceArn;
            return this;
        }

        public final ReadSetFiles.Builder getFiles() {
            return this.files != null ? this.files.toBuilder() : null;
        }

        public final void setFiles(ReadSetFiles.BuilderImpl files) {
            this.files = files != null ? files.build() : null;
        }

        @Override
        public final Builder files(ReadSetFiles files) {
            this.files = files;
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getCreationType() {
            return this.creationType;
        }

        public final void setCreationType(String creationType) {
            this.creationType = creationType;
        }

        @Override
        public final Builder creationType(String creationType) {
            this.creationType = creationType;
            return this;
        }

        @Override
        public final Builder creationType(CreationType creationType) {
            this.creationType(creationType == null ? null : creationType.toString());
            return this;
        }

        public final ETag.Builder getEtag() {
            return this.etag != null ? this.etag.toBuilder() : null;
        }

        public final void setEtag(ETag.BuilderImpl etag) {
            this.etag = etag != null ? etag.build() : null;
        }

        @Override
        public final Builder etag(ETag etag) {
            this.etag = etag;
            return this;
        }

        public final String getCreationJobId() {
            return this.creationJobId;
        }

        public final void setCreationJobId(String creationJobId) {
            this.creationJobId = creationJobId;
        }

        @Override
        public final Builder creationJobId(String creationJobId) {
            this.creationJobId = creationJobId;
            return this;
        }

        @Override
        public GetReadSetMetadataResponse build() {
            return new GetReadSetMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadSetMetadataResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder sequenceStoreId(String var1);

        public Builder subjectId(String var1);

        public Builder sampleId(String var1);

        public Builder status(String var1);

        public Builder status(ReadSetStatus var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder fileType(String var1);

        public Builder fileType(FileType var1);

        public Builder creationTime(Instant var1);

        public Builder sequenceInformation(SequenceInformation var1);

        default public Builder sequenceInformation(Consumer<SequenceInformation.Builder> sequenceInformation) {
            return this.sequenceInformation((SequenceInformation)((SequenceInformation.Builder)SequenceInformation.builder().applyMutation(sequenceInformation)).build());
        }

        public Builder referenceArn(String var1);

        public Builder files(ReadSetFiles var1);

        default public Builder files(Consumer<ReadSetFiles.Builder> files) {
            return this.files((ReadSetFiles)((ReadSetFiles.Builder)ReadSetFiles.builder().applyMutation(files)).build());
        }

        public Builder statusMessage(String var1);

        public Builder creationType(String var1);

        public Builder creationType(CreationType var1);

        public Builder etag(ETag var1);

        default public Builder etag(Consumer<ETag.Builder> etag) {
            return this.etag((ETag)((ETag.Builder)ETag.builder().applyMutation(etag)).build());
        }

        public Builder creationJobId(String var1);
    }
}

