/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.waiters.OmicsAsyncWaiter;
import software.amazon.awssdk.services.omics.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultOmicsAsyncWaiter
implements OmicsAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final OmicsAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetAnnotationImportJobResponse> annotationImportJobCreatedWaiter;
    private final AsyncWaiter<GetAnnotationStoreResponse> annotationStoreCreatedWaiter;
    private final AsyncWaiter<GetAnnotationStoreResponse> annotationStoreDeletedWaiter;
    private final AsyncWaiter<GetAnnotationStoreVersionResponse> annotationStoreVersionCreatedWaiter;
    private final AsyncWaiter<GetAnnotationStoreVersionResponse> annotationStoreVersionDeletedWaiter;
    private final AsyncWaiter<GetReadSetActivationJobResponse> readSetActivationJobCompletedWaiter;
    private final AsyncWaiter<GetReadSetExportJobResponse> readSetExportJobCompletedWaiter;
    private final AsyncWaiter<GetReadSetImportJobResponse> readSetImportJobCompletedWaiter;
    private final AsyncWaiter<GetReferenceImportJobResponse> referenceImportJobCompletedWaiter;
    private final AsyncWaiter<GetRunResponse> runCompletedWaiter;
    private final AsyncWaiter<GetRunResponse> runRunningWaiter;
    private final AsyncWaiter<GetRunTaskResponse> taskCompletedWaiter;
    private final AsyncWaiter<GetRunTaskResponse> taskRunningWaiter;
    private final AsyncWaiter<GetVariantImportJobResponse> variantImportJobCreatedWaiter;
    private final AsyncWaiter<GetVariantStoreResponse> variantStoreCreatedWaiter;
    private final AsyncWaiter<GetVariantStoreResponse> variantStoreDeletedWaiter;
    private final AsyncWaiter<GetWorkflowResponse> workflowActiveWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultOmicsAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (OmicsAsyncClient)OmicsAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.annotationImportJobCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetAnnotationImportJobResponse.class).acceptors(DefaultOmicsAsyncWaiter.annotationImportJobCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.annotationImportJobCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.annotationStoreCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetAnnotationStoreResponse.class).acceptors(DefaultOmicsAsyncWaiter.annotationStoreCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.annotationStoreCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.annotationStoreDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetAnnotationStoreResponse.class).acceptors(DefaultOmicsAsyncWaiter.annotationStoreDeletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.annotationStoreDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.annotationStoreVersionCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetAnnotationStoreVersionResponse.class).acceptors(DefaultOmicsAsyncWaiter.annotationStoreVersionCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.annotationStoreVersionCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.annotationStoreVersionDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetAnnotationStoreVersionResponse.class).acceptors(DefaultOmicsAsyncWaiter.annotationStoreVersionDeletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.annotationStoreVersionDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.readSetActivationJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetReadSetActivationJobResponse.class).acceptors(DefaultOmicsAsyncWaiter.readSetActivationJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.readSetActivationJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.readSetExportJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetReadSetExportJobResponse.class).acceptors(DefaultOmicsAsyncWaiter.readSetExportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.readSetExportJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.readSetImportJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetReadSetImportJobResponse.class).acceptors(DefaultOmicsAsyncWaiter.readSetImportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.readSetImportJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.referenceImportJobCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetReferenceImportJobResponse.class).acceptors(DefaultOmicsAsyncWaiter.referenceImportJobCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.referenceImportJobCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.runCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRunResponse.class).acceptors(DefaultOmicsAsyncWaiter.runCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.runCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.runRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRunResponse.class).acceptors(DefaultOmicsAsyncWaiter.runRunningWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.runRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.taskCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRunTaskResponse.class).acceptors(DefaultOmicsAsyncWaiter.taskCompletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.taskCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.taskRunningWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetRunTaskResponse.class).acceptors(DefaultOmicsAsyncWaiter.taskRunningWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.taskRunningWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.variantImportJobCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetVariantImportJobResponse.class).acceptors(DefaultOmicsAsyncWaiter.variantImportJobCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.variantImportJobCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.variantStoreCreatedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetVariantStoreResponse.class).acceptors(DefaultOmicsAsyncWaiter.variantStoreCreatedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.variantStoreCreatedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.variantStoreDeletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetVariantStoreResponse.class).acceptors(DefaultOmicsAsyncWaiter.variantStoreDeletedWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.variantStoreDeletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.workflowActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetWorkflowResponse.class).acceptors(DefaultOmicsAsyncWaiter.workflowActiveWaiterAcceptors())).overrideConfiguration(DefaultOmicsAsyncWaiter.workflowActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationImportJobResponse>> waitUntilAnnotationImportJobCreated(GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        return this.annotationImportJobCreatedWaiter.runAsync(() -> this.client.getAnnotationImportJob(this.applyWaitersUserAgent(getAnnotationImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationImportJobResponse>> waitUntilAnnotationImportJobCreated(GetAnnotationImportJobRequest getAnnotationImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationImportJobCreatedWaiter.runAsync(() -> this.client.getAnnotationImportJob(this.applyWaitersUserAgent(getAnnotationImportJobRequest)), DefaultOmicsAsyncWaiter.annotationImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreCreated(GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return this.annotationStoreCreatedWaiter.runAsync(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreCreated(GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationStoreCreatedWaiter.runAsync(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)), DefaultOmicsAsyncWaiter.annotationStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreDeleted(GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return this.annotationStoreDeletedWaiter.runAsync(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreResponse>> waitUntilAnnotationStoreDeleted(GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationStoreDeletedWaiter.runAsync(() -> this.client.getAnnotationStore(this.applyWaitersUserAgent(getAnnotationStoreRequest)), DefaultOmicsAsyncWaiter.annotationStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionCreated(GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        return this.annotationStoreVersionCreatedWaiter.runAsync(() -> this.client.getAnnotationStoreVersion(this.applyWaitersUserAgent(getAnnotationStoreVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionCreated(GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationStoreVersionCreatedWaiter.runAsync(() -> this.client.getAnnotationStoreVersion(this.applyWaitersUserAgent(getAnnotationStoreVersionRequest)), DefaultOmicsAsyncWaiter.annotationStoreVersionCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionDeleted(GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        return this.annotationStoreVersionDeletedWaiter.runAsync(() -> this.client.getAnnotationStoreVersion(this.applyWaitersUserAgent(getAnnotationStoreVersionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetAnnotationStoreVersionResponse>> waitUntilAnnotationStoreVersionDeleted(GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.annotationStoreVersionDeletedWaiter.runAsync(() -> this.client.getAnnotationStoreVersion(this.applyWaitersUserAgent(getAnnotationStoreVersionRequest)), DefaultOmicsAsyncWaiter.annotationStoreVersionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetActivationJobResponse>> waitUntilReadSetActivationJobCompleted(GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        return this.readSetActivationJobCompletedWaiter.runAsync(() -> this.client.getReadSetActivationJob(this.applyWaitersUserAgent(getReadSetActivationJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetActivationJobResponse>> waitUntilReadSetActivationJobCompleted(GetReadSetActivationJobRequest getReadSetActivationJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.readSetActivationJobCompletedWaiter.runAsync(() -> this.client.getReadSetActivationJob(this.applyWaitersUserAgent(getReadSetActivationJobRequest)), DefaultOmicsAsyncWaiter.readSetActivationJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetExportJobResponse>> waitUntilReadSetExportJobCompleted(GetReadSetExportJobRequest getReadSetExportJobRequest) {
        return this.readSetExportJobCompletedWaiter.runAsync(() -> this.client.getReadSetExportJob(this.applyWaitersUserAgent(getReadSetExportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetExportJobResponse>> waitUntilReadSetExportJobCompleted(GetReadSetExportJobRequest getReadSetExportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.readSetExportJobCompletedWaiter.runAsync(() -> this.client.getReadSetExportJob(this.applyWaitersUserAgent(getReadSetExportJobRequest)), DefaultOmicsAsyncWaiter.readSetExportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetImportJobResponse>> waitUntilReadSetImportJobCompleted(GetReadSetImportJobRequest getReadSetImportJobRequest) {
        return this.readSetImportJobCompletedWaiter.runAsync(() -> this.client.getReadSetImportJob(this.applyWaitersUserAgent(getReadSetImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReadSetImportJobResponse>> waitUntilReadSetImportJobCompleted(GetReadSetImportJobRequest getReadSetImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.readSetImportJobCompletedWaiter.runAsync(() -> this.client.getReadSetImportJob(this.applyWaitersUserAgent(getReadSetImportJobRequest)), DefaultOmicsAsyncWaiter.readSetImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReferenceImportJobResponse>> waitUntilReferenceImportJobCompleted(GetReferenceImportJobRequest getReferenceImportJobRequest) {
        return this.referenceImportJobCompletedWaiter.runAsync(() -> this.client.getReferenceImportJob(this.applyWaitersUserAgent(getReferenceImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetReferenceImportJobResponse>> waitUntilReferenceImportJobCompleted(GetReferenceImportJobRequest getReferenceImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.referenceImportJobCompletedWaiter.runAsync(() -> this.client.getReferenceImportJob(this.applyWaitersUserAgent(getReferenceImportJobRequest)), DefaultOmicsAsyncWaiter.referenceImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunCompleted(GetRunRequest getRunRequest) {
        return this.runCompletedWaiter.runAsync(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunCompleted(GetRunRequest getRunRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.runCompletedWaiter.runAsync(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)), DefaultOmicsAsyncWaiter.runCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunRunning(GetRunRequest getRunRequest) {
        return this.runRunningWaiter.runAsync(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunResponse>> waitUntilRunRunning(GetRunRequest getRunRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.runRunningWaiter.runAsync(() -> this.client.getRun(this.applyWaitersUserAgent(getRunRequest)), DefaultOmicsAsyncWaiter.runRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest) {
        return this.taskCompletedWaiter.runAsync(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.taskCompletedWaiter.runAsync(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)), DefaultOmicsAsyncWaiter.taskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest) {
        return this.taskRunningWaiter.runAsync(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetRunTaskResponse>> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.taskRunningWaiter.runAsync(() -> this.client.getRunTask(this.applyWaitersUserAgent(getRunTaskRequest)), DefaultOmicsAsyncWaiter.taskRunningWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantImportJobResponse>> waitUntilVariantImportJobCreated(GetVariantImportJobRequest getVariantImportJobRequest) {
        return this.variantImportJobCreatedWaiter.runAsync(() -> this.client.getVariantImportJob(this.applyWaitersUserAgent(getVariantImportJobRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantImportJobResponse>> waitUntilVariantImportJobCreated(GetVariantImportJobRequest getVariantImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.variantImportJobCreatedWaiter.runAsync(() -> this.client.getVariantImportJob(this.applyWaitersUserAgent(getVariantImportJobRequest)), DefaultOmicsAsyncWaiter.variantImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest) {
        return this.variantStoreCreatedWaiter.runAsync(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.variantStoreCreatedWaiter.runAsync(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)), DefaultOmicsAsyncWaiter.variantStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest) {
        return this.variantStoreDeletedWaiter.runAsync(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetVariantStoreResponse>> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.variantStoreDeletedWaiter.runAsync(() -> this.client.getVariantStore(this.applyWaitersUserAgent(getVariantStoreRequest)), DefaultOmicsAsyncWaiter.variantStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetWorkflowResponse>> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest) {
        return this.workflowActiveWaiter.runAsync(() -> this.client.getWorkflow(this.applyWaitersUserAgent(getWorkflowRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetWorkflowResponse>> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.workflowActiveWaiter.runAsync(() -> this.client.getWorkflow(this.applyWaitersUserAgent(getWorkflowRequest)), DefaultOmicsAsyncWaiter.workflowActiveWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetAnnotationImportJobResponse>> annotationImportJobCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationImportJobResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultOmicsAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> annotationStoreVersionCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> annotationStoreVersionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> result = new ArrayList<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultOmicsAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetActivationJobResponse>> readSetActivationJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReadSetActivationJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReadSetActivationJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetExportJobResponse>> readSetExportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReadSetExportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReadSetExportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetImportJobResponse>> readSetImportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReadSetImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReadSetImportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReferenceImportJobResponse>> referenceImportJobCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetReferenceImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetReferenceImportJobResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunTaskResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<WaiterAcceptor<? super GetRunTaskResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantImportJobResponse>> variantImportJobCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVariantImportJobResponse>> result = new ArrayList<WaiterAcceptor<? super GetVariantImportJobResponse>>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreCreatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<WaiterAcceptor<? super GetVariantStoreResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultOmicsAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetWorkflowResponse>> workflowActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetWorkflowResponse>> result = new ArrayList<WaiterAcceptor<? super GetWorkflowResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration annotationImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreVersionCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreVersionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetActivationJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetExportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration referenceImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration workflowActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static OmicsAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends OmicsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OmicsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements OmicsAsyncWaiter.Builder {
        private OmicsAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public OmicsAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public OmicsAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public OmicsAsyncWaiter.Builder client(OmicsAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public OmicsAsyncWaiter build() {
            return new DefaultOmicsAsyncWaiter(this);
        }
    }
}

