/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.ETagAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ETag
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ETag> {
    private static final SdkField<String> ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("algorithm").getter(ETag.getter(ETag::algorithmAsString)).setter(ETag.setter(Builder::algorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("algorithm").build()}).build();
    private static final SdkField<String> SOURCE1_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source1").getter(ETag.getter(ETag::source1)).setter(ETag.setter(Builder::source1)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source1").build()}).build();
    private static final SdkField<String> SOURCE2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("source2").getter(ETag.getter(ETag::source2)).setter(ETag.setter(Builder::source2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source2").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_FIELD, SOURCE1_FIELD, SOURCE2_FIELD));
    private static final long serialVersionUID = 1L;
    private final String algorithm;
    private final String source1;
    private final String source2;

    private ETag(BuilderImpl builder) {
        this.algorithm = builder.algorithm;
        this.source1 = builder.source1;
        this.source2 = builder.source2;
    }

    public final ETagAlgorithm algorithm() {
        return ETagAlgorithm.fromValue(this.algorithm);
    }

    public final String algorithmAsString() {
        return this.algorithm;
    }

    public final String source1() {
        return this.source1;
    }

    public final String source2() {
        return this.source2;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.source1());
        hashCode = 31 * hashCode + Objects.hashCode(this.source2());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ETag)) {
            return false;
        }
        ETag other = (ETag)obj;
        return Objects.equals(this.algorithmAsString(), other.algorithmAsString()) && Objects.equals(this.source1(), other.source1()) && Objects.equals(this.source2(), other.source2());
    }

    public final String toString() {
        return ToString.builder((String)"ETag").add("Algorithm", (Object)this.algorithmAsString()).add("Source1", (Object)this.source1()).add("Source2", (Object)this.source2()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "algorithm": {
                return Optional.ofNullable(clazz.cast(this.algorithmAsString()));
            }
            case "source1": {
                return Optional.ofNullable(clazz.cast(this.source1()));
            }
            case "source2": {
                return Optional.ofNullable(clazz.cast(this.source2()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ETag, T> g) {
        return obj -> g.apply((ETag)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String algorithm;
        private String source1;
        private String source2;

        private BuilderImpl() {
        }

        private BuilderImpl(ETag model) {
            this.algorithm(model.algorithm);
            this.source1(model.source1);
            this.source2(model.source2);
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        @Override
        public final Builder algorithm(String algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public final Builder algorithm(ETagAlgorithm algorithm) {
            this.algorithm(algorithm == null ? null : algorithm.toString());
            return this;
        }

        public final String getSource1() {
            return this.source1;
        }

        public final void setSource1(String source1) {
            this.source1 = source1;
        }

        @Override
        public final Builder source1(String source1) {
            this.source1 = source1;
            return this;
        }

        public final String getSource2() {
            return this.source2;
        }

        public final void setSource2(String source2) {
            this.source2 = source2;
        }

        @Override
        public final Builder source2(String source2) {
            this.source2 = source2;
            return this;
        }

        public ETag build() {
            return new ETag(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ETag> {
        public Builder algorithm(String var1);

        public Builder algorithm(ETagAlgorithm var1);

        public Builder source1(String var1);

        public Builder source2(String var1);
    }
}

