/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkflowParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkflowParameter> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(WorkflowParameter.getter(WorkflowParameter::description)).setter(WorkflowParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> OPTIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("optional").getter(WorkflowParameter.getter(WorkflowParameter::optional)).setter(WorkflowParameter.setter(Builder::optional)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optional").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, OPTIONAL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String description;
    private final Boolean optional;

    private WorkflowParameter(BuilderImpl builder) {
        this.description = builder.description;
        this.optional = builder.optional;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean optional() {
        return this.optional;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.optional());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkflowParameter)) {
            return false;
        }
        WorkflowParameter other = (WorkflowParameter)obj;
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.optional(), other.optional());
    }

    public final String toString() {
        return ToString.builder((String)"WorkflowParameter").add("Description", (Object)this.description()).add("Optional", (Object)this.optional()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "optional": {
                return Optional.ofNullable(clazz.cast(this.optional()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WorkflowParameter, T> g) {
        return obj -> g.apply((WorkflowParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String description;
        private Boolean optional;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkflowParameter model) {
            this.description(model.description);
            this.optional(model.optional);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getOptional() {
            return this.optional;
        }

        public final void setOptional(Boolean optional) {
            this.optional = optional;
        }

        @Override
        public final Builder optional(Boolean optional) {
            this.optional = optional;
            return this;
        }

        public WorkflowParameter build() {
            return new WorkflowParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkflowParameter> {
        public Builder description(String var1);

        public Builder optional(Boolean var1);
    }
}

