/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse;
import software.amazon.awssdk.services.omics.model.MultipartReadSetUploadListItem;

public class ListMultipartReadSetUploadsIterable
implements SdkIterable<ListMultipartReadSetUploadsResponse> {
    private final OmicsClient client;
    private final ListMultipartReadSetUploadsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMultipartReadSetUploadsIterable(OmicsClient client, ListMultipartReadSetUploadsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMultipartReadSetUploadsResponseFetcher();
    }

    public Iterator<ListMultipartReadSetUploadsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MultipartReadSetUploadListItem> uploads() {
        Function<ListMultipartReadSetUploadsResponse, Iterator> getIterator = response -> {
            if (response != null && response.uploads() != null) {
                return response.uploads().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMultipartReadSetUploadsResponseFetcher
    implements SyncPageFetcher<ListMultipartReadSetUploadsResponse> {
        private ListMultipartReadSetUploadsResponseFetcher() {
        }

        public boolean hasNextPage(ListMultipartReadSetUploadsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMultipartReadSetUploadsResponse nextPage(ListMultipartReadSetUploadsResponse previousPage) {
            if (previousPage == null) {
                return ListMultipartReadSetUploadsIterable.this.client.listMultipartReadSetUploads(ListMultipartReadSetUploadsIterable.this.firstRequest);
            }
            return ListMultipartReadSetUploadsIterable.this.client.listMultipartReadSetUploads((ListMultipartReadSetUploadsRequest)((Object)ListMultipartReadSetUploadsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

