/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.omics.auth.scheme.OmicsAuthSchemeParams;
import software.amazon.awssdk.services.omics.auth.scheme.OmicsAuthSchemeProvider;

@SdkInternalApi
public final class DefaultOmicsAuthSchemeProvider
implements OmicsAuthSchemeProvider {
    private static final DefaultOmicsAuthSchemeProvider DEFAULT = new DefaultOmicsAuthSchemeProvider();

    private DefaultOmicsAuthSchemeProvider() {
    }

    public static DefaultOmicsAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(OmicsAuthSchemeParams params) {
        ArrayList<Object> options = new ArrayList<Object>();
        switch (params.operation()) {
            case "UploadReadSetPart": {
                options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"omics").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).putSignerProperty(AwsV4HttpSigner.PAYLOAD_SIGNING_ENABLED, (Object)false).build());
                break;
            }
            default: {
                options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"omics").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

