/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Files in a read set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReadSetFiles implements SdkPojo, Serializable, ToCopyableBuilder<ReadSetFiles.Builder, ReadSetFiles> {
    private static final SdkField<FileInformation> SOURCE1_FIELD = SdkField.<FileInformation> builder(MarshallingType.SDK_POJO)
            .memberName("source1").getter(getter(ReadSetFiles::source1)).setter(setter(Builder::source1))
            .constructor(FileInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source1").build()).build();

    private static final SdkField<FileInformation> SOURCE2_FIELD = SdkField.<FileInformation> builder(MarshallingType.SDK_POJO)
            .memberName("source2").getter(getter(ReadSetFiles::source2)).setter(setter(Builder::source2))
            .constructor(FileInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source2").build()).build();

    private static final SdkField<FileInformation> INDEX_FIELD = SdkField.<FileInformation> builder(MarshallingType.SDK_POJO)
            .memberName("index").getter(getter(ReadSetFiles::index)).setter(setter(Builder::index))
            .constructor(FileInformation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("index").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE1_FIELD, SOURCE2_FIELD,
            INDEX_FIELD));

    private static final long serialVersionUID = 1L;

    private final FileInformation source1;

    private final FileInformation source2;

    private final FileInformation index;

    private ReadSetFiles(BuilderImpl builder) {
        this.source1 = builder.source1;
        this.source2 = builder.source2;
        this.index = builder.index;
    }

    /**
     * <p>
     * The location of the first file in Amazon S3.
     * </p>
     * 
     * @return The location of the first file in Amazon S3.
     */
    public final FileInformation source1() {
        return source1;
    }

    /**
     * <p>
     * The location of the second file in Amazon S3.
     * </p>
     * 
     * @return The location of the second file in Amazon S3.
     */
    public final FileInformation source2() {
        return source2;
    }

    /**
     * <p>
     * The files' index.
     * </p>
     * 
     * @return The files' index.
     */
    public final FileInformation index() {
        return index;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source1());
        hashCode = 31 * hashCode + Objects.hashCode(source2());
        hashCode = 31 * hashCode + Objects.hashCode(index());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadSetFiles)) {
            return false;
        }
        ReadSetFiles other = (ReadSetFiles) obj;
        return Objects.equals(source1(), other.source1()) && Objects.equals(source2(), other.source2())
                && Objects.equals(index(), other.index());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReadSetFiles").add("Source1", source1()).add("Source2", source2()).add("Index", index()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source1":
            return Optional.ofNullable(clazz.cast(source1()));
        case "source2":
            return Optional.ofNullable(clazz.cast(source2()));
        case "index":
            return Optional.ofNullable(clazz.cast(index()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReadSetFiles, T> g) {
        return obj -> g.apply((ReadSetFiles) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReadSetFiles> {
        /**
         * <p>
         * The location of the first file in Amazon S3.
         * </p>
         * 
         * @param source1
         *        The location of the first file in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source1(FileInformation source1);

        /**
         * <p>
         * The location of the first file in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileInformation.Builder} avoiding the
         * need to create one manually via {@link FileInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #source1(FileInformation)}.
         * 
         * @param source1
         *        a consumer that will call methods on {@link FileInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source1(FileInformation)
         */
        default Builder source1(Consumer<FileInformation.Builder> source1) {
            return source1(FileInformation.builder().applyMutation(source1).build());
        }

        /**
         * <p>
         * The location of the second file in Amazon S3.
         * </p>
         * 
         * @param source2
         *        The location of the second file in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source2(FileInformation source2);

        /**
         * <p>
         * The location of the second file in Amazon S3.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileInformation.Builder} avoiding the
         * need to create one manually via {@link FileInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #source2(FileInformation)}.
         * 
         * @param source2
         *        a consumer that will call methods on {@link FileInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #source2(FileInformation)
         */
        default Builder source2(Consumer<FileInformation.Builder> source2) {
            return source2(FileInformation.builder().applyMutation(source2).build());
        }

        /**
         * <p>
         * The files' index.
         * </p>
         * 
         * @param index
         *        The files' index.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder index(FileInformation index);

        /**
         * <p>
         * The files' index.
         * </p>
         * This is a convenience method that creates an instance of the {@link FileInformation.Builder} avoiding the
         * need to create one manually via {@link FileInformation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FileInformation.Builder#build()} is called immediately and its
         * result is passed to {@link #index(FileInformation)}.
         * 
         * @param index
         *        a consumer that will call methods on {@link FileInformation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #index(FileInformation)
         */
        default Builder index(Consumer<FileInformation.Builder> index) {
            return index(FileInformation.builder().applyMutation(index).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FileInformation source1;

        private FileInformation source2;

        private FileInformation index;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadSetFiles model) {
            source1(model.source1);
            source2(model.source2);
            index(model.index);
        }

        public final FileInformation.Builder getSource1() {
            return source1 != null ? source1.toBuilder() : null;
        }

        public final void setSource1(FileInformation.BuilderImpl source1) {
            this.source1 = source1 != null ? source1.build() : null;
        }

        @Override
        public final Builder source1(FileInformation source1) {
            this.source1 = source1;
            return this;
        }

        public final FileInformation.Builder getSource2() {
            return source2 != null ? source2.toBuilder() : null;
        }

        public final void setSource2(FileInformation.BuilderImpl source2) {
            this.source2 = source2 != null ? source2.build() : null;
        }

        @Override
        public final Builder source2(FileInformation source2) {
            this.source2 = source2;
            return this;
        }

        public final FileInformation.Builder getIndex() {
            return index != null ? index.toBuilder() : null;
        }

        public final void setIndex(FileInformation.BuilderImpl index) {
            this.index = index != null ? index.build() : null;
        }

        @Override
        public final Builder index(FileInformation index) {
            this.index = index;
            return this;
        }

        @Override
        public ReadSetFiles build() {
            return new ReadSetFiles(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
