/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetUploadPartListItem;

public class ListReadSetUploadPartsIterable
implements SdkIterable<ListReadSetUploadPartsResponse> {
    private final OmicsClient client;
    private final ListReadSetUploadPartsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReadSetUploadPartsIterable(OmicsClient client, ListReadSetUploadPartsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReadSetUploadPartsResponseFetcher();
    }

    public Iterator<ListReadSetUploadPartsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReadSetUploadPartListItem> parts() {
        Function<ListReadSetUploadPartsResponse, Iterator> getIterator = response -> {
            if (response != null && response.parts() != null) {
                return response.parts().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReadSetUploadPartsResponseFetcher
    implements SyncPageFetcher<ListReadSetUploadPartsResponse> {
        private ListReadSetUploadPartsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetUploadPartsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReadSetUploadPartsResponse nextPage(ListReadSetUploadPartsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetUploadPartsIterable.this.client.listReadSetUploadParts(ListReadSetUploadPartsIterable.this.firstRequest);
            }
            return ListReadSetUploadPartsIterable.this.client.listReadSetUploadParts((ListReadSetUploadPartsRequest)((Object)ListReadSetUploadPartsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

