/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetListItem;

public class ListReadSetsIterable
implements SdkIterable<ListReadSetsResponse> {
    private final OmicsClient client;
    private final ListReadSetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListReadSetsIterable(OmicsClient client, ListReadSetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListReadSetsResponseFetcher();
    }

    public Iterator<ListReadSetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReadSetListItem> readSets() {
        Function<ListReadSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.readSets() != null) {
                return response.readSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListReadSetsResponseFetcher
    implements SyncPageFetcher<ListReadSetsResponse> {
        private ListReadSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListReadSetsResponse nextPage(ListReadSetsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetsIterable.this.client.listReadSets(ListReadSetsIterable.this.firstRequest);
            }
            return ListReadSetsIterable.this.client.listReadSets((ListReadSetsRequest)((Object)ListReadSetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

