/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.Aws4UnsignedPayloadSigner;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.OmicsServiceClientConfiguration;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.AccessDeniedException;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.CancelRunRequest;
import software.amazon.awssdk.services.omics.model.CancelRunResponse;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.ConflictException;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.CreateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunResponse;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetRunGroupRequest;
import software.amazon.awssdk.services.omics.model.GetRunGroupResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.InternalServerException;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.ListRunsRequest;
import software.amazon.awssdk.services.omics.model.ListRunsResponse;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.omics.model.NotSupportedOperationException;
import software.amazon.awssdk.services.omics.model.OmicsException;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.RangeNotSatisfiableException;
import software.amazon.awssdk.services.omics.model.RequestTimeoutException;
import software.amazon.awssdk.services.omics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.omics.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartRunRequest;
import software.amazon.awssdk.services.omics.model.StartRunResponse;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.TagResourceRequest;
import software.amazon.awssdk.services.omics.model.TagResourceResponse;
import software.amazon.awssdk.services.omics.model.ThrottlingException;
import software.amazon.awssdk.services.omics.model.UntagResourceRequest;
import software.amazon.awssdk.services.omics.model.UntagResourceResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartResponse;
import software.amazon.awssdk.services.omics.model.ValidationException;
import software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsIterable;
import software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresIterable;
import software.amazon.awssdk.services.omics.paginators.ListMultipartReadSetUploadsIterable;
import software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsIterable;
import software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsIterable;
import software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsIterable;
import software.amazon.awssdk.services.omics.paginators.ListReadSetUploadPartsIterable;
import software.amazon.awssdk.services.omics.paginators.ListReadSetsIterable;
import software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsIterable;
import software.amazon.awssdk.services.omics.paginators.ListReferenceStoresIterable;
import software.amazon.awssdk.services.omics.paginators.ListReferencesIterable;
import software.amazon.awssdk.services.omics.paginators.ListRunGroupsIterable;
import software.amazon.awssdk.services.omics.paginators.ListRunTasksIterable;
import software.amazon.awssdk.services.omics.paginators.ListRunsIterable;
import software.amazon.awssdk.services.omics.paginators.ListSequenceStoresIterable;
import software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsIterable;
import software.amazon.awssdk.services.omics.paginators.ListVariantStoresIterable;
import software.amazon.awssdk.services.omics.paginators.ListWorkflowsIterable;
import software.amazon.awssdk.services.omics.transform.AbortMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.BatchDeleteReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CompleteMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunTaskRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListMultipartReadSetUploadsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetActivationJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetUploadPartsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferencesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunGroupsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunTasksRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListSequenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UploadReadSetPartRequestMarshaller;
import software.amazon.awssdk.services.omics.waiters.OmicsWaiter;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultOmicsClient
implements OmicsClient {
    private static final Logger log = Logger.loggerFor(DefaultOmicsClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final OmicsServiceClientConfiguration serviceClientConfiguration;

    protected DefaultOmicsClient(OmicsServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbortMultipartReadSetUploadResponse abortMultipartReadSetUpload(AbortMultipartReadSetUploadRequest abortMultipartReadSetUploadRequest) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        abortMultipartReadSetUploadRequest = this.applySignerOverride(abortMultipartReadSetUploadRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AbortMultipartReadSetUploadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, abortMultipartReadSetUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AbortMultipartReadSetUpload");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            AbortMultipartReadSetUploadResponse abortMultipartReadSetUploadResponse = (AbortMultipartReadSetUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AbortMultipartReadSetUpload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)abortMultipartReadSetUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AbortMultipartReadSetUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return abortMultipartReadSetUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$abortMultipartReadSetUpload$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteReadSetResponse batchDeleteReadSet(BatchDeleteReadSetRequest batchDeleteReadSetRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        batchDeleteReadSetRequest = this.applySignerOverride(batchDeleteReadSetRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, BatchDeleteReadSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, batchDeleteReadSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BatchDeleteReadSet");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            BatchDeleteReadSetResponse batchDeleteReadSetResponse = (BatchDeleteReadSetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BatchDeleteReadSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)batchDeleteReadSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BatchDeleteReadSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return batchDeleteReadSetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$batchDeleteReadSet$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelAnnotationImportJobResponse cancelAnnotationImportJob(CancelAnnotationImportJobRequest cancelAnnotationImportJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        cancelAnnotationImportJobRequest = this.applySignerOverride(cancelAnnotationImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelAnnotationImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, cancelAnnotationImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            CancelAnnotationImportJobResponse cancelAnnotationImportJobResponse = (CancelAnnotationImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelAnnotationImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)cancelAnnotationImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelAnnotationImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelAnnotationImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$cancelAnnotationImportJob$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelRunResponse cancelRun(CancelRunRequest cancelRunRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        cancelRunRequest = this.applySignerOverride(cancelRunRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, cancelRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            CancelRunResponse cancelRunResponse = (CancelRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)cancelRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$cancelRun$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelVariantImportJobResponse cancelVariantImportJob(CancelVariantImportJobRequest cancelVariantImportJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        cancelVariantImportJobRequest = this.applySignerOverride(cancelVariantImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelVariantImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, cancelVariantImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            CancelVariantImportJobResponse cancelVariantImportJobResponse = (CancelVariantImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelVariantImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)cancelVariantImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelVariantImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelVariantImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$cancelVariantImportJob$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteMultipartReadSetUploadResponse completeMultipartReadSetUpload(CompleteMultipartReadSetUploadRequest completeMultipartReadSetUploadRequest) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        completeMultipartReadSetUploadRequest = this.applySignerOverride(completeMultipartReadSetUploadRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CompleteMultipartReadSetUploadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, completeMultipartReadSetUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CompleteMultipartReadSetUpload");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";
            CompleteMultipartReadSetUploadResponse completeMultipartReadSetUploadResponse = (CompleteMultipartReadSetUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CompleteMultipartReadSetUpload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)completeMultipartReadSetUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CompleteMultipartReadSetUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return completeMultipartReadSetUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$completeMultipartReadSetUpload$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAnnotationStoreResponse createAnnotationStore(CreateAnnotationStoreRequest createAnnotationStoreRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        createAnnotationStoreRequest = this.applySignerOverride(createAnnotationStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnnotationStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, createAnnotationStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            CreateAnnotationStoreResponse createAnnotationStoreResponse = (CreateAnnotationStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnnotationStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createAnnotationStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAnnotationStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAnnotationStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$createAnnotationStore$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateMultipartReadSetUploadResponse createMultipartReadSetUpload(CreateMultipartReadSetUploadRequest createMultipartReadSetUploadRequest) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        createMultipartReadSetUploadRequest = this.applySignerOverride(createMultipartReadSetUploadRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateMultipartReadSetUploadResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, createMultipartReadSetUploadRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateMultipartReadSetUpload");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            CreateMultipartReadSetUploadResponse createMultipartReadSetUploadResponse = (CreateMultipartReadSetUploadResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateMultipartReadSetUpload").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createMultipartReadSetUploadRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateMultipartReadSetUploadRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createMultipartReadSetUploadResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$createMultipartReadSetUpload$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateReferenceStoreResponse createReferenceStore(CreateReferenceStoreRequest createReferenceStoreRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        createReferenceStoreRequest = this.applySignerOverride(createReferenceStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateReferenceStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, createReferenceStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            CreateReferenceStoreResponse createReferenceStoreResponse = (CreateReferenceStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateReferenceStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createReferenceStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateReferenceStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createReferenceStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$createReferenceStore$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRunGroupResponse createRunGroup(CreateRunGroupRequest createRunGroupRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        createRunGroupRequest = this.applySignerOverride(createRunGroupRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateRunGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, createRunGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            CreateRunGroupResponse createRunGroupResponse = (CreateRunGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateRunGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createRunGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateRunGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createRunGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$createRunGroup$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateSequenceStoreResponse createSequenceStore(CreateSequenceStoreRequest createSequenceStoreRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        createSequenceStoreRequest = this.applySignerOverride(createSequenceStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateSequenceStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, createSequenceStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            CreateSequenceStoreResponse createSequenceStoreResponse = (CreateSequenceStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateSequenceStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createSequenceStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateSequenceStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createSequenceStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$createSequenceStore$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateVariantStoreResponse createVariantStore(CreateVariantStoreRequest createVariantStoreRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        createVariantStoreRequest = this.applySignerOverride(createVariantStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateVariantStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, createVariantStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            CreateVariantStoreResponse createVariantStoreResponse = (CreateVariantStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateVariantStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createVariantStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateVariantStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createVariantStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$createVariantStore$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        createWorkflowRequest = this.applySignerOverride(createWorkflowRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateWorkflowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, createWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            CreateWorkflowResponse createWorkflowResponse = (CreateWorkflowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateWorkflow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)createWorkflowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createWorkflowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$createWorkflow$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnnotationStoreResponse deleteAnnotationStore(DeleteAnnotationStoreRequest deleteAnnotationStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        deleteAnnotationStoreRequest = this.applySignerOverride(deleteAnnotationStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnnotationStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteAnnotationStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            DeleteAnnotationStoreResponse deleteAnnotationStoreResponse = (DeleteAnnotationStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnnotationStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteAnnotationStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnnotationStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnnotationStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteAnnotationStore$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReferenceResponse deleteReference(DeleteReferenceRequest deleteReferenceRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        deleteReferenceRequest = this.applySignerOverride(deleteReferenceRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReferenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteReferenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReference");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            DeleteReferenceResponse deleteReferenceResponse = (DeleteReferenceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReference").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteReferenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReferenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReferenceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteReference$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteReferenceStoreResponse deleteReferenceStore(DeleteReferenceStoreRequest deleteReferenceStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        deleteReferenceStoreRequest = this.applySignerOverride(deleteReferenceStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteReferenceStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteReferenceStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            DeleteReferenceStoreResponse deleteReferenceStoreResponse = (DeleteReferenceStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteReferenceStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteReferenceStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteReferenceStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteReferenceStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteReferenceStore$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRunResponse deleteRun(DeleteRunRequest deleteRunRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        deleteRunRequest = this.applySignerOverride(deleteRunRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            DeleteRunResponse deleteRunResponse = (DeleteRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteRun$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRunGroupResponse deleteRunGroup(DeleteRunGroupRequest deleteRunGroupRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        deleteRunGroupRequest = this.applySignerOverride(deleteRunGroupRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteRunGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteRunGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            DeleteRunGroupResponse deleteRunGroupResponse = (DeleteRunGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteRunGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteRunGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteRunGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteRunGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteRunGroup$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSequenceStoreResponse deleteSequenceStore(DeleteSequenceStoreRequest deleteSequenceStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        deleteSequenceStoreRequest = this.applySignerOverride(deleteSequenceStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteSequenceStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteSequenceStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            DeleteSequenceStoreResponse deleteSequenceStoreResponse = (DeleteSequenceStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSequenceStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteSequenceStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSequenceStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteSequenceStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteSequenceStore$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteVariantStoreResponse deleteVariantStore(DeleteVariantStoreRequest deleteVariantStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        deleteVariantStoreRequest = this.applySignerOverride(deleteVariantStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteVariantStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteVariantStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            DeleteVariantStoreResponse deleteVariantStoreResponse = (DeleteVariantStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteVariantStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteVariantStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteVariantStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteVariantStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteVariantStore$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        deleteWorkflowRequest = this.applySignerOverride(deleteWorkflowRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteWorkflowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, deleteWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            DeleteWorkflowResponse deleteWorkflowResponse = (DeleteWorkflowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteWorkflow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)deleteWorkflowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteWorkflowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$deleteWorkflow$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnnotationImportJobResponse getAnnotationImportJob(GetAnnotationImportJobRequest getAnnotationImportJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        getAnnotationImportJobRequest = this.applySignerOverride(getAnnotationImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnnotationImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getAnnotationImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            GetAnnotationImportJobResponse getAnnotationImportJobResponse = (GetAnnotationImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnnotationImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAnnotationImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnnotationImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnnotationImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getAnnotationImportJob$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnnotationStoreResponse getAnnotationStore(GetAnnotationStoreRequest getAnnotationStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        getAnnotationStoreRequest = this.applySignerOverride(getAnnotationStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnnotationStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getAnnotationStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            GetAnnotationStoreResponse getAnnotationStoreResponse = (GetAnnotationStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnnotationStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getAnnotationStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAnnotationStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnnotationStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getAnnotationStore$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getReadSet(GetReadSetRequest getReadSetRequest, ResponseTransformer<GetReadSetResponse, ReturnT> responseTransformer) throws InternalServerException, RangeNotSatisfiableException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReadSetRequest = this.applySignerOverride(getReadSetRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadSetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReadSetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadSet");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadSet").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReadSetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadSetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReadSet$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReadSetActivationJobResponse getReadSetActivationJob(GetReadSetActivationJobRequest getReadSetActivationJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReadSetActivationJobRequest = this.applySignerOverride(getReadSetActivationJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadSetActivationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReadSetActivationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadSetActivationJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetReadSetActivationJobResponse getReadSetActivationJobResponse = (GetReadSetActivationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadSetActivationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReadSetActivationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadSetActivationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReadSetActivationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReadSetActivationJob$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReadSetExportJobResponse getReadSetExportJob(GetReadSetExportJobRequest getReadSetExportJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReadSetExportJobRequest = this.applySignerOverride(getReadSetExportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadSetExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReadSetExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadSetExportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetReadSetExportJobResponse getReadSetExportJobResponse = (GetReadSetExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadSetExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReadSetExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadSetExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReadSetExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReadSetExportJob$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReadSetImportJobResponse getReadSetImportJob(GetReadSetImportJobRequest getReadSetImportJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReadSetImportJobRequest = this.applySignerOverride(getReadSetImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadSetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReadSetImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadSetImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetReadSetImportJobResponse getReadSetImportJobResponse = (GetReadSetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadSetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReadSetImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadSetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReadSetImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReadSetImportJob$26((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReadSetMetadataResponse getReadSetMetadata(GetReadSetMetadataRequest getReadSetMetadataRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReadSetMetadataRequest = this.applySignerOverride(getReadSetMetadataRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReadSetMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReadSetMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReadSetMetadata");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetReadSetMetadataResponse getReadSetMetadataResponse = (GetReadSetMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReadSetMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReadSetMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReadSetMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReadSetMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReadSetMetadata$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <ReturnT> ReturnT getReference(GetReferenceRequest getReferenceRequest, ResponseTransformer<GetReferenceResponse, ReturnT> responseTransformer) throws InternalServerException, RangeNotSatisfiableException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReferenceRequest = this.applySignerOverride(getReferenceRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true).isPayloadJson(false).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReferenceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReferenceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReference");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";
            Object object = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReference").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReferenceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReferenceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)), responseTransformer);
            return (ReturnT)object;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReference$28((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReferenceImportJobResponse getReferenceImportJob(GetReferenceImportJobRequest getReferenceImportJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReferenceImportJobRequest = this.applySignerOverride(getReferenceImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReferenceImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReferenceImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReferenceImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetReferenceImportJobResponse getReferenceImportJobResponse = (GetReferenceImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReferenceImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReferenceImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReferenceImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReferenceImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReferenceImportJob$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReferenceMetadataResponse getReferenceMetadata(GetReferenceMetadataRequest getReferenceMetadataRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReferenceMetadataRequest = this.applySignerOverride(getReferenceMetadataRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReferenceMetadataResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReferenceMetadataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReferenceMetadata");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetReferenceMetadataResponse getReferenceMetadataResponse = (GetReferenceMetadataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReferenceMetadata").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReferenceMetadataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReferenceMetadataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReferenceMetadataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReferenceMetadata$30((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetReferenceStoreResponse getReferenceStore(GetReferenceStoreRequest getReferenceStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getReferenceStoreRequest = this.applySignerOverride(getReferenceStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetReferenceStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getReferenceStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetReferenceStoreResponse getReferenceStoreResponse = (GetReferenceStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetReferenceStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getReferenceStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetReferenceStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getReferenceStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getReferenceStore$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRunResponse getRun(GetRunRequest getRunRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getRunRequest = this.applySignerOverride(getRunRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            GetRunResponse getRunResponse = (GetRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getRun$32((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRunGroupResponse getRunGroup(GetRunGroupRequest getRunGroupRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getRunGroupRequest = this.applySignerOverride(getRunGroupRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRunGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getRunGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            GetRunGroupResponse getRunGroupResponse = (GetRunGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRunGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getRunGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRunGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRunGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getRunGroup$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRunTaskResponse getRunTask(GetRunTaskRequest getRunTaskRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getRunTaskRequest = this.applySignerOverride(getRunTaskRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetRunTaskResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getRunTaskRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetRunTask");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            GetRunTaskResponse getRunTaskResponse = (GetRunTaskResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetRunTask").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getRunTaskRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetRunTaskRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getRunTaskResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getRunTask$34((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetSequenceStoreResponse getSequenceStore(GetSequenceStoreRequest getSequenceStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getSequenceStoreRequest = this.applySignerOverride(getSequenceStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetSequenceStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getSequenceStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            GetSequenceStoreResponse getSequenceStoreResponse = (GetSequenceStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetSequenceStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getSequenceStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetSequenceStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getSequenceStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getSequenceStore$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVariantImportJobResponse getVariantImportJob(GetVariantImportJobRequest getVariantImportJobRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        getVariantImportJobRequest = this.applySignerOverride(getVariantImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVariantImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getVariantImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            GetVariantImportJobResponse getVariantImportJobResponse = (GetVariantImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVariantImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getVariantImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetVariantImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVariantImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getVariantImportJob$36((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVariantStoreResponse getVariantStore(GetVariantStoreRequest getVariantStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        getVariantStoreRequest = this.applySignerOverride(getVariantStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVariantStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getVariantStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            GetVariantStoreResponse getVariantStoreResponse = (GetVariantStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVariantStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getVariantStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetVariantStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVariantStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getVariantStore$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        getWorkflowRequest = this.applySignerOverride(getWorkflowRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetWorkflowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, getWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            GetWorkflowResponse getWorkflowResponse = (GetWorkflowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetWorkflow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)getWorkflowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getWorkflowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$getWorkflow$38((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnnotationImportJobsResponse listAnnotationImportJobs(ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        listAnnotationImportJobsRequest = this.applySignerOverride(listAnnotationImportJobsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnnotationImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listAnnotationImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnnotationImportJobs");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            ListAnnotationImportJobsResponse listAnnotationImportJobsResponse = (ListAnnotationImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnnotationImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listAnnotationImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnnotationImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnnotationImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listAnnotationImportJobs$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnnotationImportJobsIterable listAnnotationImportJobsPaginator(ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        return new ListAnnotationImportJobsIterable(this, this.applyPaginatorUserAgent(listAnnotationImportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnnotationStoresResponse listAnnotationStores(ListAnnotationStoresRequest listAnnotationStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        listAnnotationStoresRequest = this.applySignerOverride(listAnnotationStoresRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnnotationStoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listAnnotationStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnnotationStores");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            ListAnnotationStoresResponse listAnnotationStoresResponse = (ListAnnotationStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnnotationStores").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listAnnotationStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAnnotationStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnnotationStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listAnnotationStores$40((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListAnnotationStoresIterable listAnnotationStoresPaginator(ListAnnotationStoresRequest listAnnotationStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        return new ListAnnotationStoresIterable(this, this.applyPaginatorUserAgent(listAnnotationStoresRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListMultipartReadSetUploadsResponse listMultipartReadSetUploads(ListMultipartReadSetUploadsRequest listMultipartReadSetUploadsRequest) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listMultipartReadSetUploadsRequest = this.applySignerOverride(listMultipartReadSetUploadsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListMultipartReadSetUploadsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listMultipartReadSetUploadsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMultipartReadSetUploads");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListMultipartReadSetUploadsResponse listMultipartReadSetUploadsResponse = (ListMultipartReadSetUploadsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMultipartReadSetUploads").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listMultipartReadSetUploadsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListMultipartReadSetUploadsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listMultipartReadSetUploadsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listMultipartReadSetUploads$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListMultipartReadSetUploadsIterable listMultipartReadSetUploadsPaginator(ListMultipartReadSetUploadsRequest listMultipartReadSetUploadsRequest) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListMultipartReadSetUploadsIterable(this, this.applyPaginatorUserAgent(listMultipartReadSetUploadsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReadSetActivationJobsResponse listReadSetActivationJobs(ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReadSetActivationJobsRequest = this.applySignerOverride(listReadSetActivationJobsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReadSetActivationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReadSetActivationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReadSetActivationJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReadSetActivationJobsResponse listReadSetActivationJobsResponse = (ListReadSetActivationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReadSetActivationJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReadSetActivationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReadSetActivationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReadSetActivationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReadSetActivationJobs$42((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReadSetActivationJobsIterable listReadSetActivationJobsPaginator(ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReadSetActivationJobsIterable(this, this.applyPaginatorUserAgent(listReadSetActivationJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReadSetExportJobsResponse listReadSetExportJobs(ListReadSetExportJobsRequest listReadSetExportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReadSetExportJobsRequest = this.applySignerOverride(listReadSetExportJobsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReadSetExportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReadSetExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReadSetExportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReadSetExportJobsResponse listReadSetExportJobsResponse = (ListReadSetExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReadSetExportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReadSetExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReadSetExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReadSetExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReadSetExportJobs$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReadSetExportJobsIterable listReadSetExportJobsPaginator(ListReadSetExportJobsRequest listReadSetExportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReadSetExportJobsIterable(this, this.applyPaginatorUserAgent(listReadSetExportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReadSetImportJobsResponse listReadSetImportJobs(ListReadSetImportJobsRequest listReadSetImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReadSetImportJobsRequest = this.applySignerOverride(listReadSetImportJobsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReadSetImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReadSetImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReadSetImportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReadSetImportJobsResponse listReadSetImportJobsResponse = (ListReadSetImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReadSetImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReadSetImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReadSetImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReadSetImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReadSetImportJobs$44((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReadSetImportJobsIterable listReadSetImportJobsPaginator(ListReadSetImportJobsRequest listReadSetImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReadSetImportJobsIterable(this, this.applyPaginatorUserAgent(listReadSetImportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReadSetUploadPartsResponse listReadSetUploadParts(ListReadSetUploadPartsRequest listReadSetUploadPartsRequest) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReadSetUploadPartsRequest = this.applySignerOverride(listReadSetUploadPartsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReadSetUploadPartsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReadSetUploadPartsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReadSetUploadParts");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReadSetUploadPartsResponse listReadSetUploadPartsResponse = (ListReadSetUploadPartsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReadSetUploadParts").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReadSetUploadPartsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReadSetUploadPartsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReadSetUploadPartsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReadSetUploadParts$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReadSetUploadPartsIterable listReadSetUploadPartsPaginator(ListReadSetUploadPartsRequest listReadSetUploadPartsRequest) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReadSetUploadPartsIterable(this, this.applyPaginatorUserAgent(listReadSetUploadPartsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReadSetsResponse listReadSets(ListReadSetsRequest listReadSetsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReadSetsRequest = this.applySignerOverride(listReadSetsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReadSetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReadSetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReadSets");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReadSetsResponse listReadSetsResponse = (ListReadSetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReadSets").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReadSetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReadSetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReadSetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReadSets$46((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReadSetsIterable listReadSetsPaginator(ListReadSetsRequest listReadSetsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReadSetsIterable(this, this.applyPaginatorUserAgent(listReadSetsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReferenceImportJobsResponse listReferenceImportJobs(ListReferenceImportJobsRequest listReferenceImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReferenceImportJobsRequest = this.applySignerOverride(listReferenceImportJobsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReferenceImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReferenceImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReferenceImportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReferenceImportJobsResponse listReferenceImportJobsResponse = (ListReferenceImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReferenceImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReferenceImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReferenceImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReferenceImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReferenceImportJobs$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReferenceImportJobsIterable listReferenceImportJobsPaginator(ListReferenceImportJobsRequest listReferenceImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReferenceImportJobsIterable(this, this.applyPaginatorUserAgent(listReferenceImportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReferenceStoresResponse listReferenceStores(ListReferenceStoresRequest listReferenceStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReferenceStoresRequest = this.applySignerOverride(listReferenceStoresRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReferenceStoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReferenceStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReferenceStores");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReferenceStoresResponse listReferenceStoresResponse = (ListReferenceStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReferenceStores").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReferenceStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReferenceStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReferenceStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReferenceStores$48((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReferenceStoresIterable listReferenceStoresPaginator(ListReferenceStoresRequest listReferenceStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReferenceStoresIterable(this, this.applyPaginatorUserAgent(listReferenceStoresRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListReferencesResponse listReferences(ListReferencesRequest listReferencesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listReferencesRequest = this.applySignerOverride(listReferencesRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListReferencesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listReferencesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListReferences");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListReferencesResponse listReferencesResponse = (ListReferencesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListReferences").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listReferencesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListReferencesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listReferencesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listReferences$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListReferencesIterable listReferencesPaginator(ListReferencesRequest listReferencesRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListReferencesIterable(this, this.applyPaginatorUserAgent(listReferencesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRunGroupsResponse listRunGroups(ListRunGroupsRequest listRunGroupsRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listRunGroupsRequest = this.applySignerOverride(listRunGroupsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRunGroupsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listRunGroupsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRunGroups");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            ListRunGroupsResponse listRunGroupsResponse = (ListRunGroupsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRunGroups").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listRunGroupsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRunGroupsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRunGroupsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listRunGroups$50((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRunGroupsIterable listRunGroupsPaginator(ListRunGroupsRequest listRunGroupsRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListRunGroupsIterable(this, this.applyPaginatorUserAgent(listRunGroupsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRunTasksResponse listRunTasks(ListRunTasksRequest listRunTasksRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listRunTasksRequest = this.applySignerOverride(listRunTasksRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRunTasksResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listRunTasksRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRunTasks");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            ListRunTasksResponse listRunTasksResponse = (ListRunTasksResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRunTasks").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listRunTasksRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRunTasksRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRunTasksResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listRunTasks$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRunTasksIterable listRunTasksPaginator(ListRunTasksRequest listRunTasksRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListRunTasksIterable(this, this.applyPaginatorUserAgent(listRunTasksRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListRunsResponse listRuns(ListRunsRequest listRunsRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listRunsRequest = this.applySignerOverride(listRunsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListRunsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listRunsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListRuns");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            ListRunsResponse listRunsResponse = (ListRunsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListRuns").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listRunsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListRunsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listRunsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listRuns$52((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListRunsIterable listRunsPaginator(ListRunsRequest listRunsRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListRunsIterable(this, this.applyPaginatorUserAgent(listRunsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListSequenceStoresResponse listSequenceStores(ListSequenceStoresRequest listSequenceStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listSequenceStoresRequest = this.applySignerOverride(listSequenceStoresRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListSequenceStoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listSequenceStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListSequenceStores");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            ListSequenceStoresResponse listSequenceStoresResponse = (ListSequenceStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListSequenceStores").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listSequenceStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListSequenceStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listSequenceStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listSequenceStores$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListSequenceStoresIterable listSequenceStoresPaginator(ListSequenceStoresRequest listSequenceStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListSequenceStoresIterable(this, this.applyPaginatorUserAgent(listSequenceStoresRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listTagsForResourceRequest = this.applySignerOverride(listTagsForResourceRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listTagsForResource$54((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVariantImportJobsResponse listVariantImportJobs(ListVariantImportJobsRequest listVariantImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        listVariantImportJobsRequest = this.applySignerOverride(listVariantImportJobsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVariantImportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listVariantImportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVariantImportJobs");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            ListVariantImportJobsResponse listVariantImportJobsResponse = (ListVariantImportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVariantImportJobs").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listVariantImportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVariantImportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVariantImportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listVariantImportJobs$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVariantImportJobsIterable listVariantImportJobsPaginator(ListVariantImportJobsRequest listVariantImportJobsRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        return new ListVariantImportJobsIterable(this, this.applyPaginatorUserAgent(listVariantImportJobsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVariantStoresResponse listVariantStores(ListVariantStoresRequest listVariantStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        listVariantStoresRequest = this.applySignerOverride(listVariantStoresRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVariantStoresResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listVariantStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVariantStores");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            ListVariantStoresResponse listVariantStoresResponse = (ListVariantStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVariantStores").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listVariantStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVariantStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVariantStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listVariantStores$56((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVariantStoresIterable listVariantStoresPaginator(ListVariantStoresRequest listVariantStoresRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        return new ListVariantStoresIterable(this, this.applyPaginatorUserAgent(listVariantStoresRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        listWorkflowsRequest = this.applySignerOverride(listWorkflowsRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListWorkflowsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, listWorkflowsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListWorkflows");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            ListWorkflowsResponse listWorkflowsResponse = (ListWorkflowsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListWorkflows").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)listWorkflowsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListWorkflowsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listWorkflowsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$listWorkflows$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListWorkflowsIterable listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        return new ListWorkflowsIterable(this, this.applyPaginatorUserAgent(listWorkflowsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAnnotationImportJobResponse startAnnotationImportJob(StartAnnotationImportJobRequest startAnnotationImportJobRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        startAnnotationImportJobRequest = this.applySignerOverride(startAnnotationImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAnnotationImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, startAnnotationImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            StartAnnotationImportJobResponse startAnnotationImportJobResponse = (StartAnnotationImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAnnotationImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startAnnotationImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartAnnotationImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startAnnotationImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$startAnnotationImportJob$58((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReadSetActivationJobResponse startReadSetActivationJob(StartReadSetActivationJobRequest startReadSetActivationJobRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        startReadSetActivationJobRequest = this.applySignerOverride(startReadSetActivationJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReadSetActivationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, startReadSetActivationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReadSetActivationJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            StartReadSetActivationJobResponse startReadSetActivationJobResponse = (StartReadSetActivationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReadSetActivationJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startReadSetActivationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReadSetActivationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReadSetActivationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$startReadSetActivationJob$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReadSetExportJobResponse startReadSetExportJob(StartReadSetExportJobRequest startReadSetExportJobRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        startReadSetExportJobRequest = this.applySignerOverride(startReadSetExportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReadSetExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, startReadSetExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReadSetExportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            StartReadSetExportJobResponse startReadSetExportJobResponse = (StartReadSetExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReadSetExportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startReadSetExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReadSetExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReadSetExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$startReadSetExportJob$60((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReadSetImportJobResponse startReadSetImportJob(StartReadSetImportJobRequest startReadSetImportJobRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        startReadSetImportJobRequest = this.applySignerOverride(startReadSetImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReadSetImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, startReadSetImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReadSetImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            StartReadSetImportJobResponse startReadSetImportJobResponse = (StartReadSetImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReadSetImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startReadSetImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReadSetImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReadSetImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$startReadSetImportJob$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartReferenceImportJobResponse startReferenceImportJob(StartReferenceImportJobRequest startReferenceImportJobRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        startReferenceImportJobRequest = this.applySignerOverride(startReferenceImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartReferenceImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, startReferenceImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartReferenceImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";
            StartReferenceImportJobResponse startReferenceImportJobResponse = (StartReferenceImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartReferenceImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startReferenceImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartReferenceImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startReferenceImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$startReferenceImportJob$62((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartRunResponse startRun(StartRunRequest startRunRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        startRunRequest = this.applySignerOverride(startRunRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartRunResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, startRunRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            StartRunResponse startRunResponse = (StartRunResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartRun").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startRunRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartRunRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startRunResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$startRun$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartVariantImportJobResponse startVariantImportJob(StartVariantImportJobRequest startVariantImportJobRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        startVariantImportJobRequest = this.applySignerOverride(startVariantImportJobRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartVariantImportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, startVariantImportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            StartVariantImportJobResponse startVariantImportJobResponse = (StartVariantImportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartVariantImportJob").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)startVariantImportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartVariantImportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startVariantImportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$startVariantImportJob$64((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        tagResourceRequest = this.applySignerOverride(tagResourceRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$tagResource$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        untagResourceRequest = this.applySignerOverride(untagResourceRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$untagResource$66((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAnnotationStoreResponse updateAnnotationStore(UpdateAnnotationStoreRequest updateAnnotationStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        updateAnnotationStoreRequest = this.applySignerOverride(updateAnnotationStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateAnnotationStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, updateAnnotationStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            UpdateAnnotationStoreResponse updateAnnotationStoreResponse = (UpdateAnnotationStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAnnotationStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateAnnotationStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAnnotationStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateAnnotationStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$updateAnnotationStore$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateRunGroupResponse updateRunGroup(UpdateRunGroupRequest updateRunGroupRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        updateRunGroupRequest = this.applySignerOverride(updateRunGroupRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateRunGroupResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, updateRunGroupRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            UpdateRunGroupResponse updateRunGroupResponse = (UpdateRunGroupResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateRunGroup").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateRunGroupRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateRunGroupRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateRunGroupResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$updateRunGroup$68((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateVariantStoreResponse updateVariantStore(UpdateVariantStoreRequest updateVariantStoreRequest) throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        updateVariantStoreRequest = this.applySignerOverride(updateVariantStoreRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateVariantStoreResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, updateVariantStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";
            UpdateVariantStoreResponse updateVariantStoreResponse = (UpdateVariantStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateVariantStore").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateVariantStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateVariantStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateVariantStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$updateVariantStore$69((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateWorkflowResponse updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        updateWorkflowRequest = this.applySignerOverride(updateWorkflowRequest, (Signer)Aws4Signer.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateWorkflowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, updateWorkflowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";
            UpdateWorkflowResponse updateWorkflowResponse = (UpdateWorkflowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateWorkflow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)updateWorkflowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateWorkflowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateWorkflowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$updateWorkflow$70((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadReadSetPartResponse uploadReadSetPart(UploadReadSetPartRequest uploadReadSetPartRequest, RequestBody requestBody) throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        uploadReadSetPartRequest = this.applySignerOverride(uploadReadSetPartRequest, (Signer)Aws4UnsignedPayloadSigner.create());
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UploadReadSetPartResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultOmicsClient.resolveMetricPublishers(this.clientConfiguration, uploadReadSetPartRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UploadReadSetPart");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";
            UploadReadSetPartResponse uploadReadSetPartResponse = (UploadReadSetPartResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UploadReadSetPart").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression).withInput((SdkRequest)uploadReadSetPartRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withRequestBody(requestBody).withMarshaller((Marshaller)((StreamingRequestMarshaller.Builder)((StreamingRequestMarshaller.Builder)((StreamingRequestMarshaller.Builder)StreamingRequestMarshaller.builder().delegateMarshaller((Marshaller)new UploadReadSetPartRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory))).requestBody(requestBody).requiresLength(true)).transferEncoding(true)).build()));
            return uploadReadSetPartResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultOmicsClient.lambda$uploadReadSetPart$71((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public OmicsWaiter waiter() {
        return OmicsWaiter.builder().client(this).build();
    }

    private <T extends OmicsRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.68").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((OmicsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private <T extends OmicsRequest> T applySignerOverride(T request, Signer signer) {
        if (request.overrideConfiguration().flatMap(c -> c.signer()).isPresent()) {
            return request;
        }
        Consumer<AwsRequestOverrideConfiguration.Builder> signerOverride = b -> ((AwsRequestOverrideConfiguration.Builder)b.signer(signer)).build();
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(signerOverride)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(signerOverride)).build());
        return (T)((Object)((OmicsRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "omics";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(OmicsException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").exceptionBuilderSupplier(RangeNotSatisfiableException::builder).httpStatusCode(Integer.valueOf(416)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("RequestTimeoutException").exceptionBuilderSupplier(RequestTimeoutException::builder).httpStatusCode(Integer.valueOf(408)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").exceptionBuilderSupplier(NotSupportedOperationException::builder).httpStatusCode(Integer.valueOf(405)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build());
    }

    @Override
    public final OmicsServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$uploadReadSetPart$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateWorkflow$70(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateVariantStore$69(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateRunGroup$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAnnotationStore$67(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$66(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startVariantImportJob$64(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startRun$63(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReferenceImportJob$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReadSetImportJob$61(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReadSetExportJob$60(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startReadSetActivationJob$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAnnotationImportJob$58(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listWorkflows$57(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVariantStores$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVariantImportJobs$55(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$54(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listSequenceStores$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRuns$52(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRunTasks$51(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listRunGroups$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReferences$49(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReferenceStores$48(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReferenceImportJobs$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReadSets$46(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReadSetUploadParts$45(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReadSetImportJobs$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReadSetExportJobs$43(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listReadSetActivationJobs$42(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMultipartReadSetUploads$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnnotationStores$40(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAnnotationImportJobs$39(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getWorkflow$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVariantStore$37(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVariantImportJob$36(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getSequenceStore$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRunTask$34(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRunGroup$33(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getRun$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReferenceStore$31(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReferenceMetadata$30(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReferenceImportJob$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReference$28(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadSetMetadata$27(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadSetImportJob$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadSetExportJob$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadSetActivationJob$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getReadSet$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnnotationStore$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAnnotationImportJob$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteWorkflow$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteVariantStore$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSequenceStore$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRunGroup$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteRun$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReferenceStore$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteReference$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnnotationStore$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createWorkflow$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createVariantStore$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createSequenceStore$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createRunGroup$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createReferenceStore$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createMultipartReadSetUpload$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAnnotationStore$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$completeMultipartReadSetUpload$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelVariantImportJob$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelRun$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$cancelAnnotationImportJob$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$batchDeleteReadSet$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$abortMultipartReadSetUpload$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

