/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.AnnotationImportItemSource;
import software.amazon.awssdk.services.omics.model.AnnotationImportItemSourcesCopier;
import software.amazon.awssdk.services.omics.model.FormatOptions;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartAnnotationImportJobRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, StartAnnotationImportJobRequest> {
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationName").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::destinationName)).setter(StartAnnotationImportJobRequest.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()}).build();
    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formatOptions").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::formatOptions)).setter(StartAnnotationImportJobRequest.setter(Builder::formatOptions)).constructor(FormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatOptions").build()}).build();
    private static final SdkField<List<AnnotationImportItemSource>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::items)).setter(StartAnnotationImportJobRequest.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnnotationImportItemSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::roleArn)).setter(StartAnnotationImportJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("runLeftNormalization").getter(StartAnnotationImportJobRequest.getter(StartAnnotationImportJobRequest::runLeftNormalization)).setter(StartAnnotationImportJobRequest.setter(Builder::runLeftNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_NAME_FIELD, FORMAT_OPTIONS_FIELD, ITEMS_FIELD, ROLE_ARN_FIELD, RUN_LEFT_NORMALIZATION_FIELD));
    private final String destinationName;
    private final FormatOptions formatOptions;
    private final List<AnnotationImportItemSource> items;
    private final String roleArn;
    private final Boolean runLeftNormalization;

    private StartAnnotationImportJobRequest(BuilderImpl builder) {
        super(builder);
        this.destinationName = builder.destinationName;
        this.formatOptions = builder.formatOptions;
        this.items = builder.items;
        this.roleArn = builder.roleArn;
        this.runLeftNormalization = builder.runLeftNormalization;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final FormatOptions formatOptions() {
        return this.formatOptions;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AnnotationImportItemSource> items() {
        return this.items;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Boolean runLeftNormalization() {
        return this.runLeftNormalization;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runLeftNormalization());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAnnotationImportJobRequest)) {
            return false;
        }
        StartAnnotationImportJobRequest other = (StartAnnotationImportJobRequest)((Object)obj);
        return Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.formatOptions(), other.formatOptions()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.runLeftNormalization(), other.runLeftNormalization());
    }

    public final String toString() {
        return ToString.builder((String)"StartAnnotationImportJobRequest").add("DestinationName", (Object)this.destinationName()).add("FormatOptions", (Object)this.formatOptions()).add("Items", this.hasItems() ? this.items() : null).add("RoleArn", (Object)this.roleArn()).add("RunLeftNormalization", (Object)this.runLeftNormalization()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "formatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "runLeftNormalization": {
                return Optional.ofNullable(clazz.cast(this.runLeftNormalization()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAnnotationImportJobRequest, T> g) {
        return obj -> g.apply((StartAnnotationImportJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String destinationName;
        private FormatOptions formatOptions;
        private List<AnnotationImportItemSource> items = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Boolean runLeftNormalization;

        private BuilderImpl() {
        }

        private BuilderImpl(StartAnnotationImportJobRequest model) {
            super(model);
            this.destinationName(model.destinationName);
            this.formatOptions(model.formatOptions);
            this.items(model.items);
            this.roleArn(model.roleArn);
            this.runLeftNormalization(model.runLeftNormalization);
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final List<AnnotationImportItemSource.Builder> getItems() {
            List<AnnotationImportItemSource.Builder> result = AnnotationImportItemSourcesCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AnnotationImportItemSource.BuilderImpl> items) {
            this.items = AnnotationImportItemSourcesCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AnnotationImportItemSource> items) {
            this.items = AnnotationImportItemSourcesCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AnnotationImportItemSource ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AnnotationImportItemSource.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AnnotationImportItemSource)((AnnotationImportItemSource.Builder)AnnotationImportItemSource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return this.runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAnnotationImportJobRequest build() {
            return new StartAnnotationImportJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartAnnotationImportJobRequest> {
        public Builder destinationName(String var1);

        public Builder formatOptions(FormatOptions var1);

        default public Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return this.formatOptions((FormatOptions)((FormatOptions.Builder)FormatOptions.builder().applyMutation(formatOptions)).build());
        }

        public Builder items(Collection<AnnotationImportItemSource> var1);

        public Builder items(AnnotationImportItemSource ... var1);

        public Builder items(Consumer<AnnotationImportItemSource.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder runLeftNormalization(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

