/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.VariantImportJobItem;

public class ListVariantImportJobsPublisher
implements SdkPublisher<ListVariantImportJobsResponse> {
    private final OmicsAsyncClient client;
    private final ListVariantImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListVariantImportJobsPublisher(OmicsAsyncClient client, ListVariantImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListVariantImportJobsPublisher(OmicsAsyncClient client, ListVariantImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListVariantImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListVariantImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VariantImportJobItem> variantImportJobs() {
        Function<ListVariantImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.variantImportJobs() != null) {
                return response.variantImportJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListVariantImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListVariantImportJobsResponseFetcher
    implements AsyncPageFetcher<ListVariantImportJobsResponse> {
        private ListVariantImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListVariantImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListVariantImportJobsResponse> nextPage(ListVariantImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListVariantImportJobsPublisher.this.client.listVariantImportJobs(ListVariantImportJobsPublisher.this.firstRequest);
            }
            return ListVariantImportJobsPublisher.this.client.listVariantImportJobs((ListVariantImportJobsRequest)((Object)ListVariantImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

