/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.VariantStoreItem;
import software.amazon.awssdk.services.omics.model.VariantStoreItemsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListVariantStoresResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, ListVariantStoresResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListVariantStoresResponse.getter(ListVariantStoresResponse::nextToken)).setter(ListVariantStoresResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<VariantStoreItem>> VARIANT_STORES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variantStores").getter(ListVariantStoresResponse.getter(ListVariantStoresResponse::variantStores)).setter(ListVariantStoresResponse.setter(Builder::variantStores)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variantStores").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VariantStoreItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, VARIANT_STORES_FIELD));
    private final String nextToken;
    private final List<VariantStoreItem> variantStores;

    private ListVariantStoresResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.variantStores = builder.variantStores;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasVariantStores() {
        return this.variantStores != null && !(this.variantStores instanceof SdkAutoConstructList);
    }

    public final List<VariantStoreItem> variantStores() {
        return this.variantStores;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariantStores() ? this.variantStores() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVariantStoresResponse)) {
            return false;
        }
        ListVariantStoresResponse other = (ListVariantStoresResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasVariantStores() == other.hasVariantStores() && Objects.equals(this.variantStores(), other.variantStores());
    }

    public final String toString() {
        return ToString.builder((String)"ListVariantStoresResponse").add("NextToken", (Object)this.nextToken()).add("VariantStores", this.hasVariantStores() ? this.variantStores() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "variantStores": {
                return Optional.ofNullable(clazz.cast(this.variantStores()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVariantStoresResponse, T> g) {
        return obj -> g.apply((ListVariantStoresResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<VariantStoreItem> variantStores = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVariantStoresResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.variantStores(model.variantStores);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VariantStoreItem.Builder> getVariantStores() {
            List<VariantStoreItem.Builder> result = VariantStoreItemsCopier.copyToBuilder(this.variantStores);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariantStores(Collection<VariantStoreItem.BuilderImpl> variantStores) {
            this.variantStores = VariantStoreItemsCopier.copyFromBuilder(variantStores);
        }

        @Override
        public final Builder variantStores(Collection<VariantStoreItem> variantStores) {
            this.variantStores = VariantStoreItemsCopier.copy(variantStores);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStores(VariantStoreItem ... variantStores) {
            this.variantStores(Arrays.asList(variantStores));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variantStores(Consumer<VariantStoreItem.Builder> ... variantStores) {
            this.variantStores(Stream.of(variantStores).map(c -> (VariantStoreItem)((VariantStoreItem.Builder)VariantStoreItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVariantStoresResponse build() {
            return new ListVariantStoresResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListVariantStoresResponse> {
        public Builder nextToken(String var1);

        public Builder variantStores(Collection<VariantStoreItem> var1);

        public Builder variantStores(VariantStoreItem ... var1);

        public Builder variantStores(Consumer<VariantStoreItem.Builder> ... var1);
    }
}

