/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.AnnotationImportItemDetail;
import software.amazon.awssdk.services.omics.model.AnnotationImportItemDetailsCopier;
import software.amazon.awssdk.services.omics.model.FormatOptions;
import software.amazon.awssdk.services.omics.model.JobStatus;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAnnotationImportJobResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetAnnotationImportJobResponse> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::completionTime)).setter(GetAnnotationImportJobResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::creationTime)).setter(GetAnnotationImportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESTINATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationName").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::destinationName)).setter(GetAnnotationImportJobResponse.setter(Builder::destinationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationName").build()}).build();
    private static final SdkField<FormatOptions> FORMAT_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formatOptions").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::formatOptions)).setter(GetAnnotationImportJobResponse.setter(Builder::formatOptions)).constructor(FormatOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatOptions").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::id)).setter(GetAnnotationImportJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<List<AnnotationImportItemDetail>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::items)).setter(GetAnnotationImportJobResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnnotationImportItemDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::roleArn)).setter(GetAnnotationImportJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<Boolean> RUN_LEFT_NORMALIZATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("runLeftNormalization").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::runLeftNormalization)).setter(GetAnnotationImportJobResponse.setter(Builder::runLeftNormalization)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLeftNormalization").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::statusAsString)).setter(GetAnnotationImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::statusMessage)).setter(GetAnnotationImportJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updateTime").getter(GetAnnotationImportJobResponse.getter(GetAnnotationImportJobResponse::updateTime)).setter(GetAnnotationImportJobResponse.setter(Builder::updateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, CREATION_TIME_FIELD, DESTINATION_NAME_FIELD, FORMAT_OPTIONS_FIELD, ID_FIELD, ITEMS_FIELD, ROLE_ARN_FIELD, RUN_LEFT_NORMALIZATION_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, UPDATE_TIME_FIELD));
    private final Instant completionTime;
    private final Instant creationTime;
    private final String destinationName;
    private final FormatOptions formatOptions;
    private final String id;
    private final List<AnnotationImportItemDetail> items;
    private final String roleArn;
    private final Boolean runLeftNormalization;
    private final String status;
    private final String statusMessage;
    private final Instant updateTime;

    private GetAnnotationImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.completionTime = builder.completionTime;
        this.creationTime = builder.creationTime;
        this.destinationName = builder.destinationName;
        this.formatOptions = builder.formatOptions;
        this.id = builder.id;
        this.items = builder.items;
        this.roleArn = builder.roleArn;
        this.runLeftNormalization = builder.runLeftNormalization;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.updateTime = builder.updateTime;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String destinationName() {
        return this.destinationName;
    }

    public final FormatOptions formatOptions() {
        return this.formatOptions;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<AnnotationImportItemDetail> items() {
        return this.items;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final Boolean runLeftNormalization() {
        return this.runLeftNormalization;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant updateTime() {
        return this.updateTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.formatOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.runLeftNormalization());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAnnotationImportJobResponse)) {
            return false;
        }
        GetAnnotationImportJobResponse other = (GetAnnotationImportJobResponse)((Object)obj);
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.destinationName(), other.destinationName()) && Objects.equals(this.formatOptions(), other.formatOptions()) && Objects.equals(this.id(), other.id()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.runLeftNormalization(), other.runLeftNormalization()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.updateTime(), other.updateTime());
    }

    public final String toString() {
        return ToString.builder((String)"GetAnnotationImportJobResponse").add("CompletionTime", (Object)this.completionTime()).add("CreationTime", (Object)this.creationTime()).add("DestinationName", (Object)this.destinationName()).add("FormatOptions", (Object)this.formatOptions()).add("Id", (Object)this.id()).add("Items", this.hasItems() ? this.items() : null).add("RoleArn", (Object)this.roleArn()).add("RunLeftNormalization", (Object)this.runLeftNormalization()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("UpdateTime", (Object)this.updateTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "destinationName": {
                return Optional.ofNullable(clazz.cast(this.destinationName()));
            }
            case "formatOptions": {
                return Optional.ofNullable(clazz.cast(this.formatOptions()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "runLeftNormalization": {
                return Optional.ofNullable(clazz.cast(this.runLeftNormalization()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "updateTime": {
                return Optional.ofNullable(clazz.cast(this.updateTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAnnotationImportJobResponse, T> g) {
        return obj -> g.apply((GetAnnotationImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private Instant completionTime;
        private Instant creationTime;
        private String destinationName;
        private FormatOptions formatOptions;
        private String id;
        private List<AnnotationImportItemDetail> items = DefaultSdkAutoConstructList.getInstance();
        private String roleArn;
        private Boolean runLeftNormalization;
        private String status;
        private String statusMessage;
        private Instant updateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAnnotationImportJobResponse model) {
            super(model);
            this.completionTime(model.completionTime);
            this.creationTime(model.creationTime);
            this.destinationName(model.destinationName);
            this.formatOptions(model.formatOptions);
            this.id(model.id);
            this.items(model.items);
            this.roleArn(model.roleArn);
            this.runLeftNormalization(model.runLeftNormalization);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.updateTime(model.updateTime);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDestinationName() {
            return this.destinationName;
        }

        public final void setDestinationName(String destinationName) {
            this.destinationName = destinationName;
        }

        @Override
        public final Builder destinationName(String destinationName) {
            this.destinationName = destinationName;
            return this;
        }

        public final FormatOptions.Builder getFormatOptions() {
            return this.formatOptions != null ? this.formatOptions.toBuilder() : null;
        }

        public final void setFormatOptions(FormatOptions.BuilderImpl formatOptions) {
            this.formatOptions = formatOptions != null ? formatOptions.build() : null;
        }

        @Override
        public final Builder formatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final List<AnnotationImportItemDetail.Builder> getItems() {
            List<AnnotationImportItemDetail.Builder> result = AnnotationImportItemDetailsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<AnnotationImportItemDetail.BuilderImpl> items) {
            this.items = AnnotationImportItemDetailsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<AnnotationImportItemDetail> items) {
            this.items = AnnotationImportItemDetailsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(AnnotationImportItemDetail ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<AnnotationImportItemDetail.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (AnnotationImportItemDetail)((AnnotationImportItemDetail.Builder)AnnotationImportItemDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final Boolean getRunLeftNormalization() {
            return this.runLeftNormalization;
        }

        public final void setRunLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
        }

        @Override
        public final Builder runLeftNormalization(Boolean runLeftNormalization) {
            this.runLeftNormalization = runLeftNormalization;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getUpdateTime() {
            return this.updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        public GetAnnotationImportJobResponse build() {
            return new GetAnnotationImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAnnotationImportJobResponse> {
        public Builder completionTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder destinationName(String var1);

        public Builder formatOptions(FormatOptions var1);

        default public Builder formatOptions(Consumer<FormatOptions.Builder> formatOptions) {
            return this.formatOptions((FormatOptions)((FormatOptions.Builder)FormatOptions.builder().applyMutation(formatOptions)).build());
        }

        public Builder id(String var1);

        public Builder items(Collection<AnnotationImportItemDetail> var1);

        public Builder items(AnnotationImportItemDetail ... var1);

        public Builder items(Consumer<AnnotationImportItemDetail.Builder> ... var1);

        public Builder roleArn(String var1);

        public Builder runLeftNormalization(Boolean var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);

        public Builder statusMessage(String var1);

        public Builder updateTime(Instant var1);
    }
}

