/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.omics.model.ImportReadSetSourceItem;
import software.amazon.awssdk.services.omics.model.ImportReadSetSourceListCopier;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetImportJobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetReadSetImportJobResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetReadSetImportJobResponse> {
    private static final SdkField<Instant> COMPLETION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completionTime").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::completionTime)).setter(GetReadSetImportJobResponse.setter(Builder::completionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completionTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::creationTime)).setter(GetReadSetImportJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::id)).setter(GetReadSetImportJobResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::roleArn)).setter(GetReadSetImportJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sequenceStoreId").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::sequenceStoreId)).setter(GetReadSetImportJobResponse.setter(Builder::sequenceStoreId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sequenceStoreId").build()}).build();
    private static final SdkField<List<ImportReadSetSourceItem>> SOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sources").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::sources)).setter(GetReadSetImportJobResponse.setter(Builder::sources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportReadSetSourceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::statusAsString)).setter(GetReadSetImportJobResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetReadSetImportJobResponse.getter(GetReadSetImportJobResponse::statusMessage)).setter(GetReadSetImportJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETION_TIME_FIELD, CREATION_TIME_FIELD, ID_FIELD, ROLE_ARN_FIELD, SEQUENCE_STORE_ID_FIELD, SOURCES_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD));
    private final Instant completionTime;
    private final Instant creationTime;
    private final String id;
    private final String roleArn;
    private final String sequenceStoreId;
    private final List<ImportReadSetSourceItem> sources;
    private final String status;
    private final String statusMessage;

    private GetReadSetImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.completionTime = builder.completionTime;
        this.creationTime = builder.creationTime;
        this.id = builder.id;
        this.roleArn = builder.roleArn;
        this.sequenceStoreId = builder.sequenceStoreId;
        this.sources = builder.sources;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
    }

    public final Instant completionTime() {
        return this.completionTime;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String id() {
        return this.id;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final String sequenceStoreId() {
        return this.sequenceStoreId;
    }

    public final boolean hasSources() {
        return this.sources != null && !(this.sources instanceof SdkAutoConstructList);
    }

    public final List<ImportReadSetSourceItem> sources() {
        return this.sources;
    }

    public final ReadSetImportJobStatus status() {
        return ReadSetImportJobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.completionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSources() ? this.sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadSetImportJobResponse)) {
            return false;
        }
        GetReadSetImportJobResponse other = (GetReadSetImportJobResponse)((Object)obj);
        return Objects.equals(this.completionTime(), other.completionTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.sequenceStoreId(), other.sequenceStoreId()) && this.hasSources() == other.hasSources() && Objects.equals(this.sources(), other.sources()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"GetReadSetImportJobResponse").add("CompletionTime", (Object)this.completionTime()).add("CreationTime", (Object)this.creationTime()).add("Id", (Object)this.id()).add("RoleArn", (Object)this.roleArn()).add("SequenceStoreId", (Object)this.sequenceStoreId()).add("Sources", this.hasSources() ? this.sources() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completionTime": {
                return Optional.ofNullable(clazz.cast(this.completionTime()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "sequenceStoreId": {
                return Optional.ofNullable(clazz.cast(this.sequenceStoreId()));
            }
            case "sources": {
                return Optional.ofNullable(clazz.cast(this.sources()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetReadSetImportJobResponse, T> g) {
        return obj -> g.apply((GetReadSetImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private Instant completionTime;
        private Instant creationTime;
        private String id;
        private String roleArn;
        private String sequenceStoreId;
        private List<ImportReadSetSourceItem> sources = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadSetImportJobResponse model) {
            super(model);
            this.completionTime(model.completionTime);
            this.creationTime(model.creationTime);
            this.id(model.id);
            this.roleArn(model.roleArn);
            this.sequenceStoreId(model.sequenceStoreId);
            this.sources(model.sources);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
        }

        public final Instant getCompletionTime() {
            return this.completionTime;
        }

        public final void setCompletionTime(Instant completionTime) {
            this.completionTime = completionTime;
        }

        @Override
        public final Builder completionTime(Instant completionTime) {
            this.completionTime = completionTime;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getSequenceStoreId() {
            return this.sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final List<ImportReadSetSourceItem.Builder> getSources() {
            List<ImportReadSetSourceItem.Builder> result = ImportReadSetSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<ImportReadSetSourceItem.BuilderImpl> sources) {
            this.sources = ImportReadSetSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<ImportReadSetSourceItem> sources) {
            this.sources = ImportReadSetSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(ImportReadSetSourceItem ... sources) {
            this.sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<ImportReadSetSourceItem.Builder> ... sources) {
            this.sources(Stream.of(sources).map(c -> (ImportReadSetSourceItem)((ImportReadSetSourceItem.Builder)ImportReadSetSourceItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ReadSetImportJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public GetReadSetImportJobResponse build() {
            return new GetReadSetImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetReadSetImportJobResponse> {
        public Builder completionTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder id(String var1);

        public Builder roleArn(String var1);

        public Builder sequenceStoreId(String var1);

        public Builder sources(Collection<ImportReadSetSourceItem> var1);

        public Builder sources(ImportReadSetSourceItem ... var1);

        public Builder sources(Consumer<ImportReadSetSourceItem.Builder> ... var1);

        public Builder status(String var1);

        public Builder status(ReadSetImportJobStatus var1);

        public Builder statusMessage(String var1);
    }
}

