/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.ReferenceItem;
import software.amazon.awssdk.services.omics.model.SseConfig;
import software.amazon.awssdk.services.omics.model.StoreFormat;
import software.amazon.awssdk.services.omics.model.StoreOptions;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAnnotationStoreRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, CreateAnnotationStoreRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAnnotationStoreRequest.getter(CreateAnnotationStoreRequest::description)).setter(CreateAnnotationStoreRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAnnotationStoreRequest.getter(CreateAnnotationStoreRequest::name)).setter(CreateAnnotationStoreRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ReferenceItem> REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reference").getter(CreateAnnotationStoreRequest.getter(CreateAnnotationStoreRequest::reference)).setter(CreateAnnotationStoreRequest.setter(Builder::reference)).constructor(ReferenceItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reference").build()}).build();
    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sseConfig").getter(CreateAnnotationStoreRequest.getter(CreateAnnotationStoreRequest::sseConfig)).setter(CreateAnnotationStoreRequest.setter(Builder::sseConfig)).constructor(SseConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()}).build();
    private static final SdkField<String> STORE_FORMAT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storeFormat").getter(CreateAnnotationStoreRequest.getter(CreateAnnotationStoreRequest::storeFormatAsString)).setter(CreateAnnotationStoreRequest.setter(Builder::storeFormat)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeFormat").build()}).build();
    private static final SdkField<StoreOptions> STORE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storeOptions").getter(CreateAnnotationStoreRequest.getter(CreateAnnotationStoreRequest::storeOptions)).setter(CreateAnnotationStoreRequest.setter(Builder::storeOptions)).constructor(StoreOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeOptions").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateAnnotationStoreRequest.getter(CreateAnnotationStoreRequest::tags)).setter(CreateAnnotationStoreRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, NAME_FIELD, REFERENCE_FIELD, SSE_CONFIG_FIELD, STORE_FORMAT_FIELD, STORE_OPTIONS_FIELD, TAGS_FIELD));
    private final String description;
    private final String name;
    private final ReferenceItem reference;
    private final SseConfig sseConfig;
    private final String storeFormat;
    private final StoreOptions storeOptions;
    private final Map<String, String> tags;

    private CreateAnnotationStoreRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.name = builder.name;
        this.reference = builder.reference;
        this.sseConfig = builder.sseConfig;
        this.storeFormat = builder.storeFormat;
        this.storeOptions = builder.storeOptions;
        this.tags = builder.tags;
    }

    public final String description() {
        return this.description;
    }

    public final String name() {
        return this.name;
    }

    public final ReferenceItem reference() {
        return this.reference;
    }

    public final SseConfig sseConfig() {
        return this.sseConfig;
    }

    public final StoreFormat storeFormat() {
        return StoreFormat.fromValue(this.storeFormat);
    }

    public final String storeFormatAsString() {
        return this.storeFormat;
    }

    public final StoreOptions storeOptions() {
        return this.storeOptions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.reference());
        hashCode = 31 * hashCode + Objects.hashCode(this.sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAnnotationStoreRequest)) {
            return false;
        }
        CreateAnnotationStoreRequest other = (CreateAnnotationStoreRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.reference(), other.reference()) && Objects.equals(this.sseConfig(), other.sseConfig()) && Objects.equals(this.storeFormatAsString(), other.storeFormatAsString()) && Objects.equals(this.storeOptions(), other.storeOptions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAnnotationStoreRequest").add("Description", (Object)this.description()).add("Name", (Object)this.name()).add("Reference", (Object)this.reference()).add("SseConfig", (Object)this.sseConfig()).add("StoreFormat", (Object)this.storeFormatAsString()).add("StoreOptions", (Object)this.storeOptions()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "reference": {
                return Optional.ofNullable(clazz.cast(this.reference()));
            }
            case "sseConfig": {
                return Optional.ofNullable(clazz.cast(this.sseConfig()));
            }
            case "storeFormat": {
                return Optional.ofNullable(clazz.cast(this.storeFormatAsString()));
            }
            case "storeOptions": {
                return Optional.ofNullable(clazz.cast(this.storeOptions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAnnotationStoreRequest, T> g) {
        return obj -> g.apply((CreateAnnotationStoreRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String description;
        private String name;
        private ReferenceItem reference;
        private SseConfig sseConfig;
        private String storeFormat;
        private StoreOptions storeOptions;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAnnotationStoreRequest model) {
            super(model);
            this.description(model.description);
            this.name(model.name);
            this.reference(model.reference);
            this.sseConfig(model.sseConfig);
            this.storeFormat(model.storeFormat);
            this.storeOptions(model.storeOptions);
            this.tags(model.tags);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ReferenceItem.Builder getReference() {
            return this.reference != null ? this.reference.toBuilder() : null;
        }

        public final void setReference(ReferenceItem.BuilderImpl reference) {
            this.reference = reference != null ? reference.build() : null;
        }

        @Override
        public final Builder reference(ReferenceItem reference) {
            this.reference = reference;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return this.sseConfig != null ? this.sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final String getStoreFormat() {
            return this.storeFormat;
        }

        public final void setStoreFormat(String storeFormat) {
            this.storeFormat = storeFormat;
        }

        @Override
        public final Builder storeFormat(String storeFormat) {
            this.storeFormat = storeFormat;
            return this;
        }

        @Override
        public final Builder storeFormat(StoreFormat storeFormat) {
            this.storeFormat(storeFormat == null ? null : storeFormat.toString());
            return this;
        }

        public final StoreOptions.Builder getStoreOptions() {
            return this.storeOptions != null ? this.storeOptions.toBuilder() : null;
        }

        public final void setStoreOptions(StoreOptions.BuilderImpl storeOptions) {
            this.storeOptions = storeOptions != null ? storeOptions.build() : null;
        }

        @Override
        public final Builder storeOptions(StoreOptions storeOptions) {
            this.storeOptions = storeOptions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAnnotationStoreRequest build() {
            return new CreateAnnotationStoreRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAnnotationStoreRequest> {
        public Builder description(String var1);

        public Builder name(String var1);

        public Builder reference(ReferenceItem var1);

        default public Builder reference(Consumer<ReferenceItem.Builder> reference) {
            return this.reference((ReferenceItem)((ReferenceItem.Builder)ReferenceItem.builder().applyMutation(reference)).build());
        }

        public Builder sseConfig(SseConfig var1);

        default public Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return this.sseConfig((SseConfig)((SseConfig.Builder)SseConfig.builder().applyMutation(sseConfig)).build());
        }

        public Builder storeFormat(String var1);

        public Builder storeFormat(StoreFormat var1);

        public Builder storeOptions(StoreOptions var1);

        default public Builder storeOptions(Consumer<StoreOptions.Builder> storeOptions) {
            return this.storeOptions((StoreOptions)((StoreOptions.Builder)StoreOptions.builder().applyMutation(storeOptions)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

