/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReadOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReadOptions> {
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(ReadOptions.getter(ReadOptions::comment)).setter(ReadOptions.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final SdkField<String> ENCODING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("encoding").getter(ReadOptions.getter(ReadOptions::encoding)).setter(ReadOptions.setter(Builder::encoding)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encoding").build()}).build();
    private static final SdkField<String> ESCAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("escape").getter(ReadOptions.getter(ReadOptions::escape)).setter(ReadOptions.setter(Builder::escape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("escape").build()}).build();
    private static final SdkField<Boolean> ESCAPE_QUOTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("escapeQuotes").getter(ReadOptions.getter(ReadOptions::escapeQuotes)).setter(ReadOptions.setter(Builder::escapeQuotes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("escapeQuotes").build()}).build();
    private static final SdkField<Boolean> HEADER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("header").getter(ReadOptions.getter(ReadOptions::header)).setter(ReadOptions.setter(Builder::header)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("header").build()}).build();
    private static final SdkField<String> LINE_SEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lineSep").getter(ReadOptions.getter(ReadOptions::lineSep)).setter(ReadOptions.setter(Builder::lineSep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineSep").build()}).build();
    private static final SdkField<String> QUOTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quote").getter(ReadOptions.getter(ReadOptions::quote)).setter(ReadOptions.setter(Builder::quote)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quote").build()}).build();
    private static final SdkField<Boolean> QUOTE_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("quoteAll").getter(ReadOptions.getter(ReadOptions::quoteAll)).setter(ReadOptions.setter(Builder::quoteAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quoteAll").build()}).build();
    private static final SdkField<String> SEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sep").getter(ReadOptions.getter(ReadOptions::sep)).setter(ReadOptions.setter(Builder::sep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sep").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMENT_FIELD, ENCODING_FIELD, ESCAPE_FIELD, ESCAPE_QUOTES_FIELD, HEADER_FIELD, LINE_SEP_FIELD, QUOTE_FIELD, QUOTE_ALL_FIELD, SEP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String comment;
    private final String encoding;
    private final String escape;
    private final Boolean escapeQuotes;
    private final Boolean header;
    private final String lineSep;
    private final String quote;
    private final Boolean quoteAll;
    private final String sep;

    private ReadOptions(BuilderImpl builder) {
        this.comment = builder.comment;
        this.encoding = builder.encoding;
        this.escape = builder.escape;
        this.escapeQuotes = builder.escapeQuotes;
        this.header = builder.header;
        this.lineSep = builder.lineSep;
        this.quote = builder.quote;
        this.quoteAll = builder.quoteAll;
        this.sep = builder.sep;
    }

    public final String comment() {
        return this.comment;
    }

    public final String encoding() {
        return this.encoding;
    }

    public final String escape() {
        return this.escape;
    }

    public final Boolean escapeQuotes() {
        return this.escapeQuotes;
    }

    public final Boolean header() {
        return this.header;
    }

    public final String lineSep() {
        return this.lineSep;
    }

    public final String quote() {
        return this.quote;
    }

    public final Boolean quoteAll() {
        return this.quoteAll;
    }

    public final String sep() {
        return this.sep;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        hashCode = 31 * hashCode + Objects.hashCode(this.encoding());
        hashCode = 31 * hashCode + Objects.hashCode(this.escape());
        hashCode = 31 * hashCode + Objects.hashCode(this.escapeQuotes());
        hashCode = 31 * hashCode + Objects.hashCode(this.header());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineSep());
        hashCode = 31 * hashCode + Objects.hashCode(this.quote());
        hashCode = 31 * hashCode + Objects.hashCode(this.quoteAll());
        hashCode = 31 * hashCode + Objects.hashCode(this.sep());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReadOptions)) {
            return false;
        }
        ReadOptions other = (ReadOptions)obj;
        return Objects.equals(this.comment(), other.comment()) && Objects.equals(this.encoding(), other.encoding()) && Objects.equals(this.escape(), other.escape()) && Objects.equals(this.escapeQuotes(), other.escapeQuotes()) && Objects.equals(this.header(), other.header()) && Objects.equals(this.lineSep(), other.lineSep()) && Objects.equals(this.quote(), other.quote()) && Objects.equals(this.quoteAll(), other.quoteAll()) && Objects.equals(this.sep(), other.sep());
    }

    public final String toString() {
        return ToString.builder((String)"ReadOptions").add("Comment", (Object)this.comment()).add("Encoding", (Object)this.encoding()).add("Escape", (Object)this.escape()).add("EscapeQuotes", (Object)this.escapeQuotes()).add("Header", (Object)this.header()).add("LineSep", (Object)this.lineSep()).add("Quote", (Object)this.quote()).add("QuoteAll", (Object)this.quoteAll()).add("Sep", (Object)this.sep()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
            case "encoding": {
                return Optional.ofNullable(clazz.cast(this.encoding()));
            }
            case "escape": {
                return Optional.ofNullable(clazz.cast(this.escape()));
            }
            case "escapeQuotes": {
                return Optional.ofNullable(clazz.cast(this.escapeQuotes()));
            }
            case "header": {
                return Optional.ofNullable(clazz.cast(this.header()));
            }
            case "lineSep": {
                return Optional.ofNullable(clazz.cast(this.lineSep()));
            }
            case "quote": {
                return Optional.ofNullable(clazz.cast(this.quote()));
            }
            case "quoteAll": {
                return Optional.ofNullable(clazz.cast(this.quoteAll()));
            }
            case "sep": {
                return Optional.ofNullable(clazz.cast(this.sep()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReadOptions, T> g) {
        return obj -> g.apply((ReadOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String comment;
        private String encoding;
        private String escape;
        private Boolean escapeQuotes;
        private Boolean header;
        private String lineSep;
        private String quote;
        private Boolean quoteAll;
        private String sep;

        private BuilderImpl() {
        }

        private BuilderImpl(ReadOptions model) {
            this.comment(model.comment);
            this.encoding(model.encoding);
            this.escape(model.escape);
            this.escapeQuotes(model.escapeQuotes);
            this.header(model.header);
            this.lineSep(model.lineSep);
            this.quote(model.quote);
            this.quoteAll(model.quoteAll);
            this.sep(model.sep);
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        public final String getEscape() {
            return this.escape;
        }

        public final void setEscape(String escape) {
            this.escape = escape;
        }

        @Override
        public final Builder escape(String escape) {
            this.escape = escape;
            return this;
        }

        public final Boolean getEscapeQuotes() {
            return this.escapeQuotes;
        }

        public final void setEscapeQuotes(Boolean escapeQuotes) {
            this.escapeQuotes = escapeQuotes;
        }

        @Override
        public final Builder escapeQuotes(Boolean escapeQuotes) {
            this.escapeQuotes = escapeQuotes;
            return this;
        }

        public final Boolean getHeader() {
            return this.header;
        }

        public final void setHeader(Boolean header) {
            this.header = header;
        }

        @Override
        public final Builder header(Boolean header) {
            this.header = header;
            return this;
        }

        public final String getLineSep() {
            return this.lineSep;
        }

        public final void setLineSep(String lineSep) {
            this.lineSep = lineSep;
        }

        @Override
        public final Builder lineSep(String lineSep) {
            this.lineSep = lineSep;
            return this;
        }

        public final String getQuote() {
            return this.quote;
        }

        public final void setQuote(String quote) {
            this.quote = quote;
        }

        @Override
        public final Builder quote(String quote) {
            this.quote = quote;
            return this;
        }

        public final Boolean getQuoteAll() {
            return this.quoteAll;
        }

        public final void setQuoteAll(Boolean quoteAll) {
            this.quoteAll = quoteAll;
        }

        @Override
        public final Builder quoteAll(Boolean quoteAll) {
            this.quoteAll = quoteAll;
            return this;
        }

        public final String getSep() {
            return this.sep;
        }

        public final void setSep(String sep) {
            this.sep = sep;
        }

        @Override
        public final Builder sep(String sep) {
            this.sep = sep;
            return this;
        }

        public ReadOptions build() {
            return new ReadOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReadOptions> {
        public Builder comment(String var1);

        public Builder encoding(String var1);

        public Builder escape(String var1);

        public Builder escapeQuotes(Boolean var1);

        public Builder header(Boolean var1);

        public Builder lineSep(String var1);

        public Builder quote(String var1);

        public Builder quoteAll(Boolean var1);

        public Builder sep(String var1);
    }
}

