/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.ImportReferenceJobItem;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;

public class ListReferenceImportJobsPublisher
implements SdkPublisher<ListReferenceImportJobsResponse> {
    private final OmicsAsyncClient client;
    private final ListReferenceImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReferenceImportJobsPublisher(OmicsAsyncClient client, ListReferenceImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReferenceImportJobsPublisher(OmicsAsyncClient client, ListReferenceImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReferenceImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReferenceImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportReferenceJobItem> importJobs() {
        Function<ListReferenceImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobs() != null) {
                return response.importJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReferenceImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReferenceImportJobsResponseFetcher
    implements AsyncPageFetcher<ListReferenceImportJobsResponse> {
        private ListReferenceImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReferenceImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReferenceImportJobsResponse> nextPage(ListReferenceImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReferenceImportJobsPublisher.this.client.listReferenceImportJobs(ListReferenceImportJobsPublisher.this.firstRequest);
            }
            return ListReferenceImportJobsPublisher.this.client.listReferenceImportJobs((ListReferenceImportJobsRequest)((Object)ListReferenceImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

