/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.ImportReadSetJobItem;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;

public class ListReadSetImportJobsPublisher
implements SdkPublisher<ListReadSetImportJobsResponse> {
    private final OmicsAsyncClient client;
    private final ListReadSetImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReadSetImportJobsPublisher(OmicsAsyncClient client, ListReadSetImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReadSetImportJobsPublisher(OmicsAsyncClient client, ListReadSetImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReadSetImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReadSetImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportReadSetJobItem> importJobs() {
        Function<ListReadSetImportJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.importJobs() != null) {
                return response.importJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReadSetImportJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReadSetImportJobsResponseFetcher
    implements AsyncPageFetcher<ListReadSetImportJobsResponse> {
        private ListReadSetImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReadSetImportJobsResponse> nextPage(ListReadSetImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetImportJobsPublisher.this.client.listReadSetImportJobs(ListReadSetImportJobsPublisher.this.firstRequest);
            }
            return ListReadSetImportJobsPublisher.this.client.listReadSetImportJobs((ListReadSetImportJobsRequest)((Object)ListReadSetImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

