/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ReadSetListItem;

public class ListReadSetsPublisher
implements SdkPublisher<ListReadSetsResponse> {
    private final OmicsAsyncClient client;
    private final ListReadSetsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListReadSetsPublisher(OmicsAsyncClient client, ListReadSetsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListReadSetsPublisher(OmicsAsyncClient client, ListReadSetsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListReadSetsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListReadSetsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReadSetListItem> readSets() {
        Function<ListReadSetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.readSets() != null) {
                return response.readSets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListReadSetsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListReadSetsResponseFetcher
    implements AsyncPageFetcher<ListReadSetsResponse> {
        private ListReadSetsResponseFetcher() {
        }

        public boolean hasNextPage(ListReadSetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListReadSetsResponse> nextPage(ListReadSetsResponse previousPage) {
            if (previousPage == null) {
                return ListReadSetsPublisher.this.client.listReadSets(ListReadSetsPublisher.this.firstRequest);
            }
            return ListReadSetsPublisher.this.client.listReadSets((ListReadSetsRequest)((Object)ListReadSetsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

