/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.ComputeModel;
import software.amazon.awssdk.services.odb.model.ShapeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DbSystemShapeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DbSystemShapeSummary> {
    private static final SdkField<Integer> AVAILABLE_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableCoreCount").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableCoreCount)).setter(DbSystemShapeSummary.setter(Builder::availableCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableCoreCount").build()}).build();
    private static final SdkField<Integer> AVAILABLE_CORE_COUNT_PER_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableCoreCountPerNode").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableCoreCountPerNode)).setter(DbSystemShapeSummary.setter(Builder::availableCoreCountPerNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableCoreCountPerNode").build()}).build();
    private static final SdkField<Integer> AVAILABLE_DATA_STORAGE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableDataStorageInTBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableDataStorageInTBs)).setter(DbSystemShapeSummary.setter(Builder::availableDataStorageInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDataStorageInTBs").build()}).build();
    private static final SdkField<Integer> AVAILABLE_DATA_STORAGE_PER_SERVER_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableDataStoragePerServerInTBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableDataStoragePerServerInTBs)).setter(DbSystemShapeSummary.setter(Builder::availableDataStoragePerServerInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDataStoragePerServerInTBs").build()}).build();
    private static final SdkField<Integer> AVAILABLE_DB_NODE_PER_NODE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableDbNodePerNodeInGBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableDbNodePerNodeInGBs)).setter(DbSystemShapeSummary.setter(Builder::availableDbNodePerNodeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDbNodePerNodeInGBs").build()}).build();
    private static final SdkField<Integer> AVAILABLE_DB_NODE_STORAGE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableDbNodeStorageInGBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableDbNodeStorageInGBs)).setter(DbSystemShapeSummary.setter(Builder::availableDbNodeStorageInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableDbNodeStorageInGBs").build()}).build();
    private static final SdkField<Integer> AVAILABLE_MEMORY_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableMemoryInGBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableMemoryInGBs)).setter(DbSystemShapeSummary.setter(Builder::availableMemoryInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableMemoryInGBs").build()}).build();
    private static final SdkField<Integer> AVAILABLE_MEMORY_PER_NODE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableMemoryPerNodeInGBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::availableMemoryPerNodeInGBs)).setter(DbSystemShapeSummary.setter(Builder::availableMemoryPerNodeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableMemoryPerNodeInGBs").build()}).build();
    private static final SdkField<Integer> CORE_COUNT_INCREMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("coreCountIncrement").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::coreCountIncrement)).setter(DbSystemShapeSummary.setter(Builder::coreCountIncrement)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("coreCountIncrement").build()}).build();
    private static final SdkField<Integer> MAX_STORAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxStorageCount").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::maxStorageCount)).setter(DbSystemShapeSummary.setter(Builder::maxStorageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxStorageCount").build()}).build();
    private static final SdkField<Integer> MAXIMUM_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maximumNodeCount").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::maximumNodeCount)).setter(DbSystemShapeSummary.setter(Builder::maximumNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maximumNodeCount").build()}).build();
    private static final SdkField<Integer> MIN_CORE_COUNT_PER_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minCoreCountPerNode").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::minCoreCountPerNode)).setter(DbSystemShapeSummary.setter(Builder::minCoreCountPerNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minCoreCountPerNode").build()}).build();
    private static final SdkField<Integer> MIN_DATA_STORAGE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minDataStorageInTBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::minDataStorageInTBs)).setter(DbSystemShapeSummary.setter(Builder::minDataStorageInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minDataStorageInTBs").build()}).build();
    private static final SdkField<Integer> MIN_DB_NODE_STORAGE_PER_NODE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minDbNodeStoragePerNodeInGBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::minDbNodeStoragePerNodeInGBs)).setter(DbSystemShapeSummary.setter(Builder::minDbNodeStoragePerNodeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minDbNodeStoragePerNodeInGBs").build()}).build();
    private static final SdkField<Integer> MIN_MEMORY_PER_NODE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minMemoryPerNodeInGBs").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::minMemoryPerNodeInGBs)).setter(DbSystemShapeSummary.setter(Builder::minMemoryPerNodeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minMemoryPerNodeInGBs").build()}).build();
    private static final SdkField<Integer> MIN_STORAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minStorageCount").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::minStorageCount)).setter(DbSystemShapeSummary.setter(Builder::minStorageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minStorageCount").build()}).build();
    private static final SdkField<Integer> MINIMUM_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumCoreCount").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::minimumCoreCount)).setter(DbSystemShapeSummary.setter(Builder::minimumCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumCoreCount").build()}).build();
    private static final SdkField<Integer> MINIMUM_NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("minimumNodeCount").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::minimumNodeCount)).setter(DbSystemShapeSummary.setter(Builder::minimumNodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumNodeCount").build()}).build();
    private static final SdkField<Integer> RUNTIME_MINIMUM_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("runtimeMinimumCoreCount").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::runtimeMinimumCoreCount)).setter(DbSystemShapeSummary.setter(Builder::runtimeMinimumCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtimeMinimumCoreCount").build()}).build();
    private static final SdkField<String> SHAPE_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shapeFamily").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::shapeFamily)).setter(DbSystemShapeSummary.setter(Builder::shapeFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shapeFamily").build()}).build();
    private static final SdkField<String> SHAPE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shapeType").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::shapeTypeAsString)).setter(DbSystemShapeSummary.setter(Builder::shapeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shapeType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::name)).setter(DbSystemShapeSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeModel").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::computeModelAsString)).setter(DbSystemShapeSummary.setter(Builder::computeModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()}).build();
    private static final SdkField<Boolean> ARE_SERVER_TYPES_SUPPORTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("areServerTypesSupported").getter(DbSystemShapeSummary.getter(DbSystemShapeSummary::areServerTypesSupported)).setter(DbSystemShapeSummary.setter(Builder::areServerTypesSupported)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("areServerTypesSupported").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABLE_CORE_COUNT_FIELD, AVAILABLE_CORE_COUNT_PER_NODE_FIELD, AVAILABLE_DATA_STORAGE_IN_T_BS_FIELD, AVAILABLE_DATA_STORAGE_PER_SERVER_IN_T_BS_FIELD, AVAILABLE_DB_NODE_PER_NODE_IN_G_BS_FIELD, AVAILABLE_DB_NODE_STORAGE_IN_G_BS_FIELD, AVAILABLE_MEMORY_IN_G_BS_FIELD, AVAILABLE_MEMORY_PER_NODE_IN_G_BS_FIELD, CORE_COUNT_INCREMENT_FIELD, MAX_STORAGE_COUNT_FIELD, MAXIMUM_NODE_COUNT_FIELD, MIN_CORE_COUNT_PER_NODE_FIELD, MIN_DATA_STORAGE_IN_T_BS_FIELD, MIN_DB_NODE_STORAGE_PER_NODE_IN_G_BS_FIELD, MIN_MEMORY_PER_NODE_IN_G_BS_FIELD, MIN_STORAGE_COUNT_FIELD, MINIMUM_CORE_COUNT_FIELD, MINIMUM_NODE_COUNT_FIELD, RUNTIME_MINIMUM_CORE_COUNT_FIELD, SHAPE_FAMILY_FIELD, SHAPE_TYPE_FIELD, NAME_FIELD, COMPUTE_MODEL_FIELD, ARE_SERVER_TYPES_SUPPORTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DbSystemShapeSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer availableCoreCount;
    private final Integer availableCoreCountPerNode;
    private final Integer availableDataStorageInTBs;
    private final Integer availableDataStoragePerServerInTBs;
    private final Integer availableDbNodePerNodeInGBs;
    private final Integer availableDbNodeStorageInGBs;
    private final Integer availableMemoryInGBs;
    private final Integer availableMemoryPerNodeInGBs;
    private final Integer coreCountIncrement;
    private final Integer maxStorageCount;
    private final Integer maximumNodeCount;
    private final Integer minCoreCountPerNode;
    private final Integer minDataStorageInTBs;
    private final Integer minDbNodeStoragePerNodeInGBs;
    private final Integer minMemoryPerNodeInGBs;
    private final Integer minStorageCount;
    private final Integer minimumCoreCount;
    private final Integer minimumNodeCount;
    private final Integer runtimeMinimumCoreCount;
    private final String shapeFamily;
    private final String shapeType;
    private final String name;
    private final String computeModel;
    private final Boolean areServerTypesSupported;

    private DbSystemShapeSummary(BuilderImpl builder) {
        this.availableCoreCount = builder.availableCoreCount;
        this.availableCoreCountPerNode = builder.availableCoreCountPerNode;
        this.availableDataStorageInTBs = builder.availableDataStorageInTBs;
        this.availableDataStoragePerServerInTBs = builder.availableDataStoragePerServerInTBs;
        this.availableDbNodePerNodeInGBs = builder.availableDbNodePerNodeInGBs;
        this.availableDbNodeStorageInGBs = builder.availableDbNodeStorageInGBs;
        this.availableMemoryInGBs = builder.availableMemoryInGBs;
        this.availableMemoryPerNodeInGBs = builder.availableMemoryPerNodeInGBs;
        this.coreCountIncrement = builder.coreCountIncrement;
        this.maxStorageCount = builder.maxStorageCount;
        this.maximumNodeCount = builder.maximumNodeCount;
        this.minCoreCountPerNode = builder.minCoreCountPerNode;
        this.minDataStorageInTBs = builder.minDataStorageInTBs;
        this.minDbNodeStoragePerNodeInGBs = builder.minDbNodeStoragePerNodeInGBs;
        this.minMemoryPerNodeInGBs = builder.minMemoryPerNodeInGBs;
        this.minStorageCount = builder.minStorageCount;
        this.minimumCoreCount = builder.minimumCoreCount;
        this.minimumNodeCount = builder.minimumNodeCount;
        this.runtimeMinimumCoreCount = builder.runtimeMinimumCoreCount;
        this.shapeFamily = builder.shapeFamily;
        this.shapeType = builder.shapeType;
        this.name = builder.name;
        this.computeModel = builder.computeModel;
        this.areServerTypesSupported = builder.areServerTypesSupported;
    }

    public final Integer availableCoreCount() {
        return this.availableCoreCount;
    }

    public final Integer availableCoreCountPerNode() {
        return this.availableCoreCountPerNode;
    }

    public final Integer availableDataStorageInTBs() {
        return this.availableDataStorageInTBs;
    }

    public final Integer availableDataStoragePerServerInTBs() {
        return this.availableDataStoragePerServerInTBs;
    }

    public final Integer availableDbNodePerNodeInGBs() {
        return this.availableDbNodePerNodeInGBs;
    }

    public final Integer availableDbNodeStorageInGBs() {
        return this.availableDbNodeStorageInGBs;
    }

    public final Integer availableMemoryInGBs() {
        return this.availableMemoryInGBs;
    }

    public final Integer availableMemoryPerNodeInGBs() {
        return this.availableMemoryPerNodeInGBs;
    }

    public final Integer coreCountIncrement() {
        return this.coreCountIncrement;
    }

    public final Integer maxStorageCount() {
        return this.maxStorageCount;
    }

    public final Integer maximumNodeCount() {
        return this.maximumNodeCount;
    }

    public final Integer minCoreCountPerNode() {
        return this.minCoreCountPerNode;
    }

    public final Integer minDataStorageInTBs() {
        return this.minDataStorageInTBs;
    }

    public final Integer minDbNodeStoragePerNodeInGBs() {
        return this.minDbNodeStoragePerNodeInGBs;
    }

    public final Integer minMemoryPerNodeInGBs() {
        return this.minMemoryPerNodeInGBs;
    }

    public final Integer minStorageCount() {
        return this.minStorageCount;
    }

    public final Integer minimumCoreCount() {
        return this.minimumCoreCount;
    }

    public final Integer minimumNodeCount() {
        return this.minimumNodeCount;
    }

    public final Integer runtimeMinimumCoreCount() {
        return this.runtimeMinimumCoreCount;
    }

    public final String shapeFamily() {
        return this.shapeFamily;
    }

    public final ShapeType shapeType() {
        return ShapeType.fromValue(this.shapeType);
    }

    public final String shapeTypeAsString() {
        return this.shapeType;
    }

    public final String name() {
        return this.name;
    }

    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(this.computeModel);
    }

    public final String computeModelAsString() {
        return this.computeModel;
    }

    public final Boolean areServerTypesSupported() {
        return this.areServerTypesSupported;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableDataStorageInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableDataStoragePerServerInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableDbNodePerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableDbNodeStorageInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableMemoryInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableMemoryPerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.coreCountIncrement());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maximumNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.minDataStorageInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.minDbNodeStoragePerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.minMemoryPerNodeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.minStorageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumNodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.runtimeMinimumCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.shapeFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.shapeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.areServerTypesSupported());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbSystemShapeSummary)) {
            return false;
        }
        DbSystemShapeSummary other = (DbSystemShapeSummary)obj;
        return Objects.equals(this.availableCoreCount(), other.availableCoreCount()) && Objects.equals(this.availableCoreCountPerNode(), other.availableCoreCountPerNode()) && Objects.equals(this.availableDataStorageInTBs(), other.availableDataStorageInTBs()) && Objects.equals(this.availableDataStoragePerServerInTBs(), other.availableDataStoragePerServerInTBs()) && Objects.equals(this.availableDbNodePerNodeInGBs(), other.availableDbNodePerNodeInGBs()) && Objects.equals(this.availableDbNodeStorageInGBs(), other.availableDbNodeStorageInGBs()) && Objects.equals(this.availableMemoryInGBs(), other.availableMemoryInGBs()) && Objects.equals(this.availableMemoryPerNodeInGBs(), other.availableMemoryPerNodeInGBs()) && Objects.equals(this.coreCountIncrement(), other.coreCountIncrement()) && Objects.equals(this.maxStorageCount(), other.maxStorageCount()) && Objects.equals(this.maximumNodeCount(), other.maximumNodeCount()) && Objects.equals(this.minCoreCountPerNode(), other.minCoreCountPerNode()) && Objects.equals(this.minDataStorageInTBs(), other.minDataStorageInTBs()) && Objects.equals(this.minDbNodeStoragePerNodeInGBs(), other.minDbNodeStoragePerNodeInGBs()) && Objects.equals(this.minMemoryPerNodeInGBs(), other.minMemoryPerNodeInGBs()) && Objects.equals(this.minStorageCount(), other.minStorageCount()) && Objects.equals(this.minimumCoreCount(), other.minimumCoreCount()) && Objects.equals(this.minimumNodeCount(), other.minimumNodeCount()) && Objects.equals(this.runtimeMinimumCoreCount(), other.runtimeMinimumCoreCount()) && Objects.equals(this.shapeFamily(), other.shapeFamily()) && Objects.equals(this.shapeTypeAsString(), other.shapeTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.computeModelAsString(), other.computeModelAsString()) && Objects.equals(this.areServerTypesSupported(), other.areServerTypesSupported());
    }

    public final String toString() {
        return ToString.builder((String)"DbSystemShapeSummary").add("AvailableCoreCount", (Object)this.availableCoreCount()).add("AvailableCoreCountPerNode", (Object)this.availableCoreCountPerNode()).add("AvailableDataStorageInTBs", (Object)this.availableDataStorageInTBs()).add("AvailableDataStoragePerServerInTBs", (Object)this.availableDataStoragePerServerInTBs()).add("AvailableDbNodePerNodeInGBs", (Object)this.availableDbNodePerNodeInGBs()).add("AvailableDbNodeStorageInGBs", (Object)this.availableDbNodeStorageInGBs()).add("AvailableMemoryInGBs", (Object)this.availableMemoryInGBs()).add("AvailableMemoryPerNodeInGBs", (Object)this.availableMemoryPerNodeInGBs()).add("CoreCountIncrement", (Object)this.coreCountIncrement()).add("MaxStorageCount", (Object)this.maxStorageCount()).add("MaximumNodeCount", (Object)this.maximumNodeCount()).add("MinCoreCountPerNode", (Object)this.minCoreCountPerNode()).add("MinDataStorageInTBs", (Object)this.minDataStorageInTBs()).add("MinDbNodeStoragePerNodeInGBs", (Object)this.minDbNodeStoragePerNodeInGBs()).add("MinMemoryPerNodeInGBs", (Object)this.minMemoryPerNodeInGBs()).add("MinStorageCount", (Object)this.minStorageCount()).add("MinimumCoreCount", (Object)this.minimumCoreCount()).add("MinimumNodeCount", (Object)this.minimumNodeCount()).add("RuntimeMinimumCoreCount", (Object)this.runtimeMinimumCoreCount()).add("ShapeFamily", (Object)this.shapeFamily()).add("ShapeType", (Object)this.shapeTypeAsString()).add("Name", (Object)this.name()).add("ComputeModel", (Object)this.computeModelAsString()).add("AreServerTypesSupported", (Object)this.areServerTypesSupported()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "availableCoreCount": {
                return Optional.ofNullable(clazz.cast(this.availableCoreCount()));
            }
            case "availableCoreCountPerNode": {
                return Optional.ofNullable(clazz.cast(this.availableCoreCountPerNode()));
            }
            case "availableDataStorageInTBs": {
                return Optional.ofNullable(clazz.cast(this.availableDataStorageInTBs()));
            }
            case "availableDataStoragePerServerInTBs": {
                return Optional.ofNullable(clazz.cast(this.availableDataStoragePerServerInTBs()));
            }
            case "availableDbNodePerNodeInGBs": {
                return Optional.ofNullable(clazz.cast(this.availableDbNodePerNodeInGBs()));
            }
            case "availableDbNodeStorageInGBs": {
                return Optional.ofNullable(clazz.cast(this.availableDbNodeStorageInGBs()));
            }
            case "availableMemoryInGBs": {
                return Optional.ofNullable(clazz.cast(this.availableMemoryInGBs()));
            }
            case "availableMemoryPerNodeInGBs": {
                return Optional.ofNullable(clazz.cast(this.availableMemoryPerNodeInGBs()));
            }
            case "coreCountIncrement": {
                return Optional.ofNullable(clazz.cast(this.coreCountIncrement()));
            }
            case "maxStorageCount": {
                return Optional.ofNullable(clazz.cast(this.maxStorageCount()));
            }
            case "maximumNodeCount": {
                return Optional.ofNullable(clazz.cast(this.maximumNodeCount()));
            }
            case "minCoreCountPerNode": {
                return Optional.ofNullable(clazz.cast(this.minCoreCountPerNode()));
            }
            case "minDataStorageInTBs": {
                return Optional.ofNullable(clazz.cast(this.minDataStorageInTBs()));
            }
            case "minDbNodeStoragePerNodeInGBs": {
                return Optional.ofNullable(clazz.cast(this.minDbNodeStoragePerNodeInGBs()));
            }
            case "minMemoryPerNodeInGBs": {
                return Optional.ofNullable(clazz.cast(this.minMemoryPerNodeInGBs()));
            }
            case "minStorageCount": {
                return Optional.ofNullable(clazz.cast(this.minStorageCount()));
            }
            case "minimumCoreCount": {
                return Optional.ofNullable(clazz.cast(this.minimumCoreCount()));
            }
            case "minimumNodeCount": {
                return Optional.ofNullable(clazz.cast(this.minimumNodeCount()));
            }
            case "runtimeMinimumCoreCount": {
                return Optional.ofNullable(clazz.cast(this.runtimeMinimumCoreCount()));
            }
            case "shapeFamily": {
                return Optional.ofNullable(clazz.cast(this.shapeFamily()));
            }
            case "shapeType": {
                return Optional.ofNullable(clazz.cast(this.shapeTypeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "computeModel": {
                return Optional.ofNullable(clazz.cast(this.computeModelAsString()));
            }
            case "areServerTypesSupported": {
                return Optional.ofNullable(clazz.cast(this.areServerTypesSupported()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("availableCoreCount", AVAILABLE_CORE_COUNT_FIELD);
        map.put("availableCoreCountPerNode", AVAILABLE_CORE_COUNT_PER_NODE_FIELD);
        map.put("availableDataStorageInTBs", AVAILABLE_DATA_STORAGE_IN_T_BS_FIELD);
        map.put("availableDataStoragePerServerInTBs", AVAILABLE_DATA_STORAGE_PER_SERVER_IN_T_BS_FIELD);
        map.put("availableDbNodePerNodeInGBs", AVAILABLE_DB_NODE_PER_NODE_IN_G_BS_FIELD);
        map.put("availableDbNodeStorageInGBs", AVAILABLE_DB_NODE_STORAGE_IN_G_BS_FIELD);
        map.put("availableMemoryInGBs", AVAILABLE_MEMORY_IN_G_BS_FIELD);
        map.put("availableMemoryPerNodeInGBs", AVAILABLE_MEMORY_PER_NODE_IN_G_BS_FIELD);
        map.put("coreCountIncrement", CORE_COUNT_INCREMENT_FIELD);
        map.put("maxStorageCount", MAX_STORAGE_COUNT_FIELD);
        map.put("maximumNodeCount", MAXIMUM_NODE_COUNT_FIELD);
        map.put("minCoreCountPerNode", MIN_CORE_COUNT_PER_NODE_FIELD);
        map.put("minDataStorageInTBs", MIN_DATA_STORAGE_IN_T_BS_FIELD);
        map.put("minDbNodeStoragePerNodeInGBs", MIN_DB_NODE_STORAGE_PER_NODE_IN_G_BS_FIELD);
        map.put("minMemoryPerNodeInGBs", MIN_MEMORY_PER_NODE_IN_G_BS_FIELD);
        map.put("minStorageCount", MIN_STORAGE_COUNT_FIELD);
        map.put("minimumCoreCount", MINIMUM_CORE_COUNT_FIELD);
        map.put("minimumNodeCount", MINIMUM_NODE_COUNT_FIELD);
        map.put("runtimeMinimumCoreCount", RUNTIME_MINIMUM_CORE_COUNT_FIELD);
        map.put("shapeFamily", SHAPE_FAMILY_FIELD);
        map.put("shapeType", SHAPE_TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        map.put("areServerTypesSupported", ARE_SERVER_TYPES_SUPPORTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbSystemShapeSummary, T> g) {
        return obj -> g.apply((DbSystemShapeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer availableCoreCount;
        private Integer availableCoreCountPerNode;
        private Integer availableDataStorageInTBs;
        private Integer availableDataStoragePerServerInTBs;
        private Integer availableDbNodePerNodeInGBs;
        private Integer availableDbNodeStorageInGBs;
        private Integer availableMemoryInGBs;
        private Integer availableMemoryPerNodeInGBs;
        private Integer coreCountIncrement;
        private Integer maxStorageCount;
        private Integer maximumNodeCount;
        private Integer minCoreCountPerNode;
        private Integer minDataStorageInTBs;
        private Integer minDbNodeStoragePerNodeInGBs;
        private Integer minMemoryPerNodeInGBs;
        private Integer minStorageCount;
        private Integer minimumCoreCount;
        private Integer minimumNodeCount;
        private Integer runtimeMinimumCoreCount;
        private String shapeFamily;
        private String shapeType;
        private String name;
        private String computeModel;
        private Boolean areServerTypesSupported;

        private BuilderImpl() {
        }

        private BuilderImpl(DbSystemShapeSummary model) {
            this.availableCoreCount(model.availableCoreCount);
            this.availableCoreCountPerNode(model.availableCoreCountPerNode);
            this.availableDataStorageInTBs(model.availableDataStorageInTBs);
            this.availableDataStoragePerServerInTBs(model.availableDataStoragePerServerInTBs);
            this.availableDbNodePerNodeInGBs(model.availableDbNodePerNodeInGBs);
            this.availableDbNodeStorageInGBs(model.availableDbNodeStorageInGBs);
            this.availableMemoryInGBs(model.availableMemoryInGBs);
            this.availableMemoryPerNodeInGBs(model.availableMemoryPerNodeInGBs);
            this.coreCountIncrement(model.coreCountIncrement);
            this.maxStorageCount(model.maxStorageCount);
            this.maximumNodeCount(model.maximumNodeCount);
            this.minCoreCountPerNode(model.minCoreCountPerNode);
            this.minDataStorageInTBs(model.minDataStorageInTBs);
            this.minDbNodeStoragePerNodeInGBs(model.minDbNodeStoragePerNodeInGBs);
            this.minMemoryPerNodeInGBs(model.minMemoryPerNodeInGBs);
            this.minStorageCount(model.minStorageCount);
            this.minimumCoreCount(model.minimumCoreCount);
            this.minimumNodeCount(model.minimumNodeCount);
            this.runtimeMinimumCoreCount(model.runtimeMinimumCoreCount);
            this.shapeFamily(model.shapeFamily);
            this.shapeType(model.shapeType);
            this.name(model.name);
            this.computeModel(model.computeModel);
            this.areServerTypesSupported(model.areServerTypesSupported);
        }

        public final Integer getAvailableCoreCount() {
            return this.availableCoreCount;
        }

        public final void setAvailableCoreCount(Integer availableCoreCount) {
            this.availableCoreCount = availableCoreCount;
        }

        @Override
        public final Builder availableCoreCount(Integer availableCoreCount) {
            this.availableCoreCount = availableCoreCount;
            return this;
        }

        public final Integer getAvailableCoreCountPerNode() {
            return this.availableCoreCountPerNode;
        }

        public final void setAvailableCoreCountPerNode(Integer availableCoreCountPerNode) {
            this.availableCoreCountPerNode = availableCoreCountPerNode;
        }

        @Override
        public final Builder availableCoreCountPerNode(Integer availableCoreCountPerNode) {
            this.availableCoreCountPerNode = availableCoreCountPerNode;
            return this;
        }

        public final Integer getAvailableDataStorageInTBs() {
            return this.availableDataStorageInTBs;
        }

        public final void setAvailableDataStorageInTBs(Integer availableDataStorageInTBs) {
            this.availableDataStorageInTBs = availableDataStorageInTBs;
        }

        @Override
        public final Builder availableDataStorageInTBs(Integer availableDataStorageInTBs) {
            this.availableDataStorageInTBs = availableDataStorageInTBs;
            return this;
        }

        public final Integer getAvailableDataStoragePerServerInTBs() {
            return this.availableDataStoragePerServerInTBs;
        }

        public final void setAvailableDataStoragePerServerInTBs(Integer availableDataStoragePerServerInTBs) {
            this.availableDataStoragePerServerInTBs = availableDataStoragePerServerInTBs;
        }

        @Override
        public final Builder availableDataStoragePerServerInTBs(Integer availableDataStoragePerServerInTBs) {
            this.availableDataStoragePerServerInTBs = availableDataStoragePerServerInTBs;
            return this;
        }

        public final Integer getAvailableDbNodePerNodeInGBs() {
            return this.availableDbNodePerNodeInGBs;
        }

        public final void setAvailableDbNodePerNodeInGBs(Integer availableDbNodePerNodeInGBs) {
            this.availableDbNodePerNodeInGBs = availableDbNodePerNodeInGBs;
        }

        @Override
        public final Builder availableDbNodePerNodeInGBs(Integer availableDbNodePerNodeInGBs) {
            this.availableDbNodePerNodeInGBs = availableDbNodePerNodeInGBs;
            return this;
        }

        public final Integer getAvailableDbNodeStorageInGBs() {
            return this.availableDbNodeStorageInGBs;
        }

        public final void setAvailableDbNodeStorageInGBs(Integer availableDbNodeStorageInGBs) {
            this.availableDbNodeStorageInGBs = availableDbNodeStorageInGBs;
        }

        @Override
        public final Builder availableDbNodeStorageInGBs(Integer availableDbNodeStorageInGBs) {
            this.availableDbNodeStorageInGBs = availableDbNodeStorageInGBs;
            return this;
        }

        public final Integer getAvailableMemoryInGBs() {
            return this.availableMemoryInGBs;
        }

        public final void setAvailableMemoryInGBs(Integer availableMemoryInGBs) {
            this.availableMemoryInGBs = availableMemoryInGBs;
        }

        @Override
        public final Builder availableMemoryInGBs(Integer availableMemoryInGBs) {
            this.availableMemoryInGBs = availableMemoryInGBs;
            return this;
        }

        public final Integer getAvailableMemoryPerNodeInGBs() {
            return this.availableMemoryPerNodeInGBs;
        }

        public final void setAvailableMemoryPerNodeInGBs(Integer availableMemoryPerNodeInGBs) {
            this.availableMemoryPerNodeInGBs = availableMemoryPerNodeInGBs;
        }

        @Override
        public final Builder availableMemoryPerNodeInGBs(Integer availableMemoryPerNodeInGBs) {
            this.availableMemoryPerNodeInGBs = availableMemoryPerNodeInGBs;
            return this;
        }

        public final Integer getCoreCountIncrement() {
            return this.coreCountIncrement;
        }

        public final void setCoreCountIncrement(Integer coreCountIncrement) {
            this.coreCountIncrement = coreCountIncrement;
        }

        @Override
        public final Builder coreCountIncrement(Integer coreCountIncrement) {
            this.coreCountIncrement = coreCountIncrement;
            return this;
        }

        public final Integer getMaxStorageCount() {
            return this.maxStorageCount;
        }

        public final void setMaxStorageCount(Integer maxStorageCount) {
            this.maxStorageCount = maxStorageCount;
        }

        @Override
        public final Builder maxStorageCount(Integer maxStorageCount) {
            this.maxStorageCount = maxStorageCount;
            return this;
        }

        public final Integer getMaximumNodeCount() {
            return this.maximumNodeCount;
        }

        public final void setMaximumNodeCount(Integer maximumNodeCount) {
            this.maximumNodeCount = maximumNodeCount;
        }

        @Override
        public final Builder maximumNodeCount(Integer maximumNodeCount) {
            this.maximumNodeCount = maximumNodeCount;
            return this;
        }

        public final Integer getMinCoreCountPerNode() {
            return this.minCoreCountPerNode;
        }

        public final void setMinCoreCountPerNode(Integer minCoreCountPerNode) {
            this.minCoreCountPerNode = minCoreCountPerNode;
        }

        @Override
        public final Builder minCoreCountPerNode(Integer minCoreCountPerNode) {
            this.minCoreCountPerNode = minCoreCountPerNode;
            return this;
        }

        public final Integer getMinDataStorageInTBs() {
            return this.minDataStorageInTBs;
        }

        public final void setMinDataStorageInTBs(Integer minDataStorageInTBs) {
            this.minDataStorageInTBs = minDataStorageInTBs;
        }

        @Override
        public final Builder minDataStorageInTBs(Integer minDataStorageInTBs) {
            this.minDataStorageInTBs = minDataStorageInTBs;
            return this;
        }

        public final Integer getMinDbNodeStoragePerNodeInGBs() {
            return this.minDbNodeStoragePerNodeInGBs;
        }

        public final void setMinDbNodeStoragePerNodeInGBs(Integer minDbNodeStoragePerNodeInGBs) {
            this.minDbNodeStoragePerNodeInGBs = minDbNodeStoragePerNodeInGBs;
        }

        @Override
        public final Builder minDbNodeStoragePerNodeInGBs(Integer minDbNodeStoragePerNodeInGBs) {
            this.minDbNodeStoragePerNodeInGBs = minDbNodeStoragePerNodeInGBs;
            return this;
        }

        public final Integer getMinMemoryPerNodeInGBs() {
            return this.minMemoryPerNodeInGBs;
        }

        public final void setMinMemoryPerNodeInGBs(Integer minMemoryPerNodeInGBs) {
            this.minMemoryPerNodeInGBs = minMemoryPerNodeInGBs;
        }

        @Override
        public final Builder minMemoryPerNodeInGBs(Integer minMemoryPerNodeInGBs) {
            this.minMemoryPerNodeInGBs = minMemoryPerNodeInGBs;
            return this;
        }

        public final Integer getMinStorageCount() {
            return this.minStorageCount;
        }

        public final void setMinStorageCount(Integer minStorageCount) {
            this.minStorageCount = minStorageCount;
        }

        @Override
        public final Builder minStorageCount(Integer minStorageCount) {
            this.minStorageCount = minStorageCount;
            return this;
        }

        public final Integer getMinimumCoreCount() {
            return this.minimumCoreCount;
        }

        public final void setMinimumCoreCount(Integer minimumCoreCount) {
            this.minimumCoreCount = minimumCoreCount;
        }

        @Override
        public final Builder minimumCoreCount(Integer minimumCoreCount) {
            this.minimumCoreCount = minimumCoreCount;
            return this;
        }

        public final Integer getMinimumNodeCount() {
            return this.minimumNodeCount;
        }

        public final void setMinimumNodeCount(Integer minimumNodeCount) {
            this.minimumNodeCount = minimumNodeCount;
        }

        @Override
        public final Builder minimumNodeCount(Integer minimumNodeCount) {
            this.minimumNodeCount = minimumNodeCount;
            return this;
        }

        public final Integer getRuntimeMinimumCoreCount() {
            return this.runtimeMinimumCoreCount;
        }

        public final void setRuntimeMinimumCoreCount(Integer runtimeMinimumCoreCount) {
            this.runtimeMinimumCoreCount = runtimeMinimumCoreCount;
        }

        @Override
        public final Builder runtimeMinimumCoreCount(Integer runtimeMinimumCoreCount) {
            this.runtimeMinimumCoreCount = runtimeMinimumCoreCount;
            return this;
        }

        public final String getShapeFamily() {
            return this.shapeFamily;
        }

        public final void setShapeFamily(String shapeFamily) {
            this.shapeFamily = shapeFamily;
        }

        @Override
        public final Builder shapeFamily(String shapeFamily) {
            this.shapeFamily = shapeFamily;
            return this;
        }

        public final String getShapeType() {
            return this.shapeType;
        }

        public final void setShapeType(String shapeType) {
            this.shapeType = shapeType;
        }

        @Override
        public final Builder shapeType(String shapeType) {
            this.shapeType = shapeType;
            return this;
        }

        @Override
        public final Builder shapeType(ShapeType shapeType) {
            this.shapeType(shapeType == null ? null : shapeType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getComputeModel() {
            return this.computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public final Boolean getAreServerTypesSupported() {
            return this.areServerTypesSupported;
        }

        public final void setAreServerTypesSupported(Boolean areServerTypesSupported) {
            this.areServerTypesSupported = areServerTypesSupported;
        }

        @Override
        public final Builder areServerTypesSupported(Boolean areServerTypesSupported) {
            this.areServerTypesSupported = areServerTypesSupported;
            return this;
        }

        public DbSystemShapeSummary build() {
            return new DbSystemShapeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DbSystemShapeSummary> {
        public Builder availableCoreCount(Integer var1);

        public Builder availableCoreCountPerNode(Integer var1);

        public Builder availableDataStorageInTBs(Integer var1);

        public Builder availableDataStoragePerServerInTBs(Integer var1);

        public Builder availableDbNodePerNodeInGBs(Integer var1);

        public Builder availableDbNodeStorageInGBs(Integer var1);

        public Builder availableMemoryInGBs(Integer var1);

        public Builder availableMemoryPerNodeInGBs(Integer var1);

        public Builder coreCountIncrement(Integer var1);

        public Builder maxStorageCount(Integer var1);

        public Builder maximumNodeCount(Integer var1);

        public Builder minCoreCountPerNode(Integer var1);

        public Builder minDataStorageInTBs(Integer var1);

        public Builder minDbNodeStoragePerNodeInGBs(Integer var1);

        public Builder minMemoryPerNodeInGBs(Integer var1);

        public Builder minStorageCount(Integer var1);

        public Builder minimumCoreCount(Integer var1);

        public Builder minimumNodeCount(Integer var1);

        public Builder runtimeMinimumCoreCount(Integer var1);

        public Builder shapeFamily(String var1);

        public Builder shapeType(String var1);

        public Builder shapeType(ShapeType var1);

        public Builder name(String var1);

        public Builder computeModel(String var1);

        public Builder computeModel(ComputeModel var1);

        public Builder areServerTypesSupported(Boolean var1);
    }
}

