/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.OciIdentityDomain;
import software.amazon.awssdk.services.odb.model.OciOnboardingStatus;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOciOnboardingStatusResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, GetOciOnboardingStatusResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetOciOnboardingStatusResponse.getter(GetOciOnboardingStatusResponse::statusAsString)).setter(GetOciOnboardingStatusResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> EXISTING_TENANCY_ACTIVATION_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("existingTenancyActivationLink").getter(GetOciOnboardingStatusResponse.getter(GetOciOnboardingStatusResponse::existingTenancyActivationLink)).setter(GetOciOnboardingStatusResponse.setter(Builder::existingTenancyActivationLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingTenancyActivationLink").build()}).build();
    private static final SdkField<String> NEW_TENANCY_ACTIVATION_LINK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("newTenancyActivationLink").getter(GetOciOnboardingStatusResponse.getter(GetOciOnboardingStatusResponse::newTenancyActivationLink)).setter(GetOciOnboardingStatusResponse.setter(Builder::newTenancyActivationLink)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newTenancyActivationLink").build()}).build();
    private static final SdkField<OciIdentityDomain> OCI_IDENTITY_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ociIdentityDomain").getter(GetOciOnboardingStatusResponse.getter(GetOciOnboardingStatusResponse::ociIdentityDomain)).setter(GetOciOnboardingStatusResponse.setter(Builder::ociIdentityDomain)).constructor(OciIdentityDomain::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomain").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, EXISTING_TENANCY_ACTIVATION_LINK_FIELD, NEW_TENANCY_ACTIVATION_LINK_FIELD, OCI_IDENTITY_DOMAIN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetOciOnboardingStatusResponse.memberNameToFieldInitializer();
    private final String status;
    private final String existingTenancyActivationLink;
    private final String newTenancyActivationLink;
    private final OciIdentityDomain ociIdentityDomain;

    private GetOciOnboardingStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.existingTenancyActivationLink = builder.existingTenancyActivationLink;
        this.newTenancyActivationLink = builder.newTenancyActivationLink;
        this.ociIdentityDomain = builder.ociIdentityDomain;
    }

    public final OciOnboardingStatus status() {
        return OciOnboardingStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String existingTenancyActivationLink() {
        return this.existingTenancyActivationLink;
    }

    public final String newTenancyActivationLink() {
        return this.newTenancyActivationLink;
    }

    public final OciIdentityDomain ociIdentityDomain() {
        return this.ociIdentityDomain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.existingTenancyActivationLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.newTenancyActivationLink());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociIdentityDomain());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOciOnboardingStatusResponse)) {
            return false;
        }
        GetOciOnboardingStatusResponse other = (GetOciOnboardingStatusResponse)((Object)obj);
        return Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.existingTenancyActivationLink(), other.existingTenancyActivationLink()) && Objects.equals(this.newTenancyActivationLink(), other.newTenancyActivationLink()) && Objects.equals(this.ociIdentityDomain(), other.ociIdentityDomain());
    }

    public final String toString() {
        return ToString.builder((String)"GetOciOnboardingStatusResponse").add("Status", (Object)this.statusAsString()).add("ExistingTenancyActivationLink", (Object)this.existingTenancyActivationLink()).add("NewTenancyActivationLink", (Object)this.newTenancyActivationLink()).add("OciIdentityDomain", (Object)this.ociIdentityDomain()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "existingTenancyActivationLink": {
                return Optional.ofNullable(clazz.cast(this.existingTenancyActivationLink()));
            }
            case "newTenancyActivationLink": {
                return Optional.ofNullable(clazz.cast(this.newTenancyActivationLink()));
            }
            case "ociIdentityDomain": {
                return Optional.ofNullable(clazz.cast(this.ociIdentityDomain()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("status", STATUS_FIELD);
        map.put("existingTenancyActivationLink", EXISTING_TENANCY_ACTIVATION_LINK_FIELD);
        map.put("newTenancyActivationLink", NEW_TENANCY_ACTIVATION_LINK_FIELD);
        map.put("ociIdentityDomain", OCI_IDENTITY_DOMAIN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetOciOnboardingStatusResponse, T> g) {
        return obj -> g.apply((GetOciOnboardingStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String status;
        private String existingTenancyActivationLink;
        private String newTenancyActivationLink;
        private OciIdentityDomain ociIdentityDomain;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOciOnboardingStatusResponse model) {
            super(model);
            this.status(model.status);
            this.existingTenancyActivationLink(model.existingTenancyActivationLink);
            this.newTenancyActivationLink(model.newTenancyActivationLink);
            this.ociIdentityDomain(model.ociIdentityDomain);
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OciOnboardingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExistingTenancyActivationLink() {
            return this.existingTenancyActivationLink;
        }

        public final void setExistingTenancyActivationLink(String existingTenancyActivationLink) {
            this.existingTenancyActivationLink = existingTenancyActivationLink;
        }

        @Override
        public final Builder existingTenancyActivationLink(String existingTenancyActivationLink) {
            this.existingTenancyActivationLink = existingTenancyActivationLink;
            return this;
        }

        public final String getNewTenancyActivationLink() {
            return this.newTenancyActivationLink;
        }

        public final void setNewTenancyActivationLink(String newTenancyActivationLink) {
            this.newTenancyActivationLink = newTenancyActivationLink;
        }

        @Override
        public final Builder newTenancyActivationLink(String newTenancyActivationLink) {
            this.newTenancyActivationLink = newTenancyActivationLink;
            return this;
        }

        public final OciIdentityDomain.Builder getOciIdentityDomain() {
            return this.ociIdentityDomain != null ? this.ociIdentityDomain.toBuilder() : null;
        }

        public final void setOciIdentityDomain(OciIdentityDomain.BuilderImpl ociIdentityDomain) {
            this.ociIdentityDomain = ociIdentityDomain != null ? ociIdentityDomain.build() : null;
        }

        @Override
        public final Builder ociIdentityDomain(OciIdentityDomain ociIdentityDomain) {
            this.ociIdentityDomain = ociIdentityDomain;
            return this;
        }

        @Override
        public GetOciOnboardingStatusResponse build() {
            return new GetOciOnboardingStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOciOnboardingStatusResponse> {
        public Builder status(String var1);

        public Builder status(OciOnboardingStatus var1);

        public Builder existingTenancyActivationLink(String var1);

        public Builder newTenancyActivationLink(String var1);

        public Builder ociIdentityDomain(OciIdentityDomain var1);

        default public Builder ociIdentityDomain(Consumer<OciIdentityDomain.Builder> ociIdentityDomain) {
            return this.ociIdentityDomain((OciIdentityDomain)((OciIdentityDomain.Builder)OciIdentityDomain.builder().applyMutation(ociIdentityDomain)).build());
        }
    }
}

