/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.DbNodeMaintenanceType;
import software.amazon.awssdk.services.odb.model.DbNodeResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DbNodeSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DbNodeSummary> {
    private static final SdkField<String> DB_NODE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbNodeId").getter(DbNodeSummary.getter(DbNodeSummary::dbNodeId)).setter(DbNodeSummary.setter(Builder::dbNodeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeId").build()}).build();
    private static final SdkField<String> DB_NODE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbNodeArn").getter(DbNodeSummary.getter(DbNodeSummary::dbNodeArn)).setter(DbNodeSummary.setter(Builder::dbNodeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DbNodeSummary.getter(DbNodeSummary::statusAsString)).setter(DbNodeSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(DbNodeSummary.getter(DbNodeSummary::statusReason)).setter(DbNodeSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> ADDITIONAL_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("additionalDetails").getter(DbNodeSummary.getter(DbNodeSummary::additionalDetails)).setter(DbNodeSummary.setter(Builder::additionalDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalDetails").build()}).build();
    private static final SdkField<String> BACKUP_IP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backupIpId").getter(DbNodeSummary.getter(DbNodeSummary::backupIpId)).setter(DbNodeSummary.setter(Builder::backupIpId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupIpId").build()}).build();
    private static final SdkField<String> BACKUP_VNIC2_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backupVnic2Id").getter(DbNodeSummary.getter(DbNodeSummary::backupVnic2Id)).setter(DbNodeSummary.setter(Builder::backupVnic2Id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupVnic2Id").build()}).build();
    private static final SdkField<String> BACKUP_VNIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backupVnicId").getter(DbNodeSummary.getter(DbNodeSummary::backupVnicId)).setter(DbNodeSummary.setter(Builder::backupVnicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupVnicId").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCount").getter(DbNodeSummary.getter(DbNodeSummary::cpuCoreCount)).setter(DbNodeSummary.setter(Builder::cpuCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()}).build();
    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs").getter(DbNodeSummary.getter(DbNodeSummary::dbNodeStorageSizeInGBs)).setter(DbNodeSummary.setter(Builder::dbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<String> DB_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbServerId").getter(DbNodeSummary.getter(DbNodeSummary::dbServerId)).setter(DbNodeSummary.setter(Builder::dbServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerId").build()}).build();
    private static final SdkField<String> DB_SYSTEM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbSystemId").getter(DbNodeSummary.getter(DbNodeSummary::dbSystemId)).setter(DbNodeSummary.setter(Builder::dbSystemId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbSystemId").build()}).build();
    private static final SdkField<String> FAULT_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("faultDomain").getter(DbNodeSummary.getter(DbNodeSummary::faultDomain)).setter(DbNodeSummary.setter(Builder::faultDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("faultDomain").build()}).build();
    private static final SdkField<String> HOST_IP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostIpId").getter(DbNodeSummary.getter(DbNodeSummary::hostIpId)).setter(DbNodeSummary.setter(Builder::hostIpId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostIpId").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(DbNodeSummary.getter(DbNodeSummary::hostname)).setter(DbNodeSummary.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> OCID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocid").getter(DbNodeSummary.getter(DbNodeSummary::ocid)).setter(DbNodeSummary.setter(Builder::ocid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()}).build();
    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociResourceAnchorName").getter(DbNodeSummary.getter(DbNodeSummary::ociResourceAnchorName)).setter(DbNodeSummary.setter(Builder::ociResourceAnchorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build()}).build();
    private static final SdkField<String> MAINTENANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("maintenanceType").getter(DbNodeSummary.getter(DbNodeSummary::maintenanceTypeAsString)).setter(DbNodeSummary.setter(Builder::maintenanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceType").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInGBs").getter(DbNodeSummary.getter(DbNodeSummary::memorySizeInGBs)).setter(DbNodeSummary.setter(Builder::memorySizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()}).build();
    private static final SdkField<Integer> SOFTWARE_STORAGE_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("softwareStorageSizeInGB").getter(DbNodeSummary.getter(DbNodeSummary::softwareStorageSizeInGB)).setter(DbNodeSummary.setter(Builder::softwareStorageSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("softwareStorageSizeInGB").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DbNodeSummary.getter(DbNodeSummary::createdAt)).setter(DbNodeSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TIME_MAINTENANCE_WINDOW_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeMaintenanceWindowEnd").getter(DbNodeSummary.getter(DbNodeSummary::timeMaintenanceWindowEnd)).setter(DbNodeSummary.setter(Builder::timeMaintenanceWindowEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeMaintenanceWindowEnd").build()}).build();
    private static final SdkField<String> TIME_MAINTENANCE_WINDOW_START_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeMaintenanceWindowStart").getter(DbNodeSummary.getter(DbNodeSummary::timeMaintenanceWindowStart)).setter(DbNodeSummary.setter(Builder::timeMaintenanceWindowStart)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeMaintenanceWindowStart").build()}).build();
    private static final SdkField<Integer> TOTAL_CPU_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalCpuCoreCount").getter(DbNodeSummary.getter(DbNodeSummary::totalCpuCoreCount)).setter(DbNodeSummary.setter(Builder::totalCpuCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalCpuCoreCount").build()}).build();
    private static final SdkField<String> VNIC2_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnic2Id").getter(DbNodeSummary.getter(DbNodeSummary::vnic2Id)).setter(DbNodeSummary.setter(Builder::vnic2Id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnic2Id").build()}).build();
    private static final SdkField<String> VNIC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("vnicId").getter(DbNodeSummary.getter(DbNodeSummary::vnicId)).setter(DbNodeSummary.setter(Builder::vnicId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vnicId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NODE_ID_FIELD, DB_NODE_ARN_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ADDITIONAL_DETAILS_FIELD, BACKUP_IP_ID_FIELD, BACKUP_VNIC2_ID_FIELD, BACKUP_VNIC_ID_FIELD, CPU_CORE_COUNT_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVER_ID_FIELD, DB_SYSTEM_ID_FIELD, FAULT_DOMAIN_FIELD, HOST_IP_ID_FIELD, HOSTNAME_FIELD, OCID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, MAINTENANCE_TYPE_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, SOFTWARE_STORAGE_SIZE_IN_GB_FIELD, CREATED_AT_FIELD, TIME_MAINTENANCE_WINDOW_END_FIELD, TIME_MAINTENANCE_WINDOW_START_FIELD, TOTAL_CPU_CORE_COUNT_FIELD, VNIC2_ID_FIELD, VNIC_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DbNodeSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbNodeId;
    private final String dbNodeArn;
    private final String status;
    private final String statusReason;
    private final String additionalDetails;
    private final String backupIpId;
    private final String backupVnic2Id;
    private final String backupVnicId;
    private final Integer cpuCoreCount;
    private final Integer dbNodeStorageSizeInGBs;
    private final String dbServerId;
    private final String dbSystemId;
    private final String faultDomain;
    private final String hostIpId;
    private final String hostname;
    private final String ocid;
    private final String ociResourceAnchorName;
    private final String maintenanceType;
    private final Integer memorySizeInGBs;
    private final Integer softwareStorageSizeInGB;
    private final Instant createdAt;
    private final String timeMaintenanceWindowEnd;
    private final String timeMaintenanceWindowStart;
    private final Integer totalCpuCoreCount;
    private final String vnic2Id;
    private final String vnicId;

    private DbNodeSummary(BuilderImpl builder) {
        this.dbNodeId = builder.dbNodeId;
        this.dbNodeArn = builder.dbNodeArn;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.additionalDetails = builder.additionalDetails;
        this.backupIpId = builder.backupIpId;
        this.backupVnic2Id = builder.backupVnic2Id;
        this.backupVnicId = builder.backupVnicId;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServerId = builder.dbServerId;
        this.dbSystemId = builder.dbSystemId;
        this.faultDomain = builder.faultDomain;
        this.hostIpId = builder.hostIpId;
        this.hostname = builder.hostname;
        this.ocid = builder.ocid;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.maintenanceType = builder.maintenanceType;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.softwareStorageSizeInGB = builder.softwareStorageSizeInGB;
        this.createdAt = builder.createdAt;
        this.timeMaintenanceWindowEnd = builder.timeMaintenanceWindowEnd;
        this.timeMaintenanceWindowStart = builder.timeMaintenanceWindowStart;
        this.totalCpuCoreCount = builder.totalCpuCoreCount;
        this.vnic2Id = builder.vnic2Id;
        this.vnicId = builder.vnicId;
    }

    public final String dbNodeId() {
        return this.dbNodeId;
    }

    public final String dbNodeArn() {
        return this.dbNodeArn;
    }

    public final DbNodeResourceStatus status() {
        return DbNodeResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String additionalDetails() {
        return this.additionalDetails;
    }

    public final String backupIpId() {
        return this.backupIpId;
    }

    public final String backupVnic2Id() {
        return this.backupVnic2Id;
    }

    public final String backupVnicId() {
        return this.backupVnicId;
    }

    public final Integer cpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final Integer dbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public final String dbServerId() {
        return this.dbServerId;
    }

    public final String dbSystemId() {
        return this.dbSystemId;
    }

    public final String faultDomain() {
        return this.faultDomain;
    }

    public final String hostIpId() {
        return this.hostIpId;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String ocid() {
        return this.ocid;
    }

    public final String ociResourceAnchorName() {
        return this.ociResourceAnchorName;
    }

    public final DbNodeMaintenanceType maintenanceType() {
        return DbNodeMaintenanceType.fromValue(this.maintenanceType);
    }

    public final String maintenanceTypeAsString() {
        return this.maintenanceType;
    }

    public final Integer memorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public final Integer softwareStorageSizeInGB() {
        return this.softwareStorageSizeInGB;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String timeMaintenanceWindowEnd() {
        return this.timeMaintenanceWindowEnd;
    }

    public final String timeMaintenanceWindowStart() {
        return this.timeMaintenanceWindowStart;
    }

    public final Integer totalCpuCoreCount() {
        return this.totalCpuCoreCount;
    }

    public final String vnic2Id() {
        return this.vnic2Id;
    }

    public final String vnicId() {
        return this.vnicId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.additionalDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupIpId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVnic2Id());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVnicId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSystemId());
        hashCode = 31 * hashCode + Objects.hashCode(this.faultDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostIpId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.softwareStorageSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeMaintenanceWindowEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeMaintenanceWindowStart());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalCpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnic2Id());
        hashCode = 31 * hashCode + Objects.hashCode(this.vnicId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbNodeSummary)) {
            return false;
        }
        DbNodeSummary other = (DbNodeSummary)obj;
        return Objects.equals(this.dbNodeId(), other.dbNodeId()) && Objects.equals(this.dbNodeArn(), other.dbNodeArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.additionalDetails(), other.additionalDetails()) && Objects.equals(this.backupIpId(), other.backupIpId()) && Objects.equals(this.backupVnic2Id(), other.backupVnic2Id()) && Objects.equals(this.backupVnicId(), other.backupVnicId()) && Objects.equals(this.cpuCoreCount(), other.cpuCoreCount()) && Objects.equals(this.dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs()) && Objects.equals(this.dbServerId(), other.dbServerId()) && Objects.equals(this.dbSystemId(), other.dbSystemId()) && Objects.equals(this.faultDomain(), other.faultDomain()) && Objects.equals(this.hostIpId(), other.hostIpId()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.ocid(), other.ocid()) && Objects.equals(this.ociResourceAnchorName(), other.ociResourceAnchorName()) && Objects.equals(this.maintenanceTypeAsString(), other.maintenanceTypeAsString()) && Objects.equals(this.memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(this.softwareStorageSizeInGB(), other.softwareStorageSizeInGB()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.timeMaintenanceWindowEnd(), other.timeMaintenanceWindowEnd()) && Objects.equals(this.timeMaintenanceWindowStart(), other.timeMaintenanceWindowStart()) && Objects.equals(this.totalCpuCoreCount(), other.totalCpuCoreCount()) && Objects.equals(this.vnic2Id(), other.vnic2Id()) && Objects.equals(this.vnicId(), other.vnicId());
    }

    public final String toString() {
        return ToString.builder((String)"DbNodeSummary").add("DbNodeId", (Object)this.dbNodeId()).add("DbNodeArn", (Object)this.dbNodeArn()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("AdditionalDetails", (Object)this.additionalDetails()).add("BackupIpId", (Object)this.backupIpId()).add("BackupVnic2Id", (Object)this.backupVnic2Id()).add("BackupVnicId", (Object)this.backupVnicId()).add("CpuCoreCount", (Object)this.cpuCoreCount()).add("DbNodeStorageSizeInGBs", (Object)this.dbNodeStorageSizeInGBs()).add("DbServerId", (Object)this.dbServerId()).add("DbSystemId", (Object)this.dbSystemId()).add("FaultDomain", (Object)this.faultDomain()).add("HostIpId", (Object)this.hostIpId()).add("Hostname", (Object)this.hostname()).add("Ocid", (Object)this.ocid()).add("OciResourceAnchorName", (Object)this.ociResourceAnchorName()).add("MaintenanceType", (Object)this.maintenanceTypeAsString()).add("MemorySizeInGBs", (Object)this.memorySizeInGBs()).add("SoftwareStorageSizeInGB", (Object)this.softwareStorageSizeInGB()).add("CreatedAt", (Object)this.createdAt()).add("TimeMaintenanceWindowEnd", (Object)this.timeMaintenanceWindowEnd()).add("TimeMaintenanceWindowStart", (Object)this.timeMaintenanceWindowStart()).add("TotalCpuCoreCount", (Object)this.totalCpuCoreCount()).add("Vnic2Id", (Object)this.vnic2Id()).add("VnicId", (Object)this.vnicId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbNodeId": {
                return Optional.ofNullable(clazz.cast(this.dbNodeId()));
            }
            case "dbNodeArn": {
                return Optional.ofNullable(clazz.cast(this.dbNodeArn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "additionalDetails": {
                return Optional.ofNullable(clazz.cast(this.additionalDetails()));
            }
            case "backupIpId": {
                return Optional.ofNullable(clazz.cast(this.backupIpId()));
            }
            case "backupVnic2Id": {
                return Optional.ofNullable(clazz.cast(this.backupVnic2Id()));
            }
            case "backupVnicId": {
                return Optional.ofNullable(clazz.cast(this.backupVnicId()));
            }
            case "cpuCoreCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCount()));
            }
            case "dbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dbNodeStorageSizeInGBs()));
            }
            case "dbServerId": {
                return Optional.ofNullable(clazz.cast(this.dbServerId()));
            }
            case "dbSystemId": {
                return Optional.ofNullable(clazz.cast(this.dbSystemId()));
            }
            case "faultDomain": {
                return Optional.ofNullable(clazz.cast(this.faultDomain()));
            }
            case "hostIpId": {
                return Optional.ofNullable(clazz.cast(this.hostIpId()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "ocid": {
                return Optional.ofNullable(clazz.cast(this.ocid()));
            }
            case "ociResourceAnchorName": {
                return Optional.ofNullable(clazz.cast(this.ociResourceAnchorName()));
            }
            case "maintenanceType": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTypeAsString()));
            }
            case "memorySizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInGBs()));
            }
            case "softwareStorageSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.softwareStorageSizeInGB()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "timeMaintenanceWindowEnd": {
                return Optional.ofNullable(clazz.cast(this.timeMaintenanceWindowEnd()));
            }
            case "timeMaintenanceWindowStart": {
                return Optional.ofNullable(clazz.cast(this.timeMaintenanceWindowStart()));
            }
            case "totalCpuCoreCount": {
                return Optional.ofNullable(clazz.cast(this.totalCpuCoreCount()));
            }
            case "vnic2Id": {
                return Optional.ofNullable(clazz.cast(this.vnic2Id()));
            }
            case "vnicId": {
                return Optional.ofNullable(clazz.cast(this.vnicId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbNodeId", DB_NODE_ID_FIELD);
        map.put("dbNodeArn", DB_NODE_ARN_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("additionalDetails", ADDITIONAL_DETAILS_FIELD);
        map.put("backupIpId", BACKUP_IP_ID_FIELD);
        map.put("backupVnic2Id", BACKUP_VNIC2_ID_FIELD);
        map.put("backupVnicId", BACKUP_VNIC_ID_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServerId", DB_SERVER_ID_FIELD);
        map.put("dbSystemId", DB_SYSTEM_ID_FIELD);
        map.put("faultDomain", FAULT_DOMAIN_FIELD);
        map.put("hostIpId", HOST_IP_ID_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("maintenanceType", MAINTENANCE_TYPE_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("softwareStorageSizeInGB", SOFTWARE_STORAGE_SIZE_IN_GB_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("timeMaintenanceWindowEnd", TIME_MAINTENANCE_WINDOW_END_FIELD);
        map.put("timeMaintenanceWindowStart", TIME_MAINTENANCE_WINDOW_START_FIELD);
        map.put("totalCpuCoreCount", TOTAL_CPU_CORE_COUNT_FIELD);
        map.put("vnic2Id", VNIC2_ID_FIELD);
        map.put("vnicId", VNIC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbNodeSummary, T> g) {
        return obj -> g.apply((DbNodeSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbNodeId;
        private String dbNodeArn;
        private String status;
        private String statusReason;
        private String additionalDetails;
        private String backupIpId;
        private String backupVnic2Id;
        private String backupVnicId;
        private Integer cpuCoreCount;
        private Integer dbNodeStorageSizeInGBs;
        private String dbServerId;
        private String dbSystemId;
        private String faultDomain;
        private String hostIpId;
        private String hostname;
        private String ocid;
        private String ociResourceAnchorName;
        private String maintenanceType;
        private Integer memorySizeInGBs;
        private Integer softwareStorageSizeInGB;
        private Instant createdAt;
        private String timeMaintenanceWindowEnd;
        private String timeMaintenanceWindowStart;
        private Integer totalCpuCoreCount;
        private String vnic2Id;
        private String vnicId;

        private BuilderImpl() {
        }

        private BuilderImpl(DbNodeSummary model) {
            this.dbNodeId(model.dbNodeId);
            this.dbNodeArn(model.dbNodeArn);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.additionalDetails(model.additionalDetails);
            this.backupIpId(model.backupIpId);
            this.backupVnic2Id(model.backupVnic2Id);
            this.backupVnicId(model.backupVnicId);
            this.cpuCoreCount(model.cpuCoreCount);
            this.dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            this.dbServerId(model.dbServerId);
            this.dbSystemId(model.dbSystemId);
            this.faultDomain(model.faultDomain);
            this.hostIpId(model.hostIpId);
            this.hostname(model.hostname);
            this.ocid(model.ocid);
            this.ociResourceAnchorName(model.ociResourceAnchorName);
            this.maintenanceType(model.maintenanceType);
            this.memorySizeInGBs(model.memorySizeInGBs);
            this.softwareStorageSizeInGB(model.softwareStorageSizeInGB);
            this.createdAt(model.createdAt);
            this.timeMaintenanceWindowEnd(model.timeMaintenanceWindowEnd);
            this.timeMaintenanceWindowStart(model.timeMaintenanceWindowStart);
            this.totalCpuCoreCount(model.totalCpuCoreCount);
            this.vnic2Id(model.vnic2Id);
            this.vnicId(model.vnicId);
        }

        public final String getDbNodeId() {
            return this.dbNodeId;
        }

        public final void setDbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
        }

        @Override
        public final Builder dbNodeId(String dbNodeId) {
            this.dbNodeId = dbNodeId;
            return this;
        }

        public final String getDbNodeArn() {
            return this.dbNodeArn;
        }

        public final void setDbNodeArn(String dbNodeArn) {
            this.dbNodeArn = dbNodeArn;
        }

        @Override
        public final Builder dbNodeArn(String dbNodeArn) {
            this.dbNodeArn = dbNodeArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DbNodeResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAdditionalDetails() {
            return this.additionalDetails;
        }

        public final void setAdditionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
        }

        @Override
        public final Builder additionalDetails(String additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public final String getBackupIpId() {
            return this.backupIpId;
        }

        public final void setBackupIpId(String backupIpId) {
            this.backupIpId = backupIpId;
        }

        @Override
        public final Builder backupIpId(String backupIpId) {
            this.backupIpId = backupIpId;
            return this;
        }

        public final String getBackupVnic2Id() {
            return this.backupVnic2Id;
        }

        public final void setBackupVnic2Id(String backupVnic2Id) {
            this.backupVnic2Id = backupVnic2Id;
        }

        @Override
        public final Builder backupVnic2Id(String backupVnic2Id) {
            this.backupVnic2Id = backupVnic2Id;
            return this;
        }

        public final String getBackupVnicId() {
            return this.backupVnicId;
        }

        public final void setBackupVnicId(String backupVnicId) {
            this.backupVnicId = backupVnicId;
        }

        @Override
        public final Builder backupVnicId(String backupVnicId) {
            this.backupVnicId = backupVnicId;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final String getDbServerId() {
            return this.dbServerId;
        }

        public final void setDbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
        }

        @Override
        public final Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            return this;
        }

        public final String getDbSystemId() {
            return this.dbSystemId;
        }

        public final void setDbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
        }

        @Override
        public final Builder dbSystemId(String dbSystemId) {
            this.dbSystemId = dbSystemId;
            return this;
        }

        public final String getFaultDomain() {
            return this.faultDomain;
        }

        public final void setFaultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
        }

        @Override
        public final Builder faultDomain(String faultDomain) {
            this.faultDomain = faultDomain;
            return this;
        }

        public final String getHostIpId() {
            return this.hostIpId;
        }

        public final void setHostIpId(String hostIpId) {
            this.hostIpId = hostIpId;
        }

        @Override
        public final Builder hostIpId(String hostIpId) {
            this.hostIpId = hostIpId;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getOcid() {
            return this.ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return this.ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getMaintenanceType() {
            return this.maintenanceType;
        }

        public final void setMaintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
        }

        @Override
        public final Builder maintenanceType(String maintenanceType) {
            this.maintenanceType = maintenanceType;
            return this;
        }

        @Override
        public final Builder maintenanceType(DbNodeMaintenanceType maintenanceType) {
            this.maintenanceType(maintenanceType == null ? null : maintenanceType.toString());
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getSoftwareStorageSizeInGB() {
            return this.softwareStorageSizeInGB;
        }

        public final void setSoftwareStorageSizeInGB(Integer softwareStorageSizeInGB) {
            this.softwareStorageSizeInGB = softwareStorageSizeInGB;
        }

        @Override
        public final Builder softwareStorageSizeInGB(Integer softwareStorageSizeInGB) {
            this.softwareStorageSizeInGB = softwareStorageSizeInGB;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getTimeMaintenanceWindowEnd() {
            return this.timeMaintenanceWindowEnd;
        }

        public final void setTimeMaintenanceWindowEnd(String timeMaintenanceWindowEnd) {
            this.timeMaintenanceWindowEnd = timeMaintenanceWindowEnd;
        }

        @Override
        public final Builder timeMaintenanceWindowEnd(String timeMaintenanceWindowEnd) {
            this.timeMaintenanceWindowEnd = timeMaintenanceWindowEnd;
            return this;
        }

        public final String getTimeMaintenanceWindowStart() {
            return this.timeMaintenanceWindowStart;
        }

        public final void setTimeMaintenanceWindowStart(String timeMaintenanceWindowStart) {
            this.timeMaintenanceWindowStart = timeMaintenanceWindowStart;
        }

        @Override
        public final Builder timeMaintenanceWindowStart(String timeMaintenanceWindowStart) {
            this.timeMaintenanceWindowStart = timeMaintenanceWindowStart;
            return this;
        }

        public final Integer getTotalCpuCoreCount() {
            return this.totalCpuCoreCount;
        }

        public final void setTotalCpuCoreCount(Integer totalCpuCoreCount) {
            this.totalCpuCoreCount = totalCpuCoreCount;
        }

        @Override
        public final Builder totalCpuCoreCount(Integer totalCpuCoreCount) {
            this.totalCpuCoreCount = totalCpuCoreCount;
            return this;
        }

        public final String getVnic2Id() {
            return this.vnic2Id;
        }

        public final void setVnic2Id(String vnic2Id) {
            this.vnic2Id = vnic2Id;
        }

        @Override
        public final Builder vnic2Id(String vnic2Id) {
            this.vnic2Id = vnic2Id;
            return this;
        }

        public final String getVnicId() {
            return this.vnicId;
        }

        public final void setVnicId(String vnicId) {
            this.vnicId = vnicId;
        }

        @Override
        public final Builder vnicId(String vnicId) {
            this.vnicId = vnicId;
            return this;
        }

        public DbNodeSummary build() {
            return new DbNodeSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DbNodeSummary> {
        public Builder dbNodeId(String var1);

        public Builder dbNodeArn(String var1);

        public Builder status(String var1);

        public Builder status(DbNodeResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder additionalDetails(String var1);

        public Builder backupIpId(String var1);

        public Builder backupVnic2Id(String var1);

        public Builder backupVnicId(String var1);

        public Builder cpuCoreCount(Integer var1);

        public Builder dbNodeStorageSizeInGBs(Integer var1);

        public Builder dbServerId(String var1);

        public Builder dbSystemId(String var1);

        public Builder faultDomain(String var1);

        public Builder hostIpId(String var1);

        public Builder hostname(String var1);

        public Builder ocid(String var1);

        public Builder ociResourceAnchorName(String var1);

        public Builder maintenanceType(String var1);

        public Builder maintenanceType(DbNodeMaintenanceType var1);

        public Builder memorySizeInGBs(Integer var1);

        public Builder softwareStorageSizeInGB(Integer var1);

        public Builder createdAt(Instant var1);

        public Builder timeMaintenanceWindowEnd(String var1);

        public Builder timeMaintenanceWindowStart(String var1);

        public Builder totalCpuCoreCount(Integer var1);

        public Builder vnic2Id(String var1);

        public Builder vnicId(String var1);
    }
}

