/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.odb.model.CustomerContact;
import software.amazon.awssdk.services.odb.model.CustomerContactsCopier;
import software.amazon.awssdk.services.odb.model.MaintenanceWindow;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.RequestTagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudExadataInfrastructureRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, CreateCloudExadataInfrastructureRequest> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::displayName)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::shape)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::availabilityZone)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::availabilityZoneId)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::tags)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> COMPUTE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("computeCount").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::computeCount)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::computeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeCount").build()}).build();
    private static final SdkField<List<CustomerContact>> CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customerContactsToSendToOCI").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::customerContactsToSendToOCI)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::customerContactsToSendToOCI)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerContactsToSendToOCI").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomerContact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maintenanceWindow").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::maintenanceWindow)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()}).build();
    private static final SdkField<Integer> STORAGE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCount").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::storageCount)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::storageCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCount").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::clientToken)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DATABASE_SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseServerType").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::databaseServerType)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::databaseServerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseServerType").build()}).build();
    private static final SdkField<String> STORAGE_SERVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageServerType").getter(CreateCloudExadataInfrastructureRequest.getter(CreateCloudExadataInfrastructureRequest::storageServerType)).setter(CreateCloudExadataInfrastructureRequest.setter(Builder::storageServerType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageServerType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD, SHAPE_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, TAGS_FIELD, COMPUTE_COUNT_FIELD, CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD, MAINTENANCE_WINDOW_FIELD, STORAGE_COUNT_FIELD, CLIENT_TOKEN_FIELD, DATABASE_SERVER_TYPE_FIELD, STORAGE_SERVER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCloudExadataInfrastructureRequest.memberNameToFieldInitializer();
    private final String displayName;
    private final String shape;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final Map<String, String> tags;
    private final Integer computeCount;
    private final List<CustomerContact> customerContactsToSendToOCI;
    private final MaintenanceWindow maintenanceWindow;
    private final Integer storageCount;
    private final String clientToken;
    private final String databaseServerType;
    private final String storageServerType;

    private CreateCloudExadataInfrastructureRequest(BuilderImpl builder) {
        super(builder);
        this.displayName = builder.displayName;
        this.shape = builder.shape;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.tags = builder.tags;
        this.computeCount = builder.computeCount;
        this.customerContactsToSendToOCI = builder.customerContactsToSendToOCI;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.storageCount = builder.storageCount;
        this.clientToken = builder.clientToken;
        this.databaseServerType = builder.databaseServerType;
        this.storageServerType = builder.storageServerType;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String shape() {
        return this.shape;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Integer computeCount() {
        return this.computeCount;
    }

    public final boolean hasCustomerContactsToSendToOCI() {
        return this.customerContactsToSendToOCI != null && !(this.customerContactsToSendToOCI instanceof SdkAutoConstructList);
    }

    public final List<CustomerContact> customerContactsToSendToOCI() {
        return this.customerContactsToSendToOCI;
    }

    public final MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final Integer storageCount() {
        return this.storageCount;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String databaseServerType() {
        return this.databaseServerType;
    }

    public final String storageServerType() {
        return this.storageServerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.shape());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.computeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerContactsToSendToOCI() ? this.customerContactsToSendToOCI() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseServerType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageServerType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudExadataInfrastructureRequest)) {
            return false;
        }
        CreateCloudExadataInfrastructureRequest other = (CreateCloudExadataInfrastructureRequest)((Object)obj);
        return Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.shape(), other.shape()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.computeCount(), other.computeCount()) && this.hasCustomerContactsToSendToOCI() == other.hasCustomerContactsToSendToOCI() && Objects.equals(this.customerContactsToSendToOCI(), other.customerContactsToSendToOCI()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.storageCount(), other.storageCount()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.databaseServerType(), other.databaseServerType()) && Objects.equals(this.storageServerType(), other.storageServerType());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudExadataInfrastructureRequest").add("DisplayName", (Object)this.displayName()).add("Shape", (Object)this.shape()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("Tags", this.hasTags() ? this.tags() : null).add("ComputeCount", (Object)this.computeCount()).add("CustomerContactsToSendToOCI", this.hasCustomerContactsToSendToOCI() ? this.customerContactsToSendToOCI() : null).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("StorageCount", (Object)this.storageCount()).add("ClientToken", (Object)this.clientToken()).add("DatabaseServerType", (Object)this.databaseServerType()).add("StorageServerType", (Object)this.storageServerType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shape()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "computeCount": {
                return Optional.ofNullable(clazz.cast(this.computeCount()));
            }
            case "customerContactsToSendToOCI": {
                return Optional.ofNullable(clazz.cast(this.customerContactsToSendToOCI()));
            }
            case "maintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "storageCount": {
                return Optional.ofNullable(clazz.cast(this.storageCount()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "databaseServerType": {
                return Optional.ofNullable(clazz.cast(this.databaseServerType()));
            }
            case "storageServerType": {
                return Optional.ofNullable(clazz.cast(this.storageServerType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("computeCount", COMPUTE_COUNT_FIELD);
        map.put("customerContactsToSendToOCI", CUSTOMER_CONTACTS_TO_SEND_TO_OCI_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("storageCount", STORAGE_COUNT_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("databaseServerType", DATABASE_SERVER_TYPE_FIELD);
        map.put("storageServerType", STORAGE_SERVER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudExadataInfrastructureRequest, T> g) {
        return obj -> g.apply((CreateCloudExadataInfrastructureRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String displayName;
        private String shape;
        private String availabilityZone;
        private String availabilityZoneId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer computeCount;
        private List<CustomerContact> customerContactsToSendToOCI = DefaultSdkAutoConstructList.getInstance();
        private MaintenanceWindow maintenanceWindow;
        private Integer storageCount;
        private String clientToken;
        private String databaseServerType;
        private String storageServerType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudExadataInfrastructureRequest model) {
            super(model);
            this.displayName(model.displayName);
            this.shape(model.shape);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.tags(model.tags);
            this.computeCount(model.computeCount);
            this.customerContactsToSendToOCI(model.customerContactsToSendToOCI);
            this.maintenanceWindow(model.maintenanceWindow);
            this.storageCount(model.storageCount);
            this.clientToken(model.clientToken);
            this.databaseServerType(model.databaseServerType);
            this.storageServerType(model.storageServerType);
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final Integer getComputeCount() {
            return this.computeCount;
        }

        public final void setComputeCount(Integer computeCount) {
            this.computeCount = computeCount;
        }

        @Override
        public final Builder computeCount(Integer computeCount) {
            this.computeCount = computeCount;
            return this;
        }

        public final List<CustomerContact.Builder> getCustomerContactsToSendToOCI() {
            List<CustomerContact.Builder> result = CustomerContactsCopier.copyToBuilder(this.customerContactsToSendToOCI);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomerContactsToSendToOCI(Collection<CustomerContact.BuilderImpl> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copyFromBuilder(customerContactsToSendToOCI);
        }

        @Override
        public final Builder customerContactsToSendToOCI(Collection<CustomerContact> customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI = CustomerContactsCopier.copy(customerContactsToSendToOCI);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(CustomerContact ... customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI(Arrays.asList(customerContactsToSendToOCI));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder> ... customerContactsToSendToOCI) {
            this.customerContactsToSendToOCI(Stream.of(customerContactsToSendToOCI).map(c -> (CustomerContact)((CustomerContact.Builder)CustomerContact.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return this.maintenanceWindow != null ? this.maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getStorageCount() {
            return this.storageCount;
        }

        public final void setStorageCount(Integer storageCount) {
            this.storageCount = storageCount;
        }

        @Override
        public final Builder storageCount(Integer storageCount) {
            this.storageCount = storageCount;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDatabaseServerType() {
            return this.databaseServerType;
        }

        public final void setDatabaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
        }

        @Override
        public final Builder databaseServerType(String databaseServerType) {
            this.databaseServerType = databaseServerType;
            return this;
        }

        public final String getStorageServerType() {
            return this.storageServerType;
        }

        public final void setStorageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
        }

        @Override
        public final Builder storageServerType(String storageServerType) {
            this.storageServerType = storageServerType;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudExadataInfrastructureRequest build() {
            return new CreateCloudExadataInfrastructureRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudExadataInfrastructureRequest> {
        public Builder displayName(String var1);

        public Builder shape(String var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder computeCount(Integer var1);

        public Builder customerContactsToSendToOCI(Collection<CustomerContact> var1);

        public Builder customerContactsToSendToOCI(CustomerContact ... var1);

        public Builder customerContactsToSendToOCI(Consumer<CustomerContact.Builder> ... var1);

        public Builder maintenanceWindow(MaintenanceWindow var1);

        default public Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return this.maintenanceWindow((MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation(maintenanceWindow)).build());
        }

        public Builder storageCount(Integer var1);

        public Builder clientToken(String var1);

        public Builder databaseServerType(String var1);

        public Builder storageServerType(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

