/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.DbNodeSummary;
import software.amazon.awssdk.services.odb.model.ListDbNodesRequest;
import software.amazon.awssdk.services.odb.model.ListDbNodesResponse;

public class ListDbNodesIterable
implements SdkIterable<ListDbNodesResponse> {
    private final OdbClient client;
    private final ListDbNodesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDbNodesIterable(OdbClient client, ListDbNodesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDbNodesResponseFetcher();
    }

    public Iterator<ListDbNodesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DbNodeSummary> dbNodes() {
        Function<ListDbNodesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbNodes() != null) {
                return response.dbNodes().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDbNodesResponseFetcher
    implements SyncPageFetcher<ListDbNodesResponse> {
        private ListDbNodesResponseFetcher() {
        }

        public boolean hasNextPage(ListDbNodesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDbNodesResponse nextPage(ListDbNodesResponse previousPage) {
            if (previousPage == null) {
                return ListDbNodesIterable.this.client.listDbNodes(ListDbNodesIterable.this.firstRequest);
            }
            return ListDbNodesIterable.this.client.listDbNodes((ListDbNodesRequest)((Object)ListDbNodesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

