/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.DbServerSummary;
import software.amazon.awssdk.services.odb.model.ListDbServersRequest;
import software.amazon.awssdk.services.odb.model.ListDbServersResponse;

public class ListDbServersIterable
implements SdkIterable<ListDbServersResponse> {
    private final OdbClient client;
    private final ListDbServersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDbServersIterable(OdbClient client, ListDbServersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDbServersResponseFetcher();
    }

    public Iterator<ListDbServersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DbServerSummary> dbServers() {
        Function<ListDbServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.dbServers() != null) {
                return response.dbServers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDbServersResponseFetcher
    implements SyncPageFetcher<ListDbServersResponse> {
        private ListDbServersResponseFetcher() {
        }

        public boolean hasNextPage(ListDbServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDbServersResponse nextPage(ListDbServersResponse previousPage) {
            if (previousPage == null) {
                return ListDbServersIterable.this.client.listDbServers(ListDbServersIterable.this.firstRequest);
            }
            return ListDbServersIterable.this.client.listDbServers((ListDbServersRequest)((Object)ListDbServersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

