/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.ComputeModel;
import software.amazon.awssdk.services.odb.model.DbServerPatchingDetails;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DbServerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DbServerSummary> {
    private static final SdkField<String> DB_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbServerId").getter(DbServerSummary.getter(DbServerSummary::dbServerId)).setter(DbServerSummary.setter(Builder::dbServerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DbServerSummary.getter(DbServerSummary::statusAsString)).setter(DbServerSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(DbServerSummary.getter(DbServerSummary::statusReason)).setter(DbServerSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCount").getter(DbServerSummary.getter(DbServerSummary::cpuCoreCount)).setter(DbServerSummary.setter(Builder::cpuCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()}).build();
    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs").getter(DbServerSummary.getter(DbServerSummary::dbNodeStorageSizeInGBs)).setter(DbServerSummary.setter(Builder::dbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<DbServerPatchingDetails> DB_SERVER_PATCHING_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dbServerPatchingDetails").getter(DbServerSummary.getter(DbServerSummary::dbServerPatchingDetails)).setter(DbServerSummary.setter(Builder::dbServerPatchingDetails)).constructor(DbServerPatchingDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServerPatchingDetails").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(DbServerSummary.getter(DbServerSummary::displayName)).setter(DbServerSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("exadataInfrastructureId").getter(DbServerSummary.getter(DbServerSummary::exadataInfrastructureId)).setter(DbServerSummary.setter(Builder::exadataInfrastructureId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exadataInfrastructureId").build()}).build();
    private static final SdkField<String> OCID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocid").getter(DbServerSummary.getter(DbServerSummary::ocid)).setter(DbServerSummary.setter(Builder::ocid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()}).build();
    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociResourceAnchorName").getter(DbServerSummary.getter(DbServerSummary::ociResourceAnchorName)).setter(DbServerSummary.setter(Builder::ociResourceAnchorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build()}).build();
    private static final SdkField<Integer> MAX_CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxCpuCount").getter(DbServerSummary.getter(DbServerSummary::maxCpuCount)).setter(DbServerSummary.setter(Builder::maxCpuCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpuCount").build()}).build();
    private static final SdkField<Integer> MAX_DB_NODE_STORAGE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxDbNodeStorageInGBs").getter(DbServerSummary.getter(DbServerSummary::maxDbNodeStorageInGBs)).setter(DbServerSummary.setter(Builder::maxDbNodeStorageInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDbNodeStorageInGBs").build()}).build();
    private static final SdkField<Integer> MAX_MEMORY_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxMemoryInGBs").getter(DbServerSummary.getter(DbServerSummary::maxMemoryInGBs)).setter(DbServerSummary.setter(Builder::maxMemoryInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxMemoryInGBs").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInGBs").getter(DbServerSummary.getter(DbServerSummary::memorySizeInGBs)).setter(DbServerSummary.setter(Builder::memorySizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(DbServerSummary.getter(DbServerSummary::shape)).setter(DbServerSummary.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DbServerSummary.getter(DbServerSummary::createdAt)).setter(DbServerSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<String>> VM_CLUSTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vmClusterIds").getter(DbServerSummary.getter(DbServerSummary::vmClusterIds)).setter(DbServerSummary.setter(Builder::vmClusterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vmClusterIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeModel").getter(DbServerSummary.getter(DbServerSummary::computeModelAsString)).setter(DbServerSummary.setter(Builder::computeModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()}).build();
    private static final SdkField<List<String>> AUTONOMOUS_VM_CLUSTER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autonomousVmClusterIds").getter(DbServerSummary.getter(DbServerSummary::autonomousVmClusterIds)).setter(DbServerSummary.setter(Builder::autonomousVmClusterIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousVmClusterIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> AUTONOMOUS_VIRTUAL_MACHINE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("autonomousVirtualMachineIds").getter(DbServerSummary.getter(DbServerSummary::autonomousVirtualMachineIds)).setter(DbServerSummary.setter(Builder::autonomousVirtualMachineIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousVirtualMachineIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_SERVER_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CPU_CORE_COUNT_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVER_PATCHING_DETAILS_FIELD, DISPLAY_NAME_FIELD, EXADATA_INFRASTRUCTURE_ID_FIELD, OCID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, MAX_CPU_COUNT_FIELD, MAX_DB_NODE_STORAGE_IN_G_BS_FIELD, MAX_MEMORY_IN_G_BS_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, SHAPE_FIELD, CREATED_AT_FIELD, VM_CLUSTER_IDS_FIELD, COMPUTE_MODEL_FIELD, AUTONOMOUS_VM_CLUSTER_IDS_FIELD, AUTONOMOUS_VIRTUAL_MACHINE_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DbServerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbServerId;
    private final String status;
    private final String statusReason;
    private final Integer cpuCoreCount;
    private final Integer dbNodeStorageSizeInGBs;
    private final DbServerPatchingDetails dbServerPatchingDetails;
    private final String displayName;
    private final String exadataInfrastructureId;
    private final String ocid;
    private final String ociResourceAnchorName;
    private final Integer maxCpuCount;
    private final Integer maxDbNodeStorageInGBs;
    private final Integer maxMemoryInGBs;
    private final Integer memorySizeInGBs;
    private final String shape;
    private final Instant createdAt;
    private final List<String> vmClusterIds;
    private final String computeModel;
    private final List<String> autonomousVmClusterIds;
    private final List<String> autonomousVirtualMachineIds;

    private DbServerSummary(BuilderImpl builder) {
        this.dbServerId = builder.dbServerId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServerPatchingDetails = builder.dbServerPatchingDetails;
        this.displayName = builder.displayName;
        this.exadataInfrastructureId = builder.exadataInfrastructureId;
        this.ocid = builder.ocid;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.maxCpuCount = builder.maxCpuCount;
        this.maxDbNodeStorageInGBs = builder.maxDbNodeStorageInGBs;
        this.maxMemoryInGBs = builder.maxMemoryInGBs;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.shape = builder.shape;
        this.createdAt = builder.createdAt;
        this.vmClusterIds = builder.vmClusterIds;
        this.computeModel = builder.computeModel;
        this.autonomousVmClusterIds = builder.autonomousVmClusterIds;
        this.autonomousVirtualMachineIds = builder.autonomousVirtualMachineIds;
    }

    public final String dbServerId() {
        return this.dbServerId;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final Integer cpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final Integer dbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public final DbServerPatchingDetails dbServerPatchingDetails() {
        return this.dbServerPatchingDetails;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String exadataInfrastructureId() {
        return this.exadataInfrastructureId;
    }

    public final String ocid() {
        return this.ocid;
    }

    public final String ociResourceAnchorName() {
        return this.ociResourceAnchorName;
    }

    public final Integer maxCpuCount() {
        return this.maxCpuCount;
    }

    public final Integer maxDbNodeStorageInGBs() {
        return this.maxDbNodeStorageInGBs;
    }

    public final Integer maxMemoryInGBs() {
        return this.maxMemoryInGBs;
    }

    public final Integer memorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public final String shape() {
        return this.shape;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final boolean hasVmClusterIds() {
        return this.vmClusterIds != null && !(this.vmClusterIds instanceof SdkAutoConstructList);
    }

    public final List<String> vmClusterIds() {
        return this.vmClusterIds;
    }

    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(this.computeModel);
    }

    public final String computeModelAsString() {
        return this.computeModel;
    }

    public final boolean hasAutonomousVmClusterIds() {
        return this.autonomousVmClusterIds != null && !(this.autonomousVmClusterIds instanceof SdkAutoConstructList);
    }

    public final List<String> autonomousVmClusterIds() {
        return this.autonomousVmClusterIds;
    }

    public final boolean hasAutonomousVirtualMachineIds() {
        return this.autonomousVirtualMachineIds != null && !(this.autonomousVirtualMachineIds instanceof SdkAutoConstructList);
    }

    public final List<String> autonomousVirtualMachineIds() {
        return this.autonomousVirtualMachineIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbServerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbServerPatchingDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.exadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDbNodeStorageInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxMemoryInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.shape());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVmClusterIds() ? this.vmClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.computeModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutonomousVmClusterIds() ? this.autonomousVmClusterIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAutonomousVirtualMachineIds() ? this.autonomousVirtualMachineIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbServerSummary)) {
            return false;
        }
        DbServerSummary other = (DbServerSummary)obj;
        return Objects.equals(this.dbServerId(), other.dbServerId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.cpuCoreCount(), other.cpuCoreCount()) && Objects.equals(this.dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs()) && Objects.equals(this.dbServerPatchingDetails(), other.dbServerPatchingDetails()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.exadataInfrastructureId(), other.exadataInfrastructureId()) && Objects.equals(this.ocid(), other.ocid()) && Objects.equals(this.ociResourceAnchorName(), other.ociResourceAnchorName()) && Objects.equals(this.maxCpuCount(), other.maxCpuCount()) && Objects.equals(this.maxDbNodeStorageInGBs(), other.maxDbNodeStorageInGBs()) && Objects.equals(this.maxMemoryInGBs(), other.maxMemoryInGBs()) && Objects.equals(this.memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(this.shape(), other.shape()) && Objects.equals(this.createdAt(), other.createdAt()) && this.hasVmClusterIds() == other.hasVmClusterIds() && Objects.equals(this.vmClusterIds(), other.vmClusterIds()) && Objects.equals(this.computeModelAsString(), other.computeModelAsString()) && this.hasAutonomousVmClusterIds() == other.hasAutonomousVmClusterIds() && Objects.equals(this.autonomousVmClusterIds(), other.autonomousVmClusterIds()) && this.hasAutonomousVirtualMachineIds() == other.hasAutonomousVirtualMachineIds() && Objects.equals(this.autonomousVirtualMachineIds(), other.autonomousVirtualMachineIds());
    }

    public final String toString() {
        return ToString.builder((String)"DbServerSummary").add("DbServerId", (Object)this.dbServerId()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CpuCoreCount", (Object)this.cpuCoreCount()).add("DbNodeStorageSizeInGBs", (Object)this.dbNodeStorageSizeInGBs()).add("DbServerPatchingDetails", (Object)this.dbServerPatchingDetails()).add("DisplayName", (Object)this.displayName()).add("ExadataInfrastructureId", (Object)this.exadataInfrastructureId()).add("Ocid", (Object)this.ocid()).add("OciResourceAnchorName", (Object)this.ociResourceAnchorName()).add("MaxCpuCount", (Object)this.maxCpuCount()).add("MaxDbNodeStorageInGBs", (Object)this.maxDbNodeStorageInGBs()).add("MaxMemoryInGBs", (Object)this.maxMemoryInGBs()).add("MemorySizeInGBs", (Object)this.memorySizeInGBs()).add("Shape", (Object)this.shape()).add("CreatedAt", (Object)this.createdAt()).add("VmClusterIds", this.hasVmClusterIds() ? this.vmClusterIds() : null).add("ComputeModel", (Object)this.computeModelAsString()).add("AutonomousVmClusterIds", this.hasAutonomousVmClusterIds() ? this.autonomousVmClusterIds() : null).add("AutonomousVirtualMachineIds", this.hasAutonomousVirtualMachineIds() ? this.autonomousVirtualMachineIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbServerId": {
                return Optional.ofNullable(clazz.cast(this.dbServerId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "cpuCoreCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCount()));
            }
            case "dbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dbNodeStorageSizeInGBs()));
            }
            case "dbServerPatchingDetails": {
                return Optional.ofNullable(clazz.cast(this.dbServerPatchingDetails()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "exadataInfrastructureId": {
                return Optional.ofNullable(clazz.cast(this.exadataInfrastructureId()));
            }
            case "ocid": {
                return Optional.ofNullable(clazz.cast(this.ocid()));
            }
            case "ociResourceAnchorName": {
                return Optional.ofNullable(clazz.cast(this.ociResourceAnchorName()));
            }
            case "maxCpuCount": {
                return Optional.ofNullable(clazz.cast(this.maxCpuCount()));
            }
            case "maxDbNodeStorageInGBs": {
                return Optional.ofNullable(clazz.cast(this.maxDbNodeStorageInGBs()));
            }
            case "maxMemoryInGBs": {
                return Optional.ofNullable(clazz.cast(this.maxMemoryInGBs()));
            }
            case "memorySizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInGBs()));
            }
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shape()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "vmClusterIds": {
                return Optional.ofNullable(clazz.cast(this.vmClusterIds()));
            }
            case "computeModel": {
                return Optional.ofNullable(clazz.cast(this.computeModelAsString()));
            }
            case "autonomousVmClusterIds": {
                return Optional.ofNullable(clazz.cast(this.autonomousVmClusterIds()));
            }
            case "autonomousVirtualMachineIds": {
                return Optional.ofNullable(clazz.cast(this.autonomousVirtualMachineIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbServerId", DB_SERVER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServerPatchingDetails", DB_SERVER_PATCHING_DETAILS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("exadataInfrastructureId", EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("maxCpuCount", MAX_CPU_COUNT_FIELD);
        map.put("maxDbNodeStorageInGBs", MAX_DB_NODE_STORAGE_IN_G_BS_FIELD);
        map.put("maxMemoryInGBs", MAX_MEMORY_IN_G_BS_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("vmClusterIds", VM_CLUSTER_IDS_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        map.put("autonomousVmClusterIds", AUTONOMOUS_VM_CLUSTER_IDS_FIELD);
        map.put("autonomousVirtualMachineIds", AUTONOMOUS_VIRTUAL_MACHINE_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbServerSummary, T> g) {
        return obj -> g.apply((DbServerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbServerId;
        private String status;
        private String statusReason;
        private Integer cpuCoreCount;
        private Integer dbNodeStorageSizeInGBs;
        private DbServerPatchingDetails dbServerPatchingDetails;
        private String displayName;
        private String exadataInfrastructureId;
        private String ocid;
        private String ociResourceAnchorName;
        private Integer maxCpuCount;
        private Integer maxDbNodeStorageInGBs;
        private Integer maxMemoryInGBs;
        private Integer memorySizeInGBs;
        private String shape;
        private Instant createdAt;
        private List<String> vmClusterIds = DefaultSdkAutoConstructList.getInstance();
        private String computeModel;
        private List<String> autonomousVmClusterIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> autonomousVirtualMachineIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DbServerSummary model) {
            this.dbServerId(model.dbServerId);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.cpuCoreCount(model.cpuCoreCount);
            this.dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            this.dbServerPatchingDetails(model.dbServerPatchingDetails);
            this.displayName(model.displayName);
            this.exadataInfrastructureId(model.exadataInfrastructureId);
            this.ocid(model.ocid);
            this.ociResourceAnchorName(model.ociResourceAnchorName);
            this.maxCpuCount(model.maxCpuCount);
            this.maxDbNodeStorageInGBs(model.maxDbNodeStorageInGBs);
            this.maxMemoryInGBs(model.maxMemoryInGBs);
            this.memorySizeInGBs(model.memorySizeInGBs);
            this.shape(model.shape);
            this.createdAt(model.createdAt);
            this.vmClusterIds(model.vmClusterIds);
            this.computeModel(model.computeModel);
            this.autonomousVmClusterIds(model.autonomousVmClusterIds);
            this.autonomousVirtualMachineIds(model.autonomousVirtualMachineIds);
        }

        public final String getDbServerId() {
            return this.dbServerId;
        }

        public final void setDbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
        }

        @Override
        public final Builder dbServerId(String dbServerId) {
            this.dbServerId = dbServerId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final DbServerPatchingDetails.Builder getDbServerPatchingDetails() {
            return this.dbServerPatchingDetails != null ? this.dbServerPatchingDetails.toBuilder() : null;
        }

        public final void setDbServerPatchingDetails(DbServerPatchingDetails.BuilderImpl dbServerPatchingDetails) {
            this.dbServerPatchingDetails = dbServerPatchingDetails != null ? dbServerPatchingDetails.build() : null;
        }

        @Override
        public final Builder dbServerPatchingDetails(DbServerPatchingDetails dbServerPatchingDetails) {
            this.dbServerPatchingDetails = dbServerPatchingDetails;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getExadataInfrastructureId() {
            return this.exadataInfrastructureId;
        }

        public final void setExadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
        }

        @Override
        public final Builder exadataInfrastructureId(String exadataInfrastructureId) {
            this.exadataInfrastructureId = exadataInfrastructureId;
            return this;
        }

        public final String getOcid() {
            return this.ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return this.ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final Integer getMaxCpuCount() {
            return this.maxCpuCount;
        }

        public final void setMaxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
        }

        @Override
        public final Builder maxCpuCount(Integer maxCpuCount) {
            this.maxCpuCount = maxCpuCount;
            return this;
        }

        public final Integer getMaxDbNodeStorageInGBs() {
            return this.maxDbNodeStorageInGBs;
        }

        public final void setMaxDbNodeStorageInGBs(Integer maxDbNodeStorageInGBs) {
            this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
        }

        @Override
        public final Builder maxDbNodeStorageInGBs(Integer maxDbNodeStorageInGBs) {
            this.maxDbNodeStorageInGBs = maxDbNodeStorageInGBs;
            return this;
        }

        public final Integer getMaxMemoryInGBs() {
            return this.maxMemoryInGBs;
        }

        public final void setMaxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
        }

        @Override
        public final Builder maxMemoryInGBs(Integer maxMemoryInGBs) {
            this.maxMemoryInGBs = maxMemoryInGBs;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Collection<String> getVmClusterIds() {
            if (this.vmClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vmClusterIds;
        }

        public final void setVmClusterIds(Collection<String> vmClusterIds) {
            this.vmClusterIds = StringListCopier.copy(vmClusterIds);
        }

        @Override
        public final Builder vmClusterIds(Collection<String> vmClusterIds) {
            this.vmClusterIds = StringListCopier.copy(vmClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vmClusterIds(String ... vmClusterIds) {
            this.vmClusterIds(Arrays.asList(vmClusterIds));
            return this;
        }

        public final String getComputeModel() {
            return this.computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public final Collection<String> getAutonomousVmClusterIds() {
            if (this.autonomousVmClusterIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autonomousVmClusterIds;
        }

        public final void setAutonomousVmClusterIds(Collection<String> autonomousVmClusterIds) {
            this.autonomousVmClusterIds = StringListCopier.copy(autonomousVmClusterIds);
        }

        @Override
        public final Builder autonomousVmClusterIds(Collection<String> autonomousVmClusterIds) {
            this.autonomousVmClusterIds = StringListCopier.copy(autonomousVmClusterIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autonomousVmClusterIds(String ... autonomousVmClusterIds) {
            this.autonomousVmClusterIds(Arrays.asList(autonomousVmClusterIds));
            return this;
        }

        public final Collection<String> getAutonomousVirtualMachineIds() {
            if (this.autonomousVirtualMachineIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.autonomousVirtualMachineIds;
        }

        public final void setAutonomousVirtualMachineIds(Collection<String> autonomousVirtualMachineIds) {
            this.autonomousVirtualMachineIds = StringListCopier.copy(autonomousVirtualMachineIds);
        }

        @Override
        public final Builder autonomousVirtualMachineIds(Collection<String> autonomousVirtualMachineIds) {
            this.autonomousVirtualMachineIds = StringListCopier.copy(autonomousVirtualMachineIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder autonomousVirtualMachineIds(String ... autonomousVirtualMachineIds) {
            this.autonomousVirtualMachineIds(Arrays.asList(autonomousVirtualMachineIds));
            return this;
        }

        public DbServerSummary build() {
            return new DbServerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DbServerSummary> {
        public Builder dbServerId(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder cpuCoreCount(Integer var1);

        public Builder dbNodeStorageSizeInGBs(Integer var1);

        public Builder dbServerPatchingDetails(DbServerPatchingDetails var1);

        default public Builder dbServerPatchingDetails(Consumer<DbServerPatchingDetails.Builder> dbServerPatchingDetails) {
            return this.dbServerPatchingDetails((DbServerPatchingDetails)((DbServerPatchingDetails.Builder)DbServerPatchingDetails.builder().applyMutation(dbServerPatchingDetails)).build());
        }

        public Builder displayName(String var1);

        public Builder exadataInfrastructureId(String var1);

        public Builder ocid(String var1);

        public Builder ociResourceAnchorName(String var1);

        public Builder maxCpuCount(Integer var1);

        public Builder maxDbNodeStorageInGBs(Integer var1);

        public Builder maxMemoryInGBs(Integer var1);

        public Builder memorySizeInGBs(Integer var1);

        public Builder shape(String var1);

        public Builder createdAt(Instant var1);

        public Builder vmClusterIds(Collection<String> var1);

        public Builder vmClusterIds(String ... var1);

        public Builder computeModel(String var1);

        public Builder computeModel(ComputeModel var1);

        public Builder autonomousVmClusterIds(Collection<String> var1);

        public Builder autonomousVmClusterIds(String ... var1);

        public Builder autonomousVirtualMachineIds(Collection<String> var1);

        public Builder autonomousVirtualMachineIds(String ... var1);
    }
}

