/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbAsyncClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksRequest;
import software.amazon.awssdk.services.odb.model.ListOdbNetworksResponse;
import software.amazon.awssdk.services.odb.model.OdbNetworkSummary;

public class ListOdbNetworksPublisher
implements SdkPublisher<ListOdbNetworksResponse> {
    private final OdbAsyncClient client;
    private final ListOdbNetworksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOdbNetworksPublisher(OdbAsyncClient client, ListOdbNetworksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOdbNetworksPublisher(OdbAsyncClient client, ListOdbNetworksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOdbNetworksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOdbNetworksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OdbNetworkSummary> odbNetworks() {
        Function<ListOdbNetworksResponse, Iterator> getIterator = response -> {
            if (response != null && response.odbNetworks() != null) {
                return response.odbNetworks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOdbNetworksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOdbNetworksResponseFetcher
    implements AsyncPageFetcher<ListOdbNetworksResponse> {
        private ListOdbNetworksResponseFetcher() {
        }

        public boolean hasNextPage(ListOdbNetworksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOdbNetworksResponse> nextPage(ListOdbNetworksResponse previousPage) {
            if (previousPage == null) {
                return ListOdbNetworksPublisher.this.client.listOdbNetworks(ListOdbNetworksPublisher.this.firstRequest);
            }
            return ListOdbNetworksPublisher.this.client.listOdbNetworks((ListOdbNetworksRequest)((Object)ListOdbNetworksPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

