/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DbIormConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DbIormConfig> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dbName").getter(DbIormConfig.getter(DbIormConfig::dbName)).setter(DbIormConfig.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbName").build()}).build();
    private static final SdkField<String> FLASH_CACHE_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("flashCacheLimit").getter(DbIormConfig.getter(DbIormConfig::flashCacheLimit)).setter(DbIormConfig.setter(Builder::flashCacheLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("flashCacheLimit").build()}).build();
    private static final SdkField<Integer> SHARE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("share").getter(DbIormConfig.getter(DbIormConfig::share)).setter(DbIormConfig.setter(Builder::share)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("share").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD, FLASH_CACHE_LIMIT_FIELD, SHARE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DbIormConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dbName;
    private final String flashCacheLimit;
    private final Integer share;

    private DbIormConfig(BuilderImpl builder) {
        this.dbName = builder.dbName;
        this.flashCacheLimit = builder.flashCacheLimit;
        this.share = builder.share;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final String flashCacheLimit() {
        return this.flashCacheLimit;
    }

    public final Integer share() {
        return this.share;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.flashCacheLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.share());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbIormConfig)) {
            return false;
        }
        DbIormConfig other = (DbIormConfig)obj;
        return Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.flashCacheLimit(), other.flashCacheLimit()) && Objects.equals(this.share(), other.share());
    }

    public final String toString() {
        return ToString.builder((String)"DbIormConfig").add("DbName", (Object)this.dbName()).add("FlashCacheLimit", (Object)this.flashCacheLimit()).add("Share", (Object)this.share()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dbName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "flashCacheLimit": {
                return Optional.ofNullable(clazz.cast(this.flashCacheLimit()));
            }
            case "share": {
                return Optional.ofNullable(clazz.cast(this.share()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dbName", DB_NAME_FIELD);
        map.put("flashCacheLimit", FLASH_CACHE_LIMIT_FIELD);
        map.put("share", SHARE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbIormConfig, T> g) {
        return obj -> g.apply((DbIormConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dbName;
        private String flashCacheLimit;
        private Integer share;

        private BuilderImpl() {
        }

        private BuilderImpl(DbIormConfig model) {
            this.dbName(model.dbName);
            this.flashCacheLimit(model.flashCacheLimit);
            this.share(model.share);
        }

        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getFlashCacheLimit() {
            return this.flashCacheLimit;
        }

        public final void setFlashCacheLimit(String flashCacheLimit) {
            this.flashCacheLimit = flashCacheLimit;
        }

        @Override
        public final Builder flashCacheLimit(String flashCacheLimit) {
            this.flashCacheLimit = flashCacheLimit;
            return this;
        }

        public final Integer getShare() {
            return this.share;
        }

        public final void setShare(Integer share) {
            this.share = share;
        }

        @Override
        public final Builder share(Integer share) {
            this.share = share;
            return this;
        }

        public DbIormConfig build() {
            return new DbIormConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DbIormConfig> {
        public Builder dbName(String var1);

        public Builder flashCacheLimit(String var1);

        public Builder share(Integer var1);
    }
}

