/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OdbPeeringConnection
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OdbPeeringConnection> {
    private static final SdkField<String> ODB_PEERING_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbPeeringConnectionId").getter(OdbPeeringConnection.getter(OdbPeeringConnection::odbPeeringConnectionId)).setter(OdbPeeringConnection.setter(Builder::odbPeeringConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnectionId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(OdbPeeringConnection.getter(OdbPeeringConnection::displayName)).setter(OdbPeeringConnection.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(OdbPeeringConnection.getter(OdbPeeringConnection::statusAsString)).setter(OdbPeeringConnection.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(OdbPeeringConnection.getter(OdbPeeringConnection::statusReason)).setter(OdbPeeringConnection.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> ODB_PEERING_CONNECTION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbPeeringConnectionArn").getter(OdbPeeringConnection.getter(OdbPeeringConnection::odbPeeringConnectionArn)).setter(OdbPeeringConnection.setter(Builder::odbPeeringConnectionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnectionArn").build()}).build();
    private static final SdkField<String> ODB_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkArn").getter(OdbPeeringConnection.getter(OdbPeeringConnection::odbNetworkArn)).setter(OdbPeeringConnection.setter(Builder::odbNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkArn").build()}).build();
    private static final SdkField<String> PEER_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("peerNetworkArn").getter(OdbPeeringConnection.getter(OdbPeeringConnection::peerNetworkArn)).setter(OdbPeeringConnection.setter(Builder::peerNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peerNetworkArn").build()}).build();
    private static final SdkField<String> ODB_PEERING_CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbPeeringConnectionType").getter(OdbPeeringConnection.getter(OdbPeeringConnection::odbPeeringConnectionType)).setter(OdbPeeringConnection.setter(Builder::odbPeeringConnectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbPeeringConnectionType").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(OdbPeeringConnection.getter(OdbPeeringConnection::createdAt)).setter(OdbPeeringConnection.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("percentProgress").getter(OdbPeeringConnection.getter(OdbPeeringConnection::percentProgress)).setter(OdbPeeringConnection.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_PEERING_CONNECTION_ID_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ODB_PEERING_CONNECTION_ARN_FIELD, ODB_NETWORK_ARN_FIELD, PEER_NETWORK_ARN_FIELD, ODB_PEERING_CONNECTION_TYPE_FIELD, CREATED_AT_FIELD, PERCENT_PROGRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OdbPeeringConnection.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String odbPeeringConnectionId;
    private final String displayName;
    private final String status;
    private final String statusReason;
    private final String odbPeeringConnectionArn;
    private final String odbNetworkArn;
    private final String peerNetworkArn;
    private final String odbPeeringConnectionType;
    private final Instant createdAt;
    private final Float percentProgress;

    private OdbPeeringConnection(BuilderImpl builder) {
        this.odbPeeringConnectionId = builder.odbPeeringConnectionId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.odbPeeringConnectionArn = builder.odbPeeringConnectionArn;
        this.odbNetworkArn = builder.odbNetworkArn;
        this.peerNetworkArn = builder.peerNetworkArn;
        this.odbPeeringConnectionType = builder.odbPeeringConnectionType;
        this.createdAt = builder.createdAt;
        this.percentProgress = builder.percentProgress;
    }

    public final String odbPeeringConnectionId() {
        return this.odbPeeringConnectionId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String odbPeeringConnectionArn() {
        return this.odbPeeringConnectionArn;
    }

    public final String odbNetworkArn() {
        return this.odbNetworkArn;
    }

    public final String peerNetworkArn() {
        return this.peerNetworkArn;
    }

    public final String odbPeeringConnectionType() {
        return this.odbPeeringConnectionType;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Float percentProgress() {
        return this.percentProgress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.odbPeeringConnectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.odbPeeringConnectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.peerNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.odbPeeringConnectionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OdbPeeringConnection)) {
            return false;
        }
        OdbPeeringConnection other = (OdbPeeringConnection)obj;
        return Objects.equals(this.odbPeeringConnectionId(), other.odbPeeringConnectionId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.odbPeeringConnectionArn(), other.odbPeeringConnectionArn()) && Objects.equals(this.odbNetworkArn(), other.odbNetworkArn()) && Objects.equals(this.peerNetworkArn(), other.peerNetworkArn()) && Objects.equals(this.odbPeeringConnectionType(), other.odbPeeringConnectionType()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.percentProgress(), other.percentProgress());
    }

    public final String toString() {
        return ToString.builder((String)"OdbPeeringConnection").add("OdbPeeringConnectionId", (Object)this.odbPeeringConnectionId()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("OdbPeeringConnectionArn", (Object)this.odbPeeringConnectionArn()).add("OdbNetworkArn", (Object)this.odbNetworkArn()).add("PeerNetworkArn", (Object)this.peerNetworkArn()).add("OdbPeeringConnectionType", (Object)this.odbPeeringConnectionType()).add("CreatedAt", (Object)this.createdAt()).add("PercentProgress", (Object)this.percentProgress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "odbPeeringConnectionId": {
                return Optional.ofNullable(clazz.cast(this.odbPeeringConnectionId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "odbPeeringConnectionArn": {
                return Optional.ofNullable(clazz.cast(this.odbPeeringConnectionArn()));
            }
            case "odbNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkArn()));
            }
            case "peerNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.peerNetworkArn()));
            }
            case "odbPeeringConnectionType": {
                return Optional.ofNullable(clazz.cast(this.odbPeeringConnectionType()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "percentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("odbPeeringConnectionId", ODB_PEERING_CONNECTION_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("odbPeeringConnectionArn", ODB_PEERING_CONNECTION_ARN_FIELD);
        map.put("odbNetworkArn", ODB_NETWORK_ARN_FIELD);
        map.put("peerNetworkArn", PEER_NETWORK_ARN_FIELD);
        map.put("odbPeeringConnectionType", ODB_PEERING_CONNECTION_TYPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OdbPeeringConnection, T> g) {
        return obj -> g.apply((OdbPeeringConnection)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String odbPeeringConnectionId;
        private String displayName;
        private String status;
        private String statusReason;
        private String odbPeeringConnectionArn;
        private String odbNetworkArn;
        private String peerNetworkArn;
        private String odbPeeringConnectionType;
        private Instant createdAt;
        private Float percentProgress;

        private BuilderImpl() {
        }

        private BuilderImpl(OdbPeeringConnection model) {
            this.odbPeeringConnectionId(model.odbPeeringConnectionId);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.odbPeeringConnectionArn(model.odbPeeringConnectionArn);
            this.odbNetworkArn(model.odbNetworkArn);
            this.peerNetworkArn(model.peerNetworkArn);
            this.odbPeeringConnectionType(model.odbPeeringConnectionType);
            this.createdAt(model.createdAt);
            this.percentProgress(model.percentProgress);
        }

        public final String getOdbPeeringConnectionId() {
            return this.odbPeeringConnectionId;
        }

        public final void setOdbPeeringConnectionId(String odbPeeringConnectionId) {
            this.odbPeeringConnectionId = odbPeeringConnectionId;
        }

        @Override
        public final Builder odbPeeringConnectionId(String odbPeeringConnectionId) {
            this.odbPeeringConnectionId = odbPeeringConnectionId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOdbPeeringConnectionArn() {
            return this.odbPeeringConnectionArn;
        }

        public final void setOdbPeeringConnectionArn(String odbPeeringConnectionArn) {
            this.odbPeeringConnectionArn = odbPeeringConnectionArn;
        }

        @Override
        public final Builder odbPeeringConnectionArn(String odbPeeringConnectionArn) {
            this.odbPeeringConnectionArn = odbPeeringConnectionArn;
            return this;
        }

        public final String getOdbNetworkArn() {
            return this.odbNetworkArn;
        }

        public final void setOdbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
        }

        @Override
        public final Builder odbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
            return this;
        }

        public final String getPeerNetworkArn() {
            return this.peerNetworkArn;
        }

        public final void setPeerNetworkArn(String peerNetworkArn) {
            this.peerNetworkArn = peerNetworkArn;
        }

        @Override
        public final Builder peerNetworkArn(String peerNetworkArn) {
            this.peerNetworkArn = peerNetworkArn;
            return this;
        }

        public final String getOdbPeeringConnectionType() {
            return this.odbPeeringConnectionType;
        }

        public final void setOdbPeeringConnectionType(String odbPeeringConnectionType) {
            this.odbPeeringConnectionType = odbPeeringConnectionType;
        }

        @Override
        public final Builder odbPeeringConnectionType(String odbPeeringConnectionType) {
            this.odbPeeringConnectionType = odbPeeringConnectionType;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Float getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public OdbPeeringConnection build() {
            return new OdbPeeringConnection(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OdbPeeringConnection> {
        public Builder odbPeeringConnectionId(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder odbPeeringConnectionArn(String var1);

        public Builder odbNetworkArn(String var1);

        public Builder peerNetworkArn(String var1);

        public Builder odbPeeringConnectionType(String var1);

        public Builder createdAt(Instant var1);

        public Builder percentProgress(Float var1);
    }
}

