/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The managed services configuration for the ODB network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ManagedServices implements SdkPojo, Serializable, ToCopyableBuilder<ManagedServices.Builder, ManagedServices> {
    private static final SdkField<String> SERVICE_NETWORK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceNetworkArn").getter(getter(ManagedServices::serviceNetworkArn))
            .setter(setter(Builder::serviceNetworkArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkArn").build()).build();

    private static final SdkField<String> RESOURCE_GATEWAY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceGatewayArn").getter(getter(ManagedServices::resourceGatewayArn))
            .setter(setter(Builder::resourceGatewayArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceGatewayArn").build())
            .build();

    private static final SdkField<List<String>> MANAGED_SERVICES_IPV4_CIDRS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("managedServicesIpv4Cidrs")
            .getter(getter(ManagedServices::managedServicesIpv4Cidrs))
            .setter(setter(Builder::managedServicesIpv4Cidrs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedServicesIpv4Cidrs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceNetworkEndpoint> SERVICE_NETWORK_ENDPOINT_FIELD = SdkField
            .<ServiceNetworkEndpoint> builder(MarshallingType.SDK_POJO).memberName("serviceNetworkEndpoint")
            .getter(getter(ManagedServices::serviceNetworkEndpoint)).setter(setter(Builder::serviceNetworkEndpoint))
            .constructor(ServiceNetworkEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceNetworkEndpoint").build())
            .build();

    private static final SdkField<ManagedS3BackupAccess> MANAGED_S3_BACKUP_ACCESS_FIELD = SdkField
            .<ManagedS3BackupAccess> builder(MarshallingType.SDK_POJO).memberName("managedS3BackupAccess")
            .getter(getter(ManagedServices::managedS3BackupAccess)).setter(setter(Builder::managedS3BackupAccess))
            .constructor(ManagedS3BackupAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedS3BackupAccess").build())
            .build();

    private static final SdkField<ZeroEtlAccess> ZERO_ETL_ACCESS_FIELD = SdkField
            .<ZeroEtlAccess> builder(MarshallingType.SDK_POJO).memberName("zeroEtlAccess")
            .getter(getter(ManagedServices::zeroEtlAccess)).setter(setter(Builder::zeroEtlAccess))
            .constructor(ZeroEtlAccess::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zeroEtlAccess").build()).build();

    private static final SdkField<S3Access> S3_ACCESS_FIELD = SdkField.<S3Access> builder(MarshallingType.SDK_POJO)
            .memberName("s3Access").getter(getter(ManagedServices::s3Access)).setter(setter(Builder::s3Access))
            .constructor(S3Access::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NETWORK_ARN_FIELD,
            RESOURCE_GATEWAY_ARN_FIELD, MANAGED_SERVICES_IPV4_CIDRS_FIELD, SERVICE_NETWORK_ENDPOINT_FIELD,
            MANAGED_S3_BACKUP_ACCESS_FIELD, ZERO_ETL_ACCESS_FIELD, S3_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String serviceNetworkArn;

    private final String resourceGatewayArn;

    private final List<String> managedServicesIpv4Cidrs;

    private final ServiceNetworkEndpoint serviceNetworkEndpoint;

    private final ManagedS3BackupAccess managedS3BackupAccess;

    private final ZeroEtlAccess zeroEtlAccess;

    private final S3Access s3Access;

    private ManagedServices(BuilderImpl builder) {
        this.serviceNetworkArn = builder.serviceNetworkArn;
        this.resourceGatewayArn = builder.resourceGatewayArn;
        this.managedServicesIpv4Cidrs = builder.managedServicesIpv4Cidrs;
        this.serviceNetworkEndpoint = builder.serviceNetworkEndpoint;
        this.managedS3BackupAccess = builder.managedS3BackupAccess;
        this.zeroEtlAccess = builder.zeroEtlAccess;
        this.s3Access = builder.s3Access;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the service network.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the service network.
     */
    public final String serviceNetworkArn() {
        return serviceNetworkArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource gateway.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource gateway.
     */
    public final String resourceGatewayArn() {
        return resourceGatewayArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the ManagedServicesIpv4Cidrs property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasManagedServicesIpv4Cidrs() {
        return managedServicesIpv4Cidrs != null && !(managedServicesIpv4Cidrs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IPv4 CIDR blocks for the managed services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManagedServicesIpv4Cidrs} method.
     * </p>
     * 
     * @return The IPv4 CIDR blocks for the managed services.
     */
    public final List<String> managedServicesIpv4Cidrs() {
        return managedServicesIpv4Cidrs;
    }

    /**
     * <p>
     * The service network endpoint configuration.
     * </p>
     * 
     * @return The service network endpoint configuration.
     */
    public final ServiceNetworkEndpoint serviceNetworkEndpoint() {
        return serviceNetworkEndpoint;
    }

    /**
     * <p>
     * The managed Amazon S3 backup access configuration.
     * </p>
     * 
     * @return The managed Amazon S3 backup access configuration.
     */
    public final ManagedS3BackupAccess managedS3BackupAccess() {
        return managedS3BackupAccess;
    }

    /**
     * <p>
     * The Zero-ETL access configuration.
     * </p>
     * 
     * @return The Zero-ETL access configuration.
     */
    public final ZeroEtlAccess zeroEtlAccess() {
        return zeroEtlAccess;
    }

    /**
     * <p>
     * The Amazon S3 access configuration.
     * </p>
     * 
     * @return The Amazon S3 access configuration.
     */
    public final S3Access s3Access() {
        return s3Access;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceGatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasManagedServicesIpv4Cidrs() ? managedServicesIpv4Cidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceNetworkEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(managedS3BackupAccess());
        hashCode = 31 * hashCode + Objects.hashCode(zeroEtlAccess());
        hashCode = 31 * hashCode + Objects.hashCode(s3Access());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManagedServices)) {
            return false;
        }
        ManagedServices other = (ManagedServices) obj;
        return Objects.equals(serviceNetworkArn(), other.serviceNetworkArn())
                && Objects.equals(resourceGatewayArn(), other.resourceGatewayArn())
                && hasManagedServicesIpv4Cidrs() == other.hasManagedServicesIpv4Cidrs()
                && Objects.equals(managedServicesIpv4Cidrs(), other.managedServicesIpv4Cidrs())
                && Objects.equals(serviceNetworkEndpoint(), other.serviceNetworkEndpoint())
                && Objects.equals(managedS3BackupAccess(), other.managedS3BackupAccess())
                && Objects.equals(zeroEtlAccess(), other.zeroEtlAccess()) && Objects.equals(s3Access(), other.s3Access());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ManagedServices").add("ServiceNetworkArn", serviceNetworkArn())
                .add("ResourceGatewayArn", resourceGatewayArn())
                .add("ManagedServicesIpv4Cidrs", hasManagedServicesIpv4Cidrs() ? managedServicesIpv4Cidrs() : null)
                .add("ServiceNetworkEndpoint", serviceNetworkEndpoint()).add("ManagedS3BackupAccess", managedS3BackupAccess())
                .add("ZeroEtlAccess", zeroEtlAccess()).add("S3Access", s3Access()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "serviceNetworkArn":
            return Optional.ofNullable(clazz.cast(serviceNetworkArn()));
        case "resourceGatewayArn":
            return Optional.ofNullable(clazz.cast(resourceGatewayArn()));
        case "managedServicesIpv4Cidrs":
            return Optional.ofNullable(clazz.cast(managedServicesIpv4Cidrs()));
        case "serviceNetworkEndpoint":
            return Optional.ofNullable(clazz.cast(serviceNetworkEndpoint()));
        case "managedS3BackupAccess":
            return Optional.ofNullable(clazz.cast(managedS3BackupAccess()));
        case "zeroEtlAccess":
            return Optional.ofNullable(clazz.cast(zeroEtlAccess()));
        case "s3Access":
            return Optional.ofNullable(clazz.cast(s3Access()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("serviceNetworkArn", SERVICE_NETWORK_ARN_FIELD);
        map.put("resourceGatewayArn", RESOURCE_GATEWAY_ARN_FIELD);
        map.put("managedServicesIpv4Cidrs", MANAGED_SERVICES_IPV4_CIDRS_FIELD);
        map.put("serviceNetworkEndpoint", SERVICE_NETWORK_ENDPOINT_FIELD);
        map.put("managedS3BackupAccess", MANAGED_S3_BACKUP_ACCESS_FIELD);
        map.put("zeroEtlAccess", ZERO_ETL_ACCESS_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ManagedServices, T> g) {
        return obj -> g.apply((ManagedServices) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ManagedServices> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the service network.
         * </p>
         * 
         * @param serviceNetworkArn
         *        The Amazon Resource Name (ARN) of the service network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkArn(String serviceNetworkArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource gateway.
         * </p>
         * 
         * @param resourceGatewayArn
         *        The Amazon Resource Name (ARN) of the resource gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceGatewayArn(String resourceGatewayArn);

        /**
         * <p>
         * The IPv4 CIDR blocks for the managed services.
         * </p>
         * 
         * @param managedServicesIpv4Cidrs
         *        The IPv4 CIDR blocks for the managed services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedServicesIpv4Cidrs(Collection<String> managedServicesIpv4Cidrs);

        /**
         * <p>
         * The IPv4 CIDR blocks for the managed services.
         * </p>
         * 
         * @param managedServicesIpv4Cidrs
         *        The IPv4 CIDR blocks for the managed services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedServicesIpv4Cidrs(String... managedServicesIpv4Cidrs);

        /**
         * <p>
         * The service network endpoint configuration.
         * </p>
         * 
         * @param serviceNetworkEndpoint
         *        The service network endpoint configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceNetworkEndpoint(ServiceNetworkEndpoint serviceNetworkEndpoint);

        /**
         * <p>
         * The service network endpoint configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceNetworkEndpoint.Builder} avoiding
         * the need to create one manually via {@link ServiceNetworkEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceNetworkEndpoint.Builder#build()} is called immediately and
         * its result is passed to {@link #serviceNetworkEndpoint(ServiceNetworkEndpoint)}.
         * 
         * @param serviceNetworkEndpoint
         *        a consumer that will call methods on {@link ServiceNetworkEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceNetworkEndpoint(ServiceNetworkEndpoint)
         */
        default Builder serviceNetworkEndpoint(Consumer<ServiceNetworkEndpoint.Builder> serviceNetworkEndpoint) {
            return serviceNetworkEndpoint(ServiceNetworkEndpoint.builder().applyMutation(serviceNetworkEndpoint).build());
        }

        /**
         * <p>
         * The managed Amazon S3 backup access configuration.
         * </p>
         * 
         * @param managedS3BackupAccess
         *        The managed Amazon S3 backup access configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder managedS3BackupAccess(ManagedS3BackupAccess managedS3BackupAccess);

        /**
         * <p>
         * The managed Amazon S3 backup access configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ManagedS3BackupAccess.Builder} avoiding
         * the need to create one manually via {@link ManagedS3BackupAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ManagedS3BackupAccess.Builder#build()} is called immediately and
         * its result is passed to {@link #managedS3BackupAccess(ManagedS3BackupAccess)}.
         * 
         * @param managedS3BackupAccess
         *        a consumer that will call methods on {@link ManagedS3BackupAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #managedS3BackupAccess(ManagedS3BackupAccess)
         */
        default Builder managedS3BackupAccess(Consumer<ManagedS3BackupAccess.Builder> managedS3BackupAccess) {
            return managedS3BackupAccess(ManagedS3BackupAccess.builder().applyMutation(managedS3BackupAccess).build());
        }

        /**
         * <p>
         * The Zero-ETL access configuration.
         * </p>
         * 
         * @param zeroEtlAccess
         *        The Zero-ETL access configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zeroEtlAccess(ZeroEtlAccess zeroEtlAccess);

        /**
         * <p>
         * The Zero-ETL access configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link ZeroEtlAccess.Builder} avoiding the need
         * to create one manually via {@link ZeroEtlAccess#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ZeroEtlAccess.Builder#build()} is called immediately and its
         * result is passed to {@link #zeroEtlAccess(ZeroEtlAccess)}.
         * 
         * @param zeroEtlAccess
         *        a consumer that will call methods on {@link ZeroEtlAccess.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #zeroEtlAccess(ZeroEtlAccess)
         */
        default Builder zeroEtlAccess(Consumer<ZeroEtlAccess.Builder> zeroEtlAccess) {
            return zeroEtlAccess(ZeroEtlAccess.builder().applyMutation(zeroEtlAccess).build());
        }

        /**
         * <p>
         * The Amazon S3 access configuration.
         * </p>
         * 
         * @param s3Access
         *        The Amazon S3 access configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Access(S3Access s3Access);

        /**
         * <p>
         * The Amazon S3 access configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Access.Builder} avoiding the need to
         * create one manually via {@link S3Access#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Access.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Access(S3Access)}.
         * 
         * @param s3Access
         *        a consumer that will call methods on {@link S3Access.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Access(S3Access)
         */
        default Builder s3Access(Consumer<S3Access.Builder> s3Access) {
            return s3Access(S3Access.builder().applyMutation(s3Access).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceNetworkArn;

        private String resourceGatewayArn;

        private List<String> managedServicesIpv4Cidrs = DefaultSdkAutoConstructList.getInstance();

        private ServiceNetworkEndpoint serviceNetworkEndpoint;

        private ManagedS3BackupAccess managedS3BackupAccess;

        private ZeroEtlAccess zeroEtlAccess;

        private S3Access s3Access;

        private BuilderImpl() {
        }

        private BuilderImpl(ManagedServices model) {
            serviceNetworkArn(model.serviceNetworkArn);
            resourceGatewayArn(model.resourceGatewayArn);
            managedServicesIpv4Cidrs(model.managedServicesIpv4Cidrs);
            serviceNetworkEndpoint(model.serviceNetworkEndpoint);
            managedS3BackupAccess(model.managedS3BackupAccess);
            zeroEtlAccess(model.zeroEtlAccess);
            s3Access(model.s3Access);
        }

        public final String getServiceNetworkArn() {
            return serviceNetworkArn;
        }

        public final void setServiceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
        }

        @Override
        public final Builder serviceNetworkArn(String serviceNetworkArn) {
            this.serviceNetworkArn = serviceNetworkArn;
            return this;
        }

        public final String getResourceGatewayArn() {
            return resourceGatewayArn;
        }

        public final void setResourceGatewayArn(String resourceGatewayArn) {
            this.resourceGatewayArn = resourceGatewayArn;
        }

        @Override
        public final Builder resourceGatewayArn(String resourceGatewayArn) {
            this.resourceGatewayArn = resourceGatewayArn;
            return this;
        }

        public final Collection<String> getManagedServicesIpv4Cidrs() {
            if (managedServicesIpv4Cidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return managedServicesIpv4Cidrs;
        }

        public final void setManagedServicesIpv4Cidrs(Collection<String> managedServicesIpv4Cidrs) {
            this.managedServicesIpv4Cidrs = StringListCopier.copy(managedServicesIpv4Cidrs);
        }

        @Override
        public final Builder managedServicesIpv4Cidrs(Collection<String> managedServicesIpv4Cidrs) {
            this.managedServicesIpv4Cidrs = StringListCopier.copy(managedServicesIpv4Cidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedServicesIpv4Cidrs(String... managedServicesIpv4Cidrs) {
            managedServicesIpv4Cidrs(Arrays.asList(managedServicesIpv4Cidrs));
            return this;
        }

        public final ServiceNetworkEndpoint.Builder getServiceNetworkEndpoint() {
            return serviceNetworkEndpoint != null ? serviceNetworkEndpoint.toBuilder() : null;
        }

        public final void setServiceNetworkEndpoint(ServiceNetworkEndpoint.BuilderImpl serviceNetworkEndpoint) {
            this.serviceNetworkEndpoint = serviceNetworkEndpoint != null ? serviceNetworkEndpoint.build() : null;
        }

        @Override
        public final Builder serviceNetworkEndpoint(ServiceNetworkEndpoint serviceNetworkEndpoint) {
            this.serviceNetworkEndpoint = serviceNetworkEndpoint;
            return this;
        }

        public final ManagedS3BackupAccess.Builder getManagedS3BackupAccess() {
            return managedS3BackupAccess != null ? managedS3BackupAccess.toBuilder() : null;
        }

        public final void setManagedS3BackupAccess(ManagedS3BackupAccess.BuilderImpl managedS3BackupAccess) {
            this.managedS3BackupAccess = managedS3BackupAccess != null ? managedS3BackupAccess.build() : null;
        }

        @Override
        public final Builder managedS3BackupAccess(ManagedS3BackupAccess managedS3BackupAccess) {
            this.managedS3BackupAccess = managedS3BackupAccess;
            return this;
        }

        public final ZeroEtlAccess.Builder getZeroEtlAccess() {
            return zeroEtlAccess != null ? zeroEtlAccess.toBuilder() : null;
        }

        public final void setZeroEtlAccess(ZeroEtlAccess.BuilderImpl zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess != null ? zeroEtlAccess.build() : null;
        }

        @Override
        public final Builder zeroEtlAccess(ZeroEtlAccess zeroEtlAccess) {
            this.zeroEtlAccess = zeroEtlAccess;
            return this;
        }

        public final S3Access.Builder getS3Access() {
            return s3Access != null ? s3Access.toBuilder() : null;
        }

        public final void setS3Access(S3Access.BuilderImpl s3Access) {
            this.s3Access = s3Access != null ? s3Access.build() : null;
        }

        @Override
        public final Builder s3Access(S3Access s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        @Override
        public ManagedServices build() {
            return new ManagedServices(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
