/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCloudExadataInfrastructureUnallocatedResourcesResponse extends OdbResponse
        implements
        ToCopyableBuilder<GetCloudExadataInfrastructureUnallocatedResourcesResponse.Builder, GetCloudExadataInfrastructureUnallocatedResourcesResponse> {
    private static final SdkField<CloudExadataInfrastructureUnallocatedResources> CLOUD_EXADATA_INFRASTRUCTURE_UNALLOCATED_RESOURCES_FIELD = SdkField
            .<CloudExadataInfrastructureUnallocatedResources> builder(MarshallingType.SDK_POJO)
            .memberName("cloudExadataInfrastructureUnallocatedResources")
            .getter(getter(GetCloudExadataInfrastructureUnallocatedResourcesResponse::cloudExadataInfrastructureUnallocatedResources))
            .setter(setter(Builder::cloudExadataInfrastructureUnallocatedResources))
            .constructor(CloudExadataInfrastructureUnallocatedResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("cloudExadataInfrastructureUnallocatedResources").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CLOUD_EXADATA_INFRASTRUCTURE_UNALLOCATED_RESOURCES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final CloudExadataInfrastructureUnallocatedResources cloudExadataInfrastructureUnallocatedResources;

    private GetCloudExadataInfrastructureUnallocatedResourcesResponse(BuilderImpl builder) {
        super(builder);
        this.cloudExadataInfrastructureUnallocatedResources = builder.cloudExadataInfrastructureUnallocatedResources;
    }

    /**
     * <p>
     * Details about the unallocated resources in the specified Cloud Exadata infrastructure.
     * </p>
     * 
     * @return Details about the unallocated resources in the specified Cloud Exadata infrastructure.
     */
    public final CloudExadataInfrastructureUnallocatedResources cloudExadataInfrastructureUnallocatedResources() {
        return cloudExadataInfrastructureUnallocatedResources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureUnallocatedResources());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCloudExadataInfrastructureUnallocatedResourcesResponse)) {
            return false;
        }
        GetCloudExadataInfrastructureUnallocatedResourcesResponse other = (GetCloudExadataInfrastructureUnallocatedResourcesResponse) obj;
        return Objects.equals(cloudExadataInfrastructureUnallocatedResources(),
                other.cloudExadataInfrastructureUnallocatedResources());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCloudExadataInfrastructureUnallocatedResourcesResponse")
                .add("CloudExadataInfrastructureUnallocatedResources", cloudExadataInfrastructureUnallocatedResources()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudExadataInfrastructureUnallocatedResources":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureUnallocatedResources()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudExadataInfrastructureUnallocatedResources", CLOUD_EXADATA_INFRASTRUCTURE_UNALLOCATED_RESOURCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCloudExadataInfrastructureUnallocatedResourcesResponse, T> g) {
        return obj -> g.apply((GetCloudExadataInfrastructureUnallocatedResourcesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCloudExadataInfrastructureUnallocatedResourcesResponse> {
        /**
         * <p>
         * Details about the unallocated resources in the specified Cloud Exadata infrastructure.
         * </p>
         * 
         * @param cloudExadataInfrastructureUnallocatedResources
         *        Details about the unallocated resources in the specified Cloud Exadata infrastructure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureUnallocatedResources(
                CloudExadataInfrastructureUnallocatedResources cloudExadataInfrastructureUnallocatedResources);

        /**
         * <p>
         * Details about the unallocated resources in the specified Cloud Exadata infrastructure.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CloudExadataInfrastructureUnallocatedResources.Builder} avoiding the need to create one manually via
         * {@link CloudExadataInfrastructureUnallocatedResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudExadataInfrastructureUnallocatedResources.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #cloudExadataInfrastructureUnallocatedResources(CloudExadataInfrastructureUnallocatedResources)}.
         * 
         * @param cloudExadataInfrastructureUnallocatedResources
         *        a consumer that will call methods on {@link CloudExadataInfrastructureUnallocatedResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudExadataInfrastructureUnallocatedResources(CloudExadataInfrastructureUnallocatedResources)
         */
        default Builder cloudExadataInfrastructureUnallocatedResources(
                Consumer<CloudExadataInfrastructureUnallocatedResources.Builder> cloudExadataInfrastructureUnallocatedResources) {
            return cloudExadataInfrastructureUnallocatedResources(CloudExadataInfrastructureUnallocatedResources.builder()
                    .applyMutation(cloudExadataInfrastructureUnallocatedResources).build());
        }
    }

    static final class BuilderImpl extends OdbResponse.BuilderImpl implements Builder {
        private CloudExadataInfrastructureUnallocatedResources cloudExadataInfrastructureUnallocatedResources;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCloudExadataInfrastructureUnallocatedResourcesResponse model) {
            super(model);
            cloudExadataInfrastructureUnallocatedResources(model.cloudExadataInfrastructureUnallocatedResources);
        }

        public final CloudExadataInfrastructureUnallocatedResources.Builder getCloudExadataInfrastructureUnallocatedResources() {
            return cloudExadataInfrastructureUnallocatedResources != null ? cloudExadataInfrastructureUnallocatedResources
                    .toBuilder() : null;
        }

        public final void setCloudExadataInfrastructureUnallocatedResources(
                CloudExadataInfrastructureUnallocatedResources.BuilderImpl cloudExadataInfrastructureUnallocatedResources) {
            this.cloudExadataInfrastructureUnallocatedResources = cloudExadataInfrastructureUnallocatedResources != null ? cloudExadataInfrastructureUnallocatedResources
                    .build() : null;
        }

        @Override
        public final Builder cloudExadataInfrastructureUnallocatedResources(
                CloudExadataInfrastructureUnallocatedResources cloudExadataInfrastructureUnallocatedResources) {
            this.cloudExadataInfrastructureUnallocatedResources = cloudExadataInfrastructureUnallocatedResources;
            return this;
        }

        @Override
        public GetCloudExadataInfrastructureUnallocatedResourcesResponse build() {
            return new GetCloudExadataInfrastructureUnallocatedResourcesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
