/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudAutonomousVmClusterRequest extends OdbRequest implements
        ToCopyableBuilder<CreateCloudAutonomousVmClusterRequest.Builder, CreateCloudAutonomousVmClusterRequest> {
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("cloudExadataInfrastructureId")
            .getter(getter(CreateCloudAutonomousVmClusterRequest::cloudExadataInfrastructureId))
            .setter(setter(Builder::cloudExadataInfrastructureId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId")
                    .build()).build();

    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("odbNetworkId").getter(getter(CreateCloudAutonomousVmClusterRequest::odbNetworkId))
            .setter(setter(Builder::odbNetworkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateCloudAutonomousVmClusterRequest::displayName))
            .setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateCloudAutonomousVmClusterRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Double> AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .memberName("autonomousDataStorageSizeInTBs")
            .getter(getter(CreateCloudAutonomousVmClusterRequest::autonomousDataStorageSizeInTBs))
            .setter(setter(Builder::autonomousDataStorageSizeInTBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousDataStorageSizeInTBs")
                    .build()).build();

    private static final SdkField<Integer> CPU_CORE_COUNT_PER_NODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("cpuCoreCountPerNode").getter(getter(CreateCloudAutonomousVmClusterRequest::cpuCoreCountPerNode))
            .setter(setter(Builder::cpuCoreCountPerNode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCountPerNode").build())
            .build();

    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dbServers")
            .getter(getter(CreateCloudAutonomousVmClusterRequest::dbServers))
            .setter(setter(Builder::dbServers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCloudAutonomousVmClusterRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Boolean> IS_MTLS_ENABLED_VM_CLUSTER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isMtlsEnabledVmCluster").getter(getter(CreateCloudAutonomousVmClusterRequest::isMtlsEnabledVmCluster))
            .setter(setter(Builder::isMtlsEnabledVmCluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMtlsEnabledVmCluster").build())
            .build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseModel").getter(getter(CreateCloudAutonomousVmClusterRequest::licenseModelAsString))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()).build();

    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField
            .<MaintenanceWindow> builder(MarshallingType.SDK_POJO).memberName("maintenanceWindow")
            .getter(getter(CreateCloudAutonomousVmClusterRequest::maintenanceWindow)).setter(setter(Builder::maintenanceWindow))
            .constructor(MaintenanceWindow::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()).build();

    private static final SdkField<Integer> MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("memoryPerOracleComputeUnitInGBs")
            .getter(getter(CreateCloudAutonomousVmClusterRequest::memoryPerOracleComputeUnitInGBs))
            .setter(setter(Builder::memoryPerOracleComputeUnitInGBs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryPerOracleComputeUnitInGBs")
                    .build()).build();

    private static final SdkField<Integer> SCAN_LISTENER_PORT_NON_TLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scanListenerPortNonTls").getter(getter(CreateCloudAutonomousVmClusterRequest::scanListenerPortNonTls))
            .setter(setter(Builder::scanListenerPortNonTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortNonTls").build())
            .build();

    private static final SdkField<Integer> SCAN_LISTENER_PORT_TLS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("scanListenerPortTls").getter(getter(CreateCloudAutonomousVmClusterRequest::scanListenerPortTls))
            .setter(setter(Builder::scanListenerPortTls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortTls").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateCloudAutonomousVmClusterRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timeZone").getter(getter(CreateCloudAutonomousVmClusterRequest::timeZone))
            .setter(setter(Builder::timeZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()).build();

    private static final SdkField<Integer> TOTAL_CONTAINER_DATABASES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("totalContainerDatabases").getter(getter(CreateCloudAutonomousVmClusterRequest::totalContainerDatabases))
            .setter(setter(Builder::totalContainerDatabases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalContainerDatabases").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, ODB_NETWORK_ID_FIELD, DISPLAY_NAME_FIELD, CLIENT_TOKEN_FIELD,
            AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD, CPU_CORE_COUNT_PER_NODE_FIELD, DB_SERVERS_FIELD, DESCRIPTION_FIELD,
            IS_MTLS_ENABLED_VM_CLUSTER_FIELD, LICENSE_MODEL_FIELD, MAINTENANCE_WINDOW_FIELD,
            MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD, SCAN_LISTENER_PORT_NON_TLS_FIELD, SCAN_LISTENER_PORT_TLS_FIELD,
            TAGS_FIELD, TIME_ZONE_FIELD, TOTAL_CONTAINER_DATABASES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cloudExadataInfrastructureId;

    private final String odbNetworkId;

    private final String displayName;

    private final String clientToken;

    private final Double autonomousDataStorageSizeInTBs;

    private final Integer cpuCoreCountPerNode;

    private final List<String> dbServers;

    private final String description;

    private final Boolean isMtlsEnabledVmCluster;

    private final String licenseModel;

    private final MaintenanceWindow maintenanceWindow;

    private final Integer memoryPerOracleComputeUnitInGBs;

    private final Integer scanListenerPortNonTls;

    private final Integer scanListenerPortTls;

    private final Map<String, String> tags;

    private final String timeZone;

    private final Integer totalContainerDatabases;

    private CreateCloudAutonomousVmClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.odbNetworkId = builder.odbNetworkId;
        this.displayName = builder.displayName;
        this.clientToken = builder.clientToken;
        this.autonomousDataStorageSizeInTBs = builder.autonomousDataStorageSizeInTBs;
        this.cpuCoreCountPerNode = builder.cpuCoreCountPerNode;
        this.dbServers = builder.dbServers;
        this.description = builder.description;
        this.isMtlsEnabledVmCluster = builder.isMtlsEnabledVmCluster;
        this.licenseModel = builder.licenseModel;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.memoryPerOracleComputeUnitInGBs = builder.memoryPerOracleComputeUnitInGBs;
        this.scanListenerPortNonTls = builder.scanListenerPortNonTls;
        this.scanListenerPortTls = builder.scanListenerPortTls;
        this.tags = builder.tags;
        this.timeZone = builder.timeZone;
        this.totalContainerDatabases = builder.totalContainerDatabases;
    }

    /**
     * <p>
     * The unique identifier of the Exadata infrastructure where the VM cluster will be created.
     * </p>
     * 
     * @return The unique identifier of the Exadata infrastructure where the VM cluster will be created.
     */
    public final String cloudExadataInfrastructureId() {
        return cloudExadataInfrastructureId;
    }

    /**
     * <p>
     * The unique identifier of the ODB network to be used for the VM cluster.
     * </p>
     * 
     * @return The unique identifier of the ODB network to be used for the VM cluster.
     */
    public final String odbNetworkId() {
        return odbNetworkId;
    }

    /**
     * <p>
     * The display name for the Autonomous VM cluster. The name does not need to be unique.
     * </p>
     * 
     * @return The display name for the Autonomous VM cluster. The name does not need to be unique.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * A client-provided token to ensure idempotency of the request.
     * </p>
     * 
     * @return A client-provided token to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The data disk group size to be allocated for Autonomous Databases, in terabytes (TB).
     * </p>
     * 
     * @return The data disk group size to be allocated for Autonomous Databases, in terabytes (TB).
     */
    public final Double autonomousDataStorageSizeInTBs() {
        return autonomousDataStorageSizeInTBs;
    }

    /**
     * <p>
     * The number of CPU cores to be enabled per VM cluster node.
     * </p>
     * 
     * @return The number of CPU cores to be enabled per VM cluster node.
     */
    public final Integer cpuCoreCountPerNode() {
        return cpuCoreCountPerNode;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbServers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDbServers() {
        return dbServers != null && !(dbServers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of database servers to be used for the Autonomous VM cluster.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbServers} method.
     * </p>
     * 
     * @return The list of database servers to be used for the Autonomous VM cluster.
     */
    public final List<String> dbServers() {
        return dbServers;
    }

    /**
     * <p>
     * A user-provided description of the Autonomous VM cluster.
     * </p>
     * 
     * @return A user-provided description of the Autonomous VM cluster.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Specifies whether to enable mutual TLS (mTLS) authentication for the Autonomous VM cluster.
     * </p>
     * 
     * @return Specifies whether to enable mutual TLS (mTLS) authentication for the Autonomous VM cluster.
     */
    public final Boolean isMtlsEnabledVmCluster() {
        return isMtlsEnabledVmCluster;
    }

    /**
     * <p>
     * The Oracle license model to apply to the Autonomous VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model to apply to the Autonomous VM cluster.
     * @see LicenseModel
     */
    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(licenseModel);
    }

    /**
     * <p>
     * The Oracle license model to apply to the Autonomous VM cluster.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #licenseModel} will
     * return {@link LicenseModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #licenseModelAsString}.
     * </p>
     * 
     * @return The Oracle license model to apply to the Autonomous VM cluster.
     * @see LicenseModel
     */
    public final String licenseModelAsString() {
        return licenseModel;
    }

    /**
     * <p>
     * The scheduling details for the maintenance window. Patching and system updates take place during the maintenance
     * window.
     * </p>
     * 
     * @return The scheduling details for the maintenance window. Patching and system updates take place during the
     *         maintenance window.
     */
    public final MaintenanceWindow maintenanceWindow() {
        return maintenanceWindow;
    }

    /**
     * <p>
     * The amount of memory to be allocated per OCPU, in GB.
     * </p>
     * 
     * @return The amount of memory to be allocated per OCPU, in GB.
     */
    public final Integer memoryPerOracleComputeUnitInGBs() {
        return memoryPerOracleComputeUnitInGBs;
    }

    /**
     * <p>
     * The SCAN listener port for non-TLS (TCP) protocol.
     * </p>
     * 
     * @return The SCAN listener port for non-TLS (TCP) protocol.
     */
    public final Integer scanListenerPortNonTls() {
        return scanListenerPortNonTls;
    }

    /**
     * <p>
     * The SCAN listener port for TLS (TCP) protocol.
     * </p>
     * 
     * @return The SCAN listener port for TLS (TCP) protocol.
     */
    public final Integer scanListenerPortTls() {
        return scanListenerPortTls;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or
     *         namespace.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The time zone to use for the Autonomous VM cluster.
     * </p>
     * 
     * @return The time zone to use for the Autonomous VM cluster.
     */
    public final String timeZone() {
        return timeZone;
    }

    /**
     * <p>
     * The total number of Autonomous CDBs that you can create in the Autonomous VM cluster.
     * </p>
     * 
     * @return The total number of Autonomous CDBs that you can create in the Autonomous VM cluster.
     */
    public final Integer totalContainerDatabases() {
        return totalContainerDatabases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(autonomousDataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(cpuCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbServers() ? dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(isMtlsEnabledVmCluster());
        hashCode = 31 * hashCode + Objects.hashCode(licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(memoryPerOracleComputeUnitInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(scanListenerPortNonTls());
        hashCode = 31 * hashCode + Objects.hashCode(scanListenerPortTls());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(totalContainerDatabases());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudAutonomousVmClusterRequest)) {
            return false;
        }
        CreateCloudAutonomousVmClusterRequest other = (CreateCloudAutonomousVmClusterRequest) obj;
        return Objects.equals(cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId())
                && Objects.equals(odbNetworkId(), other.odbNetworkId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(autonomousDataStorageSizeInTBs(), other.autonomousDataStorageSizeInTBs())
                && Objects.equals(cpuCoreCountPerNode(), other.cpuCoreCountPerNode()) && hasDbServers() == other.hasDbServers()
                && Objects.equals(dbServers(), other.dbServers()) && Objects.equals(description(), other.description())
                && Objects.equals(isMtlsEnabledVmCluster(), other.isMtlsEnabledVmCluster())
                && Objects.equals(licenseModelAsString(), other.licenseModelAsString())
                && Objects.equals(maintenanceWindow(), other.maintenanceWindow())
                && Objects.equals(memoryPerOracleComputeUnitInGBs(), other.memoryPerOracleComputeUnitInGBs())
                && Objects.equals(scanListenerPortNonTls(), other.scanListenerPortNonTls())
                && Objects.equals(scanListenerPortTls(), other.scanListenerPortTls()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(timeZone(), other.timeZone())
                && Objects.equals(totalContainerDatabases(), other.totalContainerDatabases());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudAutonomousVmClusterRequest")
                .add("CloudExadataInfrastructureId", cloudExadataInfrastructureId()).add("OdbNetworkId", odbNetworkId())
                .add("DisplayName", displayName()).add("ClientToken", clientToken())
                .add("AutonomousDataStorageSizeInTBs", autonomousDataStorageSizeInTBs())
                .add("CpuCoreCountPerNode", cpuCoreCountPerNode()).add("DbServers", hasDbServers() ? dbServers() : null)
                .add("Description", description()).add("IsMtlsEnabledVmCluster", isMtlsEnabledVmCluster())
                .add("LicenseModel", licenseModelAsString()).add("MaintenanceWindow", maintenanceWindow())
                .add("MemoryPerOracleComputeUnitInGBs", memoryPerOracleComputeUnitInGBs())
                .add("ScanListenerPortNonTls", scanListenerPortNonTls()).add("ScanListenerPortTls", scanListenerPortTls())
                .add("Tags", hasTags() ? tags() : null).add("TimeZone", timeZone())
                .add("TotalContainerDatabases", totalContainerDatabases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudExadataInfrastructureId":
            return Optional.ofNullable(clazz.cast(cloudExadataInfrastructureId()));
        case "odbNetworkId":
            return Optional.ofNullable(clazz.cast(odbNetworkId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "autonomousDataStorageSizeInTBs":
            return Optional.ofNullable(clazz.cast(autonomousDataStorageSizeInTBs()));
        case "cpuCoreCountPerNode":
            return Optional.ofNullable(clazz.cast(cpuCoreCountPerNode()));
        case "dbServers":
            return Optional.ofNullable(clazz.cast(dbServers()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "isMtlsEnabledVmCluster":
            return Optional.ofNullable(clazz.cast(isMtlsEnabledVmCluster()));
        case "licenseModel":
            return Optional.ofNullable(clazz.cast(licenseModelAsString()));
        case "maintenanceWindow":
            return Optional.ofNullable(clazz.cast(maintenanceWindow()));
        case "memoryPerOracleComputeUnitInGBs":
            return Optional.ofNullable(clazz.cast(memoryPerOracleComputeUnitInGBs()));
        case "scanListenerPortNonTls":
            return Optional.ofNullable(clazz.cast(scanListenerPortNonTls()));
        case "scanListenerPortTls":
            return Optional.ofNullable(clazz.cast(scanListenerPortTls()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "timeZone":
            return Optional.ofNullable(clazz.cast(timeZone()));
        case "totalContainerDatabases":
            return Optional.ofNullable(clazz.cast(totalContainerDatabases()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("autonomousDataStorageSizeInTBs", AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("cpuCoreCountPerNode", CPU_CORE_COUNT_PER_NODE_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("isMtlsEnabledVmCluster", IS_MTLS_ENABLED_VM_CLUSTER_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("memoryPerOracleComputeUnitInGBs", MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD);
        map.put("scanListenerPortNonTls", SCAN_LISTENER_PORT_NON_TLS_FIELD);
        map.put("scanListenerPortTls", SCAN_LISTENER_PORT_TLS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("totalContainerDatabases", TOTAL_CONTAINER_DATABASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudAutonomousVmClusterRequest, T> g) {
        return obj -> g.apply((CreateCloudAutonomousVmClusterRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OdbRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateCloudAutonomousVmClusterRequest> {
        /**
         * <p>
         * The unique identifier of the Exadata infrastructure where the VM cluster will be created.
         * </p>
         * 
         * @param cloudExadataInfrastructureId
         *        The unique identifier of the Exadata infrastructure where the VM cluster will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId);

        /**
         * <p>
         * The unique identifier of the ODB network to be used for the VM cluster.
         * </p>
         * 
         * @param odbNetworkId
         *        The unique identifier of the ODB network to be used for the VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder odbNetworkId(String odbNetworkId);

        /**
         * <p>
         * The display name for the Autonomous VM cluster. The name does not need to be unique.
         * </p>
         * 
         * @param displayName
         *        The display name for the Autonomous VM cluster. The name does not need to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * A client-provided token to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        A client-provided token to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The data disk group size to be allocated for Autonomous Databases, in terabytes (TB).
         * </p>
         * 
         * @param autonomousDataStorageSizeInTBs
         *        The data disk group size to be allocated for Autonomous Databases, in terabytes (TB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs);

        /**
         * <p>
         * The number of CPU cores to be enabled per VM cluster node.
         * </p>
         * 
         * @param cpuCoreCountPerNode
         *        The number of CPU cores to be enabled per VM cluster node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode);

        /**
         * <p>
         * The list of database servers to be used for the Autonomous VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers to be used for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(Collection<String> dbServers);

        /**
         * <p>
         * The list of database servers to be used for the Autonomous VM cluster.
         * </p>
         * 
         * @param dbServers
         *        The list of database servers to be used for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbServers(String... dbServers);

        /**
         * <p>
         * A user-provided description of the Autonomous VM cluster.
         * </p>
         * 
         * @param description
         *        A user-provided description of the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Specifies whether to enable mutual TLS (mTLS) authentication for the Autonomous VM cluster.
         * </p>
         * 
         * @param isMtlsEnabledVmCluster
         *        Specifies whether to enable mutual TLS (mTLS) authentication for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster);

        /**
         * <p>
         * The Oracle license model to apply to the Autonomous VM cluster.
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model to apply to the Autonomous VM cluster.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * The Oracle license model to apply to the Autonomous VM cluster.
         * </p>
         * 
         * @param licenseModel
         *        The Oracle license model to apply to the Autonomous VM cluster.
         * @see LicenseModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseModel
         */
        Builder licenseModel(LicenseModel licenseModel);

        /**
         * <p>
         * The scheduling details for the maintenance window. Patching and system updates take place during the
         * maintenance window.
         * </p>
         * 
         * @param maintenanceWindow
         *        The scheduling details for the maintenance window. Patching and system updates take place during the
         *        maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceWindow(MaintenanceWindow maintenanceWindow);

        /**
         * <p>
         * The scheduling details for the maintenance window. Patching and system updates take place during the
         * maintenance window.
         * </p>
         * This is a convenience method that creates an instance of the {@link MaintenanceWindow.Builder} avoiding the
         * need to create one manually via {@link MaintenanceWindow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MaintenanceWindow.Builder#build()} is called immediately and its
         * result is passed to {@link #maintenanceWindow(MaintenanceWindow)}.
         * 
         * @param maintenanceWindow
         *        a consumer that will call methods on {@link MaintenanceWindow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #maintenanceWindow(MaintenanceWindow)
         */
        default Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return maintenanceWindow(MaintenanceWindow.builder().applyMutation(maintenanceWindow).build());
        }

        /**
         * <p>
         * The amount of memory to be allocated per OCPU, in GB.
         * </p>
         * 
         * @param memoryPerOracleComputeUnitInGBs
         *        The amount of memory to be allocated per OCPU, in GB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs);

        /**
         * <p>
         * The SCAN listener port for non-TLS (TCP) protocol.
         * </p>
         * 
         * @param scanListenerPortNonTls
         *        The SCAN listener port for non-TLS (TCP) protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanListenerPortNonTls(Integer scanListenerPortNonTls);

        /**
         * <p>
         * The SCAN listener port for TLS (TCP) protocol.
         * </p>
         * 
         * @param scanListenerPortTls
         *        The SCAN listener port for TLS (TCP) protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scanListenerPortTls(Integer scanListenerPortTls);

        /**
         * <p>
         * Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or namespace.
         * </p>
         * 
         * @param tags
         *        Free-form tags for this resource. Each tag is a key-value pair with no predefined name, type, or
         *        namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The time zone to use for the Autonomous VM cluster.
         * </p>
         * 
         * @param timeZone
         *        The time zone to use for the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * The total number of Autonomous CDBs that you can create in the Autonomous VM cluster.
         * </p>
         * 
         * @param totalContainerDatabases
         *        The total number of Autonomous CDBs that you can create in the Autonomous VM cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalContainerDatabases(Integer totalContainerDatabases);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OdbRequest.BuilderImpl implements Builder {
        private String cloudExadataInfrastructureId;

        private String odbNetworkId;

        private String displayName;

        private String clientToken;

        private Double autonomousDataStorageSizeInTBs;

        private Integer cpuCoreCountPerNode;

        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();

        private String description;

        private Boolean isMtlsEnabledVmCluster;

        private String licenseModel;

        private MaintenanceWindow maintenanceWindow;

        private Integer memoryPerOracleComputeUnitInGBs;

        private Integer scanListenerPortNonTls;

        private Integer scanListenerPortTls;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String timeZone;

        private Integer totalContainerDatabases;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudAutonomousVmClusterRequest model) {
            super(model);
            cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            odbNetworkId(model.odbNetworkId);
            displayName(model.displayName);
            clientToken(model.clientToken);
            autonomousDataStorageSizeInTBs(model.autonomousDataStorageSizeInTBs);
            cpuCoreCountPerNode(model.cpuCoreCountPerNode);
            dbServers(model.dbServers);
            description(model.description);
            isMtlsEnabledVmCluster(model.isMtlsEnabledVmCluster);
            licenseModel(model.licenseModel);
            maintenanceWindow(model.maintenanceWindow);
            memoryPerOracleComputeUnitInGBs(model.memoryPerOracleComputeUnitInGBs);
            scanListenerPortNonTls(model.scanListenerPortNonTls);
            scanListenerPortTls(model.scanListenerPortTls);
            tags(model.tags);
            timeZone(model.timeZone);
            totalContainerDatabases(model.totalContainerDatabases);
        }

        public final String getCloudExadataInfrastructureId() {
            return cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final String getOdbNetworkId() {
            return odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Double getAutonomousDataStorageSizeInTBs() {
            return autonomousDataStorageSizeInTBs;
        }

        public final void setAutonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        }

        @Override
        public final Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            return this;
        }

        public final Integer getCpuCoreCountPerNode() {
            return cpuCoreCountPerNode;
        }

        public final void setCpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        }

        @Override
        public final Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String... dbServers) {
            dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIsMtlsEnabledVmCluster() {
            return isMtlsEnabledVmCluster;
        }

        public final void setIsMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
        }

        @Override
        public final Builder isMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return maintenanceWindow != null ? maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getMemoryPerOracleComputeUnitInGBs() {
            return memoryPerOracleComputeUnitInGBs;
        }

        public final void setMemoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        }

        @Override
        public final Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            return this;
        }

        public final Integer getScanListenerPortNonTls() {
            return scanListenerPortNonTls;
        }

        public final void setScanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
        }

        @Override
        public final Builder scanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
            return this;
        }

        public final Integer getScanListenerPortTls() {
            return scanListenerPortTls;
        }

        public final void setScanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
        }

        @Override
        public final Builder scanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Integer getTotalContainerDatabases() {
            return totalContainerDatabases;
        }

        public final void setTotalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
        }

        @Override
        public final Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudAutonomousVmClusterRequest build() {
            return new CreateCloudAutonomousVmClusterRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
