/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.ManagedServices;
import software.amazon.awssdk.services.odb.model.OciDnsForwardingConfig;
import software.amazon.awssdk.services.odb.model.OciDnsForwardingConfigListCopier;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OdbNetworkSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OdbNetworkSummary> {
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(OdbNetworkSummary.getter(OdbNetworkSummary::odbNetworkId)).setter(OdbNetworkSummary.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(OdbNetworkSummary.getter(OdbNetworkSummary::displayName)).setter(OdbNetworkSummary.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(OdbNetworkSummary.getter(OdbNetworkSummary::statusAsString)).setter(OdbNetworkSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(OdbNetworkSummary.getter(OdbNetworkSummary::statusReason)).setter(OdbNetworkSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> ODB_NETWORK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkArn").getter(OdbNetworkSummary.getter(OdbNetworkSummary::odbNetworkArn)).setter(OdbNetworkSummary.setter(Builder::odbNetworkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkArn").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(OdbNetworkSummary.getter(OdbNetworkSummary::availabilityZone)).setter(OdbNetworkSummary.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZoneId").getter(OdbNetworkSummary.getter(OdbNetworkSummary::availabilityZoneId)).setter(OdbNetworkSummary.setter(Builder::availabilityZoneId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZoneId").build()}).build();
    private static final SdkField<String> CLIENT_SUBNET_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientSubnetCidr").getter(OdbNetworkSummary.getter(OdbNetworkSummary::clientSubnetCidr)).setter(OdbNetworkSummary.setter(Builder::clientSubnetCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnetCidr").build()}).build();
    private static final SdkField<String> BACKUP_SUBNET_CIDR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("backupSubnetCidr").getter(OdbNetworkSummary.getter(OdbNetworkSummary::backupSubnetCidr)).setter(OdbNetworkSummary.setter(Builder::backupSubnetCidr)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("backupSubnetCidr").build()}).build();
    private static final SdkField<String> CUSTOM_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customDomainName").getter(OdbNetworkSummary.getter(OdbNetworkSummary::customDomainName)).setter(OdbNetworkSummary.setter(Builder::customDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customDomainName").build()}).build();
    private static final SdkField<String> DEFAULT_DNS_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultDnsPrefix").getter(OdbNetworkSummary.getter(OdbNetworkSummary::defaultDnsPrefix)).setter(OdbNetworkSummary.setter(Builder::defaultDnsPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultDnsPrefix").build()}).build();
    private static final SdkField<List<String>> PEERED_CIDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("peeredCidrs").getter(OdbNetworkSummary.getter(OdbNetworkSummary::peeredCidrs)).setter(OdbNetworkSummary.setter(Builder::peeredCidrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("peeredCidrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OCI_NETWORK_ANCHOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociNetworkAnchorId").getter(OdbNetworkSummary.getter(OdbNetworkSummary::ociNetworkAnchorId)).setter(OdbNetworkSummary.setter(Builder::ociNetworkAnchorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociNetworkAnchorId").build()}).build();
    private static final SdkField<String> OCI_NETWORK_ANCHOR_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociNetworkAnchorUrl").getter(OdbNetworkSummary.getter(OdbNetworkSummary::ociNetworkAnchorUrl)).setter(OdbNetworkSummary.setter(Builder::ociNetworkAnchorUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociNetworkAnchorUrl").build()}).build();
    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociResourceAnchorName").getter(OdbNetworkSummary.getter(OdbNetworkSummary::ociResourceAnchorName)).setter(OdbNetworkSummary.setter(Builder::ociResourceAnchorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build()}).build();
    private static final SdkField<String> OCI_VCN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociVcnId").getter(OdbNetworkSummary.getter(OdbNetworkSummary::ociVcnId)).setter(OdbNetworkSummary.setter(Builder::ociVcnId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociVcnId").build()}).build();
    private static final SdkField<String> OCI_VCN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociVcnUrl").getter(OdbNetworkSummary.getter(OdbNetworkSummary::ociVcnUrl)).setter(OdbNetworkSummary.setter(Builder::ociVcnUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociVcnUrl").build()}).build();
    private static final SdkField<List<OciDnsForwardingConfig>> OCI_DNS_FORWARDING_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ociDnsForwardingConfigs").getter(OdbNetworkSummary.getter(OdbNetworkSummary::ociDnsForwardingConfigs)).setter(OdbNetworkSummary.setter(Builder::ociDnsForwardingConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociDnsForwardingConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OciDnsForwardingConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(OdbNetworkSummary.getter(OdbNetworkSummary::createdAt)).setter(OdbNetworkSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("percentProgress").getter(OdbNetworkSummary.getter(OdbNetworkSummary::percentProgress)).setter(OdbNetworkSummary.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()}).build();
    private static final SdkField<ManagedServices> MANAGED_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("managedServices").getter(OdbNetworkSummary.getter(OdbNetworkSummary::managedServices)).setter(OdbNetworkSummary.setter(Builder::managedServices)).constructor(ManagedServices::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedServices").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ODB_NETWORK_ID_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ODB_NETWORK_ARN_FIELD, AVAILABILITY_ZONE_FIELD, AVAILABILITY_ZONE_ID_FIELD, CLIENT_SUBNET_CIDR_FIELD, BACKUP_SUBNET_CIDR_FIELD, CUSTOM_DOMAIN_NAME_FIELD, DEFAULT_DNS_PREFIX_FIELD, PEERED_CIDRS_FIELD, OCI_NETWORK_ANCHOR_ID_FIELD, OCI_NETWORK_ANCHOR_URL_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, OCI_VCN_ID_FIELD, OCI_VCN_URL_FIELD, OCI_DNS_FORWARDING_CONFIGS_FIELD, CREATED_AT_FIELD, PERCENT_PROGRESS_FIELD, MANAGED_SERVICES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OdbNetworkSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String odbNetworkId;
    private final String displayName;
    private final String status;
    private final String statusReason;
    private final String odbNetworkArn;
    private final String availabilityZone;
    private final String availabilityZoneId;
    private final String clientSubnetCidr;
    private final String backupSubnetCidr;
    private final String customDomainName;
    private final String defaultDnsPrefix;
    private final List<String> peeredCidrs;
    private final String ociNetworkAnchorId;
    private final String ociNetworkAnchorUrl;
    private final String ociResourceAnchorName;
    private final String ociVcnId;
    private final String ociVcnUrl;
    private final List<OciDnsForwardingConfig> ociDnsForwardingConfigs;
    private final Instant createdAt;
    private final Float percentProgress;
    private final ManagedServices managedServices;

    private OdbNetworkSummary(BuilderImpl builder) {
        this.odbNetworkId = builder.odbNetworkId;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.odbNetworkArn = builder.odbNetworkArn;
        this.availabilityZone = builder.availabilityZone;
        this.availabilityZoneId = builder.availabilityZoneId;
        this.clientSubnetCidr = builder.clientSubnetCidr;
        this.backupSubnetCidr = builder.backupSubnetCidr;
        this.customDomainName = builder.customDomainName;
        this.defaultDnsPrefix = builder.defaultDnsPrefix;
        this.peeredCidrs = builder.peeredCidrs;
        this.ociNetworkAnchorId = builder.ociNetworkAnchorId;
        this.ociNetworkAnchorUrl = builder.ociNetworkAnchorUrl;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.ociVcnId = builder.ociVcnId;
        this.ociVcnUrl = builder.ociVcnUrl;
        this.ociDnsForwardingConfigs = builder.ociDnsForwardingConfigs;
        this.createdAt = builder.createdAt;
        this.percentProgress = builder.percentProgress;
        this.managedServices = builder.managedServices;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String odbNetworkArn() {
        return this.odbNetworkArn;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String availabilityZoneId() {
        return this.availabilityZoneId;
    }

    public final String clientSubnetCidr() {
        return this.clientSubnetCidr;
    }

    public final String backupSubnetCidr() {
        return this.backupSubnetCidr;
    }

    public final String customDomainName() {
        return this.customDomainName;
    }

    public final String defaultDnsPrefix() {
        return this.defaultDnsPrefix;
    }

    public final boolean hasPeeredCidrs() {
        return this.peeredCidrs != null && !(this.peeredCidrs instanceof SdkAutoConstructList);
    }

    public final List<String> peeredCidrs() {
        return this.peeredCidrs;
    }

    public final String ociNetworkAnchorId() {
        return this.ociNetworkAnchorId;
    }

    public final String ociNetworkAnchorUrl() {
        return this.ociNetworkAnchorUrl;
    }

    public final String ociResourceAnchorName() {
        return this.ociResourceAnchorName;
    }

    public final String ociVcnId() {
        return this.ociVcnId;
    }

    public final String ociVcnUrl() {
        return this.ociVcnUrl;
    }

    public final boolean hasOciDnsForwardingConfigs() {
        return this.ociDnsForwardingConfigs != null && !(this.ociDnsForwardingConfigs instanceof SdkAutoConstructList);
    }

    public final List<OciDnsForwardingConfig> ociDnsForwardingConfigs() {
        return this.ociDnsForwardingConfigs;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Float percentProgress() {
        return this.percentProgress;
    }

    public final ManagedServices managedServices() {
        return this.managedServices;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSubnetCidr());
        hashCode = 31 * hashCode + Objects.hashCode(this.customDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultDnsPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPeeredCidrs() ? this.peeredCidrs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ociNetworkAnchorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociNetworkAnchorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociVcnId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociVcnUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOciDnsForwardingConfigs() ? this.ociDnsForwardingConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.managedServices());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OdbNetworkSummary)) {
            return false;
        }
        OdbNetworkSummary other = (OdbNetworkSummary)obj;
        return Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.odbNetworkArn(), other.odbNetworkArn()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.availabilityZoneId(), other.availabilityZoneId()) && Objects.equals(this.clientSubnetCidr(), other.clientSubnetCidr()) && Objects.equals(this.backupSubnetCidr(), other.backupSubnetCidr()) && Objects.equals(this.customDomainName(), other.customDomainName()) && Objects.equals(this.defaultDnsPrefix(), other.defaultDnsPrefix()) && this.hasPeeredCidrs() == other.hasPeeredCidrs() && Objects.equals(this.peeredCidrs(), other.peeredCidrs()) && Objects.equals(this.ociNetworkAnchorId(), other.ociNetworkAnchorId()) && Objects.equals(this.ociNetworkAnchorUrl(), other.ociNetworkAnchorUrl()) && Objects.equals(this.ociResourceAnchorName(), other.ociResourceAnchorName()) && Objects.equals(this.ociVcnId(), other.ociVcnId()) && Objects.equals(this.ociVcnUrl(), other.ociVcnUrl()) && this.hasOciDnsForwardingConfigs() == other.hasOciDnsForwardingConfigs() && Objects.equals(this.ociDnsForwardingConfigs(), other.ociDnsForwardingConfigs()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.managedServices(), other.managedServices());
    }

    public final String toString() {
        return ToString.builder((String)"OdbNetworkSummary").add("OdbNetworkId", (Object)this.odbNetworkId()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("OdbNetworkArn", (Object)this.odbNetworkArn()).add("AvailabilityZone", (Object)this.availabilityZone()).add("AvailabilityZoneId", (Object)this.availabilityZoneId()).add("ClientSubnetCidr", (Object)this.clientSubnetCidr()).add("BackupSubnetCidr", (Object)this.backupSubnetCidr()).add("CustomDomainName", (Object)this.customDomainName()).add("DefaultDnsPrefix", (Object)this.defaultDnsPrefix()).add("PeeredCidrs", this.hasPeeredCidrs() ? this.peeredCidrs() : null).add("OciNetworkAnchorId", (Object)this.ociNetworkAnchorId()).add("OciNetworkAnchorUrl", (Object)this.ociNetworkAnchorUrl()).add("OciResourceAnchorName", (Object)this.ociResourceAnchorName()).add("OciVcnId", (Object)this.ociVcnId()).add("OciVcnUrl", (Object)this.ociVcnUrl()).add("OciDnsForwardingConfigs", this.hasOciDnsForwardingConfigs() ? this.ociDnsForwardingConfigs() : null).add("CreatedAt", (Object)this.createdAt()).add("PercentProgress", (Object)this.percentProgress()).add("ManagedServices", (Object)this.managedServices()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "odbNetworkArn": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkArn()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "availabilityZoneId": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneId()));
            }
            case "clientSubnetCidr": {
                return Optional.ofNullable(clazz.cast(this.clientSubnetCidr()));
            }
            case "backupSubnetCidr": {
                return Optional.ofNullable(clazz.cast(this.backupSubnetCidr()));
            }
            case "customDomainName": {
                return Optional.ofNullable(clazz.cast(this.customDomainName()));
            }
            case "defaultDnsPrefix": {
                return Optional.ofNullable(clazz.cast(this.defaultDnsPrefix()));
            }
            case "peeredCidrs": {
                return Optional.ofNullable(clazz.cast(this.peeredCidrs()));
            }
            case "ociNetworkAnchorId": {
                return Optional.ofNullable(clazz.cast(this.ociNetworkAnchorId()));
            }
            case "ociNetworkAnchorUrl": {
                return Optional.ofNullable(clazz.cast(this.ociNetworkAnchorUrl()));
            }
            case "ociResourceAnchorName": {
                return Optional.ofNullable(clazz.cast(this.ociResourceAnchorName()));
            }
            case "ociVcnId": {
                return Optional.ofNullable(clazz.cast(this.ociVcnId()));
            }
            case "ociVcnUrl": {
                return Optional.ofNullable(clazz.cast(this.ociVcnUrl()));
            }
            case "ociDnsForwardingConfigs": {
                return Optional.ofNullable(clazz.cast(this.ociDnsForwardingConfigs()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "percentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "managedServices": {
                return Optional.ofNullable(clazz.cast(this.managedServices()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("odbNetworkArn", ODB_NETWORK_ARN_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("availabilityZoneId", AVAILABILITY_ZONE_ID_FIELD);
        map.put("clientSubnetCidr", CLIENT_SUBNET_CIDR_FIELD);
        map.put("backupSubnetCidr", BACKUP_SUBNET_CIDR_FIELD);
        map.put("customDomainName", CUSTOM_DOMAIN_NAME_FIELD);
        map.put("defaultDnsPrefix", DEFAULT_DNS_PREFIX_FIELD);
        map.put("peeredCidrs", PEERED_CIDRS_FIELD);
        map.put("ociNetworkAnchorId", OCI_NETWORK_ANCHOR_ID_FIELD);
        map.put("ociNetworkAnchorUrl", OCI_NETWORK_ANCHOR_URL_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("ociVcnId", OCI_VCN_ID_FIELD);
        map.put("ociVcnUrl", OCI_VCN_URL_FIELD);
        map.put("ociDnsForwardingConfigs", OCI_DNS_FORWARDING_CONFIGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("managedServices", MANAGED_SERVICES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OdbNetworkSummary, T> g) {
        return obj -> g.apply((OdbNetworkSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String odbNetworkId;
        private String displayName;
        private String status;
        private String statusReason;
        private String odbNetworkArn;
        private String availabilityZone;
        private String availabilityZoneId;
        private String clientSubnetCidr;
        private String backupSubnetCidr;
        private String customDomainName;
        private String defaultDnsPrefix;
        private List<String> peeredCidrs = DefaultSdkAutoConstructList.getInstance();
        private String ociNetworkAnchorId;
        private String ociNetworkAnchorUrl;
        private String ociResourceAnchorName;
        private String ociVcnId;
        private String ociVcnUrl;
        private List<OciDnsForwardingConfig> ociDnsForwardingConfigs = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Float percentProgress;
        private ManagedServices managedServices;

        private BuilderImpl() {
        }

        private BuilderImpl(OdbNetworkSummary model) {
            this.odbNetworkId(model.odbNetworkId);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.odbNetworkArn(model.odbNetworkArn);
            this.availabilityZone(model.availabilityZone);
            this.availabilityZoneId(model.availabilityZoneId);
            this.clientSubnetCidr(model.clientSubnetCidr);
            this.backupSubnetCidr(model.backupSubnetCidr);
            this.customDomainName(model.customDomainName);
            this.defaultDnsPrefix(model.defaultDnsPrefix);
            this.peeredCidrs(model.peeredCidrs);
            this.ociNetworkAnchorId(model.ociNetworkAnchorId);
            this.ociNetworkAnchorUrl(model.ociNetworkAnchorUrl);
            this.ociResourceAnchorName(model.ociResourceAnchorName);
            this.ociVcnId(model.ociVcnId);
            this.ociVcnUrl(model.ociVcnUrl);
            this.ociDnsForwardingConfigs(model.ociDnsForwardingConfigs);
            this.createdAt(model.createdAt);
            this.percentProgress(model.percentProgress);
            this.managedServices(model.managedServices);
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getOdbNetworkArn() {
            return this.odbNetworkArn;
        }

        public final void setOdbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
        }

        @Override
        public final Builder odbNetworkArn(String odbNetworkArn) {
            this.odbNetworkArn = odbNetworkArn;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getAvailabilityZoneId() {
            return this.availabilityZoneId;
        }

        public final void setAvailabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
        }

        @Override
        public final Builder availabilityZoneId(String availabilityZoneId) {
            this.availabilityZoneId = availabilityZoneId;
            return this;
        }

        public final String getClientSubnetCidr() {
            return this.clientSubnetCidr;
        }

        public final void setClientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
        }

        @Override
        public final Builder clientSubnetCidr(String clientSubnetCidr) {
            this.clientSubnetCidr = clientSubnetCidr;
            return this;
        }

        public final String getBackupSubnetCidr() {
            return this.backupSubnetCidr;
        }

        public final void setBackupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
        }

        @Override
        public final Builder backupSubnetCidr(String backupSubnetCidr) {
            this.backupSubnetCidr = backupSubnetCidr;
            return this;
        }

        public final String getCustomDomainName() {
            return this.customDomainName;
        }

        public final void setCustomDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
        }

        @Override
        public final Builder customDomainName(String customDomainName) {
            this.customDomainName = customDomainName;
            return this;
        }

        public final String getDefaultDnsPrefix() {
            return this.defaultDnsPrefix;
        }

        public final void setDefaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
        }

        @Override
        public final Builder defaultDnsPrefix(String defaultDnsPrefix) {
            this.defaultDnsPrefix = defaultDnsPrefix;
            return this;
        }

        public final Collection<String> getPeeredCidrs() {
            if (this.peeredCidrs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.peeredCidrs;
        }

        public final void setPeeredCidrs(Collection<String> peeredCidrs) {
            this.peeredCidrs = StringListCopier.copy(peeredCidrs);
        }

        @Override
        public final Builder peeredCidrs(Collection<String> peeredCidrs) {
            this.peeredCidrs = StringListCopier.copy(peeredCidrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder peeredCidrs(String ... peeredCidrs) {
            this.peeredCidrs(Arrays.asList(peeredCidrs));
            return this;
        }

        public final String getOciNetworkAnchorId() {
            return this.ociNetworkAnchorId;
        }

        public final void setOciNetworkAnchorId(String ociNetworkAnchorId) {
            this.ociNetworkAnchorId = ociNetworkAnchorId;
        }

        @Override
        public final Builder ociNetworkAnchorId(String ociNetworkAnchorId) {
            this.ociNetworkAnchorId = ociNetworkAnchorId;
            return this;
        }

        public final String getOciNetworkAnchorUrl() {
            return this.ociNetworkAnchorUrl;
        }

        public final void setOciNetworkAnchorUrl(String ociNetworkAnchorUrl) {
            this.ociNetworkAnchorUrl = ociNetworkAnchorUrl;
        }

        @Override
        public final Builder ociNetworkAnchorUrl(String ociNetworkAnchorUrl) {
            this.ociNetworkAnchorUrl = ociNetworkAnchorUrl;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return this.ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final String getOciVcnId() {
            return this.ociVcnId;
        }

        public final void setOciVcnId(String ociVcnId) {
            this.ociVcnId = ociVcnId;
        }

        @Override
        public final Builder ociVcnId(String ociVcnId) {
            this.ociVcnId = ociVcnId;
            return this;
        }

        public final String getOciVcnUrl() {
            return this.ociVcnUrl;
        }

        public final void setOciVcnUrl(String ociVcnUrl) {
            this.ociVcnUrl = ociVcnUrl;
        }

        @Override
        public final Builder ociVcnUrl(String ociVcnUrl) {
            this.ociVcnUrl = ociVcnUrl;
            return this;
        }

        public final List<OciDnsForwardingConfig.Builder> getOciDnsForwardingConfigs() {
            List<OciDnsForwardingConfig.Builder> result = OciDnsForwardingConfigListCopier.copyToBuilder(this.ociDnsForwardingConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOciDnsForwardingConfigs(Collection<OciDnsForwardingConfig.BuilderImpl> ociDnsForwardingConfigs) {
            this.ociDnsForwardingConfigs = OciDnsForwardingConfigListCopier.copyFromBuilder(ociDnsForwardingConfigs);
        }

        @Override
        public final Builder ociDnsForwardingConfigs(Collection<OciDnsForwardingConfig> ociDnsForwardingConfigs) {
            this.ociDnsForwardingConfigs = OciDnsForwardingConfigListCopier.copy(ociDnsForwardingConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ociDnsForwardingConfigs(OciDnsForwardingConfig ... ociDnsForwardingConfigs) {
            this.ociDnsForwardingConfigs(Arrays.asList(ociDnsForwardingConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ociDnsForwardingConfigs(Consumer<OciDnsForwardingConfig.Builder> ... ociDnsForwardingConfigs) {
            this.ociDnsForwardingConfigs(Stream.of(ociDnsForwardingConfigs).map(c -> (OciDnsForwardingConfig)((OciDnsForwardingConfig.Builder)OciDnsForwardingConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Float getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final ManagedServices.Builder getManagedServices() {
            return this.managedServices != null ? this.managedServices.toBuilder() : null;
        }

        public final void setManagedServices(ManagedServices.BuilderImpl managedServices) {
            this.managedServices = managedServices != null ? managedServices.build() : null;
        }

        @Override
        public final Builder managedServices(ManagedServices managedServices) {
            this.managedServices = managedServices;
            return this;
        }

        public OdbNetworkSummary build() {
            return new OdbNetworkSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OdbNetworkSummary> {
        public Builder odbNetworkId(String var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder odbNetworkArn(String var1);

        public Builder availabilityZone(String var1);

        public Builder availabilityZoneId(String var1);

        public Builder clientSubnetCidr(String var1);

        public Builder backupSubnetCidr(String var1);

        public Builder customDomainName(String var1);

        public Builder defaultDnsPrefix(String var1);

        public Builder peeredCidrs(Collection<String> var1);

        public Builder peeredCidrs(String ... var1);

        public Builder ociNetworkAnchorId(String var1);

        public Builder ociNetworkAnchorUrl(String var1);

        public Builder ociResourceAnchorName(String var1);

        public Builder ociVcnId(String var1);

        public Builder ociVcnUrl(String var1);

        public Builder ociDnsForwardingConfigs(Collection<OciDnsForwardingConfig> var1);

        public Builder ociDnsForwardingConfigs(OciDnsForwardingConfig ... var1);

        public Builder ociDnsForwardingConfigs(Consumer<OciDnsForwardingConfig.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder percentProgress(Float var1);

        public Builder managedServices(ManagedServices var1);

        default public Builder managedServices(Consumer<ManagedServices.Builder> managedServices) {
            return this.managedServices((ManagedServices)((ManagedServices.Builder)ManagedServices.builder().applyMutation(managedServices)).build());
        }
    }
}

