/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.DbSystemShapeListCopier;
import software.amazon.awssdk.services.odb.model.DbSystemShapeSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDbSystemShapesResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListDbSystemShapesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDbSystemShapesResponse.getter(ListDbSystemShapesResponse::nextToken)).setter(ListDbSystemShapesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<DbSystemShapeSummary>> DB_SYSTEM_SHAPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbSystemShapes").getter(ListDbSystemShapesResponse.getter(ListDbSystemShapesResponse::dbSystemShapes)).setter(ListDbSystemShapesResponse.setter(Builder::dbSystemShapes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbSystemShapes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DbSystemShapeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, DB_SYSTEM_SHAPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDbSystemShapesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<DbSystemShapeSummary> dbSystemShapes;

    private ListDbSystemShapesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.dbSystemShapes = builder.dbSystemShapes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasDbSystemShapes() {
        return this.dbSystemShapes != null && !(this.dbSystemShapes instanceof SdkAutoConstructList);
    }

    public final List<DbSystemShapeSummary> dbSystemShapes() {
        return this.dbSystemShapes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbSystemShapes() ? this.dbSystemShapes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDbSystemShapesResponse)) {
            return false;
        }
        ListDbSystemShapesResponse other = (ListDbSystemShapesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasDbSystemShapes() == other.hasDbSystemShapes() && Objects.equals(this.dbSystemShapes(), other.dbSystemShapes());
    }

    public final String toString() {
        return ToString.builder((String)"ListDbSystemShapesResponse").add("NextToken", (Object)this.nextToken()).add("DbSystemShapes", this.hasDbSystemShapes() ? this.dbSystemShapes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "dbSystemShapes": {
                return Optional.ofNullable(clazz.cast(this.dbSystemShapes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("dbSystemShapes", DB_SYSTEM_SHAPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDbSystemShapesResponse, T> g) {
        return obj -> g.apply((ListDbSystemShapesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<DbSystemShapeSummary> dbSystemShapes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDbSystemShapesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.dbSystemShapes(model.dbSystemShapes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<DbSystemShapeSummary.Builder> getDbSystemShapes() {
            List<DbSystemShapeSummary.Builder> result = DbSystemShapeListCopier.copyToBuilder(this.dbSystemShapes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbSystemShapes(Collection<DbSystemShapeSummary.BuilderImpl> dbSystemShapes) {
            this.dbSystemShapes = DbSystemShapeListCopier.copyFromBuilder(dbSystemShapes);
        }

        @Override
        public final Builder dbSystemShapes(Collection<DbSystemShapeSummary> dbSystemShapes) {
            this.dbSystemShapes = DbSystemShapeListCopier.copy(dbSystemShapes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSystemShapes(DbSystemShapeSummary ... dbSystemShapes) {
            this.dbSystemShapes(Arrays.asList(dbSystemShapes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSystemShapes(Consumer<DbSystemShapeSummary.Builder> ... dbSystemShapes) {
            this.dbSystemShapes(Stream.of(dbSystemShapes).map(c -> (DbSystemShapeSummary)((DbSystemShapeSummary.Builder)DbSystemShapeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListDbSystemShapesResponse build() {
            return new ListDbSystemShapesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDbSystemShapesResponse> {
        public Builder nextToken(String var1);

        public Builder dbSystemShapes(Collection<DbSystemShapeSummary> var1);

        public Builder dbSystemShapes(DbSystemShapeSummary ... var1);

        public Builder dbSystemShapes(Consumer<DbSystemShapeSummary.Builder> ... var1);
    }
}

