/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.CloudAutonomousVmClusterSummary;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersRequest;
import software.amazon.awssdk.services.odb.model.ListCloudAutonomousVmClustersResponse;

public class ListCloudAutonomousVmClustersIterable
implements SdkIterable<ListCloudAutonomousVmClustersResponse> {
    private final OdbClient client;
    private final ListCloudAutonomousVmClustersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudAutonomousVmClustersIterable(OdbClient client, ListCloudAutonomousVmClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCloudAutonomousVmClustersResponseFetcher();
    }

    public Iterator<ListCloudAutonomousVmClustersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudAutonomousVmClusterSummary> cloudAutonomousVmClusters() {
        Function<ListCloudAutonomousVmClustersResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudAutonomousVmClusters() != null) {
                return response.cloudAutonomousVmClusters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCloudAutonomousVmClustersResponseFetcher
    implements SyncPageFetcher<ListCloudAutonomousVmClustersResponse> {
        private ListCloudAutonomousVmClustersResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudAutonomousVmClustersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCloudAutonomousVmClustersResponse nextPage(ListCloudAutonomousVmClustersResponse previousPage) {
            if (previousPage == null) {
                return ListCloudAutonomousVmClustersIterable.this.client.listCloudAutonomousVmClusters(ListCloudAutonomousVmClustersIterable.this.firstRequest);
            }
            return ListCloudAutonomousVmClustersIterable.this.client.listCloudAutonomousVmClusters((ListCloudAutonomousVmClustersRequest)((Object)ListCloudAutonomousVmClustersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

