/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsRequest;
import software.amazon.awssdk.services.odb.model.ListOdbPeeringConnectionsResponse;
import software.amazon.awssdk.services.odb.model.OdbPeeringConnectionSummary;

public class ListOdbPeeringConnectionsIterable
implements SdkIterable<ListOdbPeeringConnectionsResponse> {
    private final OdbClient client;
    private final ListOdbPeeringConnectionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListOdbPeeringConnectionsIterable(OdbClient client, ListOdbPeeringConnectionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListOdbPeeringConnectionsResponseFetcher();
    }

    public Iterator<ListOdbPeeringConnectionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<OdbPeeringConnectionSummary> odbPeeringConnections() {
        Function<ListOdbPeeringConnectionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.odbPeeringConnections() != null) {
                return response.odbPeeringConnections().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListOdbPeeringConnectionsResponseFetcher
    implements SyncPageFetcher<ListOdbPeeringConnectionsResponse> {
        private ListOdbPeeringConnectionsResponseFetcher() {
        }

        public boolean hasNextPage(ListOdbPeeringConnectionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListOdbPeeringConnectionsResponse nextPage(ListOdbPeeringConnectionsResponse previousPage) {
            if (previousPage == null) {
                return ListOdbPeeringConnectionsIterable.this.client.listOdbPeeringConnections(ListOdbPeeringConnectionsIterable.this.firstRequest);
            }
            return ListOdbPeeringConnectionsIterable.this.client.listOdbPeeringConnections((ListOdbPeeringConnectionsRequest)((Object)ListOdbPeeringConnectionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

