/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.ComputeModel;
import software.amazon.awssdk.services.odb.model.LicenseModel;
import software.amazon.awssdk.services.odb.model.MaintenanceWindow;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CloudAutonomousVmCluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CloudAutonomousVmCluster> {
    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudAutonomousVmClusterId").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::cloudAutonomousVmClusterId)).setter(CloudAutonomousVmCluster.setter(Builder::cloudAutonomousVmClusterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterId").build()}).build();
    private static final SdkField<String> CLOUD_AUTONOMOUS_VM_CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudAutonomousVmClusterArn").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::cloudAutonomousVmClusterArn)).setter(CloudAutonomousVmCluster.setter(Builder::cloudAutonomousVmClusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudAutonomousVmClusterArn").build()}).build();
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::odbNetworkId)).setter(CloudAutonomousVmCluster.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<String> OCI_RESOURCE_ANCHOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociResourceAnchorName").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::ociResourceAnchorName)).setter(CloudAutonomousVmCluster.setter(Builder::ociResourceAnchorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociResourceAnchorName").build()}).build();
    private static final SdkField<Float> PERCENT_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("percentProgress").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::percentProgress)).setter(CloudAutonomousVmCluster.setter(Builder::percentProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("percentProgress").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::displayName)).setter(CloudAutonomousVmCluster.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::statusAsString)).setter(CloudAutonomousVmCluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::statusReason)).setter(CloudAutonomousVmCluster.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudExadataInfrastructureId").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::cloudExadataInfrastructureId)).setter(CloudAutonomousVmCluster.setter(Builder::cloudExadataInfrastructureId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId").build()}).build();
    private static final SdkField<Float> AUTONOMOUS_DATA_STORAGE_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("autonomousDataStoragePercentage").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::autonomousDataStoragePercentage)).setter(CloudAutonomousVmCluster.setter(Builder::autonomousDataStoragePercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousDataStoragePercentage").build()}).build();
    private static final SdkField<Double> AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("autonomousDataStorageSizeInTBs").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::autonomousDataStorageSizeInTBs)).setter(CloudAutonomousVmCluster.setter(Builder::autonomousDataStorageSizeInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autonomousDataStorageSizeInTBs").build()}).build();
    private static final SdkField<Double> AVAILABLE_AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("availableAutonomousDataStorageSizeInTBs").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::availableAutonomousDataStorageSizeInTBs)).setter(CloudAutonomousVmCluster.setter(Builder::availableAutonomousDataStorageSizeInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableAutonomousDataStorageSizeInTBs").build()}).build();
    private static final SdkField<Integer> AVAILABLE_CONTAINER_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("availableContainerDatabases").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::availableContainerDatabases)).setter(CloudAutonomousVmCluster.setter(Builder::availableContainerDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableContainerDatabases").build()}).build();
    private static final SdkField<Float> AVAILABLE_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("availableCpus").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::availableCpus)).setter(CloudAutonomousVmCluster.setter(Builder::availableCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availableCpus").build()}).build();
    private static final SdkField<String> COMPUTE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("computeModel").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::computeModelAsString)).setter(CloudAutonomousVmCluster.setter(Builder::computeModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("computeModel").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCount").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::cpuCoreCount)).setter(CloudAutonomousVmCluster.setter(Builder::cpuCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_PER_NODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCountPerNode").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::cpuCoreCountPerNode)).setter(CloudAutonomousVmCluster.setter(Builder::cpuCoreCountPerNode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCountPerNode").build()}).build();
    private static final SdkField<Float> CPU_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("cpuPercentage").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::cpuPercentage)).setter(CloudAutonomousVmCluster.setter(Builder::cpuPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuPercentage").build()}).build();
    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("dataStorageSizeInGBs").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::dataStorageSizeInGBs)).setter(CloudAutonomousVmCluster.setter(Builder::dataStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInGBs").build()}).build();
    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("dataStorageSizeInTBs").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::dataStorageSizeInTBs)).setter(CloudAutonomousVmCluster.setter(Builder::dataStorageSizeInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build()}).build();
    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::dbNodeStorageSizeInGBs)).setter(CloudAutonomousVmCluster.setter(Builder::dbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbServers").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::dbServers)).setter(CloudAutonomousVmCluster.setter(Builder::dbServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::description)).setter(CloudAutonomousVmCluster.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domain").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::domain)).setter(CloudAutonomousVmCluster.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domain").build()}).build();
    private static final SdkField<Double> EXADATA_STORAGE_IN_T_BS_LOWEST_SCALED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("exadataStorageInTBsLowestScaledValue").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::exadataStorageInTBsLowestScaledValue)).setter(CloudAutonomousVmCluster.setter(Builder::exadataStorageInTBsLowestScaledValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exadataStorageInTBsLowestScaledValue").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::hostname)).setter(CloudAutonomousVmCluster.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> OCID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ocid").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::ocid)).setter(CloudAutonomousVmCluster.setter(Builder::ocid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ocid").build()}).build();
    private static final SdkField<String> OCI_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociUrl").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::ociUrl)).setter(CloudAutonomousVmCluster.setter(Builder::ociUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociUrl").build()}).build();
    private static final SdkField<Boolean> IS_MTLS_ENABLED_VM_CLUSTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isMtlsEnabledVmCluster").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::isMtlsEnabledVmCluster)).setter(CloudAutonomousVmCluster.setter(Builder::isMtlsEnabledVmCluster)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isMtlsEnabledVmCluster").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseModel").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::licenseModelAsString)).setter(CloudAutonomousVmCluster.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()}).build();
    private static final SdkField<MaintenanceWindow> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("maintenanceWindow").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::maintenanceWindow)).setter(CloudAutonomousVmCluster.setter(Builder::maintenanceWindow)).constructor(MaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maintenanceWindow").build()}).build();
    private static final SdkField<Integer> MAX_ACDS_LOWEST_SCALED_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxAcdsLowestScaledValue").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::maxAcdsLowestScaledValue)).setter(CloudAutonomousVmCluster.setter(Builder::maxAcdsLowestScaledValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxAcdsLowestScaledValue").build()}).build();
    private static final SdkField<Integer> MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memoryPerOracleComputeUnitInGBs").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::memoryPerOracleComputeUnitInGBs)).setter(CloudAutonomousVmCluster.setter(Builder::memoryPerOracleComputeUnitInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryPerOracleComputeUnitInGBs").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInGBs").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::memorySizeInGBs)).setter(CloudAutonomousVmCluster.setter(Builder::memorySizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()}).build();
    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nodeCount").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::nodeCount)).setter(CloudAutonomousVmCluster.setter(Builder::nodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeCount").build()}).build();
    private static final SdkField<Integer> NON_PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("nonProvisionableAutonomousContainerDatabases").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::nonProvisionableAutonomousContainerDatabases)).setter(CloudAutonomousVmCluster.setter(Builder::nonProvisionableAutonomousContainerDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nonProvisionableAutonomousContainerDatabases").build()}).build();
    private static final SdkField<Integer> PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("provisionableAutonomousContainerDatabases").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::provisionableAutonomousContainerDatabases)).setter(CloudAutonomousVmCluster.setter(Builder::provisionableAutonomousContainerDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionableAutonomousContainerDatabases").build()}).build();
    private static final SdkField<Integer> PROVISIONED_AUTONOMOUS_CONTAINER_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("provisionedAutonomousContainerDatabases").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::provisionedAutonomousContainerDatabases)).setter(CloudAutonomousVmCluster.setter(Builder::provisionedAutonomousContainerDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedAutonomousContainerDatabases").build()}).build();
    private static final SdkField<Float> PROVISIONED_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("provisionedCpus").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::provisionedCpus)).setter(CloudAutonomousVmCluster.setter(Builder::provisionedCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisionedCpus").build()}).build();
    private static final SdkField<Float> RECLAIMABLE_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("reclaimableCpus").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::reclaimableCpus)).setter(CloudAutonomousVmCluster.setter(Builder::reclaimableCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reclaimableCpus").build()}).build();
    private static final SdkField<Float> RESERVED_CPUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("reservedCpus").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::reservedCpus)).setter(CloudAutonomousVmCluster.setter(Builder::reservedCpus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reservedCpus").build()}).build();
    private static final SdkField<Integer> SCAN_LISTENER_PORT_NON_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scanListenerPortNonTls").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::scanListenerPortNonTls)).setter(CloudAutonomousVmCluster.setter(Builder::scanListenerPortNonTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortNonTls").build()}).build();
    private static final SdkField<Integer> SCAN_LISTENER_PORT_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scanListenerPortTls").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::scanListenerPortTls)).setter(CloudAutonomousVmCluster.setter(Builder::scanListenerPortTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortTls").build()}).build();
    private static final SdkField<String> SHAPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("shape").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::shape)).setter(CloudAutonomousVmCluster.setter(Builder::shape)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shape").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::createdAt)).setter(CloudAutonomousVmCluster.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> TIME_DATABASE_SSL_CERTIFICATE_EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timeDatabaseSslCertificateExpires").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::timeDatabaseSslCertificateExpires)).setter(CloudAutonomousVmCluster.setter(Builder::timeDatabaseSslCertificateExpires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeDatabaseSslCertificateExpires").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> TIME_ORDS_CERTIFICATE_EXPIRES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("timeOrdsCertificateExpires").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::timeOrdsCertificateExpires)).setter(CloudAutonomousVmCluster.setter(Builder::timeOrdsCertificateExpires)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeOrdsCertificateExpires").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeZone").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::timeZone)).setter(CloudAutonomousVmCluster.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()}).build();
    private static final SdkField<Integer> TOTAL_CONTAINER_DATABASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("totalContainerDatabases").getter(CloudAutonomousVmCluster.getter(CloudAutonomousVmCluster::totalContainerDatabases)).setter(CloudAutonomousVmCluster.setter(Builder::totalContainerDatabases)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalContainerDatabases").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD, CLOUD_AUTONOMOUS_VM_CLUSTER_ARN_FIELD, ODB_NETWORK_ID_FIELD, OCI_RESOURCE_ANCHOR_NAME_FIELD, PERCENT_PROGRESS_FIELD, DISPLAY_NAME_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, AUTONOMOUS_DATA_STORAGE_PERCENTAGE_FIELD, AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD, AVAILABLE_AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD, AVAILABLE_CONTAINER_DATABASES_FIELD, AVAILABLE_CPUS_FIELD, COMPUTE_MODEL_FIELD, CPU_CORE_COUNT_FIELD, CPU_CORE_COUNT_PER_NODE_FIELD, CPU_PERCENTAGE_FIELD, DATA_STORAGE_SIZE_IN_G_BS_FIELD, DATA_STORAGE_SIZE_IN_T_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVERS_FIELD, DESCRIPTION_FIELD, DOMAIN_FIELD, EXADATA_STORAGE_IN_T_BS_LOWEST_SCALED_VALUE_FIELD, HOSTNAME_FIELD, OCID_FIELD, OCI_URL_FIELD, IS_MTLS_ENABLED_VM_CLUSTER_FIELD, LICENSE_MODEL_FIELD, MAINTENANCE_WINDOW_FIELD, MAX_ACDS_LOWEST_SCALED_VALUE_FIELD, MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, NODE_COUNT_FIELD, NON_PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD, PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD, PROVISIONED_AUTONOMOUS_CONTAINER_DATABASES_FIELD, PROVISIONED_CPUS_FIELD, RECLAIMABLE_CPUS_FIELD, RESERVED_CPUS_FIELD, SCAN_LISTENER_PORT_NON_TLS_FIELD, SCAN_LISTENER_PORT_TLS_FIELD, SHAPE_FIELD, CREATED_AT_FIELD, TIME_DATABASE_SSL_CERTIFICATE_EXPIRES_FIELD, TIME_ORDS_CERTIFICATE_EXPIRES_FIELD, TIME_ZONE_FIELD, TOTAL_CONTAINER_DATABASES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CloudAutonomousVmCluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cloudAutonomousVmClusterId;
    private final String cloudAutonomousVmClusterArn;
    private final String odbNetworkId;
    private final String ociResourceAnchorName;
    private final Float percentProgress;
    private final String displayName;
    private final String status;
    private final String statusReason;
    private final String cloudExadataInfrastructureId;
    private final Float autonomousDataStoragePercentage;
    private final Double autonomousDataStorageSizeInTBs;
    private final Double availableAutonomousDataStorageSizeInTBs;
    private final Integer availableContainerDatabases;
    private final Float availableCpus;
    private final String computeModel;
    private final Integer cpuCoreCount;
    private final Integer cpuCoreCountPerNode;
    private final Float cpuPercentage;
    private final Double dataStorageSizeInGBs;
    private final Double dataStorageSizeInTBs;
    private final Integer dbNodeStorageSizeInGBs;
    private final List<String> dbServers;
    private final String description;
    private final String domain;
    private final Double exadataStorageInTBsLowestScaledValue;
    private final String hostname;
    private final String ocid;
    private final String ociUrl;
    private final Boolean isMtlsEnabledVmCluster;
    private final String licenseModel;
    private final MaintenanceWindow maintenanceWindow;
    private final Integer maxAcdsLowestScaledValue;
    private final Integer memoryPerOracleComputeUnitInGBs;
    private final Integer memorySizeInGBs;
    private final Integer nodeCount;
    private final Integer nonProvisionableAutonomousContainerDatabases;
    private final Integer provisionableAutonomousContainerDatabases;
    private final Integer provisionedAutonomousContainerDatabases;
    private final Float provisionedCpus;
    private final Float reclaimableCpus;
    private final Float reservedCpus;
    private final Integer scanListenerPortNonTls;
    private final Integer scanListenerPortTls;
    private final String shape;
    private final Instant createdAt;
    private final Instant timeDatabaseSslCertificateExpires;
    private final Instant timeOrdsCertificateExpires;
    private final String timeZone;
    private final Integer totalContainerDatabases;

    private CloudAutonomousVmCluster(BuilderImpl builder) {
        this.cloudAutonomousVmClusterId = builder.cloudAutonomousVmClusterId;
        this.cloudAutonomousVmClusterArn = builder.cloudAutonomousVmClusterArn;
        this.odbNetworkId = builder.odbNetworkId;
        this.ociResourceAnchorName = builder.ociResourceAnchorName;
        this.percentProgress = builder.percentProgress;
        this.displayName = builder.displayName;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.autonomousDataStoragePercentage = builder.autonomousDataStoragePercentage;
        this.autonomousDataStorageSizeInTBs = builder.autonomousDataStorageSizeInTBs;
        this.availableAutonomousDataStorageSizeInTBs = builder.availableAutonomousDataStorageSizeInTBs;
        this.availableContainerDatabases = builder.availableContainerDatabases;
        this.availableCpus = builder.availableCpus;
        this.computeModel = builder.computeModel;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.cpuCoreCountPerNode = builder.cpuCoreCountPerNode;
        this.cpuPercentage = builder.cpuPercentage;
        this.dataStorageSizeInGBs = builder.dataStorageSizeInGBs;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServers = builder.dbServers;
        this.description = builder.description;
        this.domain = builder.domain;
        this.exadataStorageInTBsLowestScaledValue = builder.exadataStorageInTBsLowestScaledValue;
        this.hostname = builder.hostname;
        this.ocid = builder.ocid;
        this.ociUrl = builder.ociUrl;
        this.isMtlsEnabledVmCluster = builder.isMtlsEnabledVmCluster;
        this.licenseModel = builder.licenseModel;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.maxAcdsLowestScaledValue = builder.maxAcdsLowestScaledValue;
        this.memoryPerOracleComputeUnitInGBs = builder.memoryPerOracleComputeUnitInGBs;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.nodeCount = builder.nodeCount;
        this.nonProvisionableAutonomousContainerDatabases = builder.nonProvisionableAutonomousContainerDatabases;
        this.provisionableAutonomousContainerDatabases = builder.provisionableAutonomousContainerDatabases;
        this.provisionedAutonomousContainerDatabases = builder.provisionedAutonomousContainerDatabases;
        this.provisionedCpus = builder.provisionedCpus;
        this.reclaimableCpus = builder.reclaimableCpus;
        this.reservedCpus = builder.reservedCpus;
        this.scanListenerPortNonTls = builder.scanListenerPortNonTls;
        this.scanListenerPortTls = builder.scanListenerPortTls;
        this.shape = builder.shape;
        this.createdAt = builder.createdAt;
        this.timeDatabaseSslCertificateExpires = builder.timeDatabaseSslCertificateExpires;
        this.timeOrdsCertificateExpires = builder.timeOrdsCertificateExpires;
        this.timeZone = builder.timeZone;
        this.totalContainerDatabases = builder.totalContainerDatabases;
    }

    public final String cloudAutonomousVmClusterId() {
        return this.cloudAutonomousVmClusterId;
    }

    public final String cloudAutonomousVmClusterArn() {
        return this.cloudAutonomousVmClusterArn;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final String ociResourceAnchorName() {
        return this.ociResourceAnchorName;
    }

    public final Float percentProgress() {
        return this.percentProgress;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String cloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public final Float autonomousDataStoragePercentage() {
        return this.autonomousDataStoragePercentage;
    }

    public final Double autonomousDataStorageSizeInTBs() {
        return this.autonomousDataStorageSizeInTBs;
    }

    public final Double availableAutonomousDataStorageSizeInTBs() {
        return this.availableAutonomousDataStorageSizeInTBs;
    }

    public final Integer availableContainerDatabases() {
        return this.availableContainerDatabases;
    }

    public final Float availableCpus() {
        return this.availableCpus;
    }

    public final ComputeModel computeModel() {
        return ComputeModel.fromValue(this.computeModel);
    }

    public final String computeModelAsString() {
        return this.computeModel;
    }

    public final Integer cpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final Integer cpuCoreCountPerNode() {
        return this.cpuCoreCountPerNode;
    }

    public final Float cpuPercentage() {
        return this.cpuPercentage;
    }

    public final Double dataStorageSizeInGBs() {
        return this.dataStorageSizeInGBs;
    }

    public final Double dataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public final Integer dbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public final boolean hasDbServers() {
        return this.dbServers != null && !(this.dbServers instanceof SdkAutoConstructList);
    }

    public final List<String> dbServers() {
        return this.dbServers;
    }

    public final String description() {
        return this.description;
    }

    public final String domain() {
        return this.domain;
    }

    public final Double exadataStorageInTBsLowestScaledValue() {
        return this.exadataStorageInTBsLowestScaledValue;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String ocid() {
        return this.ocid;
    }

    public final String ociUrl() {
        return this.ociUrl;
    }

    public final Boolean isMtlsEnabledVmCluster() {
        return this.isMtlsEnabledVmCluster;
    }

    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(this.licenseModel);
    }

    public final String licenseModelAsString() {
        return this.licenseModel;
    }

    public final MaintenanceWindow maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final Integer maxAcdsLowestScaledValue() {
        return this.maxAcdsLowestScaledValue;
    }

    public final Integer memoryPerOracleComputeUnitInGBs() {
        return this.memoryPerOracleComputeUnitInGBs;
    }

    public final Integer memorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public final Integer nodeCount() {
        return this.nodeCount;
    }

    public final Integer nonProvisionableAutonomousContainerDatabases() {
        return this.nonProvisionableAutonomousContainerDatabases;
    }

    public final Integer provisionableAutonomousContainerDatabases() {
        return this.provisionableAutonomousContainerDatabases;
    }

    public final Integer provisionedAutonomousContainerDatabases() {
        return this.provisionedAutonomousContainerDatabases;
    }

    public final Float provisionedCpus() {
        return this.provisionedCpus;
    }

    public final Float reclaimableCpus() {
        return this.reclaimableCpus;
    }

    public final Float reservedCpus() {
        return this.reservedCpus;
    }

    public final Integer scanListenerPortNonTls() {
        return this.scanListenerPortNonTls;
    }

    public final Integer scanListenerPortTls() {
        return this.scanListenerPortTls;
    }

    public final String shape() {
        return this.shape;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant timeDatabaseSslCertificateExpires() {
        return this.timeDatabaseSslCertificateExpires;
    }

    public final Instant timeOrdsCertificateExpires() {
        return this.timeOrdsCertificateExpires;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final Integer totalContainerDatabases() {
        return this.totalContainerDatabases;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudAutonomousVmClusterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudAutonomousVmClusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociResourceAnchorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.percentProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autonomousDataStoragePercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.autonomousDataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableAutonomousDataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.availableCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCountPerNode());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuPercentage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbServers() ? this.dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domain());
        hashCode = 31 * hashCode + Objects.hashCode(this.exadataStorageInTBsLowestScaledValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.ocid());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.isMtlsEnabledVmCluster());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAcdsLowestScaledValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryPerOracleComputeUnitInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.nonProvisionableAutonomousContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionableAutonomousContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedAutonomousContainerDatabases());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisionedCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.reclaimableCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedCpus());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanListenerPortNonTls());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanListenerPortTls());
        hashCode = 31 * hashCode + Objects.hashCode(this.shape());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeDatabaseSslCertificateExpires());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeOrdsCertificateExpires());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalContainerDatabases());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudAutonomousVmCluster)) {
            return false;
        }
        CloudAutonomousVmCluster other = (CloudAutonomousVmCluster)obj;
        return Objects.equals(this.cloudAutonomousVmClusterId(), other.cloudAutonomousVmClusterId()) && Objects.equals(this.cloudAutonomousVmClusterArn(), other.cloudAutonomousVmClusterArn()) && Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.ociResourceAnchorName(), other.ociResourceAnchorName()) && Objects.equals(this.percentProgress(), other.percentProgress()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId()) && Objects.equals(this.autonomousDataStoragePercentage(), other.autonomousDataStoragePercentage()) && Objects.equals(this.autonomousDataStorageSizeInTBs(), other.autonomousDataStorageSizeInTBs()) && Objects.equals(this.availableAutonomousDataStorageSizeInTBs(), other.availableAutonomousDataStorageSizeInTBs()) && Objects.equals(this.availableContainerDatabases(), other.availableContainerDatabases()) && Objects.equals(this.availableCpus(), other.availableCpus()) && Objects.equals(this.computeModelAsString(), other.computeModelAsString()) && Objects.equals(this.cpuCoreCount(), other.cpuCoreCount()) && Objects.equals(this.cpuCoreCountPerNode(), other.cpuCoreCountPerNode()) && Objects.equals(this.cpuPercentage(), other.cpuPercentage()) && Objects.equals(this.dataStorageSizeInGBs(), other.dataStorageSizeInGBs()) && Objects.equals(this.dataStorageSizeInTBs(), other.dataStorageSizeInTBs()) && Objects.equals(this.dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs()) && this.hasDbServers() == other.hasDbServers() && Objects.equals(this.dbServers(), other.dbServers()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domain(), other.domain()) && Objects.equals(this.exadataStorageInTBsLowestScaledValue(), other.exadataStorageInTBsLowestScaledValue()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.ocid(), other.ocid()) && Objects.equals(this.ociUrl(), other.ociUrl()) && Objects.equals(this.isMtlsEnabledVmCluster(), other.isMtlsEnabledVmCluster()) && Objects.equals(this.licenseModelAsString(), other.licenseModelAsString()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.maxAcdsLowestScaledValue(), other.maxAcdsLowestScaledValue()) && Objects.equals(this.memoryPerOracleComputeUnitInGBs(), other.memoryPerOracleComputeUnitInGBs()) && Objects.equals(this.memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(this.nodeCount(), other.nodeCount()) && Objects.equals(this.nonProvisionableAutonomousContainerDatabases(), other.nonProvisionableAutonomousContainerDatabases()) && Objects.equals(this.provisionableAutonomousContainerDatabases(), other.provisionableAutonomousContainerDatabases()) && Objects.equals(this.provisionedAutonomousContainerDatabases(), other.provisionedAutonomousContainerDatabases()) && Objects.equals(this.provisionedCpus(), other.provisionedCpus()) && Objects.equals(this.reclaimableCpus(), other.reclaimableCpus()) && Objects.equals(this.reservedCpus(), other.reservedCpus()) && Objects.equals(this.scanListenerPortNonTls(), other.scanListenerPortNonTls()) && Objects.equals(this.scanListenerPortTls(), other.scanListenerPortTls()) && Objects.equals(this.shape(), other.shape()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.timeDatabaseSslCertificateExpires(), other.timeDatabaseSslCertificateExpires()) && Objects.equals(this.timeOrdsCertificateExpires(), other.timeOrdsCertificateExpires()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.totalContainerDatabases(), other.totalContainerDatabases());
    }

    public final String toString() {
        return ToString.builder((String)"CloudAutonomousVmCluster").add("CloudAutonomousVmClusterId", (Object)this.cloudAutonomousVmClusterId()).add("CloudAutonomousVmClusterArn", (Object)this.cloudAutonomousVmClusterArn()).add("OdbNetworkId", (Object)this.odbNetworkId()).add("OciResourceAnchorName", (Object)this.ociResourceAnchorName()).add("PercentProgress", (Object)this.percentProgress()).add("DisplayName", (Object)this.displayName()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("CloudExadataInfrastructureId", (Object)this.cloudExadataInfrastructureId()).add("AutonomousDataStoragePercentage", (Object)this.autonomousDataStoragePercentage()).add("AutonomousDataStorageSizeInTBs", (Object)this.autonomousDataStorageSizeInTBs()).add("AvailableAutonomousDataStorageSizeInTBs", (Object)this.availableAutonomousDataStorageSizeInTBs()).add("AvailableContainerDatabases", (Object)this.availableContainerDatabases()).add("AvailableCpus", (Object)this.availableCpus()).add("ComputeModel", (Object)this.computeModelAsString()).add("CpuCoreCount", (Object)this.cpuCoreCount()).add("CpuCoreCountPerNode", (Object)this.cpuCoreCountPerNode()).add("CpuPercentage", (Object)this.cpuPercentage()).add("DataStorageSizeInGBs", (Object)this.dataStorageSizeInGBs()).add("DataStorageSizeInTBs", (Object)this.dataStorageSizeInTBs()).add("DbNodeStorageSizeInGBs", (Object)this.dbNodeStorageSizeInGBs()).add("DbServers", this.hasDbServers() ? this.dbServers() : null).add("Description", (Object)this.description()).add("Domain", (Object)this.domain()).add("ExadataStorageInTBsLowestScaledValue", (Object)this.exadataStorageInTBsLowestScaledValue()).add("Hostname", (Object)this.hostname()).add("Ocid", (Object)this.ocid()).add("OciUrl", (Object)this.ociUrl()).add("IsMtlsEnabledVmCluster", (Object)this.isMtlsEnabledVmCluster()).add("LicenseModel", (Object)this.licenseModelAsString()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("MaxAcdsLowestScaledValue", (Object)this.maxAcdsLowestScaledValue()).add("MemoryPerOracleComputeUnitInGBs", (Object)this.memoryPerOracleComputeUnitInGBs()).add("MemorySizeInGBs", (Object)this.memorySizeInGBs()).add("NodeCount", (Object)this.nodeCount()).add("NonProvisionableAutonomousContainerDatabases", (Object)this.nonProvisionableAutonomousContainerDatabases()).add("ProvisionableAutonomousContainerDatabases", (Object)this.provisionableAutonomousContainerDatabases()).add("ProvisionedAutonomousContainerDatabases", (Object)this.provisionedAutonomousContainerDatabases()).add("ProvisionedCpus", (Object)this.provisionedCpus()).add("ReclaimableCpus", (Object)this.reclaimableCpus()).add("ReservedCpus", (Object)this.reservedCpus()).add("ScanListenerPortNonTls", (Object)this.scanListenerPortNonTls()).add("ScanListenerPortTls", (Object)this.scanListenerPortTls()).add("Shape", (Object)this.shape()).add("CreatedAt", (Object)this.createdAt()).add("TimeDatabaseSslCertificateExpires", (Object)this.timeDatabaseSslCertificateExpires()).add("TimeOrdsCertificateExpires", (Object)this.timeOrdsCertificateExpires()).add("TimeZone", (Object)this.timeZone()).add("TotalContainerDatabases", (Object)this.totalContainerDatabases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudAutonomousVmClusterId": {
                return Optional.ofNullable(clazz.cast(this.cloudAutonomousVmClusterId()));
            }
            case "cloudAutonomousVmClusterArn": {
                return Optional.ofNullable(clazz.cast(this.cloudAutonomousVmClusterArn()));
            }
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "ociResourceAnchorName": {
                return Optional.ofNullable(clazz.cast(this.ociResourceAnchorName()));
            }
            case "percentProgress": {
                return Optional.ofNullable(clazz.cast(this.percentProgress()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "cloudExadataInfrastructureId": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructureId()));
            }
            case "autonomousDataStoragePercentage": {
                return Optional.ofNullable(clazz.cast(this.autonomousDataStoragePercentage()));
            }
            case "autonomousDataStorageSizeInTBs": {
                return Optional.ofNullable(clazz.cast(this.autonomousDataStorageSizeInTBs()));
            }
            case "availableAutonomousDataStorageSizeInTBs": {
                return Optional.ofNullable(clazz.cast(this.availableAutonomousDataStorageSizeInTBs()));
            }
            case "availableContainerDatabases": {
                return Optional.ofNullable(clazz.cast(this.availableContainerDatabases()));
            }
            case "availableCpus": {
                return Optional.ofNullable(clazz.cast(this.availableCpus()));
            }
            case "computeModel": {
                return Optional.ofNullable(clazz.cast(this.computeModelAsString()));
            }
            case "cpuCoreCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCount()));
            }
            case "cpuCoreCountPerNode": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCountPerNode()));
            }
            case "cpuPercentage": {
                return Optional.ofNullable(clazz.cast(this.cpuPercentage()));
            }
            case "dataStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dataStorageSizeInGBs()));
            }
            case "dataStorageSizeInTBs": {
                return Optional.ofNullable(clazz.cast(this.dataStorageSizeInTBs()));
            }
            case "dbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dbNodeStorageSizeInGBs()));
            }
            case "dbServers": {
                return Optional.ofNullable(clazz.cast(this.dbServers()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domain": {
                return Optional.ofNullable(clazz.cast(this.domain()));
            }
            case "exadataStorageInTBsLowestScaledValue": {
                return Optional.ofNullable(clazz.cast(this.exadataStorageInTBsLowestScaledValue()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "ocid": {
                return Optional.ofNullable(clazz.cast(this.ocid()));
            }
            case "ociUrl": {
                return Optional.ofNullable(clazz.cast(this.ociUrl()));
            }
            case "isMtlsEnabledVmCluster": {
                return Optional.ofNullable(clazz.cast(this.isMtlsEnabledVmCluster()));
            }
            case "licenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModelAsString()));
            }
            case "maintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "maxAcdsLowestScaledValue": {
                return Optional.ofNullable(clazz.cast(this.maxAcdsLowestScaledValue()));
            }
            case "memoryPerOracleComputeUnitInGBs": {
                return Optional.ofNullable(clazz.cast(this.memoryPerOracleComputeUnitInGBs()));
            }
            case "memorySizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInGBs()));
            }
            case "nodeCount": {
                return Optional.ofNullable(clazz.cast(this.nodeCount()));
            }
            case "nonProvisionableAutonomousContainerDatabases": {
                return Optional.ofNullable(clazz.cast(this.nonProvisionableAutonomousContainerDatabases()));
            }
            case "provisionableAutonomousContainerDatabases": {
                return Optional.ofNullable(clazz.cast(this.provisionableAutonomousContainerDatabases()));
            }
            case "provisionedAutonomousContainerDatabases": {
                return Optional.ofNullable(clazz.cast(this.provisionedAutonomousContainerDatabases()));
            }
            case "provisionedCpus": {
                return Optional.ofNullable(clazz.cast(this.provisionedCpus()));
            }
            case "reclaimableCpus": {
                return Optional.ofNullable(clazz.cast(this.reclaimableCpus()));
            }
            case "reservedCpus": {
                return Optional.ofNullable(clazz.cast(this.reservedCpus()));
            }
            case "scanListenerPortNonTls": {
                return Optional.ofNullable(clazz.cast(this.scanListenerPortNonTls()));
            }
            case "scanListenerPortTls": {
                return Optional.ofNullable(clazz.cast(this.scanListenerPortTls()));
            }
            case "shape": {
                return Optional.ofNullable(clazz.cast(this.shape()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "timeDatabaseSslCertificateExpires": {
                return Optional.ofNullable(clazz.cast(this.timeDatabaseSslCertificateExpires()));
            }
            case "timeOrdsCertificateExpires": {
                return Optional.ofNullable(clazz.cast(this.timeOrdsCertificateExpires()));
            }
            case "timeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "totalContainerDatabases": {
                return Optional.ofNullable(clazz.cast(this.totalContainerDatabases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudAutonomousVmClusterId", CLOUD_AUTONOMOUS_VM_CLUSTER_ID_FIELD);
        map.put("cloudAutonomousVmClusterArn", CLOUD_AUTONOMOUS_VM_CLUSTER_ARN_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("ociResourceAnchorName", OCI_RESOURCE_ANCHOR_NAME_FIELD);
        map.put("percentProgress", PERCENT_PROGRESS_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("autonomousDataStoragePercentage", AUTONOMOUS_DATA_STORAGE_PERCENTAGE_FIELD);
        map.put("autonomousDataStorageSizeInTBs", AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("availableAutonomousDataStorageSizeInTBs", AVAILABLE_AUTONOMOUS_DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("availableContainerDatabases", AVAILABLE_CONTAINER_DATABASES_FIELD);
        map.put("availableCpus", AVAILABLE_CPUS_FIELD);
        map.put("computeModel", COMPUTE_MODEL_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("cpuCoreCountPerNode", CPU_CORE_COUNT_PER_NODE_FIELD);
        map.put("cpuPercentage", CPU_PERCENTAGE_FIELD);
        map.put("dataStorageSizeInGBs", DATA_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domain", DOMAIN_FIELD);
        map.put("exadataStorageInTBsLowestScaledValue", EXADATA_STORAGE_IN_T_BS_LOWEST_SCALED_VALUE_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("ocid", OCID_FIELD);
        map.put("ociUrl", OCI_URL_FIELD);
        map.put("isMtlsEnabledVmCluster", IS_MTLS_ENABLED_VM_CLUSTER_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("maintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("maxAcdsLowestScaledValue", MAX_ACDS_LOWEST_SCALED_VALUE_FIELD);
        map.put("memoryPerOracleComputeUnitInGBs", MEMORY_PER_ORACLE_COMPUTE_UNIT_IN_G_BS_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("nodeCount", NODE_COUNT_FIELD);
        map.put("nonProvisionableAutonomousContainerDatabases", NON_PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD);
        map.put("provisionableAutonomousContainerDatabases", PROVISIONABLE_AUTONOMOUS_CONTAINER_DATABASES_FIELD);
        map.put("provisionedAutonomousContainerDatabases", PROVISIONED_AUTONOMOUS_CONTAINER_DATABASES_FIELD);
        map.put("provisionedCpus", PROVISIONED_CPUS_FIELD);
        map.put("reclaimableCpus", RECLAIMABLE_CPUS_FIELD);
        map.put("reservedCpus", RESERVED_CPUS_FIELD);
        map.put("scanListenerPortNonTls", SCAN_LISTENER_PORT_NON_TLS_FIELD);
        map.put("scanListenerPortTls", SCAN_LISTENER_PORT_TLS_FIELD);
        map.put("shape", SHAPE_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("timeDatabaseSslCertificateExpires", TIME_DATABASE_SSL_CERTIFICATE_EXPIRES_FIELD);
        map.put("timeOrdsCertificateExpires", TIME_ORDS_CERTIFICATE_EXPIRES_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("totalContainerDatabases", TOTAL_CONTAINER_DATABASES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudAutonomousVmCluster, T> g) {
        return obj -> g.apply((CloudAutonomousVmCluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudAutonomousVmClusterId;
        private String cloudAutonomousVmClusterArn;
        private String odbNetworkId;
        private String ociResourceAnchorName;
        private Float percentProgress;
        private String displayName;
        private String status;
        private String statusReason;
        private String cloudExadataInfrastructureId;
        private Float autonomousDataStoragePercentage;
        private Double autonomousDataStorageSizeInTBs;
        private Double availableAutonomousDataStorageSizeInTBs;
        private Integer availableContainerDatabases;
        private Float availableCpus;
        private String computeModel;
        private Integer cpuCoreCount;
        private Integer cpuCoreCountPerNode;
        private Float cpuPercentage;
        private Double dataStorageSizeInGBs;
        private Double dataStorageSizeInTBs;
        private Integer dbNodeStorageSizeInGBs;
        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();
        private String description;
        private String domain;
        private Double exadataStorageInTBsLowestScaledValue;
        private String hostname;
        private String ocid;
        private String ociUrl;
        private Boolean isMtlsEnabledVmCluster;
        private String licenseModel;
        private MaintenanceWindow maintenanceWindow;
        private Integer maxAcdsLowestScaledValue;
        private Integer memoryPerOracleComputeUnitInGBs;
        private Integer memorySizeInGBs;
        private Integer nodeCount;
        private Integer nonProvisionableAutonomousContainerDatabases;
        private Integer provisionableAutonomousContainerDatabases;
        private Integer provisionedAutonomousContainerDatabases;
        private Float provisionedCpus;
        private Float reclaimableCpus;
        private Float reservedCpus;
        private Integer scanListenerPortNonTls;
        private Integer scanListenerPortTls;
        private String shape;
        private Instant createdAt;
        private Instant timeDatabaseSslCertificateExpires;
        private Instant timeOrdsCertificateExpires;
        private String timeZone;
        private Integer totalContainerDatabases;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudAutonomousVmCluster model) {
            this.cloudAutonomousVmClusterId(model.cloudAutonomousVmClusterId);
            this.cloudAutonomousVmClusterArn(model.cloudAutonomousVmClusterArn);
            this.odbNetworkId(model.odbNetworkId);
            this.ociResourceAnchorName(model.ociResourceAnchorName);
            this.percentProgress(model.percentProgress);
            this.displayName(model.displayName);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            this.autonomousDataStoragePercentage(model.autonomousDataStoragePercentage);
            this.autonomousDataStorageSizeInTBs(model.autonomousDataStorageSizeInTBs);
            this.availableAutonomousDataStorageSizeInTBs(model.availableAutonomousDataStorageSizeInTBs);
            this.availableContainerDatabases(model.availableContainerDatabases);
            this.availableCpus(model.availableCpus);
            this.computeModel(model.computeModel);
            this.cpuCoreCount(model.cpuCoreCount);
            this.cpuCoreCountPerNode(model.cpuCoreCountPerNode);
            this.cpuPercentage(model.cpuPercentage);
            this.dataStorageSizeInGBs(model.dataStorageSizeInGBs);
            this.dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            this.dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            this.dbServers(model.dbServers);
            this.description(model.description);
            this.domain(model.domain);
            this.exadataStorageInTBsLowestScaledValue(model.exadataStorageInTBsLowestScaledValue);
            this.hostname(model.hostname);
            this.ocid(model.ocid);
            this.ociUrl(model.ociUrl);
            this.isMtlsEnabledVmCluster(model.isMtlsEnabledVmCluster);
            this.licenseModel(model.licenseModel);
            this.maintenanceWindow(model.maintenanceWindow);
            this.maxAcdsLowestScaledValue(model.maxAcdsLowestScaledValue);
            this.memoryPerOracleComputeUnitInGBs(model.memoryPerOracleComputeUnitInGBs);
            this.memorySizeInGBs(model.memorySizeInGBs);
            this.nodeCount(model.nodeCount);
            this.nonProvisionableAutonomousContainerDatabases(model.nonProvisionableAutonomousContainerDatabases);
            this.provisionableAutonomousContainerDatabases(model.provisionableAutonomousContainerDatabases);
            this.provisionedAutonomousContainerDatabases(model.provisionedAutonomousContainerDatabases);
            this.provisionedCpus(model.provisionedCpus);
            this.reclaimableCpus(model.reclaimableCpus);
            this.reservedCpus(model.reservedCpus);
            this.scanListenerPortNonTls(model.scanListenerPortNonTls);
            this.scanListenerPortTls(model.scanListenerPortTls);
            this.shape(model.shape);
            this.createdAt(model.createdAt);
            this.timeDatabaseSslCertificateExpires(model.timeDatabaseSslCertificateExpires);
            this.timeOrdsCertificateExpires(model.timeOrdsCertificateExpires);
            this.timeZone(model.timeZone);
            this.totalContainerDatabases(model.totalContainerDatabases);
        }

        public final String getCloudAutonomousVmClusterId() {
            return this.cloudAutonomousVmClusterId;
        }

        public final void setCloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
        }

        @Override
        public final Builder cloudAutonomousVmClusterId(String cloudAutonomousVmClusterId) {
            this.cloudAutonomousVmClusterId = cloudAutonomousVmClusterId;
            return this;
        }

        public final String getCloudAutonomousVmClusterArn() {
            return this.cloudAutonomousVmClusterArn;
        }

        public final void setCloudAutonomousVmClusterArn(String cloudAutonomousVmClusterArn) {
            this.cloudAutonomousVmClusterArn = cloudAutonomousVmClusterArn;
        }

        @Override
        public final Builder cloudAutonomousVmClusterArn(String cloudAutonomousVmClusterArn) {
            this.cloudAutonomousVmClusterArn = cloudAutonomousVmClusterArn;
            return this;
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getOciResourceAnchorName() {
            return this.ociResourceAnchorName;
        }

        public final void setOciResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
        }

        @Override
        public final Builder ociResourceAnchorName(String ociResourceAnchorName) {
            this.ociResourceAnchorName = ociResourceAnchorName;
            return this;
        }

        public final Float getPercentProgress() {
            return this.percentProgress;
        }

        public final void setPercentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
        }

        @Override
        public final Builder percentProgress(Float percentProgress) {
            this.percentProgress = percentProgress;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final Float getAutonomousDataStoragePercentage() {
            return this.autonomousDataStoragePercentage;
        }

        public final void setAutonomousDataStoragePercentage(Float autonomousDataStoragePercentage) {
            this.autonomousDataStoragePercentage = autonomousDataStoragePercentage;
        }

        @Override
        public final Builder autonomousDataStoragePercentage(Float autonomousDataStoragePercentage) {
            this.autonomousDataStoragePercentage = autonomousDataStoragePercentage;
            return this;
        }

        public final Double getAutonomousDataStorageSizeInTBs() {
            return this.autonomousDataStorageSizeInTBs;
        }

        public final void setAutonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
        }

        @Override
        public final Builder autonomousDataStorageSizeInTBs(Double autonomousDataStorageSizeInTBs) {
            this.autonomousDataStorageSizeInTBs = autonomousDataStorageSizeInTBs;
            return this;
        }

        public final Double getAvailableAutonomousDataStorageSizeInTBs() {
            return this.availableAutonomousDataStorageSizeInTBs;
        }

        public final void setAvailableAutonomousDataStorageSizeInTBs(Double availableAutonomousDataStorageSizeInTBs) {
            this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
        }

        @Override
        public final Builder availableAutonomousDataStorageSizeInTBs(Double availableAutonomousDataStorageSizeInTBs) {
            this.availableAutonomousDataStorageSizeInTBs = availableAutonomousDataStorageSizeInTBs;
            return this;
        }

        public final Integer getAvailableContainerDatabases() {
            return this.availableContainerDatabases;
        }

        public final void setAvailableContainerDatabases(Integer availableContainerDatabases) {
            this.availableContainerDatabases = availableContainerDatabases;
        }

        @Override
        public final Builder availableContainerDatabases(Integer availableContainerDatabases) {
            this.availableContainerDatabases = availableContainerDatabases;
            return this;
        }

        public final Float getAvailableCpus() {
            return this.availableCpus;
        }

        public final void setAvailableCpus(Float availableCpus) {
            this.availableCpus = availableCpus;
        }

        @Override
        public final Builder availableCpus(Float availableCpus) {
            this.availableCpus = availableCpus;
            return this;
        }

        public final String getComputeModel() {
            return this.computeModel;
        }

        public final void setComputeModel(String computeModel) {
            this.computeModel = computeModel;
        }

        @Override
        public final Builder computeModel(String computeModel) {
            this.computeModel = computeModel;
            return this;
        }

        @Override
        public final Builder computeModel(ComputeModel computeModel) {
            this.computeModel(computeModel == null ? null : computeModel.toString());
            return this;
        }

        public final Integer getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final Integer getCpuCoreCountPerNode() {
            return this.cpuCoreCountPerNode;
        }

        public final void setCpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
        }

        @Override
        public final Builder cpuCoreCountPerNode(Integer cpuCoreCountPerNode) {
            this.cpuCoreCountPerNode = cpuCoreCountPerNode;
            return this;
        }

        public final Float getCpuPercentage() {
            return this.cpuPercentage;
        }

        public final void setCpuPercentage(Float cpuPercentage) {
            this.cpuPercentage = cpuPercentage;
        }

        @Override
        public final Builder cpuPercentage(Float cpuPercentage) {
            this.cpuPercentage = cpuPercentage;
            return this;
        }

        public final Double getDataStorageSizeInGBs() {
            return this.dataStorageSizeInGBs;
        }

        public final void setDataStorageSizeInGBs(Double dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
        }

        @Override
        public final Builder dataStorageSizeInGBs(Double dataStorageSizeInGBs) {
            this.dataStorageSizeInGBs = dataStorageSizeInGBs;
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return this.dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (this.dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String ... dbServers) {
            this.dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public final Double getExadataStorageInTBsLowestScaledValue() {
            return this.exadataStorageInTBsLowestScaledValue;
        }

        public final void setExadataStorageInTBsLowestScaledValue(Double exadataStorageInTBsLowestScaledValue) {
            this.exadataStorageInTBsLowestScaledValue = exadataStorageInTBsLowestScaledValue;
        }

        @Override
        public final Builder exadataStorageInTBsLowestScaledValue(Double exadataStorageInTBsLowestScaledValue) {
            this.exadataStorageInTBsLowestScaledValue = exadataStorageInTBsLowestScaledValue;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getOcid() {
            return this.ocid;
        }

        public final void setOcid(String ocid) {
            this.ocid = ocid;
        }

        @Override
        public final Builder ocid(String ocid) {
            this.ocid = ocid;
            return this;
        }

        public final String getOciUrl() {
            return this.ociUrl;
        }

        public final void setOciUrl(String ociUrl) {
            this.ociUrl = ociUrl;
        }

        @Override
        public final Builder ociUrl(String ociUrl) {
            this.ociUrl = ociUrl;
            return this;
        }

        public final Boolean getIsMtlsEnabledVmCluster() {
            return this.isMtlsEnabledVmCluster;
        }

        public final void setIsMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
        }

        @Override
        public final Builder isMtlsEnabledVmCluster(Boolean isMtlsEnabledVmCluster) {
            this.isMtlsEnabledVmCluster = isMtlsEnabledVmCluster;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final MaintenanceWindow.Builder getMaintenanceWindow() {
            return this.maintenanceWindow != null ? this.maintenanceWindow.toBuilder() : null;
        }

        public final void setMaintenanceWindow(MaintenanceWindow.BuilderImpl maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow != null ? maintenanceWindow.build() : null;
        }

        @Override
        public final Builder maintenanceWindow(MaintenanceWindow maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final Integer getMaxAcdsLowestScaledValue() {
            return this.maxAcdsLowestScaledValue;
        }

        public final void setMaxAcdsLowestScaledValue(Integer maxAcdsLowestScaledValue) {
            this.maxAcdsLowestScaledValue = maxAcdsLowestScaledValue;
        }

        @Override
        public final Builder maxAcdsLowestScaledValue(Integer maxAcdsLowestScaledValue) {
            this.maxAcdsLowestScaledValue = maxAcdsLowestScaledValue;
            return this;
        }

        public final Integer getMemoryPerOracleComputeUnitInGBs() {
            return this.memoryPerOracleComputeUnitInGBs;
        }

        public final void setMemoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
        }

        @Override
        public final Builder memoryPerOracleComputeUnitInGBs(Integer memoryPerOracleComputeUnitInGBs) {
            this.memoryPerOracleComputeUnitInGBs = memoryPerOracleComputeUnitInGBs;
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final Integer getNonProvisionableAutonomousContainerDatabases() {
            return this.nonProvisionableAutonomousContainerDatabases;
        }

        public final void setNonProvisionableAutonomousContainerDatabases(Integer nonProvisionableAutonomousContainerDatabases) {
            this.nonProvisionableAutonomousContainerDatabases = nonProvisionableAutonomousContainerDatabases;
        }

        @Override
        public final Builder nonProvisionableAutonomousContainerDatabases(Integer nonProvisionableAutonomousContainerDatabases) {
            this.nonProvisionableAutonomousContainerDatabases = nonProvisionableAutonomousContainerDatabases;
            return this;
        }

        public final Integer getProvisionableAutonomousContainerDatabases() {
            return this.provisionableAutonomousContainerDatabases;
        }

        public final void setProvisionableAutonomousContainerDatabases(Integer provisionableAutonomousContainerDatabases) {
            this.provisionableAutonomousContainerDatabases = provisionableAutonomousContainerDatabases;
        }

        @Override
        public final Builder provisionableAutonomousContainerDatabases(Integer provisionableAutonomousContainerDatabases) {
            this.provisionableAutonomousContainerDatabases = provisionableAutonomousContainerDatabases;
            return this;
        }

        public final Integer getProvisionedAutonomousContainerDatabases() {
            return this.provisionedAutonomousContainerDatabases;
        }

        public final void setProvisionedAutonomousContainerDatabases(Integer provisionedAutonomousContainerDatabases) {
            this.provisionedAutonomousContainerDatabases = provisionedAutonomousContainerDatabases;
        }

        @Override
        public final Builder provisionedAutonomousContainerDatabases(Integer provisionedAutonomousContainerDatabases) {
            this.provisionedAutonomousContainerDatabases = provisionedAutonomousContainerDatabases;
            return this;
        }

        public final Float getProvisionedCpus() {
            return this.provisionedCpus;
        }

        public final void setProvisionedCpus(Float provisionedCpus) {
            this.provisionedCpus = provisionedCpus;
        }

        @Override
        public final Builder provisionedCpus(Float provisionedCpus) {
            this.provisionedCpus = provisionedCpus;
            return this;
        }

        public final Float getReclaimableCpus() {
            return this.reclaimableCpus;
        }

        public final void setReclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
        }

        @Override
        public final Builder reclaimableCpus(Float reclaimableCpus) {
            this.reclaimableCpus = reclaimableCpus;
            return this;
        }

        public final Float getReservedCpus() {
            return this.reservedCpus;
        }

        public final void setReservedCpus(Float reservedCpus) {
            this.reservedCpus = reservedCpus;
        }

        @Override
        public final Builder reservedCpus(Float reservedCpus) {
            this.reservedCpus = reservedCpus;
            return this;
        }

        public final Integer getScanListenerPortNonTls() {
            return this.scanListenerPortNonTls;
        }

        public final void setScanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
        }

        @Override
        public final Builder scanListenerPortNonTls(Integer scanListenerPortNonTls) {
            this.scanListenerPortNonTls = scanListenerPortNonTls;
            return this;
        }

        public final Integer getScanListenerPortTls() {
            return this.scanListenerPortTls;
        }

        public final void setScanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
        }

        @Override
        public final Builder scanListenerPortTls(Integer scanListenerPortTls) {
            this.scanListenerPortTls = scanListenerPortTls;
            return this;
        }

        public final String getShape() {
            return this.shape;
        }

        public final void setShape(String shape) {
            this.shape = shape;
        }

        @Override
        public final Builder shape(String shape) {
            this.shape = shape;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getTimeDatabaseSslCertificateExpires() {
            return this.timeDatabaseSslCertificateExpires;
        }

        public final void setTimeDatabaseSslCertificateExpires(Instant timeDatabaseSslCertificateExpires) {
            this.timeDatabaseSslCertificateExpires = timeDatabaseSslCertificateExpires;
        }

        @Override
        public final Builder timeDatabaseSslCertificateExpires(Instant timeDatabaseSslCertificateExpires) {
            this.timeDatabaseSslCertificateExpires = timeDatabaseSslCertificateExpires;
            return this;
        }

        public final Instant getTimeOrdsCertificateExpires() {
            return this.timeOrdsCertificateExpires;
        }

        public final void setTimeOrdsCertificateExpires(Instant timeOrdsCertificateExpires) {
            this.timeOrdsCertificateExpires = timeOrdsCertificateExpires;
        }

        @Override
        public final Builder timeOrdsCertificateExpires(Instant timeOrdsCertificateExpires) {
            this.timeOrdsCertificateExpires = timeOrdsCertificateExpires;
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final Integer getTotalContainerDatabases() {
            return this.totalContainerDatabases;
        }

        public final void setTotalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
        }

        @Override
        public final Builder totalContainerDatabases(Integer totalContainerDatabases) {
            this.totalContainerDatabases = totalContainerDatabases;
            return this;
        }

        public CloudAutonomousVmCluster build() {
            return new CloudAutonomousVmCluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CloudAutonomousVmCluster> {
        public Builder cloudAutonomousVmClusterId(String var1);

        public Builder cloudAutonomousVmClusterArn(String var1);

        public Builder odbNetworkId(String var1);

        public Builder ociResourceAnchorName(String var1);

        public Builder percentProgress(Float var1);

        public Builder displayName(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder cloudExadataInfrastructureId(String var1);

        public Builder autonomousDataStoragePercentage(Float var1);

        public Builder autonomousDataStorageSizeInTBs(Double var1);

        public Builder availableAutonomousDataStorageSizeInTBs(Double var1);

        public Builder availableContainerDatabases(Integer var1);

        public Builder availableCpus(Float var1);

        public Builder computeModel(String var1);

        public Builder computeModel(ComputeModel var1);

        public Builder cpuCoreCount(Integer var1);

        public Builder cpuCoreCountPerNode(Integer var1);

        public Builder cpuPercentage(Float var1);

        public Builder dataStorageSizeInGBs(Double var1);

        public Builder dataStorageSizeInTBs(Double var1);

        public Builder dbNodeStorageSizeInGBs(Integer var1);

        public Builder dbServers(Collection<String> var1);

        public Builder dbServers(String ... var1);

        public Builder description(String var1);

        public Builder domain(String var1);

        public Builder exadataStorageInTBsLowestScaledValue(Double var1);

        public Builder hostname(String var1);

        public Builder ocid(String var1);

        public Builder ociUrl(String var1);

        public Builder isMtlsEnabledVmCluster(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder licenseModel(LicenseModel var1);

        public Builder maintenanceWindow(MaintenanceWindow var1);

        default public Builder maintenanceWindow(Consumer<MaintenanceWindow.Builder> maintenanceWindow) {
            return this.maintenanceWindow((MaintenanceWindow)((MaintenanceWindow.Builder)MaintenanceWindow.builder().applyMutation(maintenanceWindow)).build());
        }

        public Builder maxAcdsLowestScaledValue(Integer var1);

        public Builder memoryPerOracleComputeUnitInGBs(Integer var1);

        public Builder memorySizeInGBs(Integer var1);

        public Builder nodeCount(Integer var1);

        public Builder nonProvisionableAutonomousContainerDatabases(Integer var1);

        public Builder provisionableAutonomousContainerDatabases(Integer var1);

        public Builder provisionedAutonomousContainerDatabases(Integer var1);

        public Builder provisionedCpus(Float var1);

        public Builder reclaimableCpus(Float var1);

        public Builder reservedCpus(Float var1);

        public Builder scanListenerPortNonTls(Integer var1);

        public Builder scanListenerPortTls(Integer var1);

        public Builder shape(String var1);

        public Builder createdAt(Instant var1);

        public Builder timeDatabaseSslCertificateExpires(Instant var1);

        public Builder timeOrdsCertificateExpires(Instant var1);

        public Builder timeZone(String var1);

        public Builder totalContainerDatabases(Integer var1);
    }
}

