/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.observabilityadmin.model.ResourceType;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetrySourceType;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetrySourceTypesCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryRuleSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryRuleSummary> {
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(TelemetryRuleSummary.getter(TelemetryRuleSummary::ruleName)).setter(TelemetryRuleSummary.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(TelemetryRuleSummary.getter(TelemetryRuleSummary::ruleArn)).setter(TelemetryRuleSummary.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreatedTimeStamp").getter(TelemetryRuleSummary.getter(TelemetryRuleSummary::createdTimeStamp)).setter(TelemetryRuleSummary.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastUpdateTimeStamp").getter(TelemetryRuleSummary.getter(TelemetryRuleSummary::lastUpdateTimeStamp)).setter(TelemetryRuleSummary.setter(Builder::lastUpdateTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(TelemetryRuleSummary.getter(TelemetryRuleSummary::resourceTypeAsString)).setter(TelemetryRuleSummary.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> TELEMETRY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TelemetryType").getter(TelemetryRuleSummary.getter(TelemetryRuleSummary::telemetryTypeAsString)).setter(TelemetryRuleSummary.setter(Builder::telemetryType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryType").build()}).build();
    private static final SdkField<List<String>> TELEMETRY_SOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TelemetrySourceTypes").getter(TelemetryRuleSummary.getter(TelemetryRuleSummary::telemetrySourceTypesAsStrings)).setter(TelemetryRuleSummary.setter(Builder::telemetrySourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetrySourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_FIELD, RULE_ARN_FIELD, CREATED_TIME_STAMP_FIELD, LAST_UPDATE_TIME_STAMP_FIELD, RESOURCE_TYPE_FIELD, TELEMETRY_TYPE_FIELD, TELEMETRY_SOURCE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TelemetryRuleSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ruleName;
    private final String ruleArn;
    private final Long createdTimeStamp;
    private final Long lastUpdateTimeStamp;
    private final String resourceType;
    private final String telemetryType;
    private final List<String> telemetrySourceTypes;

    private TelemetryRuleSummary(BuilderImpl builder) {
        this.ruleName = builder.ruleName;
        this.ruleArn = builder.ruleArn;
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.resourceType = builder.resourceType;
        this.telemetryType = builder.telemetryType;
        this.telemetrySourceTypes = builder.telemetrySourceTypes;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final Long createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public final Long lastUpdateTimeStamp() {
        return this.lastUpdateTimeStamp;
    }

    public final ResourceType resourceType() {
        return ResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final TelemetryType telemetryType() {
        return TelemetryType.fromValue(this.telemetryType);
    }

    public final String telemetryTypeAsString() {
        return this.telemetryType;
    }

    public final List<TelemetrySourceType> telemetrySourceTypes() {
        return TelemetrySourceTypesCopier.copyStringToEnum(this.telemetrySourceTypes);
    }

    public final boolean hasTelemetrySourceTypes() {
        return this.telemetrySourceTypes != null && !(this.telemetrySourceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> telemetrySourceTypesAsStrings() {
        return this.telemetrySourceTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.telemetryTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTelemetrySourceTypes() ? this.telemetrySourceTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryRuleSummary)) {
            return false;
        }
        TelemetryRuleSummary other = (TelemetryRuleSummary)obj;
        return Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(this.lastUpdateTimeStamp(), other.lastUpdateTimeStamp()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.telemetryTypeAsString(), other.telemetryTypeAsString()) && this.hasTelemetrySourceTypes() == other.hasTelemetrySourceTypes() && Objects.equals(this.telemetrySourceTypesAsStrings(), other.telemetrySourceTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"TelemetryRuleSummary").add("RuleName", (Object)this.ruleName()).add("RuleArn", (Object)this.ruleArn()).add("CreatedTimeStamp", (Object)this.createdTimeStamp()).add("LastUpdateTimeStamp", (Object)this.lastUpdateTimeStamp()).add("ResourceType", (Object)this.resourceTypeAsString()).add("TelemetryType", (Object)this.telemetryTypeAsString()).add("TelemetrySourceTypes", this.hasTelemetrySourceTypes() ? this.telemetrySourceTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
            case "LastUpdateTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimeStamp()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "TelemetryType": {
                return Optional.ofNullable(clazz.cast(this.telemetryTypeAsString()));
            }
            case "TelemetrySourceTypes": {
                return Optional.ofNullable(clazz.cast(this.telemetrySourceTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("TelemetryType", TELEMETRY_TYPE_FIELD);
        map.put("TelemetrySourceTypes", TELEMETRY_SOURCE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryRuleSummary, T> g) {
        return obj -> g.apply((TelemetryRuleSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ruleName;
        private String ruleArn;
        private Long createdTimeStamp;
        private Long lastUpdateTimeStamp;
        private String resourceType;
        private String telemetryType;
        private List<String> telemetrySourceTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryRuleSummary model) {
            this.ruleName(model.ruleName);
            this.ruleArn(model.ruleArn);
            this.createdTimeStamp(model.createdTimeStamp);
            this.lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            this.resourceType(model.resourceType);
            this.telemetryType(model.telemetryType);
            this.telemetrySourceTypesWithStrings(model.telemetrySourceTypes);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final Long getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return this.lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getTelemetryType() {
            return this.telemetryType;
        }

        public final void setTelemetryType(String telemetryType) {
            this.telemetryType = telemetryType;
        }

        @Override
        public final Builder telemetryType(String telemetryType) {
            this.telemetryType = telemetryType;
            return this;
        }

        @Override
        public final Builder telemetryType(TelemetryType telemetryType) {
            this.telemetryType(telemetryType == null ? null : telemetryType.toString());
            return this;
        }

        public final Collection<String> getTelemetrySourceTypes() {
            if (this.telemetrySourceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.telemetrySourceTypes;
        }

        public final void setTelemetrySourceTypes(Collection<String> telemetrySourceTypes) {
            this.telemetrySourceTypes = TelemetrySourceTypesCopier.copy(telemetrySourceTypes);
        }

        @Override
        public final Builder telemetrySourceTypesWithStrings(Collection<String> telemetrySourceTypes) {
            this.telemetrySourceTypes = TelemetrySourceTypesCopier.copy(telemetrySourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetrySourceTypesWithStrings(String ... telemetrySourceTypes) {
            this.telemetrySourceTypesWithStrings(Arrays.asList(telemetrySourceTypes));
            return this;
        }

        @Override
        public final Builder telemetrySourceTypes(Collection<TelemetrySourceType> telemetrySourceTypes) {
            this.telemetrySourceTypes = TelemetrySourceTypesCopier.copyEnumToString(telemetrySourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetrySourceTypes(TelemetrySourceType ... telemetrySourceTypes) {
            this.telemetrySourceTypes(Arrays.asList(telemetrySourceTypes));
            return this;
        }

        public TelemetryRuleSummary build() {
            return new TelemetryRuleSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryRuleSummary> {
        public Builder ruleName(String var1);

        public Builder ruleArn(String var1);

        public Builder createdTimeStamp(Long var1);

        public Builder lastUpdateTimeStamp(Long var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ResourceType var1);

        public Builder telemetryType(String var1);

        public Builder telemetryType(TelemetryType var1);

        public Builder telemetrySourceTypesWithStrings(Collection<String> var1);

        public Builder telemetrySourceTypesWithStrings(String ... var1);

        public Builder telemetrySourceTypes(Collection<TelemetrySourceType> var1);

        public Builder telemetrySourceTypes(TelemetrySourceType ... var1);
    }
}

