/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.observabilityadmin.model.ConfigurationSummary;
import software.amazon.awssdk.services.observabilityadmin.model.TagMapOutputCopier;
import software.amazon.awssdk.services.observabilityadmin.model.TelemetryPipelineStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TelemetryPipelineSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TelemetryPipelineSummary> {
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("CreatedTimeStamp").getter(TelemetryPipelineSummary.getter(TelemetryPipelineSummary::createdTimeStamp)).setter(TelemetryPipelineSummary.setter(Builder::createdTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()}).build();
    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("LastUpdateTimeStamp").getter(TelemetryPipelineSummary.getter(TelemetryPipelineSummary::lastUpdateTimeStamp)).setter(TelemetryPipelineSummary.setter(Builder::lastUpdateTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(TelemetryPipelineSummary.getter(TelemetryPipelineSummary::arn)).setter(TelemetryPipelineSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(TelemetryPipelineSummary.getter(TelemetryPipelineSummary::name)).setter(TelemetryPipelineSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(TelemetryPipelineSummary.getter(TelemetryPipelineSummary::statusAsString)).setter(TelemetryPipelineSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(TelemetryPipelineSummary.getter(TelemetryPipelineSummary::tags)).setter(TelemetryPipelineSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConfigurationSummary> CONFIGURATION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationSummary").getter(TelemetryPipelineSummary.getter(TelemetryPipelineSummary::configurationSummary)).setter(TelemetryPipelineSummary.setter(Builder::configurationSummary)).constructor(ConfigurationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSummary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_STAMP_FIELD, LAST_UPDATE_TIME_STAMP_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD, CONFIGURATION_SUMMARY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TelemetryPipelineSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Long createdTimeStamp;
    private final Long lastUpdateTimeStamp;
    private final String arn;
    private final String name;
    private final String status;
    private final Map<String, String> tags;
    private final ConfigurationSummary configurationSummary;

    private TelemetryPipelineSummary(BuilderImpl builder) {
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
        this.configurationSummary = builder.configurationSummary;
    }

    public final Long createdTimeStamp() {
        return this.createdTimeStamp;
    }

    public final Long lastUpdateTimeStamp() {
        return this.lastUpdateTimeStamp;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final TelemetryPipelineStatus status() {
        return TelemetryPipelineStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ConfigurationSummary configurationSummary() {
        return this.configurationSummary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSummary());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryPipelineSummary)) {
            return false;
        }
        TelemetryPipelineSummary other = (TelemetryPipelineSummary)obj;
        return Objects.equals(this.createdTimeStamp(), other.createdTimeStamp()) && Objects.equals(this.lastUpdateTimeStamp(), other.lastUpdateTimeStamp()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.configurationSummary(), other.configurationSummary());
    }

    public final String toString() {
        return ToString.builder((String)"TelemetryPipelineSummary").add("CreatedTimeStamp", (Object)this.createdTimeStamp()).add("LastUpdateTimeStamp", (Object)this.lastUpdateTimeStamp()).add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("ConfigurationSummary", (Object)this.configurationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.createdTimeStamp()));
            }
            case "LastUpdateTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateTimeStamp()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ConfigurationSummary": {
                return Optional.ofNullable(clazz.cast(this.configurationSummary()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ConfigurationSummary", CONFIGURATION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryPipelineSummary, T> g) {
        return obj -> g.apply((TelemetryPipelineSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long createdTimeStamp;
        private Long lastUpdateTimeStamp;
        private String arn;
        private String name;
        private String status;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ConfigurationSummary configurationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryPipelineSummary model) {
            this.createdTimeStamp(model.createdTimeStamp);
            this.lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            this.arn(model.arn);
            this.name(model.name);
            this.status(model.status);
            this.tags(model.tags);
            this.configurationSummary(model.configurationSummary);
        }

        public final Long getCreatedTimeStamp() {
            return this.createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return this.lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
            return this;
        }

        public final ConfigurationSummary.Builder getConfigurationSummary() {
            return this.configurationSummary != null ? this.configurationSummary.toBuilder() : null;
        }

        public final void setConfigurationSummary(ConfigurationSummary.BuilderImpl configurationSummary) {
            this.configurationSummary = configurationSummary != null ? configurationSummary.build() : null;
        }

        @Override
        public final Builder configurationSummary(ConfigurationSummary configurationSummary) {
            this.configurationSummary = configurationSummary;
            return this;
        }

        public TelemetryPipelineSummary build() {
            return new TelemetryPipelineSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TelemetryPipelineSummary> {
        public Builder createdTimeStamp(Long var1);

        public Builder lastUpdateTimeStamp(Long var1);

        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(TelemetryPipelineStatus var1);

        public Builder tags(Map<String, String> var1);

        public Builder configurationSummary(ConfigurationSummary var1);

        default public Builder configurationSummary(Consumer<ConfigurationSummary.Builder> configurationSummary) {
            return this.configurationSummary((ConfigurationSummary)((ConfigurationSummary.Builder)ConfigurationSummary.builder().applyMutation(configurationSummary)).build());
        }
    }
}

