/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a detailed validation error with message, reason, and field mapping for comprehensive error reporting.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationError implements SdkPojo, Serializable, ToCopyableBuilder<ValidationError.Builder, ValidationError> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ValidationError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ValidationError::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<Map<String, String>> FIELD_MAP_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("FieldMap")
            .getter(getter(ValidationError::fieldMap))
            .setter(setter(Builder::fieldMap))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldMap").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, REASON_FIELD,
            FIELD_MAP_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final String reason;

    private final Map<String, String> fieldMap;

    private ValidationError(BuilderImpl builder) {
        this.message = builder.message;
        this.reason = builder.reason;
        this.fieldMap = builder.fieldMap;
    }

    /**
     * <p>
     * The error message describing the validation issue.
     * </p>
     * 
     * @return The error message describing the validation issue.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The reason code or category for the validation error.
     * </p>
     * 
     * @return The reason code or category for the validation error.
     */
    public final String reason() {
        return reason;
    }

    /**
     * For responses, this returns true if the service returned a value for the FieldMap property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFieldMap() {
        return fieldMap != null && !(fieldMap instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A mapping of field names to specific validation issues within the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFieldMap} method.
     * </p>
     * 
     * @return A mapping of field names to specific validation issues within the configuration.
     */
    public final Map<String, String> fieldMap() {
        return fieldMap;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(hasFieldMap() ? fieldMap() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(reason(), other.reason())
                && hasFieldMap() == other.hasFieldMap() && Objects.equals(fieldMap(), other.fieldMap());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationError").add("Message", message()).add("Reason", reason())
                .add("FieldMap", hasFieldMap() ? fieldMap() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "FieldMap":
            return Optional.ofNullable(clazz.cast(fieldMap()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Message", MESSAGE_FIELD);
        map.put("Reason", REASON_FIELD);
        map.put("FieldMap", FIELD_MAP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationError, T> g) {
        return obj -> g.apply((ValidationError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationError> {
        /**
         * <p>
         * The error message describing the validation issue.
         * </p>
         * 
         * @param message
         *        The error message describing the validation issue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The reason code or category for the validation error.
         * </p>
         * 
         * @param reason
         *        The reason code or category for the validation error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * A mapping of field names to specific validation issues within the configuration.
         * </p>
         * 
         * @param fieldMap
         *        A mapping of field names to specific validation issues within the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldMap(Map<String, String> fieldMap);
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private String reason;

        private Map<String, String> fieldMap = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationError model) {
            message(model.message);
            reason(model.reason);
            fieldMap(model.fieldMap);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final Map<String, String> getFieldMap() {
            if (fieldMap instanceof SdkAutoConstructMap) {
                return null;
            }
            return fieldMap;
        }

        public final void setFieldMap(Map<String, String> fieldMap) {
            this.fieldMap = FieldMapCopier.copy(fieldMap);
        }

        @Override
        public final Builder fieldMap(Map<String, String> fieldMap) {
            this.fieldMap = FieldMapCopier.copy(fieldMap);
            return this;
        }

        @Override
        public ValidationError build() {
            return new ValidationError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
