/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration parameters specific to VPC Flow Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VPCFlowLogParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<VPCFlowLogParameters.Builder, VPCFlowLogParameters> {
    private static final SdkField<String> LOG_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogFormat").getter(getter(VPCFlowLogParameters::logFormat)).setter(setter(Builder::logFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFormat").build()).build();

    private static final SdkField<String> TRAFFIC_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TrafficType").getter(getter(VPCFlowLogParameters::trafficType)).setter(setter(Builder::trafficType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficType").build()).build();

    private static final SdkField<Integer> MAX_AGGREGATION_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAggregationInterval").getter(getter(VPCFlowLogParameters::maxAggregationInterval))
            .setter(setter(Builder::maxAggregationInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAggregationInterval").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_FORMAT_FIELD,
            TRAFFIC_TYPE_FIELD, MAX_AGGREGATION_INTERVAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logFormat;

    private final String trafficType;

    private final Integer maxAggregationInterval;

    private VPCFlowLogParameters(BuilderImpl builder) {
        this.logFormat = builder.logFormat;
        this.trafficType = builder.trafficType;
        this.maxAggregationInterval = builder.maxAggregationInterval;
    }

    /**
     * <p>
     * The format in which VPC Flow Log entries should be logged.
     * </p>
     * 
     * @return The format in which VPC Flow Log entries should be logged.
     */
    public final String logFormat() {
        return logFormat;
    }

    /**
     * <p>
     * The type of traffic to log (ACCEPT, REJECT, or ALL).
     * </p>
     * 
     * @return The type of traffic to log (ACCEPT, REJECT, or ALL).
     */
    public final String trafficType() {
        return trafficType;
    }

    /**
     * <p>
     * The maximum interval in seconds between the capture of flow log records.
     * </p>
     * 
     * @return The maximum interval in seconds between the capture of flow log records.
     */
    public final Integer maxAggregationInterval() {
        return maxAggregationInterval;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logFormat());
        hashCode = 31 * hashCode + Objects.hashCode(trafficType());
        hashCode = 31 * hashCode + Objects.hashCode(maxAggregationInterval());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VPCFlowLogParameters)) {
            return false;
        }
        VPCFlowLogParameters other = (VPCFlowLogParameters) obj;
        return Objects.equals(logFormat(), other.logFormat()) && Objects.equals(trafficType(), other.trafficType())
                && Objects.equals(maxAggregationInterval(), other.maxAggregationInterval());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VPCFlowLogParameters").add("LogFormat", logFormat()).add("TrafficType", trafficType())
                .add("MaxAggregationInterval", maxAggregationInterval()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogFormat":
            return Optional.ofNullable(clazz.cast(logFormat()));
        case "TrafficType":
            return Optional.ofNullable(clazz.cast(trafficType()));
        case "MaxAggregationInterval":
            return Optional.ofNullable(clazz.cast(maxAggregationInterval()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogFormat", LOG_FORMAT_FIELD);
        map.put("TrafficType", TRAFFIC_TYPE_FIELD);
        map.put("MaxAggregationInterval", MAX_AGGREGATION_INTERVAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VPCFlowLogParameters, T> g) {
        return obj -> g.apply((VPCFlowLogParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VPCFlowLogParameters> {
        /**
         * <p>
         * The format in which VPC Flow Log entries should be logged.
         * </p>
         * 
         * @param logFormat
         *        The format in which VPC Flow Log entries should be logged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logFormat(String logFormat);

        /**
         * <p>
         * The type of traffic to log (ACCEPT, REJECT, or ALL).
         * </p>
         * 
         * @param trafficType
         *        The type of traffic to log (ACCEPT, REJECT, or ALL).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trafficType(String trafficType);

        /**
         * <p>
         * The maximum interval in seconds between the capture of flow log records.
         * </p>
         * 
         * @param maxAggregationInterval
         *        The maximum interval in seconds between the capture of flow log records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAggregationInterval(Integer maxAggregationInterval);
    }

    static final class BuilderImpl implements Builder {
        private String logFormat;

        private String trafficType;

        private Integer maxAggregationInterval;

        private BuilderImpl() {
        }

        private BuilderImpl(VPCFlowLogParameters model) {
            logFormat(model.logFormat);
            trafficType(model.trafficType);
            maxAggregationInterval(model.maxAggregationInterval);
        }

        public final String getLogFormat() {
            return logFormat;
        }

        public final void setLogFormat(String logFormat) {
            this.logFormat = logFormat;
        }

        @Override
        public final Builder logFormat(String logFormat) {
            this.logFormat = logFormat;
            return this;
        }

        public final String getTrafficType() {
            return trafficType;
        }

        public final void setTrafficType(String trafficType) {
            this.trafficType = trafficType;
        }

        @Override
        public final Builder trafficType(String trafficType) {
            this.trafficType = trafficType;
            return this;
        }

        public final Integer getMaxAggregationInterval() {
            return maxAggregationInterval;
        }

        public final void setMaxAggregationInterval(Integer maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
        }

        @Override
        public final Builder maxAggregationInterval(Integer maxAggregationInterval) {
            this.maxAggregationInterval = maxAggregationInterval;
            return this;
        }

        @Override
        public VPCFlowLogParameters build() {
            return new VPCFlowLogParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
