/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestTelemetryPipelineRequest extends ObservabilityAdminRequest implements
        ToCopyableBuilder<TestTelemetryPipelineRequest.Builder, TestTelemetryPipelineRequest> {
    private static final SdkField<List<Record>> RECORDS_FIELD = SdkField
            .<List<Record>> builder(MarshallingType.LIST)
            .memberName("Records")
            .getter(getter(TestTelemetryPipelineRequest::records))
            .setter(setter(Builder::records))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Records").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Record> builder(MarshallingType.SDK_POJO)
                                            .constructor(Record::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TelemetryPipelineConfiguration> CONFIGURATION_FIELD = SdkField
            .<TelemetryPipelineConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(TestTelemetryPipelineRequest::configuration)).setter(setter(Builder::configuration))
            .constructor(TelemetryPipelineConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORDS_FIELD,
            CONFIGURATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Record> records;

    private final TelemetryPipelineConfiguration configuration;

    private TestTelemetryPipelineRequest(BuilderImpl builder) {
        super(builder);
        this.records = builder.records;
        this.configuration = builder.configuration;
    }

    /**
     * For responses, this returns true if the service returned a value for the Records property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRecords() {
        return records != null && !(records instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sample records to process through the pipeline configuration for testing purposes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecords} method.
     * </p>
     * 
     * @return The sample records to process through the pipeline configuration for testing purposes.
     */
    public final List<Record> records() {
        return records;
    }

    /**
     * <p>
     * The pipeline configuration to test with the provided sample records.
     * </p>
     * 
     * @return The pipeline configuration to test with the provided sample records.
     */
    public final TelemetryPipelineConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasRecords() ? records() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestTelemetryPipelineRequest)) {
            return false;
        }
        TestTelemetryPipelineRequest other = (TestTelemetryPipelineRequest) obj;
        return hasRecords() == other.hasRecords() && Objects.equals(records(), other.records())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestTelemetryPipelineRequest").add("Records", hasRecords() ? records() : null)
                .add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Records":
            return Optional.ofNullable(clazz.cast(records()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Records", RECORDS_FIELD);
        map.put("Configuration", CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestTelemetryPipelineRequest, T> g) {
        return obj -> g.apply((TestTelemetryPipelineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, TestTelemetryPipelineRequest> {
        /**
         * <p>
         * The sample records to process through the pipeline configuration for testing purposes.
         * </p>
         * 
         * @param records
         *        The sample records to process through the pipeline configuration for testing purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Collection<Record> records);

        /**
         * <p>
         * The sample records to process through the pipeline configuration for testing purposes.
         * </p>
         * 
         * @param records
         *        The sample records to process through the pipeline configuration for testing purposes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder records(Record... records);

        /**
         * <p>
         * The sample records to process through the pipeline configuration for testing purposes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.observabilityadmin.model.Record.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.observabilityadmin.model.Record#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.observabilityadmin.model.Record.Builder#build()} is called immediately
         * and its result is passed to {@link #records(List<Record>)}.
         * 
         * @param records
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.observabilityadmin.model.Record.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #records(java.util.Collection<Record>)
         */
        Builder records(Consumer<Record.Builder>... records);

        /**
         * <p>
         * The pipeline configuration to test with the provided sample records.
         * </p>
         * 
         * @param configuration
         *        The pipeline configuration to test with the provided sample records.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(TelemetryPipelineConfiguration configuration);

        /**
         * <p>
         * The pipeline configuration to test with the provided sample records.
         * </p>
         * This is a convenience method that creates an instance of the {@link TelemetryPipelineConfiguration.Builder}
         * avoiding the need to create one manually via {@link TelemetryPipelineConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TelemetryPipelineConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(TelemetryPipelineConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link TelemetryPipelineConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(TelemetryPipelineConfiguration)
         */
        default Builder configuration(Consumer<TelemetryPipelineConfiguration.Builder> configuration) {
            return configuration(TelemetryPipelineConfiguration.builder().applyMutation(configuration).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ObservabilityAdminRequest.BuilderImpl implements Builder {
        private List<Record> records = DefaultSdkAutoConstructList.getInstance();

        private TelemetryPipelineConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(TestTelemetryPipelineRequest model) {
            super(model);
            records(model.records);
            configuration(model.configuration);
        }

        public final List<Record.Builder> getRecords() {
            List<Record.Builder> result = RecordsCopier.copyToBuilder(this.records);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecords(Collection<Record.BuilderImpl> records) {
            this.records = RecordsCopier.copyFromBuilder(records);
        }

        @Override
        public final Builder records(Collection<Record> records) {
            this.records = RecordsCopier.copy(records);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Record... records) {
            records(Arrays.asList(records));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder records(Consumer<Record.Builder>... records) {
            records(Stream.of(records).map(c -> Record.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TelemetryPipelineConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        public final void setConfiguration(TelemetryPipelineConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(TelemetryPipelineConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public TestTelemetryPipelineRequest build() {
            return new TestTelemetryPipelineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
