/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about a telemetry pipeline for listing operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TelemetryPipelineSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TelemetryPipelineSummary.Builder, TelemetryPipelineSummary> {
    private static final SdkField<Long> CREATED_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("CreatedTimeStamp").getter(getter(TelemetryPipelineSummary::createdTimeStamp))
            .setter(setter(Builder::createdTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTimeStamp").build()).build();

    private static final SdkField<Long> LAST_UPDATE_TIME_STAMP_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LastUpdateTimeStamp").getter(getter(TelemetryPipelineSummary::lastUpdateTimeStamp))
            .setter(setter(Builder::lastUpdateTimeStamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateTimeStamp").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TelemetryPipelineSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(TelemetryPipelineSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(TelemetryPipelineSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(TelemetryPipelineSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<ConfigurationSummary> CONFIGURATION_SUMMARY_FIELD = SdkField
            .<ConfigurationSummary> builder(MarshallingType.SDK_POJO).memberName("ConfigurationSummary")
            .getter(getter(TelemetryPipelineSummary::configurationSummary)).setter(setter(Builder::configurationSummary))
            .constructor(ConfigurationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_TIME_STAMP_FIELD,
            LAST_UPDATE_TIME_STAMP_FIELD, ARN_FIELD, NAME_FIELD, STATUS_FIELD, TAGS_FIELD, CONFIGURATION_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long createdTimeStamp;

    private final Long lastUpdateTimeStamp;

    private final String arn;

    private final String name;

    private final String status;

    private final Map<String, String> tags;

    private final ConfigurationSummary configurationSummary;

    private TelemetryPipelineSummary(BuilderImpl builder) {
        this.createdTimeStamp = builder.createdTimeStamp;
        this.lastUpdateTimeStamp = builder.lastUpdateTimeStamp;
        this.arn = builder.arn;
        this.name = builder.name;
        this.status = builder.status;
        this.tags = builder.tags;
        this.configurationSummary = builder.configurationSummary;
    }

    /**
     * <p>
     * The timestamp when the telemetry pipeline was created.
     * </p>
     * 
     * @return The timestamp when the telemetry pipeline was created.
     */
    public final Long createdTimeStamp() {
        return createdTimeStamp;
    }

    /**
     * <p>
     * The timestamp when the telemetry pipeline was last updated.
     * </p>
     * 
     * @return The timestamp when the telemetry pipeline was last updated.
     */
    public final Long lastUpdateTimeStamp() {
        return lastUpdateTimeStamp;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the telemetry pipeline.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the telemetry pipeline.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the telemetry pipeline.
     * </p>
     * 
     * @return The name of the telemetry pipeline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the telemetry pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the telemetry pipeline.
     * @see TelemetryPipelineStatus
     */
    public final TelemetryPipelineStatus status() {
        return TelemetryPipelineStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the telemetry pipeline.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TelemetryPipelineStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the telemetry pipeline.
     * @see TelemetryPipelineStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The key-value pairs associated with the telemetry pipeline resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The key-value pairs associated with the telemetry pipeline resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * A summary of the pipeline configuration components.
     * </p>
     * 
     * @return A summary of the pipeline configuration components.
     */
    public final ConfigurationSummary configurationSummary() {
        return configurationSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTimeStamp());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(configurationSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TelemetryPipelineSummary)) {
            return false;
        }
        TelemetryPipelineSummary other = (TelemetryPipelineSummary) obj;
        return Objects.equals(createdTimeStamp(), other.createdTimeStamp())
                && Objects.equals(lastUpdateTimeStamp(), other.lastUpdateTimeStamp()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(configurationSummary(), other.configurationSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TelemetryPipelineSummary").add("CreatedTimeStamp", createdTimeStamp())
                .add("LastUpdateTimeStamp", lastUpdateTimeStamp()).add("Arn", arn()).add("Name", name())
                .add("Status", statusAsString()).add("Tags", hasTags() ? tags() : null)
                .add("ConfigurationSummary", configurationSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreatedTimeStamp":
            return Optional.ofNullable(clazz.cast(createdTimeStamp()));
        case "LastUpdateTimeStamp":
            return Optional.ofNullable(clazz.cast(lastUpdateTimeStamp()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "ConfigurationSummary":
            return Optional.ofNullable(clazz.cast(configurationSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreatedTimeStamp", CREATED_TIME_STAMP_FIELD);
        map.put("LastUpdateTimeStamp", LAST_UPDATE_TIME_STAMP_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("ConfigurationSummary", CONFIGURATION_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TelemetryPipelineSummary, T> g) {
        return obj -> g.apply((TelemetryPipelineSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TelemetryPipelineSummary> {
        /**
         * <p>
         * The timestamp when the telemetry pipeline was created.
         * </p>
         * 
         * @param createdTimeStamp
         *        The timestamp when the telemetry pipeline was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTimeStamp(Long createdTimeStamp);

        /**
         * <p>
         * The timestamp when the telemetry pipeline was last updated.
         * </p>
         * 
         * @param lastUpdateTimeStamp
         *        The timestamp when the telemetry pipeline was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the telemetry pipeline.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the telemetry pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the telemetry pipeline.
         * </p>
         * 
         * @param name
         *        The name of the telemetry pipeline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the telemetry pipeline.
         * </p>
         * 
         * @param status
         *        The current status of the telemetry pipeline.
         * @see TelemetryPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryPipelineStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the telemetry pipeline.
         * </p>
         * 
         * @param status
         *        The current status of the telemetry pipeline.
         * @see TelemetryPipelineStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TelemetryPipelineStatus
         */
        Builder status(TelemetryPipelineStatus status);

        /**
         * <p>
         * The key-value pairs associated with the telemetry pipeline resource.
         * </p>
         * 
         * @param tags
         *        The key-value pairs associated with the telemetry pipeline resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A summary of the pipeline configuration components.
         * </p>
         * 
         * @param configurationSummary
         *        A summary of the pipeline configuration components.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSummary(ConfigurationSummary configurationSummary);

        /**
         * <p>
         * A summary of the pipeline configuration components.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfigurationSummary.Builder} avoiding
         * the need to create one manually via {@link ConfigurationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfigurationSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #configurationSummary(ConfigurationSummary)}.
         * 
         * @param configurationSummary
         *        a consumer that will call methods on {@link ConfigurationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configurationSummary(ConfigurationSummary)
         */
        default Builder configurationSummary(Consumer<ConfigurationSummary.Builder> configurationSummary) {
            return configurationSummary(ConfigurationSummary.builder().applyMutation(configurationSummary).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Long createdTimeStamp;

        private Long lastUpdateTimeStamp;

        private String arn;

        private String name;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private ConfigurationSummary configurationSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(TelemetryPipelineSummary model) {
            createdTimeStamp(model.createdTimeStamp);
            lastUpdateTimeStamp(model.lastUpdateTimeStamp);
            arn(model.arn);
            name(model.name);
            status(model.status);
            tags(model.tags);
            configurationSummary(model.configurationSummary);
        }

        public final Long getCreatedTimeStamp() {
            return createdTimeStamp;
        }

        public final void setCreatedTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
        }

        @Override
        public final Builder createdTimeStamp(Long createdTimeStamp) {
            this.createdTimeStamp = createdTimeStamp;
            return this;
        }

        public final Long getLastUpdateTimeStamp() {
            return lastUpdateTimeStamp;
        }

        public final void setLastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
        }

        @Override
        public final Builder lastUpdateTimeStamp(Long lastUpdateTimeStamp) {
            this.lastUpdateTimeStamp = lastUpdateTimeStamp;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TelemetryPipelineStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapOutputCopier.copy(tags);
            return this;
        }

        public final ConfigurationSummary.Builder getConfigurationSummary() {
            return configurationSummary != null ? configurationSummary.toBuilder() : null;
        }

        public final void setConfigurationSummary(ConfigurationSummary.BuilderImpl configurationSummary) {
            this.configurationSummary = configurationSummary != null ? configurationSummary.build() : null;
        }

        @Override
        public final Builder configurationSummary(ConfigurationSummary configurationSummary) {
            this.configurationSummary = configurationSummary;
            return this;
        }

        @Override
        public TelemetryPipelineSummary build() {
            return new TelemetryPipelineSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
