/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class TelemetryPipelineSummariesCopier {
    static List<TelemetryPipelineSummary> copy(Collection<? extends TelemetryPipelineSummary> telemetryPipelineSummariesParam) {
        List<TelemetryPipelineSummary> list;
        if (telemetryPipelineSummariesParam == null || telemetryPipelineSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TelemetryPipelineSummary> modifiableList = new ArrayList<>(telemetryPipelineSummariesParam.size());
            telemetryPipelineSummariesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TelemetryPipelineSummary> copyFromBuilder(
            Collection<? extends TelemetryPipelineSummary.Builder> telemetryPipelineSummariesParam) {
        List<TelemetryPipelineSummary> list;
        if (telemetryPipelineSummariesParam == null || telemetryPipelineSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TelemetryPipelineSummary> modifiableList = new ArrayList<>(telemetryPipelineSummariesParam.size());
            telemetryPipelineSummariesParam.forEach(entry -> {
                TelemetryPipelineSummary member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<TelemetryPipelineSummary.Builder> copyToBuilder(
            Collection<? extends TelemetryPipelineSummary> telemetryPipelineSummariesParam) {
        List<TelemetryPipelineSummary.Builder> list;
        if (telemetryPipelineSummariesParam == null || telemetryPipelineSummariesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<TelemetryPipelineSummary.Builder> modifiableList = new ArrayList<>(telemetryPipelineSummariesParam.size());
            telemetryPipelineSummariesParam.forEach(entry -> {
                TelemetryPipelineSummary.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
