/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for selecting and handling source log groups for centralization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceLogsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceLogsConfiguration.Builder, SourceLogsConfiguration> {
    private static final SdkField<String> LOG_GROUP_SELECTION_CRITERIA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LogGroupSelectionCriteria").getter(getter(SourceLogsConfiguration::logGroupSelectionCriteria))
            .setter(setter(Builder::logGroupSelectionCriteria))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupSelectionCriteria").build())
            .build();

    private static final SdkField<String> ENCRYPTED_LOG_GROUP_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EncryptedLogGroupStrategy").getter(getter(SourceLogsConfiguration::encryptedLogGroupStrategyAsString))
            .setter(setter(Builder::encryptedLogGroupStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptedLogGroupStrategy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LOG_GROUP_SELECTION_CRITERIA_FIELD, ENCRYPTED_LOG_GROUP_STRATEGY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String logGroupSelectionCriteria;

    private final String encryptedLogGroupStrategy;

    private SourceLogsConfiguration(BuilderImpl builder) {
        this.logGroupSelectionCriteria = builder.logGroupSelectionCriteria;
        this.encryptedLogGroupStrategy = builder.encryptedLogGroupStrategy;
    }

    /**
     * <p>
     * The selection criteria that specifies which source log groups to centralize. The selection criteria uses the same
     * format as OAM link filters.
     * </p>
     * 
     * @return The selection criteria that specifies which source log groups to centralize. The selection criteria uses
     *         the same format as OAM link filters.
     */
    public final String logGroupSelectionCriteria() {
        return logGroupSelectionCriteria;
    }

    /**
     * <p>
     * A strategy determining whether to centralize source log groups that are encrypted with customer managed KMS keys
     * (CMK). ALLOW will consider CMK encrypted source log groups for centralization while SKIP will skip CMK encrypted
     * source log groups from centralization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #encryptedLogGroupStrategy} will return {@link EncryptedLogGroupStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #encryptedLogGroupStrategyAsString}.
     * </p>
     * 
     * @return A strategy determining whether to centralize source log groups that are encrypted with customer managed
     *         KMS keys (CMK). ALLOW will consider CMK encrypted source log groups for centralization while SKIP will
     *         skip CMK encrypted source log groups from centralization.
     * @see EncryptedLogGroupStrategy
     */
    public final EncryptedLogGroupStrategy encryptedLogGroupStrategy() {
        return EncryptedLogGroupStrategy.fromValue(encryptedLogGroupStrategy);
    }

    /**
     * <p>
     * A strategy determining whether to centralize source log groups that are encrypted with customer managed KMS keys
     * (CMK). ALLOW will consider CMK encrypted source log groups for centralization while SKIP will skip CMK encrypted
     * source log groups from centralization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #encryptedLogGroupStrategy} will return {@link EncryptedLogGroupStrategy#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #encryptedLogGroupStrategyAsString}.
     * </p>
     * 
     * @return A strategy determining whether to centralize source log groups that are encrypted with customer managed
     *         KMS keys (CMK). ALLOW will consider CMK encrypted source log groups for centralization while SKIP will
     *         skip CMK encrypted source log groups from centralization.
     * @see EncryptedLogGroupStrategy
     */
    public final String encryptedLogGroupStrategyAsString() {
        return encryptedLogGroupStrategy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(logGroupSelectionCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(encryptedLogGroupStrategyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceLogsConfiguration)) {
            return false;
        }
        SourceLogsConfiguration other = (SourceLogsConfiguration) obj;
        return Objects.equals(logGroupSelectionCriteria(), other.logGroupSelectionCriteria())
                && Objects.equals(encryptedLogGroupStrategyAsString(), other.encryptedLogGroupStrategyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceLogsConfiguration").add("LogGroupSelectionCriteria", logGroupSelectionCriteria())
                .add("EncryptedLogGroupStrategy", encryptedLogGroupStrategyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogGroupSelectionCriteria":
            return Optional.ofNullable(clazz.cast(logGroupSelectionCriteria()));
        case "EncryptedLogGroupStrategy":
            return Optional.ofNullable(clazz.cast(encryptedLogGroupStrategyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("LogGroupSelectionCriteria", LOG_GROUP_SELECTION_CRITERIA_FIELD);
        map.put("EncryptedLogGroupStrategy", ENCRYPTED_LOG_GROUP_STRATEGY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceLogsConfiguration, T> g) {
        return obj -> g.apply((SourceLogsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceLogsConfiguration> {
        /**
         * <p>
         * The selection criteria that specifies which source log groups to centralize. The selection criteria uses the
         * same format as OAM link filters.
         * </p>
         * 
         * @param logGroupSelectionCriteria
         *        The selection criteria that specifies which source log groups to centralize. The selection criteria
         *        uses the same format as OAM link filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupSelectionCriteria(String logGroupSelectionCriteria);

        /**
         * <p>
         * A strategy determining whether to centralize source log groups that are encrypted with customer managed KMS
         * keys (CMK). ALLOW will consider CMK encrypted source log groups for centralization while SKIP will skip CMK
         * encrypted source log groups from centralization.
         * </p>
         * 
         * @param encryptedLogGroupStrategy
         *        A strategy determining whether to centralize source log groups that are encrypted with customer
         *        managed KMS keys (CMK). ALLOW will consider CMK encrypted source log groups for centralization while
         *        SKIP will skip CMK encrypted source log groups from centralization.
         * @see EncryptedLogGroupStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptedLogGroupStrategy
         */
        Builder encryptedLogGroupStrategy(String encryptedLogGroupStrategy);

        /**
         * <p>
         * A strategy determining whether to centralize source log groups that are encrypted with customer managed KMS
         * keys (CMK). ALLOW will consider CMK encrypted source log groups for centralization while SKIP will skip CMK
         * encrypted source log groups from centralization.
         * </p>
         * 
         * @param encryptedLogGroupStrategy
         *        A strategy determining whether to centralize source log groups that are encrypted with customer
         *        managed KMS keys (CMK). ALLOW will consider CMK encrypted source log groups for centralization while
         *        SKIP will skip CMK encrypted source log groups from centralization.
         * @see EncryptedLogGroupStrategy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EncryptedLogGroupStrategy
         */
        Builder encryptedLogGroupStrategy(EncryptedLogGroupStrategy encryptedLogGroupStrategy);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupSelectionCriteria;

        private String encryptedLogGroupStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceLogsConfiguration model) {
            logGroupSelectionCriteria(model.logGroupSelectionCriteria);
            encryptedLogGroupStrategy(model.encryptedLogGroupStrategy);
        }

        public final String getLogGroupSelectionCriteria() {
            return logGroupSelectionCriteria;
        }

        public final void setLogGroupSelectionCriteria(String logGroupSelectionCriteria) {
            this.logGroupSelectionCriteria = logGroupSelectionCriteria;
        }

        @Override
        public final Builder logGroupSelectionCriteria(String logGroupSelectionCriteria) {
            this.logGroupSelectionCriteria = logGroupSelectionCriteria;
            return this;
        }

        public final String getEncryptedLogGroupStrategy() {
            return encryptedLogGroupStrategy;
        }

        public final void setEncryptedLogGroupStrategy(String encryptedLogGroupStrategy) {
            this.encryptedLogGroupStrategy = encryptedLogGroupStrategy;
        }

        @Override
        public final Builder encryptedLogGroupStrategy(String encryptedLogGroupStrategy) {
            this.encryptedLogGroupStrategy = encryptedLogGroupStrategy;
            return this;
        }

        @Override
        public final Builder encryptedLogGroupStrategy(EncryptedLogGroupStrategy encryptedLogGroupStrategy) {
            this.encryptedLogGroupStrategy(encryptedLogGroupStrategy == null ? null : encryptedLogGroupStrategy.toString());
            return this;
        }

        @Override
        public SourceLogsConfiguration build() {
            return new SourceLogsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
