/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTelemetryRulesResponse extends ObservabilityAdminResponse implements
        ToCopyableBuilder<ListTelemetryRulesResponse.Builder, ListTelemetryRulesResponse> {
    private static final SdkField<List<TelemetryRuleSummary>> TELEMETRY_RULE_SUMMARIES_FIELD = SdkField
            .<List<TelemetryRuleSummary>> builder(MarshallingType.LIST)
            .memberName("TelemetryRuleSummaries")
            .getter(getter(ListTelemetryRulesResponse::telemetryRuleSummaries))
            .setter(setter(Builder::telemetryRuleSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TelemetryRuleSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TelemetryRuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(TelemetryRuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTelemetryRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TELEMETRY_RULE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<TelemetryRuleSummary> telemetryRuleSummaries;

    private final String nextToken;

    private ListTelemetryRulesResponse(BuilderImpl builder) {
        super(builder);
        this.telemetryRuleSummaries = builder.telemetryRuleSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TelemetryRuleSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTelemetryRuleSummaries() {
        return telemetryRuleSummaries != null && !(telemetryRuleSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of telemetry rule summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTelemetryRuleSummaries} method.
     * </p>
     * 
     * @return A list of telemetry rule summaries.
     */
    public final List<TelemetryRuleSummary> telemetryRuleSummaries() {
        return telemetryRuleSummaries;
    }

    /**
     * <p>
     * A token to resume pagination of results.
     * </p>
     * 
     * @return A token to resume pagination of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTelemetryRuleSummaries() ? telemetryRuleSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTelemetryRulesResponse)) {
            return false;
        }
        ListTelemetryRulesResponse other = (ListTelemetryRulesResponse) obj;
        return hasTelemetryRuleSummaries() == other.hasTelemetryRuleSummaries()
                && Objects.equals(telemetryRuleSummaries(), other.telemetryRuleSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTelemetryRulesResponse")
                .add("TelemetryRuleSummaries", hasTelemetryRuleSummaries() ? telemetryRuleSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TelemetryRuleSummaries":
            return Optional.ofNullable(clazz.cast(telemetryRuleSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TelemetryRuleSummaries", TELEMETRY_RULE_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTelemetryRulesResponse, T> g) {
        return obj -> g.apply((ListTelemetryRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTelemetryRulesResponse> {
        /**
         * <p>
         * A list of telemetry rule summaries.
         * </p>
         * 
         * @param telemetryRuleSummaries
         *        A list of telemetry rule summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryRuleSummaries(Collection<TelemetryRuleSummary> telemetryRuleSummaries);

        /**
         * <p>
         * A list of telemetry rule summaries.
         * </p>
         * 
         * @param telemetryRuleSummaries
         *        A list of telemetry rule summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder telemetryRuleSummaries(TelemetryRuleSummary... telemetryRuleSummaries);

        /**
         * <p>
         * A list of telemetry rule summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #telemetryRuleSummaries(List<TelemetryRuleSummary>)}.
         * 
         * @param telemetryRuleSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.observabilityadmin.model.TelemetryRuleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #telemetryRuleSummaries(java.util.Collection<TelemetryRuleSummary>)
         */
        Builder telemetryRuleSummaries(Consumer<TelemetryRuleSummary.Builder>... telemetryRuleSummaries);

        /**
         * <p>
         * A token to resume pagination of results.
         * </p>
         * 
         * @param nextToken
         *        A token to resume pagination of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ObservabilityAdminResponse.BuilderImpl implements Builder {
        private List<TelemetryRuleSummary> telemetryRuleSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTelemetryRulesResponse model) {
            super(model);
            telemetryRuleSummaries(model.telemetryRuleSummaries);
            nextToken(model.nextToken);
        }

        public final List<TelemetryRuleSummary.Builder> getTelemetryRuleSummaries() {
            List<TelemetryRuleSummary.Builder> result = TelemetryRuleSummariesCopier.copyToBuilder(this.telemetryRuleSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTelemetryRuleSummaries(Collection<TelemetryRuleSummary.BuilderImpl> telemetryRuleSummaries) {
            this.telemetryRuleSummaries = TelemetryRuleSummariesCopier.copyFromBuilder(telemetryRuleSummaries);
        }

        @Override
        public final Builder telemetryRuleSummaries(Collection<TelemetryRuleSummary> telemetryRuleSummaries) {
            this.telemetryRuleSummaries = TelemetryRuleSummariesCopier.copy(telemetryRuleSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRuleSummaries(TelemetryRuleSummary... telemetryRuleSummaries) {
            telemetryRuleSummaries(Arrays.asList(telemetryRuleSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder telemetryRuleSummaries(Consumer<TelemetryRuleSummary.Builder>... telemetryRuleSummaries) {
            telemetryRuleSummaries(Stream.of(telemetryRuleSummaries)
                    .map(c -> TelemetryRuleSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTelemetryRulesResponse build() {
            return new ListTelemetryRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
