/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.observabilityadmin.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTelemetryRulesForOrganizationRequest extends ObservabilityAdminRequest implements
        ToCopyableBuilder<ListTelemetryRulesForOrganizationRequest.Builder, ListTelemetryRulesForOrganizationRequest> {
    private static final SdkField<String> RULE_NAME_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RuleNamePrefix").getter(getter(ListTelemetryRulesForOrganizationRequest::ruleNamePrefix))
            .setter(setter(Builder::ruleNamePrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleNamePrefix").build()).build();

    private static final SdkField<List<String>> SOURCE_ACCOUNT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceAccountIds")
            .getter(getter(ListTelemetryRulesForOrganizationRequest::sourceAccountIds))
            .setter(setter(Builder::sourceAccountIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAccountIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SOURCE_ORGANIZATION_UNIT_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SourceOrganizationUnitIds")
            .getter(getter(ListTelemetryRulesForOrganizationRequest::sourceOrganizationUnitIds))
            .setter(setter(Builder::sourceOrganizationUnitIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceOrganizationUnitIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListTelemetryRulesForOrganizationRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListTelemetryRulesForOrganizationRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_NAME_PREFIX_FIELD,
            SOURCE_ACCOUNT_IDS_FIELD, SOURCE_ORGANIZATION_UNIT_IDS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String ruleNamePrefix;

    private final List<String> sourceAccountIds;

    private final List<String> sourceOrganizationUnitIds;

    private final Integer maxResults;

    private final String nextToken;

    private ListTelemetryRulesForOrganizationRequest(BuilderImpl builder) {
        super(builder);
        this.ruleNamePrefix = builder.ruleNamePrefix;
        this.sourceAccountIds = builder.sourceAccountIds;
        this.sourceOrganizationUnitIds = builder.sourceOrganizationUnitIds;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A string to filter organization telemetry rules whose names begin with the specified prefix.
     * </p>
     * 
     * @return A string to filter organization telemetry rules whose names begin with the specified prefix.
     */
    public final String ruleNamePrefix() {
        return ruleNamePrefix;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceAccountIds property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSourceAccountIds() {
        return sourceAccountIds != null && !(sourceAccountIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of account IDs to filter organization telemetry rules by their source accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceAccountIds} method.
     * </p>
     * 
     * @return The list of account IDs to filter organization telemetry rules by their source accounts.
     */
    public final List<String> sourceAccountIds() {
        return sourceAccountIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the SourceOrganizationUnitIds property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSourceOrganizationUnitIds() {
        return sourceOrganizationUnitIds != null && !(sourceOrganizationUnitIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of organizational unit IDs to filter organization telemetry rules by their source organizational units.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSourceOrganizationUnitIds} method.
     * </p>
     * 
     * @return The list of organizational unit IDs to filter organization telemetry rules by their source organizational
     *         units.
     */
    public final List<String> sourceOrganizationUnitIds() {
        return sourceOrganizationUnitIds;
    }

    /**
     * <p>
     * The maximum number of organization telemetry rules to return in a single call.
     * </p>
     * 
     * @return The maximum number of organization telemetry rules to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. A previous call generates this token.
     * </p>
     * 
     * @return The token for the next set of results. A previous call generates this token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ruleNamePrefix());
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceAccountIds() ? sourceAccountIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSourceOrganizationUnitIds() ? sourceOrganizationUnitIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTelemetryRulesForOrganizationRequest)) {
            return false;
        }
        ListTelemetryRulesForOrganizationRequest other = (ListTelemetryRulesForOrganizationRequest) obj;
        return Objects.equals(ruleNamePrefix(), other.ruleNamePrefix()) && hasSourceAccountIds() == other.hasSourceAccountIds()
                && Objects.equals(sourceAccountIds(), other.sourceAccountIds())
                && hasSourceOrganizationUnitIds() == other.hasSourceOrganizationUnitIds()
                && Objects.equals(sourceOrganizationUnitIds(), other.sourceOrganizationUnitIds())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTelemetryRulesForOrganizationRequest").add("RuleNamePrefix", ruleNamePrefix())
                .add("SourceAccountIds", hasSourceAccountIds() ? sourceAccountIds() : null)
                .add("SourceOrganizationUnitIds", hasSourceOrganizationUnitIds() ? sourceOrganizationUnitIds() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RuleNamePrefix":
            return Optional.ofNullable(clazz.cast(ruleNamePrefix()));
        case "SourceAccountIds":
            return Optional.ofNullable(clazz.cast(sourceAccountIds()));
        case "SourceOrganizationUnitIds":
            return Optional.ofNullable(clazz.cast(sourceOrganizationUnitIds()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RuleNamePrefix", RULE_NAME_PREFIX_FIELD);
        map.put("SourceAccountIds", SOURCE_ACCOUNT_IDS_FIELD);
        map.put("SourceOrganizationUnitIds", SOURCE_ORGANIZATION_UNIT_IDS_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTelemetryRulesForOrganizationRequest, T> g) {
        return obj -> g.apply((ListTelemetryRulesForOrganizationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ObservabilityAdminRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTelemetryRulesForOrganizationRequest> {
        /**
         * <p>
         * A string to filter organization telemetry rules whose names begin with the specified prefix.
         * </p>
         * 
         * @param ruleNamePrefix
         *        A string to filter organization telemetry rules whose names begin with the specified prefix.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleNamePrefix(String ruleNamePrefix);

        /**
         * <p>
         * The list of account IDs to filter organization telemetry rules by their source accounts.
         * </p>
         * 
         * @param sourceAccountIds
         *        The list of account IDs to filter organization telemetry rules by their source accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountIds(Collection<String> sourceAccountIds);

        /**
         * <p>
         * The list of account IDs to filter organization telemetry rules by their source accounts.
         * </p>
         * 
         * @param sourceAccountIds
         *        The list of account IDs to filter organization telemetry rules by their source accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountIds(String... sourceAccountIds);

        /**
         * <p>
         * The list of organizational unit IDs to filter organization telemetry rules by their source organizational
         * units.
         * </p>
         * 
         * @param sourceOrganizationUnitIds
         *        The list of organizational unit IDs to filter organization telemetry rules by their source
         *        organizational units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceOrganizationUnitIds(Collection<String> sourceOrganizationUnitIds);

        /**
         * <p>
         * The list of organizational unit IDs to filter organization telemetry rules by their source organizational
         * units.
         * </p>
         * 
         * @param sourceOrganizationUnitIds
         *        The list of organizational unit IDs to filter organization telemetry rules by their source
         *        organizational units.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceOrganizationUnitIds(String... sourceOrganizationUnitIds);

        /**
         * <p>
         * The maximum number of organization telemetry rules to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of organization telemetry rules to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. A previous call generates this token.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. A previous call generates this token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ObservabilityAdminRequest.BuilderImpl implements Builder {
        private String ruleNamePrefix;

        private List<String> sourceAccountIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> sourceOrganizationUnitIds = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTelemetryRulesForOrganizationRequest model) {
            super(model);
            ruleNamePrefix(model.ruleNamePrefix);
            sourceAccountIds(model.sourceAccountIds);
            sourceOrganizationUnitIds(model.sourceOrganizationUnitIds);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getRuleNamePrefix() {
            return ruleNamePrefix;
        }

        public final void setRuleNamePrefix(String ruleNamePrefix) {
            this.ruleNamePrefix = ruleNamePrefix;
        }

        @Override
        public final Builder ruleNamePrefix(String ruleNamePrefix) {
            this.ruleNamePrefix = ruleNamePrefix;
            return this;
        }

        public final Collection<String> getSourceAccountIds() {
            if (sourceAccountIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceAccountIds;
        }

        public final void setSourceAccountIds(Collection<String> sourceAccountIds) {
            this.sourceAccountIds = AccountIdentifiersCopier.copy(sourceAccountIds);
        }

        @Override
        public final Builder sourceAccountIds(Collection<String> sourceAccountIds) {
            this.sourceAccountIds = AccountIdentifiersCopier.copy(sourceAccountIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAccountIds(String... sourceAccountIds) {
            sourceAccountIds(Arrays.asList(sourceAccountIds));
            return this;
        }

        public final Collection<String> getSourceOrganizationUnitIds() {
            if (sourceOrganizationUnitIds instanceof SdkAutoConstructList) {
                return null;
            }
            return sourceOrganizationUnitIds;
        }

        public final void setSourceOrganizationUnitIds(Collection<String> sourceOrganizationUnitIds) {
            this.sourceOrganizationUnitIds = OrganizationUnitIdentifiersCopier.copy(sourceOrganizationUnitIds);
        }

        @Override
        public final Builder sourceOrganizationUnitIds(Collection<String> sourceOrganizationUnitIds) {
            this.sourceOrganizationUnitIds = OrganizationUnitIdentifiersCopier.copy(sourceOrganizationUnitIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceOrganizationUnitIds(String... sourceOrganizationUnitIds) {
            sourceOrganizationUnitIds(Arrays.asList(sourceOrganizationUnitIds));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTelemetryRulesForOrganizationRequest build() {
            return new ListTelemetryRulesForOrganizationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
